/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.sibresources.SIBDestinationMediation;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionMediationNotFound;
import com.ibm.ws.sib.admin.impl.JsAdminFactoryImpl;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsDestinationCache;
import com.ibm.ws.sib.admin.impl.MediationDefinitionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class JsMediationCache {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsMediationCache";
    private static final TraceComponent tc = SibTr.register((Class)JsMediationCache.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private JsBusImpl _bus = null;
    private JsDestinationCache _destinationCache = null;
    private JsAdminFactory _jsaf = null;
    private static HashMap mdMap;

    public JsMediationCache(JsBusImpl jsBusImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsMediationCache().<init>");
        }
        this._bus = jsBusImpl;
        try {
            this._jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populateCache();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsMediationCache().<init>");
        }
    }

    private void populateCache() {
        String string;
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateCache");
        }
        boolean bl = false;
        Resource resource = null;
        String string3 = null;
        try {
            object2 = JsAdminService.getInstance();
            object = (Repository)object2.getService(Repository.class);
            string2 = object.getConfigRoot().getConfigRootPath();
            string = object.getCellName();
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            string3 = "file:/" + string2 + "/cells/" + string + "/buses/" + this._bus.getName() + "/" + "sib-mediations.xml";
            URI uRI = URI.createURI((String)string3);
            resource = wASResourceSetImpl.createResource(uRI);
            resource.load(wASResourceSetImpl.getLoadOptions());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMediationCache._getSIBMediation", (String)"1", (Object)this);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string3);
        }
        object2 = resource.getContents().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof SIBDestinationMediation)) continue;
            string2 = (SIBDestinationMediation)object;
            string = ((JsAdminFactoryImpl)this._jsaf).createMediationDefinition((SIBDestinationMediation)string2);
            mdMap.put(string.getMediationName(), string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateCache");
        }
    }

    private void illegalArguments(String string) throws SIBExceptionBase {
        throw new SIBExceptionBase("Illegal argument value(s) specified; " + string);
    }

    public MediationDefinition NEWgetSIBMediation(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        MediationDefinition mediationDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBMediation", (Object)(string + " " + string2));
        }
        if (string2 == null) {
            this.illegalArguments("name is mandatory");
        }
        if (string != null && !string.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        if ((mediationDefinition = (MediationDefinition)mdMap.get(string2)) == null) {
            throw new SIBExceptionMediationNotFound(string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBMediation");
        }
        return mediationDefinition;
    }

    public MediationDefinition getSIBMediation(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        SIBDestinationMediation sIBDestinationMediation;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBMediation", (Object)(string + " " + string2));
        }
        if (string2 == null) {
            this.illegalArguments("name is mandatory");
        }
        if (string != null && !string.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        if ((sIBDestinationMediation = this._getSIBMediation(string2)) == null) {
            throw new SIBExceptionMediationNotFound(string2);
        }
        MediationDefinition mediationDefinition = ((JsAdminFactoryImpl)this._jsaf).createMediationDefinition(sIBDestinationMediation);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBMediation");
        }
        return mediationDefinition;
    }

    public void getSIBMediation(String string, String string2, MediationDefinition mediationDefinition) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        SIBDestinationMediation sIBDestinationMediation;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBMediation", (Object)(string + " " + string2));
        }
        if (string2 == null || mediationDefinition == null) {
            this.illegalArguments("both name and md are mandatory");
        }
        if (string != null && !string.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        if ((sIBDestinationMediation = this._getSIBMediation(string2)) == null) {
            throw new SIBExceptionMediationNotFound(string2);
        }
        ((MediationDefinitionImpl)mediationDefinition).reset(sIBDestinationMediation);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBMediation");
        }
    }

    public Set getSIBMediationLocalitySet(String string, String string2) throws SIBExceptionBase {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBMediationLocalitySet", (Object)(string + " " + string2));
        }
        if (string2 == null) {
            this.illegalArguments("name is mandatory");
        }
        if (string != null && !string.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        Set set = this._getSIBMediationLocalitySet(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBMediationLocalitySet", (Object)new Integer(set.size()));
        }
        return set;
    }

    private SIBDestinationMediation _getSIBMediation(String string) {
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBDestination", (Object)string);
        }
        Resource resource = null;
        String string3 = null;
        try {
            object2 = JsAdminService.getInstance();
            object = (Repository)object2.getService(Repository.class);
            string2 = object.getConfigRoot().getConfigRootPath();
            String string4 = object.getCellName();
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            string3 = "file:/" + string2 + "/cells/" + string4 + "/buses/" + this._bus.getName() + "/" + "sib-mediations.xml";
            URI uRI = URI.createURI((String)string3);
            resource = wASResourceSetImpl.createResource(uRI);
            resource.load(wASResourceSetImpl.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMediationCache._getSIBMediation", (String)"1", (Object)this);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string3);
        }
        object2 = resource.getContents().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof SIBDestinationMediation) || !(string2 = (SIBDestinationMediation)object).getMediationName().equals(string)) continue;
            return string2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBMediation");
        }
        return null;
    }

    public SIBDestinationMediation _getSIBMediationByUuid(String string) {
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBMediationByUuid", (Object)string);
        }
        Resource resource = null;
        String string3 = null;
        try {
            object2 = JsAdminService.getInstance();
            object = (Repository)object2.getService(Repository.class);
            string2 = object.getConfigRoot().getConfigRootPath();
            String string4 = object.getCellName();
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            string3 = "file:/" + string2 + "/cells/" + string4 + "/buses/" + this._bus.getName() + "/" + "sib-mediations.xml";
            URI uRI = URI.createURI((String)string3);
            resource = wASResourceSetImpl.createResource(uRI);
            resource.load(wASResourceSetImpl.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMediationCache._getSIBMediationByUuid", (String)"1", (Object)this);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string3);
        }
        object2 = resource.getContents().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof SIBDestinationMediation) || !(string2 = (SIBDestinationMediation)object).getUuid().equals(string)) continue;
            return string2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBMediationByUuid");
        }
        return null;
    }

    private Set _getSIBMediationLocalitySet(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBMediationLocalitySet", (Object)new Object[]{string, string2});
        }
        HashSet hashSet = new HashSet();
        Set set = this.getDestinationCache().getMediationEntryByUuid(string2);
        if (set != null) {
            hashSet.addAll(set);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBMediationLocalitySet");
        }
        return hashSet;
    }

    private JsDestinationCache getDestinationCache() {
        if (this._destinationCache != null) {
            return this._destinationCache;
        }
        return this._bus.getDestinationCache();
    }

    void setDestinationCache(JsDestinationCache jsDestinationCache) {
        this._destinationCache = jsDestinationCache;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsMediationCache.java, SIB.admin, WAS602.SIB, o0610.11 1.2");
        }
        mdMap = new HashMap();
    }
}

