/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.sibresources.SIBLocalizationPoint;
import com.ibm.websphere.models.config.sibresources.SIBMessagingEngine;
import com.ibm.websphere.models.config.sibresources.SIBQueue;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.models.config.sibresources.SIBusMember;
import com.ibm.websphere.models.config.sibresources.SIBusMemberTarget;
import com.ibm.websphere.models.config.sibresources.impl.SIBDatastoreImpl;
import com.ibm.websphere.models.config.sibresources.impl.SIBMQLinkSenderChannelLocalizationPointImpl;
import com.ibm.websphere.models.config.sibresources.impl.SIBMessagingEngineImpl;
import com.ibm.websphere.models.config.sibservice.SIBService;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.JsMain;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsMonitoredComponent;
import com.ibm.ws.sib.admin.JsProcessComponent;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.dynconfig.DynamicConfigManager;
import com.ibm.ws.sib.admin.dynconfig.JsBusListener;
import com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.JsBusActivatableListener;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsConfigObject;
import com.ibm.ws.sib.admin.impl.JsEObjectImpl;
import com.ibm.ws.sib.admin.impl.JsMainImplMBean;
import com.ibm.ws.sib.admin.impl.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.JsShadowMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.SIBJMSResource;
import com.ibm.ws.sib.utils.BuildInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class JsMainImpl
extends JsConfigObject
implements JsMain,
JsMainImplMBean,
JsHealthMonitor,
VetoableChangeListener,
ConfigChangeListener,
SecurityServiceListener {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsMainImpl";
    private static final TraceComponent tc = SibTr.register((Class)JsMainImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.impl.CWSIDText");
    private boolean _platform_zOS = false;
    private boolean _platform_zOS_servant = false;
    private boolean _platform_zOS_CRA = false;
    private boolean _enabled = false;
    private boolean _serverStarted = false;
    private boolean _serverStopping = false;
    private boolean _haEnabled = true;
    private JsHealthState recordedHealth = JsHealthState.getOK();
    private int _serverMode = 0;
    private static Vector _processComponents;
    private static Hashtable _messagingEngines;
    private static Vector jmeAutoClasses;
    private SIBService copyConfig;
    private Repository _repository = null;
    SIBJMSResource _jmsResource = null;
    private static Vector _busVector;
    private DynamicConfigManager _dynConfigManager = DynamicConfigManager.getManager();
    private StatsGroup _sibServiceStatsGroup = null;
    private StatsGroup _meStatsGroup = null;
    private boolean _securityServiceUp = false;
    private List _activatableListeners = new ArrayList();

    public JsMainImpl() {
        super("SIBMain", "SIBMain");
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsMainImpl().<init>");
        }
        BuildInfo.traceBuildInfo();
        JsAdminService jsAdminService = JsAdminService.getInstance();
        jsAdminService.setAdminMain((JsMain)this);
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.pmi.preprocess.sib_admin_StatsTemplateLookup");
            StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((StatsTemplateLookup)clazz.newInstance()));
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("PMI StatsTemplateLookup failed with " + exception.toString()));
            }
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this._platform_zOS = true;
            this._platform_zOS_servant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
            this._platform_zOS_CRA = PlatformHelperFactory.getPlatformHelper().isCRAJvm();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Running on ZOS, CRA:" + this._platform_zOS_CRA + " servant:" + this._platform_zOS_servant));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Running on non-ZOS platform");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsMainImpl().<init>");
        }
    }

    public boolean isHAEnabled() {
        return this._haEnabled;
    }

    public boolean isZOSPlatform() {
        return this._platform_zOS;
    }

    public boolean isZOSCRA() {
        return this._platform_zOS_CRA;
    }

    public boolean isZOSServant() {
        return this._platform_zOS_servant;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        SecurityService securityService = (SecurityService)this.getService(SecurityService.class);
        securityService.addListener((SecurityServiceListener)this);
        this.releaseService(securityService);
        this._repository = (Repository)this.getService(Repository.class);
        SIBService sIBService = null;
        if (object != null) {
            sIBService = (SIBService)object;
        }
        if (sIBService != null && sIBService.isSetEnable()) {
            this._enabled = sIBService.isEnable();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("initialize: enabled=" + this._enabled));
        }
        if (this._enabled) {
            JsMessagingEngine jsMessagingEngine;
            Object object2;
            Enumeration<Object> enumeration;
            block28: {
                this._serverMode = ((Server)this.getService(Server.class)).getServerMode();
                if (tc.isDebugEnabled()) {
                    if (this.isServerInRecoveryMode()) {
                        SibTr.debug((TraceComponent)tc, (String)"server is in recovery mode");
                    } else {
                        SibTr.debug((TraceComponent)tc, (String)"server is in normal mode");
                    }
                }
                if (StatsFactory.isPMIEnabled()) {
                    try {
                        this._sibServiceStatsGroup = StatsFactory.createStatsGroup((String)nls.getFormattedMessage("StatGroup.SIBService", null, null), (String)"/com/ibm/ws/sib/admin/pmi/xml/SIBService.xml", (ObjectName)null);
                        if (this._sibServiceStatsGroup != null) {
                            this._meStatsGroup = StatsFactory.createStatsGroup((String)nls.getFormattedMessage("StatGroup.SIBMessagingEngines", null, null), (String)"/com/ibm/ws/sib/admin/pmi/xml/SIBMessagingEngines.xml", (StatsGroup)this._sibServiceStatsGroup, null);
                        }
                        break block28;
                    }
                    catch (StatsFactoryException statsFactoryException) {
                        FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.initialize", (String)"405", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Unable to create SIB Service and SIB Messaging Engines Stats Groups");
                        }
                        break block28;
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"PMI not enabled in WAS. No stats instance created.");
                }
            }
            ComponentImpl componentImpl = (ComponentImpl)this.getService(Server.class);
            componentImpl.addVetoableChangeListener("state", (VetoableChangeListener)this);
            if (sIBService.isConfigurationReloadEnabled()) {
                this._dynConfigManager.initialize(this, this._repository.getConfigRoot().getConfigRootPath());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"initialize: dynamic config enabled");
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"initialize: dynamic config disabled");
            }
            if (System.getProperty("HA_DISABLED") != null) {
                this._haEnabled = false;
                SibTr.info((TraceComponent)tc, (String)"SIB_ENVIRONMENT_SIAS0025");
            }
            EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
            this.copyConfig = (SIBService)etoolsCopyUtility.copy((EObject)sIBService);
            this.addService(JsMainImpl.class);
            if (!this.isZOSPlatform() || this.isZOSCRA()) {
                this.activateJMSResource();
                this.loadClass("com.ibm.ws.sib.trm.TrmMainImpl");
                this.loadClass("com.ibm.ws.sib.comms.CommsAdminComponent");
                this.loadClass("com.ibm.ws.sib.mediation.runtime.MediationStartupComponent");
                enumeration = _processComponents.elements();
                try {
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        jsMessagingEngine = ((ComponentList)object2).getRef();
                        if (!(jsMessagingEngine instanceof JsProcessComponent)) continue;
                        ((JsProcessComponent)jsMessagingEngine).initialize();
                        this.setCustomProperties((JsProcessComponent)jsMessagingEngine);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.initialize", (String)"1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
                }
            }
            this.createMessagingEngines();
            enumeration = _messagingEngines.elements();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                jsMessagingEngine = ((MessagingEngine)object2).getRuntime();
                if (!(jsMessagingEngine instanceof BaseMessagingEngineImpl)) continue;
                try {
                    ((BaseMessagingEngineImpl)jsMessagingEngine).initialize(null);
                    this.setCustomProperties((BaseMessagingEngineImpl)jsMessagingEngine);
                    this.setAttributes((BaseMessagingEngineImpl)jsMessagingEngine, ((MessagingEngine)object2).getConfig());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.initialize", (String)"2", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
                    SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)((BaseMessagingEngineImpl)jsMessagingEngine).getName());
                }
            }
        } else {
            SibTr.info((TraceComponent)tc, (String)"SIB_NOT_ENABLED_SIAS0006", (Object)this.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (!this._enabled) {
            return;
        }
        Enumeration enumeration = _processComponents.elements();
        try {
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = ((ComponentList)object2).getRef();
                if (!(object instanceof JsProcessComponent)) continue;
                object.start();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.start", (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
        }
        object2 = _messagingEngines.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)object).getRuntime();
            try {
                ((BaseMessagingEngineImpl)jsMessagingEngine).startConditional();
            }
            catch (RuntimeWarning runtimeWarning) {
                FFDCFilter.processException((Throwable)runtimeWarning, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.start", (String)"2", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)runtimeWarning));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)((Object)runtimeWarning));
            }
            catch (RuntimeError runtimeError) {
                FFDCFilter.processException((Throwable)runtimeError, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.start", (String)"3", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)runtimeError));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)((Object)runtimeError));
                throw runtimeError;
            }
        }
        this._dynConfigManager.start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void serverStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted");
        }
        this._serverStarted = true;
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(jsMessagingEngine instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)jsMessagingEngine).serverStarted();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.serverStarted", (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
                SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)((BaseMessagingEngineImpl)jsMessagingEngine).getName());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    public void serverStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping");
        }
        this._serverStopping = true;
        this._serverStarted = false;
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(jsMessagingEngine instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)jsMessagingEngine).serverStopping();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.serverStopping", (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public void stop() {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this._dynConfigManager.stop();
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = ((MessagingEngine)object2).getRuntime();
            try {
                ((BaseMessagingEngineImpl)object).stopConditional(0);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.stop", (String)"2", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
            }
        }
        object2 = _processComponents.elements();
        try {
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                JsProcessComponent jsProcessComponent = ((ComponentList)object).getRef();
                if (!(jsProcessComponent instanceof JsProcessComponent)) continue;
                jsProcessComponent.stop();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.stop", (String)"3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = ((MessagingEngine)object2).getRuntime();
            if (!(object instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)object).destroy();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.destroy", (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
            }
        }
        object2 = _processComponents.elements();
        try {
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                JsProcessComponent jsProcessComponent = ((ComponentList)object).getRef();
                if (!(jsProcessComponent instanceof JsProcessComponent)) continue;
                jsProcessComponent.destroy();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.destroy", (String)"2", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    private void createMessagingEngines() {
        Object e;
        Iterator iterator;
        Resource resource;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMessagingEngines");
        }
        boolean bl = false;
        try {
            this._repository.getConfigRoot();
            resource = this._repository.getConfigRoot().getResource(4, "sib-engines.xml");
            bl = true;
            iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof SIBMessagingEngineImpl)) continue;
                try {
                    this.createMessageEngine((SIBMessagingEngineImpl)e);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.createMessagingEngines", (String)"1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
                    SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)((SIBMessagingEngineImpl)e).getName());
                }
            }
            this._dynConfigManager.registerEngine(resource.getURI(), this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"The WCCM document <sib-engines.xml> was not found at SERVER scope; assuming not in server");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.createMessagingEngines", (String)"2", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
        }
        try {
            this._repository.getConfigRoot();
            resource = this._repository.getConfigRoot().getResource(2, "sib-engines.xml");
            bl = true;
            iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof SIBMessagingEngineImpl)) continue;
                try {
                    this.createMessageEngine((SIBMessagingEngineImpl)e);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.createMessagingEngines", (String)"3", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
                }
            }
            this._dynConfigManager.registerEngine(resource.getURI(), this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"The WCCM document <sib-engines.xml> was not found at CLUSTER scope; assuming not in cluster");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.createMessagingEngines", (String)"4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)exception);
        }
        if (!bl && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"The WCCM document <sib-engines.xml> was not found at any scope");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMessagingEngines");
        }
    }

    private MessagingEngine createMessageEngine(SIBMessagingEngineImpl sIBMessagingEngineImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMessageEngine", (Object)sIBMessagingEngineImpl.toString());
        }
        BaseMessagingEngineImpl baseMessagingEngineImpl = null;
        JsBusImpl jsBusImpl = this.getBusProxy(sIBMessagingEngineImpl);
        SIBDatastoreImpl sIBDatastoreImpl = (SIBDatastoreImpl)sIBMessagingEngineImpl.getDataStore();
        baseMessagingEngineImpl = !this.isZOSPlatform() || this.isZOSCRA() ? new JsMessagingEngineImpl(this, jsBusImpl, sIBMessagingEngineImpl, sIBDatastoreImpl) : new JsShadowMessagingEngineImpl(this, jsBusImpl, sIBMessagingEngineImpl, sIBDatastoreImpl);
        MessagingEngine messagingEngine = new MessagingEngine(sIBMessagingEngineImpl, sIBDatastoreImpl, (JsMessagingEngine)baseMessagingEngineImpl);
        _messagingEngines.put(sIBMessagingEngineImpl.getUuid(), messagingEngine);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMessageEngine", (Object)messagingEngine.toString());
        }
        return messagingEngine;
    }

    private void setCustomProperties(JsProcessComponent jsProcessComponent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperties");
        }
        EList eList = this.copyConfig.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            String string2 = property.getValue();
            jsProcessComponent.setCustomProperty(property.getName(), property.getValue());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperties");
        }
    }

    private void setCustomProperties(BaseMessagingEngineImpl baseMessagingEngineImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperties", (Object)(baseMessagingEngineImpl.getBusName() + baseMessagingEngineImpl.getName()));
        }
        EList eList = baseMessagingEngineImpl.getMeConfig().getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            String string2 = property.getValue();
            baseMessagingEngineImpl.setCustomProperty(property.getName(), property.getValue());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperties");
        }
    }

    private void loadClass(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadClass", (Object)string);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            _processComponents.addElement(new ComponentList(string, (JsProcessComponent)clazz.newInstance()));
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.loadClass", (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)instantiationException);
            SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.loadClass", (String)"2", (Object)this);
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadClass");
        }
    }

    private JsBusImpl getBusProxy(SIBMessagingEngineImpl sIBMessagingEngineImpl) {
        JsBusImpl jsBusImpl;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusProxy");
        }
        Enumeration enumeration = _busVector.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            jsBusImpl = (JsBusImpl)object;
            if (!jsBusImpl.getName().equals(sIBMessagingEngineImpl.getBusName())) continue;
            return jsBusImpl;
        }
        object = this.getBusEObject(sIBMessagingEngineImpl.getBusName());
        jsBusImpl = new JsBusImpl((EObject)object, this, sIBMessagingEngineImpl.getBusName(), sIBMessagingEngineImpl.getBusUuid());
        _busVector.addElement(jsBusImpl);
        try {
            SIBus sIBus = (SIBus)object;
            if (sIBus.isConfigurationReloadEnabled()) {
                JsBusListener.registerListener(this._dynConfigManager, sIBMessagingEngineImpl.getBusName(), this);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("dynamic config reload has been disabled for bus " + sIBMessagingEngineImpl.getBusName()));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.getBusProxy", (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusProxy");
        }
        return jsBusImpl;
    }

    private JsBusImpl getBusProxy(String string) throws SIBExceptionBusNotFound {
        Enumeration enumeration = _busVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsBusImpl jsBusImpl = (JsBusImpl)e;
            if (!jsBusImpl.getName().equals(string)) continue;
            return jsBusImpl;
        }
        throw new SIBExceptionBusNotFound(string);
    }

    public JsBus getBus(String string) throws SIBExceptionBusNotFound {
        return this.getBusProxy(string);
    }

    public EObject getBusEObject(String string) {
        Object object;
        String string2;
        String string3;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusEObject", (Object)string);
        }
        boolean bl = false;
        Resource resource = null;
        String string4 = null;
        try {
            object3 = JsAdminService.getInstance();
            object2 = (Repository)object3.getService(Repository.class);
            string3 = object2.getConfigRoot().getConfigRootPath();
            string2 = object2.getCellName();
            object = new WASResourceSetImpl();
            string4 = "file:/" + string3 + "/cells/" + string2 + "/buses/" + string + "/" + "sib-bus.xml";
            URI uRI = URI.createURI((String)string4);
            resource = object.createResource(uRI);
            resource.load(object.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.getBusEObject", (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string4);
        }
        object3 = resource.getContents().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 instanceof SIBus && ((SIBus)object2).getName().equals(string)) {
                boolean bl2 = false;
                return (EObject)object2;
            }
            if (!(object2 instanceof SIBQueue)) continue;
            string3 = (SIBQueue)object2;
            string2 = string3.getIdentifier();
            object = string3.getUuid();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusEObject");
        }
        return null;
    }

    Set getEngineUuidSet(String string, String string2, String string3) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEngineUuidSet", (Object)string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Resource resource = null;
        String string4 = null;
        try {
            object2 = JsAdminService.getInstance();
            object = (Repository)object2.getService(Repository.class);
            String string5 = object.getConfigRoot().getConfigRootPath();
            String string6 = object.getCellName();
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            string4 = "file:/" + string5 + "/cells/" + string6 + "/nodes/" + string2 + "/servers/" + string3 + "/" + "sib-engines.xml";
            URI uRI = URI.createURI((String)string4);
            resource = wASResourceSetImpl.createResource(uRI);
            resource.load(wASResourceSetImpl.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.getEngineUuidSet", (String)"5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string4);
        }
        object2 = resource.getContents().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof SIBMessagingEngine) || !string.equals(((SIBMessagingEngine)object).getBusName())) continue;
            hashSet.add(((SIBMessagingEngine)object).getUuid());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEngineUuidSet");
        }
        return hashSet;
    }

    public JsProcessComponent getProcessComponent(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProcessComponent", (Object)string);
        }
        Enumeration enumeration = _processComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!((ComponentList)e).getClassName().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getProcessComponent", (Object)"FOUND");
            }
            return ((ComponentList)e).getRef();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProcessComponent", (Object)"NULL");
        }
        return null;
    }

    public JsMessagingEngineImpl getMessagingEngine(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngine", (Object)string);
        }
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(jsMessagingEngine instanceof JsMessagingEngineImpl) || !string.equals(((JsMessagingEngineImpl)jsMessagingEngine).getName())) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessagingEngine", (Object)"FOUND");
            }
            return (JsMessagingEngineImpl)jsMessagingEngine;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngine", (Object)"NULL");
        }
        return null;
    }

    public JsMessagingEngine getMessagingEngine(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngine", (Object)(string + " " + string2));
        }
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(jsMessagingEngine instanceof BaseMessagingEngineImpl) || !((BaseMessagingEngineImpl)jsMessagingEngine).getBusName().equals(string) || !((BaseMessagingEngineImpl)jsMessagingEngine).getName().equals(string2)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessagingEngine", (Object)"FOUND");
            }
            return jsMessagingEngine;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngine", (Object)"NULL");
        }
        return null;
    }

    public Enumeration listMessagingEngines() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listMessagingEngines");
        }
        Vector<JsMessagingEngine> vector = new Vector<JsMessagingEngine>();
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(jsMessagingEngine instanceof BaseMessagingEngineImpl)) continue;
            vector.addElement(jsMessagingEngine);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listMessagingEngines", vector.elements());
        }
        return vector.elements();
    }

    public Enumeration listMessagingEngines(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listMessagingEngines", (Object)string);
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.listMessagingEngines();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!((BaseMessagingEngineImpl)e).getBusName().equals(string)) continue;
            vector.addElement(e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listMessagingEngines", vector.elements());
        }
        return vector.elements();
    }

    public Set getMessagingEngineSet(String string) {
        Object object;
        EList eList;
        HashSet<String> hashSet;
        JsBusImpl jsBusImpl;
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineSet", (Object)string);
            }
            bl = false;
            jsBusImpl = null;
            hashSet = new HashSet<String>();
            try {
                jsBusImpl = this.getBusProxy(string);
                bl = true;
            }
            catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
                if (!tc.isDebugEnabled()) break block7;
                SibTr.debug((TraceComponent)tc, (String)("Could not find bus proxy for bus " + string));
            }
        }
        if (bl && (eList = ((SIBus)(object = (EObject)jsBusImpl.getEObject())).getBusMembers()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SIBusMember sIBusMember = (SIBusMember)iterator.next();
                EList eList2 = sIBusMember.getTarget();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    SIBusMemberTarget sIBusMemberTarget = (SIBusMemberTarget)iterator2.next();
                    hashSet.add(sIBusMemberTarget.getEngineUuid());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            object = new Integer(hashSet.size());
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineSet", (Object)((Integer)object).toString());
        }
        return hashSet;
    }

    public String[] showMessagingEngines() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"showMessagingEngines");
        }
        String[] stringArray = new String[_messagingEngines.size()];
        Enumeration enumeration = this.listMessagingEngines();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            stringArray[n++] = ((BaseMessagingEngineImpl)e).getBusName() + ":" + ((BaseMessagingEngineImpl)e).getName() + ":" + ((BaseMessagingEngineImpl)e).getState();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"showMessagingEngines", (Object)stringArray);
        }
        return stringArray;
    }

    public void startMessagingEngine(String string, String string2) throws Exception {
        BaseMessagingEngineImpl baseMessagingEngineImpl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startMessagingEngine", (Object)(string + string2));
        }
        if ((baseMessagingEngineImpl = (BaseMessagingEngineImpl)this.getMessagingEngine(string, string2)) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + string + " name=" + string2 + ">"));
            }
            throw new Exception("The messaging engine <bus=" + string + " name=" + string2 + "> does not exist");
        }
        baseMessagingEngineImpl.startConditional();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startMessagingEngine");
        }
    }

    public void stopMessagingEngine(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMessagingEngine", (Object)(string + string2));
        }
        this.stopMessagingEngine(string, string2, 0);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopMessagingEngine");
        }
    }

    public void stopMessagingEngine(String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMessagingEngine", (Object)(string + string2 + string3));
        }
        int n = Integer.parseInt(string3);
        this.stopMessagingEngine(string, string2, n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopMessagingEngine");
        }
    }

    private void stopMessagingEngine(String string, String string2, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMessagingEngine", (Object)(string + string2 + n));
        }
        if (n < 0 || n > 1) {
            throw new Exception("Invalid stop mode <" + n + "> specified");
        }
        BaseMessagingEngineImpl baseMessagingEngineImpl = (BaseMessagingEngineImpl)this.getMessagingEngine(string, string2);
        if (baseMessagingEngineImpl == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + string + " name=" + string2 + ">"));
            }
            throw new Exception("The messaging engine <bus=" + string + " name=" + string2 + "> does not exist");
        }
        baseMessagingEngineImpl.stopConditional(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopMessagingEngine");
        }
    }

    private void setAttributes(BaseMessagingEngineImpl baseMessagingEngineImpl, SIBMessagingEngineImpl sIBMessagingEngineImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttributes", (Object)(baseMessagingEngineImpl.getBusName() + baseMessagingEngineImpl.getName()));
        }
        Iterator iterator = sIBMessagingEngineImpl.eContents().iterator();
        EClass eClass = sIBMessagingEngineImpl.eClass();
        EList eList = eClass.getEAllAttributes();
        Iterator iterator2 = eList.iterator();
        while (iterator2.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator2.next();
            baseMessagingEngineImpl.setAttribute(eAttribute.getName(), this.getAttributeValue((EObject)sIBMessagingEngineImpl, eAttribute));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttributes");
        }
    }

    public String getAttribute(BaseMessagingEngineImpl baseMessagingEngineImpl, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttribute", (Object)(baseMessagingEngineImpl.getBusName() + baseMessagingEngineImpl.getName() + string));
        }
        Enumeration enumeration = _messagingEngines.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            JsMessagingEngine jsMessagingEngine = ((MessagingEngine)v).getRuntime();
            if (!(baseMessagingEngineImpl instanceof BaseMessagingEngineImpl) || baseMessagingEngineImpl != jsMessagingEngine) continue;
            String string2 = this.getAttributeValue((EObject)((MessagingEngine)v).getConfig(), string);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAttribute", (Object)string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttribute", (Object)"");
        }
        return "";
    }

    private String getAttributeValue(EObject eObject, EAttribute eAttribute) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttributeValue");
        }
        String string = (object = eObject.eGet((EStructuralFeature)eAttribute)) == null ? "" : object.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttributeValue", (Object)string);
        }
        return string;
    }

    private String getAttributeValue(EObject eObject, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttributeValue", (Object)string);
        }
        Iterator iterator = eObject.eContents().iterator();
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        Iterator iterator2 = eList.iterator();
        while (iterator2.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator2.next();
            if (!eAttribute.getName().equals(string)) continue;
            String string2 = this.getAttributeValue(eObject, eAttribute);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAttributeValue", (Object)string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttributeValue", (Object)"");
        }
        return "";
    }

    public void activateJMSResource() {
        if (this._jmsResource == null) {
            this._jmsResource = new SIBJMSResource();
        }
    }

    public void deactivateJMSResource() {
        if (this._jmsResource != null) {
            this._jmsResource.deactivateMBean();
            this._jmsResource = null;
        }
    }

    public Object getService(Class clazz) {
        return super.getService(clazz);
    }

    public void releaseService(Object object) {
        super.releaseService(object);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getPropertyName().equals("state")) {
            if (propertyChangeEvent.getNewValue().equals("STARTED")) {
                this.serverStarted();
            } else if (propertyChangeEvent.getNewValue().equals("STOPPING")) {
                this.serverStopping();
            }
        }
    }

    public boolean isServerStarted() {
        return this._serverStarted;
    }

    public boolean isServerStopping() {
        return this._serverStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsHealthState getHealthState() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        JsHealthState jsHealthState = this.recordedHealth;
        Enumeration enumeration = _processComponents.elements();
        while (jsHealthState.couldBeWorse() && enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            JsProcessComponent jsProcessComponent = ((ComponentList)object).getRef();
            if (!(jsProcessComponent instanceof JsMonitoredComponent)) continue;
            JsHealthState jsHealthState2 = ((JsMonitoredComponent)jsProcessComponent).getHealthState();
            String string = jsProcessComponent.getClass().getName();
            SibTr.debug((TraceComponent)tc, (String)("SIBService" + string + " component reported health: " + jsHealthState2));
            jsHealthState = jsHealthState.moreSevere(jsHealthState2);
        }
        object = this.recordedHealth;
        synchronized (object) {
            this.recordedHealth = this.recordedHealth.moreSevere(jsHealthState);
        }
        SibTr.debug((TraceComponent)tc, (String)("SIBService finished monitoring components; aggregate health is: " + jsHealthState));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState");
        }
        return jsHealthState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLocalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportLocalError");
        }
        JsHealthState jsHealthState = JsHealthState.getLocalError();
        JsHealthState jsHealthState2 = this.recordedHealth;
        synchronized (jsHealthState2) {
            this.recordedHealth = this.recordedHealth.moreSevere(jsHealthState);
        }
        SibTr.debug((TraceComponent)tc, (String)"SIBService recorded local error reported by component.");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportLocalError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportGlobalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportGlobalError");
        }
        JsHealthState jsHealthState = JsHealthState.getGlobalError();
        JsHealthState jsHealthState2 = this.recordedHealth;
        synchronized (jsHealthState2) {
            this.recordedHealth = this.recordedHealth.moreSevere(jsHealthState);
        }
        SibTr.debug((TraceComponent)tc, (String)"SIBService recorded global error reported by component.");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportGlobalError");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        JsEngineComponent jsEngineComponent;
        Object object;
        block24: {
            ConfigChangeNotifier[] configChangeNotifierArray;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"configChanged");
            }
            if ((configChangeNotifierArray = configRepositoryEvent.getChanges()).length > 0) {
                object = configChangeNotifierArray[0].getUri();
                if (tc.isDebugEnabled() && configChangeNotifierArray.length != 1) {
                    SibTr.debug((TraceComponent)tc, (String)("configChanged: number of changes=" + configChangeNotifierArray.length + " (only first will be processed)"));
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("configChanged: uri of changed file=" + (String)object));
                }
                object = ((String)object).substring(((String)object).indexOf("/", 7));
                try {
                    JsEObjectImpl jsEObjectImpl;
                    Object object2;
                    Object object3;
                    Resource resource = this._repository.getConfigRoot().getResource(0, (String)object);
                    jsEngineComponent = resource.getContents();
                    Iterator iterator = resource.getContents().iterator();
                    int n = jsEngineComponent.size();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("configChanged: MEs found in config file=" + n));
                    }
                    ArrayList arrayList = new ArrayList(_messagingEngines.keySet());
                    ArrayList<BaseMessagingEngineImpl> arrayList2 = new ArrayList<BaseMessagingEngineImpl>();
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        if (!(object3 instanceof SIBMessagingEngineImpl)) continue;
                        object2 = (SIBMessagingEngineImpl)object3;
                        jsEObjectImpl = this.getBusProxy((SIBMessagingEngineImpl)object2);
                        if (((JsBusImpl)jsEObjectImpl).isConfigurationReloadEnabled()) {
                            BaseMessagingEngineImpl baseMessagingEngineImpl;
                            MessagingEngine messagingEngine;
                            if (!_messagingEngines.containsKey(object2.getUuid())) {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("configChanged: create ME :" + object2.getName()));
                                }
                                messagingEngine = this.createMessageEngine((SIBMessagingEngineImpl)object2);
                                baseMessagingEngineImpl = (BaseMessagingEngineImpl)messagingEngine.getRuntime();
                                baseMessagingEngineImpl.initialize(null);
                                this.setCustomProperties(baseMessagingEngineImpl);
                                this.setAttributes(baseMessagingEngineImpl, messagingEngine.getConfig());
                                arrayList2.add(baseMessagingEngineImpl);
                                continue;
                            }
                            messagingEngine = (MessagingEngine)_messagingEngines.get(object2.getUuid());
                            baseMessagingEngineImpl = (BaseMessagingEngineImpl)messagingEngine.getRuntime();
                            if (baseMessagingEngineImpl.isInDynConfigUpdate()) {
                                this.reloadEngine(baseMessagingEngineImpl, (SIBMessagingEngineImpl)object2);
                            }
                            arrayList.remove(object2.getUuid());
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("configChanged: bus reload disabled skip ME :" + object2.getName()));
                        }
                        arrayList.remove(object2.getUuid());
                    }
                    if (arrayList2.size() > 0) {
                        try {
                            object3 = (ResourceMgr)this.getService(ResourceMgr.class);
                            object3.reload();
                            this.releaseService(object3);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.configChanged", (String)"1879", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)exception);
                            SibTr.debug((TraceComponent)tc, (String)"Exception reloading ResourceMgr", (Object)exception);
                        }
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            try {
                                ((BaseMessagingEngineImpl)arrayList2.get(i)).startConditional();
                                continue;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.configChanged", (String)"1888", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)exception);
                                SibTr.debug((TraceComponent)tc, (String)"Exception calling engine.startConditional()", (Object)exception);
                            }
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("configChanged: number of MEs deleted=" + arrayList.size()));
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            object2 = (MessagingEngine)_messagingEngines.get(arrayList.get(i));
                            jsEObjectImpl = (BaseMessagingEngineImpl)((MessagingEngine)object2).getRuntime();
                            this._dynConfigManager.removeNotifiedME((BaseMessagingEngineImpl)jsEObjectImpl);
                            ((BaseMessagingEngineImpl)jsEObjectImpl).stopConditional(0);
                            if (!tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)("configChanged: stopped ME :" + arrayList.get(i)));
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsMainImpl.configChanged", (String)"1525", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    if (!tc.isDebugEnabled()) break block24;
                    SibTr.debug((TraceComponent)tc, (String)("configChanged: Exception thrown, " + exception));
                }
            }
        }
        object = this._dynConfigManager.getNotifiedMEs();
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            jsEngineComponent = (JsEngineComponent)((ArrayList)object).get(i);
            jsEngineComponent.engineReloaded((JsMessagingEngine)jsEngineComponent);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    private void reloadEngine(BaseMessagingEngineImpl baseMessagingEngineImpl, SIBMessagingEngineImpl sIBMessagingEngineImpl) throws Exception {
        SIBLocalizationPoint sIBLocalizationPoint;
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reloadEngine", (Object)baseMessagingEngineImpl.getName());
        }
        boolean bl = false;
        ArrayList arrayList = baseMessagingEngineImpl.getLPConfigObjects();
        EList eList = sIBMessagingEngineImpl.getLocalizationPoints();
        HashMap<String, SIBLocalizationPoint> hashMap = new HashMap<String, SIBLocalizationPoint>();
        for (n = 0; n < arrayList.size(); ++n) {
            SIBLocalizationPoint sIBLocalizationPoint2 = (SIBLocalizationPoint)arrayList.get(n);
            hashMap.put(sIBLocalizationPoint2.getUuid(), sIBLocalizationPoint2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("reloadEngine: Total number of existing LPs = " + hashMap.size()));
            Iterator<Object> iterator = hashMap.values().iterator();
            sIBLocalizationPoint = null;
            while (iterator.hasNext()) {
                sIBLocalizationPoint = (SIBLocalizationPoint)iterator.next();
                SibTr.debug((TraceComponent)tc, (String)("reloadEngine:   ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid() + " TARGETUUID=" + sIBLocalizationPoint.getTargetUuid() + " CLASS=" + sIBLocalizationPoint.getClass()));
            }
            SibTr.debug((TraceComponent)tc, (String)("reloadEngine: Total number of LPs read from config file = " + eList.size()));
            iterator = eList.iterator();
            while (iterator.hasNext()) {
                sIBLocalizationPoint = (SIBLocalizationPoint)iterator.next();
                SibTr.debug((TraceComponent)tc, (String)("reloadEngine:   ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid() + " TARGETUUID=" + sIBLocalizationPoint.getTargetUuid() + " CLASS=" + sIBLocalizationPoint.getClass()));
            }
        }
        baseMessagingEngineImpl.startLocalizationPointUpdates();
        for (n = 0; n < eList.size(); ++n) {
            sIBLocalizationPoint = (SIBLocalizationPoint)eList.get(n);
            String string = sIBLocalizationPoint.getUuid();
            if (!hashMap.containsKey(string)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("reloadEngine: add LP ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid()));
                }
                if (!(sIBLocalizationPoint instanceof SIBMQLinkSenderChannelLocalizationPointImpl)) {
                    baseMessagingEngineImpl.addLocalizationPoint(sIBLocalizationPoint);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("reloadEngine: unexpected LP ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid()));
                }
                bl = true;
                continue;
            }
            SIBLocalizationPoint sIBLocalizationPoint3 = (SIBLocalizationPoint)hashMap.get(string);
            if (!(sIBLocalizationPoint3 instanceof SIBMQLinkSenderChannelLocalizationPointImpl)) {
                boolean bl2;
                boolean bl3 = bl2 = sIBLocalizationPoint.isSendAllowed() != sIBLocalizationPoint3.isSendAllowed() || sIBLocalizationPoint.getHighMessageThreshold() != sIBLocalizationPoint3.getHighMessageThreshold() || sIBLocalizationPoint.isSendAllowed() != sIBLocalizationPoint3.isSendAllowed();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("reloadEngine: checking LP for changes, ID=" + sIBLocalizationPoint3.getIdentifier() + " UUID=" + sIBLocalizationPoint3.getUuid()));
                    String string2 = "reloadEngine: changes detected: ";
                    if (sIBLocalizationPoint.isSendAllowed() != sIBLocalizationPoint3.isSendAllowed()) {
                        string2 = "SendAllowed (old=" + sIBLocalizationPoint3.isSendAllowed() + ", new=" + sIBLocalizationPoint.isSendAllowed() + ") ";
                    }
                    if (sIBLocalizationPoint.getHighMessageThreshold() != sIBLocalizationPoint3.getHighMessageThreshold()) {
                        string2 = string2 + "HighMessageThreshold (old=" + sIBLocalizationPoint3.getHighMessageThreshold() + ", new=" + sIBLocalizationPoint.getHighMessageThreshold() + ") ";
                    }
                    if (bl2) {
                        SibTr.debug((TraceComponent)tc, (String)string2);
                    }
                }
                if (bl2) {
                    baseMessagingEngineImpl.alterLocalizationPoint(sIBLocalizationPoint);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("reloadEngine: unexpected LP ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid()));
            }
            hashMap.remove(string);
        }
        if (!hashMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("reloadEngine: number of LPs to delete=" + hashMap.size()));
            }
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                sIBLocalizationPoint = (SIBLocalizationPoint)iterator.next();
                if (!(sIBLocalizationPoint instanceof SIBMQLinkSenderChannelLocalizationPointImpl)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("reloadEngine: delete LP ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid()));
                    }
                    baseMessagingEngineImpl.deleteLocalizationPoint(sIBLocalizationPoint);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("reloadEngine: unexpected LP ID=" + sIBLocalizationPoint.getIdentifier() + " UUID=" + sIBLocalizationPoint.getUuid()));
                }
                bl = true;
            }
        }
        baseMessagingEngineImpl.endLocalizationPointUpdates();
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"reloadEngine: ME changed, tell subcomponents");
            }
            baseMessagingEngineImpl.engineReloaded((JsMessagingEngine)baseMessagingEngineImpl);
            baseMessagingEngineImpl.setLPConfigObjects((List)eList);
            this._dynConfigManager.removeNotifiedME(baseMessagingEngineImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reloadEngine");
        }
    }

    public StatsGroup getSibServiceStatsGroup() {
        return this._sibServiceStatsGroup;
    }

    public StatsGroup getSibEnginesStatsGroup() {
        return this._meStatsGroup;
    }

    public synchronized boolean isJsBusActivatable(JsBus jsBus) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isJsBusActivatable", (Object)jsBus);
        }
        boolean bl2 = bl = !jsBus.isSecure();
        if (!bl) {
            bl = this._securityServiceUp;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isJsBusActivatable", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public synchronized void addJsBusActivatableListener(JsBus jsBus, JsBusActivatableListener jsBusActivatableListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addJsBusActivatableListener", (Object)new Object[]{jsBus, jsBusActivatableListener});
        }
        this._activatableListeners.add(jsBusActivatableListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addJsBusActivatableListener");
        }
    }

    public synchronized void stateChanged(SecurityServiceEvent securityServiceEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stateChanged", (Object)securityServiceEvent);
        }
        if (securityServiceEvent.getState() == 1) {
            this._securityServiceUp = true;
            this.dispatchActivationListeners();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stateChanged");
        }
    }

    private synchronized void dispatchActivationListeners() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchActivationListeners");
        }
        Iterator iterator = this._activatableListeners.iterator();
        while (iterator.hasNext()) {
            JsBusActivatableListener jsBusActivatableListener = (JsBusActivatableListener)iterator.next();
            jsBusActivatableListener.busIsActivatable();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchActivationListeners");
        }
    }

    public boolean isServerInRecoveryMode() {
        return this._serverMode == 1;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsMainImpl.java, SIB.admin, WAS602.SIB, o0610.11 1.90.1.2");
        }
        _processComponents = new Vector();
        _messagingEngines = new Hashtable();
        jmeAutoClasses = new Vector();
        _busVector = new Vector();
    }

    class MessagingEngine {
        private SIBMessagingEngineImpl _meConfig = null;
        private SIBDatastoreImpl _dsConfig = null;
        private JsMessagingEngine _me = null;

        MessagingEngine(SIBMessagingEngineImpl sIBMessagingEngineImpl, JsMessagingEngine jsMessagingEngine) {
            this._meConfig = sIBMessagingEngineImpl;
            this._me = jsMessagingEngine;
        }

        MessagingEngine(SIBMessagingEngineImpl sIBMessagingEngineImpl, SIBDatastoreImpl sIBDatastoreImpl, JsMessagingEngine jsMessagingEngine) {
            this._meConfig = sIBMessagingEngineImpl;
            this._dsConfig = sIBDatastoreImpl;
            this._me = jsMessagingEngine;
        }

        SIBMessagingEngineImpl getConfig() {
            return this._meConfig;
        }

        SIBDatastoreImpl getDatastoreConfig() {
            return this._dsConfig;
        }

        JsMessagingEngine getRuntime() {
            return this._me;
        }
    }

    class ComponentList {
        private String _className;
        private JsProcessComponent _componentRef;

        ComponentList(String string, JsProcessComponent jsProcessComponent) {
            this._className = string;
            this._componentRef = jsProcessComponent;
        }

        String getClassName() {
            return this._className;
        }

        JsProcessComponent getRef() {
            return this._componentRef;
        }
    }
}

