/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.sibresources.SIBAbstractDestination;
import com.ibm.websphere.models.config.sibresources.SIBDestination;
import com.ibm.websphere.models.config.sibresources.SIBDestinationAlias;
import com.ibm.websphere.models.config.sibresources.SIBDestinationForeign;
import com.ibm.websphere.models.config.sibresources.SIBDestinationMediation;
import com.ibm.websphere.models.config.sibresources.SIBLocalizationPointRef;
import com.ibm.websphere.models.config.sibresources.SIBQueue;
import com.ibm.websphere.models.config.sibresources.SIBTopicSpace;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.impl.DestinationDefinitionImpl;
import com.ibm.ws.sib.admin.impl.JsAdminFactoryImpl;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsCacheMediation;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class JsCacheDestination {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsCacheDestination";
    private static final TraceComponent tc = SibTr.register((Class)JsCacheDestination.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private JsBusImpl _bus = null;
    private JsCacheMediation _mediationCache = null;
    private JsAdminFactory _jsaf = null;
    private Administrator _mpAdmin = null;
    private ArrayList _rawDestinations = new ArrayList();
    private HashMap _cacheByName = new HashMap();
    private HashMap _cacheByUuid = new HashMap();
    private HashMap mediationUuidMap = new HashMap();

    public JsCacheDestination(JsBusImpl jsBusImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsCacheDestination().<init>");
        }
        this._bus = jsBusImpl;
        try {
            this._jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populateCache();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsCacheDestination().<init>");
        }
    }

    private void populateCache() {
        URI uRI;
        WASResourceSetImpl wASResourceSetImpl;
        String string;
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateCache");
        }
        String string3 = null;
        Resource resource = null;
        SIBDestinationMediation sIBDestinationMediation = null;
        MediationDefinition mediationDefinition = null;
        try {
            object2 = JsAdminService.getInstance();
            object = (Repository)object2.getService(Repository.class);
            string2 = object.getConfigRoot().getConfigRootPath();
            string = object.getCellName();
            wASResourceSetImpl = new WASResourceSetImpl();
            string3 = "file:/" + string2 + "/cells/" + string + "/buses/" + this._bus.getName() + "/" + "sib-destinations.xml";
            uRI = URI.createURI((String)string3);
            resource = wASResourceSetImpl.createResource(uRI);
            resource.load(wASResourceSetImpl.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsCacheDestination.populateCache", (String)"5", (Object)this);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", string3);
        }
        object2 = resource.getContents().iterator();
        while (object2.hasNext()) {
            SIBLocalizationPointRef sIBLocalizationPointRef;
            Object e;
            Iterator iterator;
            object = object2.next();
            if (object instanceof SIBDestination) {
                this._rawDestinations.add(object);
            }
            if (object instanceof SIBQueue) {
                string2 = (SIBQueue)object;
                string = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((SIBDestination)string2);
                wASResourceSetImpl = string2.getDestinationMediationRef();
                if (wASResourceSetImpl != null) {
                    sIBDestinationMediation = this.getMediationCache()._getSIBMediationByUuid(wASResourceSetImpl.getMediationUuid());
                    mediationDefinition = ((JsAdminFactoryImpl)this._jsaf).createMediationDefinition(sIBDestinationMediation);
                    string.setMediationDefinition(mediationDefinition);
                    uRI = wASResourceSetImpl.getLocalizationPointRefs();
                    iterator = uRI.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        sIBLocalizationPointRef = (SIBLocalizationPointRef)e;
                        this.addMediationEntry(string2.getUuid(), sIBLocalizationPointRef.getEngineUuid());
                    }
                }
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)string, (SIBAbstractDestination)string2);
                continue;
            }
            if (object instanceof SIBTopicSpace) {
                string2 = (SIBTopicSpace)object;
                string = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((SIBDestination)string2);
                wASResourceSetImpl = string2.getDestinationMediationRef();
                if (wASResourceSetImpl != null) {
                    sIBDestinationMediation = this.getMediationCache()._getSIBMediationByUuid(wASResourceSetImpl.getMediationUuid());
                    mediationDefinition = ((JsAdminFactoryImpl)this._jsaf).createMediationDefinition(sIBDestinationMediation);
                    string.setMediationDefinition(mediationDefinition);
                    uRI = wASResourceSetImpl.getLocalizationPointRefs();
                    iterator = uRI.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        sIBLocalizationPointRef = (SIBLocalizationPointRef)e;
                        this.addMediationEntry(string2.getUuid(), sIBLocalizationPointRef.getEngineUuid());
                    }
                }
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)string, (SIBAbstractDestination)string2);
                continue;
            }
            if (object instanceof SIBDestinationAlias) {
                string2 = (SIBDestinationAlias)object;
                string = ((JsAdminFactoryImpl)this._jsaf).createDestinationAliasDefinition((SIBDestinationAlias)object);
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)string, (SIBAbstractDestination)string2);
                continue;
            }
            if (!(object instanceof SIBDestinationForeign)) continue;
            string2 = (SIBDestinationForeign)object;
            string = ((JsAdminFactoryImpl)this._jsaf).createDestinationForeignDefinition((SIBDestinationForeign)object);
            if (string2.getBus() == null || string2.getBus().equals("")) {
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)string, (SIBAbstractDestination)string2);
                continue;
            }
            this.addEntry(string2.getBus(), (BaseDestinationDefinition)string, (SIBAbstractDestination)string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateCache");
        }
    }

    private void addEntry(String string, BaseDestinationDefinition baseDestinationDefinition, SIBAbstractDestination sIBAbstractDestination) {
        HashMap<String, DestinationMapEntry> hashMap;
        HashMap hashMap2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addEntry", (Object)new Object[]{string, baseDestinationDefinition, sIBAbstractDestination});
        }
        if ((hashMap2 = (HashMap)this._cacheByName.get(string)) == null) {
            hashMap = new HashMap<String, DestinationMapEntry>();
            hashMap.put(sIBAbstractDestination.getIdentifier(), new DestinationMapEntry(baseDestinationDefinition, sIBAbstractDestination));
            this._cacheByName.put(string, hashMap);
        } else {
            hashMap2.put(sIBAbstractDestination.getIdentifier(), new DestinationMapEntry(baseDestinationDefinition, sIBAbstractDestination));
        }
        hashMap2 = (HashMap)this._cacheByUuid.get(string);
        if (hashMap2 == null) {
            hashMap = new HashMap();
            hashMap.put(sIBAbstractDestination.getUuid(), new DestinationMapEntry(baseDestinationDefinition, sIBAbstractDestination));
            this._cacheByUuid.put(string, hashMap);
        } else {
            hashMap2.put(sIBAbstractDestination.getUuid(), new DestinationMapEntry(baseDestinationDefinition, sIBAbstractDestination));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addEntry");
        }
    }

    private BaseDestinationDefinition getEntryByName(String string, String string2) {
        DestinationMapEntry destinationMapEntry;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEntryByName", (Object)new Object[]{string, string2});
        }
        if ((hashMap = (HashMap)this._cacheByName.get(string)) != null && (destinationMapEntry = (DestinationMapEntry)hashMap.get(string2)) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getEntryByName", (Object)new Object[]{destinationMapEntry.getDestinationDefinition()});
            }
            return destinationMapEntry.getDestinationDefinition();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEntryByName", (Object)"null");
        }
        return null;
    }

    private BaseDestinationDefinition getEntryByUuid(String string, String string2) {
        DestinationMapEntry destinationMapEntry;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEntryByUuid", (Object)new Object[]{string, string2});
        }
        if ((hashMap = (HashMap)this._cacheByUuid.get(string)) != null && (destinationMapEntry = (DestinationMapEntry)hashMap.get(string2)) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getEntryByUuid", (Object)new Object[]{destinationMapEntry.getDestinationDefinition()});
            }
            return destinationMapEntry.getDestinationDefinition();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEntryByUuid", (Object)"null");
        }
        return null;
    }

    private void illegalArguments(String string) throws SIBExceptionBase {
        throw new SIBExceptionBase("Illegal argument value(s) specified; " + string);
    }

    public BaseDestinationDefinition getSIBDestination(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        BaseDestinationDefinition baseDestinationDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestination", (Object)new Object[]{string, string2});
        }
        String string3 = null;
        if (string2 == null) {
            this.illegalArguments("name is mandatory");
        }
        if ((baseDestinationDefinition = this.getEntryByName(string3 = string == null || string.equals("") ? this._bus.getName() : string, string2)) == null) {
            throw new SIBExceptionDestinationNotFound(string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestination", (Object)new Object[]{baseDestinationDefinition});
        }
        return baseDestinationDefinition;
    }

    public BaseDestinationDefinition getSIBDestinationByUuid(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        BaseDestinationDefinition baseDestinationDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationByUuid", (Object)new Object[]{string, string2});
        }
        String string3 = null;
        if (string2 == null) {
            this.illegalArguments("uuid is mandatory");
        }
        if ((baseDestinationDefinition = this.getEntryByUuid(string3 = string == null || string.equals("") ? this._bus.getName() : string, string2)) == null) {
            throw new SIBExceptionDestinationNotFound(string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationByUuid", (Object)new Object[]{baseDestinationDefinition});
        }
        return baseDestinationDefinition;
    }

    public void getSIBDestination(String string, String string2, DestinationDefinition destinationDefinition) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        SIBAbstractDestination sIBAbstractDestination;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestination", (Object)(string + " " + string2));
        }
        String string3 = null;
        if (string2 == null || destinationDefinition == null) {
            this.illegalArguments("name or dd are mandatory");
        }
        if ((sIBAbstractDestination = this._getSIBDestination(string3 = string == null || string.equals("") ? this._bus.getName() : string, string2)) == null) {
            throw new SIBExceptionDestinationNotFound(string2);
        }
        if (sIBAbstractDestination instanceof SIBDestination) {
            ((DestinationDefinitionImpl)destinationDefinition).reset((SIBDestination)sIBAbstractDestination);
        } else if (sIBAbstractDestination instanceof SIBDestinationAlias || sIBAbstractDestination instanceof SIBDestinationForeign) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestination");
        }
    }

    public Set getSIBDestinationLocalitySet(String string, String string2) throws SIBExceptionBase {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)new Object[]{string, string2});
        }
        if (string2 == null) {
            this.illegalArguments("name is mandatory");
        }
        if (string != null && !string.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        Set set = this._getSIBDestinationLocalitySet(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)new Integer(set.size()));
        }
        return set;
    }

    private SIBAbstractDestination _getSIBDestination(String string, String string2) {
        Object object;
        String string3;
        String string4;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBDestination", (Object)new Object[]{string, string2});
        }
        boolean bl = false;
        Resource resource = null;
        String string5 = null;
        String string6 = null;
        Object var7_7 = null;
        string5 = string == null || string.equals("") ? this._bus.getName() : string;
        try {
            object3 = JsAdminService.getInstance();
            object2 = (Repository)object3.getService(Repository.class);
            string4 = object2.getConfigRoot().getConfigRootPath();
            string3 = object2.getCellName();
            object = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)("file:/" + string4 + "/cells/" + string3 + "/buses/" + this._bus.getName() + "/" + "sib-destinations.xml"));
            resource = object.createResource(uRI);
            resource.load(object.getLoadOptions());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.JsCacheDestination._getSIBDestination", (String)"1", (Object)this);
            SibTr.info((TraceComponent)tc, (String)"CONFIG_LOAD_FAILED_SIAS0008", var7_7);
        }
        object3 = resource.getContents().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 instanceof SIBDestination) {
                string4 = (SIBDestination)object2;
                if (!string4.getIdentifier().equals(string2)) continue;
                string3 = string4.getIdentifier();
                object = string2;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"_getSIBDestination", (Object)new Object[]{string4});
                }
                return string4;
            }
            if (object2 instanceof SIBDestinationAlias) {
                string4 = (SIBDestinationAlias)object2;
                if (!string4.getIdentifier().equals(string2) || !(string6 = string4.getBus() == null || string4.getBus().equals("") ? this._bus.getName() : string4.getBus()).equals(string5)) continue;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"_getSIBDestination", (Object)new Object[]{string4});
                }
                return string4;
            }
            if (!(object2 instanceof SIBDestinationForeign) || !(string4 = (SIBDestinationForeign)object2).getIdentifier().equals(string2) || !(string6 = string4.getBus() == null || string4.getBus().equals("") ? this._bus.getName() : string4.getBus()).equals(string5)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"_getSIBDestination", (Object)new Object[]{string4});
            }
            return string4;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBDestination", (Object)"null");
        }
        return null;
    }

    private Set _getSIBDestinationLocalitySet(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBDestinationLocalitySet", (Object)new Object[]{string, string2});
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this._rawDestinations.iterator();
        while (iterator.hasNext()) {
            SIBDestination sIBDestination;
            Object e = iterator.next();
            if (!(e instanceof SIBDestination) || !(sIBDestination = (SIBDestination)e).getUuid().equals(string2)) continue;
            Iterator iterator2 = sIBDestination.getLocalizationPointRefs().iterator();
            while (iterator2.hasNext()) {
                SIBLocalizationPointRef sIBLocalizationPointRef = (SIBLocalizationPointRef)iterator2.next();
                hashSet.add(sIBLocalizationPointRef.getEngineUuid());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBDestinationLocalitySet", (Object)new Integer(hashSet.size()));
        }
        return hashSet;
    }

    private void addMediationEntry(String string, String string2) {
        Set set;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMediationEntry", (Object)new Object[]{string, string2});
        }
        if ((set = (Set)this.mediationUuidMap.get(string)) == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            this.mediationUuidMap.put(string, hashSet);
        } else {
            set.add(string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMediationEntry");
        }
    }

    public Set getMediationEntryByUuid(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationEntryByUuid", (Object)new Object[]{string});
        }
        Set set = (Set)this.mediationUuidMap.get(string);
        if (tc.isEntryEnabled()) {
            Integer n = set != null ? new Integer(set.size()) : new Integer(0);
            SibTr.exit((TraceComponent)tc, (String)"getMediationEntryByUuid", (Object)n);
        }
        return set;
    }

    private JsCacheMediation getMediationCache() {
        if (this._mediationCache != null) {
            return this._mediationCache;
        }
        return null;
    }

    void setMediationCache(JsCacheMediation jsCacheMediation) {
        this._mediationCache = jsCacheMediation;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsCacheDestination.java, SIB.admin, WAS602.SIB, o0610.11 1.20");
        }
    }

    private class DestinationMapEntry {
        private boolean _created = false;
        private BaseDestinationDefinition _dd = null;
        private boolean _requested = false;
        private Set _set = new HashSet();

        private DestinationMapEntry(BaseDestinationDefinition baseDestinationDefinition, SIBAbstractDestination sIBAbstractDestination) {
            this._dd = baseDestinationDefinition;
            this.buildLocalitySet(sIBAbstractDestination);
        }

        private void setCreated() {
            this._created = true;
        }

        private void buildLocalitySet(SIBAbstractDestination sIBAbstractDestination) {
            if (sIBAbstractDestination instanceof SIBDestination) {
                SIBDestination sIBDestination = (SIBDestination)sIBAbstractDestination;
                EList eList = sIBDestination.getLocalizationPointRefs();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    SIBLocalizationPointRef sIBLocalizationPointRef = (SIBLocalizationPointRef)iterator.next();
                    this._set.add(sIBLocalizationPointRef.getEngineUuid());
                }
            }
        }

        private BaseDestinationDefinition getDestinationDefinition() {
            return this._dd;
        }
    }
}

