/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.impl.SIBDatastoreImpl;
import com.ibm.websphere.models.config.sibresources.impl.SIBMessagingEngineImpl;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.HAManagerMessagingEngine;
import com.ibm.ws.sib.admin.impl.HAManagerMessagingEngineMBean;
import com.ibm.ws.sib.admin.impl.JsActivationThread;
import com.ibm.ws.sib.admin.impl.JsBusActivatableListener;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsDeactivationThread;
import com.ibm.ws.sib.admin.impl.JsMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class HAManagerMessagingEngineImpl
extends BaseMessagingEngineImpl
implements HAManagerMessagingEngine,
HAManagerMessagingEngineMBean,
JsBusActivatableListener,
HAGroupCallback {
    private static final TraceComponent tc = SibTr.register((Class)HAManagerMessagingEngineImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl";
    private AsynchOperationComplete _activationCallback = null;
    private Object _activationCallbackContext = null;
    private JsActivationThread _activationThread = null;
    private AsynchOperationComplete _deactivationCallback = null;
    private Object _deactivationCallbackContext = null;
    private JsDeactivationThread _deactivationThread = null;
    private GroupManager _groupManager;
    protected GroupName _groupName;
    private Map _groupProps;
    private Map _memberProps;
    protected HAGroup _haGroup;

    public HAManagerMessagingEngineImpl(JsMainImpl jsMainImpl, JsBusImpl jsBusImpl, SIBMessagingEngineImpl sIBMessagingEngineImpl, SIBDatastoreImpl sIBDatastoreImpl) {
        super(jsMainImpl, jsBusImpl, sIBMessagingEngineImpl, sIBDatastoreImpl);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"HAMessagingEngineImpl().<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"HAMessagingEngineImpl().<init>");
        }
    }

    public final void busIsActivatable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"busIsActivatable");
        }
        if (!this._activationThread.isAlive()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Starting activation thread for ME");
            }
            this._activationThread.start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"busIsActivatable");
        }
    }

    private void createGroupName() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createGroupName");
        }
        this._groupProps = new HashMap();
        this._groupProps.put("type", "WSAF_SIB");
        this._groupProps.put("WSAF_SIB_MESSAGING_ENGINE", this._name);
        this._groupProps.put("WSAF_SIB_BUS", this._bus.getName());
        String string = null;
        Server server = (Server)this._mainImpl.getService(Server.class);
        if (server != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getService located Server");
            }
            string = server.getClusterName();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("clusterName is " + string));
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getService of Server failed");
            }
            throw new RuntimeWarning("Could not get Server service. ME " + this._name + " cannot start.");
        }
        if (string != null) {
            this._groupProps.put("IBM_hc", string);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"invoke GroupManager.createGroupName ");
        }
        try {
            this._groupName = this._groupManager.createGroupName(this._groupProps);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.createGroupName", (String)"8", (Object)this, (Object[])new Object[]{this._groupManager, this._groupProps, string});
            SibTr.error((TraceComponent)tc, (String)"FAILED_TO_CREATE_GROUP_NAME_SIAS0041");
            SibTr.exception((TraceComponent)tc, (Exception)((Object)hAException));
            throw new RuntimeWarning("Could not create GroupName for ME " + this._name);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"created GroupName");
        }
        if (tc.isDebugEnabled()) {
            if (this._groupName == null) {
                SibTr.debug((TraceComponent)tc, (String)"_groupName is null");
            } else {
                Map map = this._groupName.getGroupProperties();
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Object v = map.get(string2);
                    SibTr.debug((TraceComponent)tc, (String)("groupNameSet contains " + string2 + " = " + v));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createGroupName");
        }
    }

    private void createMemberProps() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMemberProps");
        }
        this._memberProps = new HashMap();
        if (tc.isDebugEnabled()) {
            Iterator iterator = this._memberProps.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this._memberProps.get(string);
                if (v == null) {
                    SibTr.debug((TraceComponent)tc, (String)("memberProps contains key " + string + ", no value"));
                    continue;
                }
                SibTr.debug((TraceComponent)tc, (String)("memberProps contains key " + string + ", value " + v));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMemberProps");
            }
        }
    }

    public final GroupName getHAGroupName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHAGroupName");
        }
        SibTr.push((Object)this);
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHAGroupName");
        }
        return this._groupName;
    }

    public final boolean isAlive(GroupName groupName) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlive");
        }
        SibTr.push((Object)this);
        if (this._state == 2 || this._state == 0 || this._state == 1 || this._state == 3 || this._state == 11 || this._state == 12) {
            SibTr.pop();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)("isAlive is false - MessagingEngine is not in HAGroup:" + groupName));
            }
            return false;
        }
        JsHealthState jsHealthState = this.assessHealth();
        if (jsHealthState.isOK()) {
            bl = true;
        } else if (jsHealthState.isLocalError()) {
            SibTr.error((TraceComponent)tc, (String)"ME_ERROR_LOCAL_SIAS0046", (Object)this._name);
            bl = false;
        } else if (jsHealthState.isGlobalError()) {
            SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)this._name);
            this.setState(13);
            bl = true;
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("isAlive: " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"memberDeactivate");
        }
        SibTr.push((Object)this);
        HAManagerMessagingEngineImpl hAManagerMessagingEngineImpl = this;
        synchronized (hAManagerMessagingEngineImpl) {
            this._deactivationCallback = asynchOperationComplete;
            this._deactivationCallbackContext = object;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " is in state " + this.getState()));
            }
            if (this._state != 7 && this._state != 10 && this._state != 13) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Instance of ME is not in a state from which it can be deactivated");
                }
                this.reportDeactivation(false, " Messaging engine " + this._name + " could not be deactivated in state " + this.getState());
                bl = false;
            }
            if (bl && this._state == 10) {
                this.setState(4);
                this.reportDeactivation(true, " Successful deactivation ");
            }
            if (bl && (this._state == 7 || this._state == 13)) {
                this.setState(9);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Creating deactivation thread for ME");
                }
                this._deactivationThread = new JsDeactivationThread(this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Starting deactivation thread for ME");
                }
                if (!this._deactivationThread.isAlive()) {
                    this._deactivationThread.start();
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Returning control to HAManager");
            }
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"memberDeactivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"memberIsActivated");
        }
        SibTr.push((Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"take synch lock on ME");
        }
        HAManagerMessagingEngineImpl hAManagerMessagingEngineImpl = this;
        synchronized (hAManagerMessagingEngineImpl) {
            block26: {
                this._activationCallback = asynchOperationComplete;
                this._activationCallbackContext = object;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " is in state " + this.getState()));
                }
                if (this._state != 2 && this._state != 3 && this._state != 4) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Instance of ME cannot be activated from state " + this.getState()));
                    }
                    this.reportActivation(false, " Activation of messaging engine " + this._name + " failed because messaging engine is in state " + this.getState());
                    bl = false;
                }
                if (bl && this._state == 2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("ME in " + this.getState() + " cannot be activated"));
                    }
                    bl = false;
                    this.reportActivation(false, " Activation of messaging engine  " + this._name + " failed because messaging engine is in state " + this.getState());
                    try {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Leaving HAGroup");
                        }
                        this._haGroup.leave();
                    }
                    catch (HAException hAException) {
                        if (!tc.isDebugEnabled()) break block26;
                        SibTr.debug((TraceComponent)tc, (String)("Continuing stop, despite HAException caught " + (Object)((Object)hAException)));
                    }
                }
            }
            if (bl && (this._state == 3 || this._state == 4)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Instance being activated");
                }
                if (this._enabled) {
                    this.setState(5);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Creating activation thread for ME");
                    }
                    this._activationThread = new JsActivationThread(this);
                    boolean bl2 = Boolean.valueOf(this.getBus().getAttribute("secure"));
                    JsMainImpl jsMainImpl = this._mainImpl;
                    synchronized (jsMainImpl) {
                        boolean bl3 = this._mainImpl.isJsBusActivatable(this._bus);
                        if (bl3) {
                            this.busIsActivatable();
                        } else {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Delaying start of messaging engine until activatable");
                            }
                            this._mainImpl.addJsBusActivatableListener(this._bus, this);
                        }
                    }
                } else {
                    this.setState(10);
                    SibTr.debug((TraceComponent)tc, (String)("Activating MBean for ME " + this.getName()));
                    this.activateMBean("SIBMessagingEngine", (EObject)this._me, this._me.getName(), null);
                    this.reportActivation(true, " Successful activation ");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Returning control to HAManager");
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"memberIsActivated");
        }
    }

    public final void memberMayActivate(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"memberMayActivate");
        }
        SibTr.push((Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"memberMayActivate ignored", (Object)groupName.toString());
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"memberMayActivate");
        }
    }

    public final void memberMayActivateCancelled(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"memberMayActivateCancelled");
        }
        SibTr.push((Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"memberMayActivateCancelled ignored", (Object)groupName.toString());
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"memberMayActivateCancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"membershipChanged()");
        }
        SibTr.push((Object)this);
        HAManagerMessagingEngineImpl hAManagerMessagingEngineImpl = this;
        synchronized (hAManagerMessagingEngineImpl) {
            if (this._state == 2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("ME in " + this.getState() + " intends to leave group"));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Leaving HAGroup");
                    }
                    this._haGroup.leave();
                }
                catch (HAException hAException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Continuing stop, despite HAException caught " + (Object)((Object)hAException)));
                    }
                }
            } else if (this._state == 3) {
                this.setState(4);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"membershipChanged seen, but ignored");
            }
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"membershipChanged");
        }
    }

    public final void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onMessage");
        }
        SibTr.push((Object)this);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"onMessage ignored");
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onMessage");
        }
    }

    private void reportActivation(boolean bl, String string) {
        boolean bl2 = true;
        AsynchOperationComplete asynchOperationComplete = this._activationCallback;
        Object object = this._activationCallbackContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportActivation");
        }
        if (asynchOperationComplete == null || object == null) {
            if (this._state != 2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"HAManager and MessagingEngine loss of synch. Fatal. Server will be killed.");
                }
                this.reportLocalError();
            }
            bl2 = false;
        }
        if (bl2) {
            try {
                if (bl) {
                    asynchOperationComplete.success(object, (Object)("ME " + this._name + " activated"));
                } else {
                    SibTr.error((TraceComponent)tc, (String)"HAMANAGER_ACTIVATION_FAILED_SIAS0039", (Object)this._name);
                    asynchOperationComplete.failed(object, "< Messaging Engine " + this._name + " could not be activated: " + string + " >", null);
                }
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.reportActivation", (String)"9", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"HAMANAGER_LOST_SYNC_SIAS0040");
                SibTr.exception((TraceComponent)tc, (Exception)((Object)hAParameterRejectedException));
                this.reportLocalError();
            }
        }
        this._activationCallback = null;
        this._activationCallbackContext = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportActivation");
        }
    }

    private void reportDeactivation(boolean bl, String string) {
        boolean bl2 = true;
        AsynchOperationComplete asynchOperationComplete = this._deactivationCallback;
        Object object = this._deactivationCallbackContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportDeactivation");
        }
        if (asynchOperationComplete == null || object == null) {
            if (this._state != 2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"HAManager and MessagingEngine loss of synch. Fatal. Server will be killed.");
                }
                this.reportLocalError();
            }
            bl2 = false;
        }
        if (bl2) {
            try {
                if (bl) {
                    asynchOperationComplete.success(object, (Object)("ME " + this._name + " deactivated"));
                } else {
                    SibTr.error((TraceComponent)tc, (String)"HAMANAGER_DEACTIVATION_FAILED_SIAS0041", (Object)this._name);
                    asynchOperationComplete.failed(object, "< Messaging Engine " + this._name + " could not be deactivated: " + string + " >", null);
                }
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.reportDeactivation", (String)"10", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"HAMANAGER_LOST_SYNC_SIAS0040");
                SibTr.exception((TraceComponent)tc, (Exception)((Object)hAParameterRejectedException));
                this.reportLocalError();
            }
        }
        this._deactivationCallback = null;
        this._deactivationCallbackContext = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportDeactivation");
        }
    }

    public void startConditional() throws RuntimeWarning, RuntimeError {
        JsMainImpl jsMainImpl;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"startConditional");
            }
            SibTr.push((Object)this);
            JsAdminService jsAdminService = JsAdminService.getInstance();
            jsMainImpl = null;
            try {
                jsMainImpl = (JsMainImpl)jsAdminService.getAdminMain();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug((TraceComponent)tc, (String)"Caught expection from getAdminMain");
            }
        }
        if (!jsMainImpl.isHAEnabled()) {
            super.startConditional();
        } else {
            this.join();
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startConditional");
        }
    }

    public void stopConditional(int n) {
        JsMainImpl jsMainImpl;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)("stopConditional mode " + n));
            }
            SibTr.push((Object)this);
            JsAdminService jsAdminService = JsAdminService.getInstance();
            jsMainImpl = null;
            try {
                jsMainImpl = (JsMainImpl)jsAdminService.getAdminMain();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug((TraceComponent)tc, (String)"Caught expection from getAdminMain");
            }
        }
        if (!jsMainImpl.isHAEnabled()) {
            super.stopConditional(n);
        } else {
            this.leave();
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopConditional");
        }
    }

    public final synchronized void activate() {
        boolean bl = true;
        boolean bl2 = true;
        String string = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activate");
        }
        SibTr.push((Object)this);
        if (this._state != 5) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("activate called, but ME already moved to state: " + this.getState()));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Activation was cancelled by stopConditional()");
            }
            bl = false;
            bl2 = false;
        }
        SibTr.debug((TraceComponent)tc, (String)("Activating MBean for ME " + this.getName()));
        this.activateMBean("SIBMessagingEngine", (EObject)this._me, this._me.getName(), null);
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Starting ME");
            }
            this.setState(6);
            try {
                this.start(0);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.autostartME", (String)"1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"ME_EXCEPTION_CAUGHT_SIAS0037", (Object)new Object[]{this._name, "BaseMessagingEngineImpl", "start()"});
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                bl = false;
                string = new String(" Exception caught during start of a subcomponent: " + exception);
            }
        }
        if (this._state != 7) {
            bl = false;
            if (string == null) {
                string = new String(" Refer to earlier error messages ");
            }
        }
        if (bl) {
            if (bl2) {
                this.reportActivation(true, "Successful activation");
            }
        } else if (bl2) {
            this.setState(4);
            this.reportActivation(false, string);
            SibTr.debug((TraceComponent)tc, (String)("Deactivating MBean for ME " + this.getName()));
            this.deactivateMBean();
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    public final synchronized void deactivate() {
        boolean bl = true;
        boolean bl2 = true;
        Object var3_3 = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deactivate");
        }
        SibTr.push((Object)this);
        if (this._state != 9) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("deactivate called, but ME already moved to state: " + this.getState()));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Deactivation was cancelled by stopConditional()");
            }
            bl = false;
            bl2 = false;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Stopping ME");
            }
            this.stop(0);
        }
        SibTr.debug((TraceComponent)tc, (String)("Deactivating MBean for ME " + this.getName()));
        this.deactivateMBean();
        if (bl) {
            this.setState(4);
            if (bl2) {
                this.reportDeactivation(true, "Successful deactivation");
            }
        } else if (bl2) {
            this.reportDeactivation(false, "Deactivation failed");
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deactivate");
        }
    }

    private final synchronized void join() throws RuntimeWarning, RuntimeError {
        Object var1_1 = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"join");
        }
        SibTr.push((Object)this);
        int n = this._state;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " is in state " + this.states[n]));
        }
        if (n != 2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"ME is not in state STATE_INITIALIZED; start will not continue");
            }
            return;
        }
        CoreStack coreStack = (CoreStack)this.getService(CoreStack.class);
        if (coreStack == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Lookup of CoreStack service failed, server will be killed");
            }
            throw new RuntimeError("Lookup of CoreStack service failed");
        }
        this._groupManager = coreStack.getGroupManager();
        if (this._groupManager == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Lookup of GroupManager failed, server will be killed");
            }
            throw new RuntimeError("Lookup of GroupManager failed");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Lookup of GroupManager succeeded");
        }
        try {
            this.createGroupName();
            this.createMemberProps();
            this.setState(3);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Attempting to join group");
            }
            this._haGroup = this._groupManager.joinGroup(this._groupName, this._memberProps, (HAGroupCallback)this);
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.startInstance", (String)"1", (Object)this, (Object[])new Object[]{this._groupManager, this._groupName, this._memberProps});
            SibTr.error((TraceComponent)tc, (String)"FAILED_TO_JOIN_GROUP_SIAS0038");
            SibTr.exception((TraceComponent)tc, (Exception)((Object)hAException));
            throw new RuntimeWarning("Failed to join HA group for ME " + this._name + " - instance not started");
        }
        catch (RuntimeWarning runtimeWarning) {
            FFDCFilter.processException((Throwable)runtimeWarning, (String)"com.ibm.ws.sib.admin.impl.HAMessagingEngineImpl.startInstance", (String)"2", (Object)this, (Object[])new Object[]{this._groupManager, this._groupName, this._memberProps});
            SibTr.error((TraceComponent)tc, (String)"FAILED_TO_JOIN_GROUP_SIAS0038");
            SibTr.exception((TraceComponent)tc, (Exception)((Object)runtimeWarning));
            throw runtimeWarning;
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"join");
        }
    }

    private final synchronized void leave() {
        boolean bl = true;
        boolean bl2 = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"leave");
        }
        SibTr.push((Object)this);
        int n = this._state;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " is in state " + this.states[n]));
        }
        if (n != 3 && n != 4 && n != 10 && n != 7 && n != 9 && n != 5 && n != 13) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"ME is not in expected state");
            }
            bl = false;
        }
        if (bl && this._haGroup == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Continuing stop, despite error that ME does not have a valid HAGroup");
            }
            bl = false;
        }
        if (bl && n == 3) {
            this.setState(2);
            bl2 = false;
        }
        if (bl && n == 9) {
            this.reportDeactivation(false, " Pending deactivation of messaging engine " + this._name + " abandoned due to server stop ");
        }
        if (bl && (n == 9 || n == 7 || n == 13)) {
            this.stop(0);
            SibTr.debug((TraceComponent)tc, (String)("Deactivating MBean for ME " + this.getName()));
            this.deactivateMBean();
            bl2 = true;
        }
        if (bl && n == 5) {
            this.reportActivation(false, " Pending activation of messaging engine " + this._name + " abandoned due to server stop ");
            this.setState(2);
            bl2 = true;
        }
        if (bl && (n == 4 || n == 10)) {
            bl2 = true;
        }
        if (bl2) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Leaving HAGroup");
                }
                this._haGroup.leave();
            }
            catch (HAException hAException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Continuing stop, despite HAException caught " + (Object)((Object)hAException)));
                }
                SibTr.exception((TraceComponent)tc, (Exception)((Object)hAException));
            }
            this.setState(2);
        }
        SibTr.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"leave");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/HAManagerMessagingEngineImpl.java, SIB.admin, WAS602.SIB, o0610.11 1.7");
        }
    }
}

