/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBLocalizationPoint;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.models.config.sibresources.impl.SIBDatastoreImpl;
import com.ibm.websphere.models.config.sibresources.impl.SIBMessagingEngineImpl;
import com.ibm.websphere.sib.admin.SIBQueuePoint;
import com.ibm.websphere.sib.admin.SIBQueuedMessage;
import com.ibm.websphere.sib.admin.SIBQueuedMessageDetail;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsMonitoredComponent;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionMediationNotFound;
import com.ibm.ws.sib.admin.exception.InvalidArgumentException;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsDatastoreImpl;
import com.ibm.ws.sib.admin.impl.JsDestinationCache;
import com.ibm.ws.sib.admin.impl.JsEObjectImpl;
import com.ibm.ws.sib.admin.impl.JsGatewayLinkImpl;
import com.ibm.ws.sib.admin.impl.JsLocalizer;
import com.ibm.ws.sib.admin.impl.JsMQClientLinkImpl;
import com.ibm.ws.sib.admin.impl.JsMQLinkImpl;
import com.ibm.ws.sib.admin.impl.JsMainImpl;
import com.ibm.ws.sib.admin.impl.JsMediationCache;
import com.ibm.ws.sib.admin.impl.JsMessagingEngineMBean;
import com.ibm.ws.sib.admin.impl.SIBQueuePointImpl;
import com.ibm.ws.sib.admin.impl.SIBQueuedMessageDetailImpl;
import com.ibm.ws.sib.admin.impl.SIBQueuedMessageImpl;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsSdoMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.trm.TrmMeMain;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import commonj.sdo.DataGraph;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;

public class BaseMessagingEngineImpl
extends JsEObjectImpl
implements JsEngineComponent,
JsMessagingEngineMBean,
JsHealthMonitor {
    private static final TraceComponent tc = SibTr.register((Class)BaseMessagingEngineImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl";
    protected boolean _enabled = false;
    private boolean _sentServerStarted = false;
    private boolean _sentServerStopping = false;
    protected boolean _inDynConfigUpdate = false;
    private JsDestinationCache oldDestCache = null;
    private JsMediationCache oldMedCache = null;
    protected static final int STATE_UNINITIALIZED = 0;
    protected static final int STATE_INITIALIZING = 1;
    protected static final int STATE_INITIALIZED = 2;
    protected static final int STATE_JOINING = 3;
    protected static final int STATE_JOINED = 4;
    protected static final int STATE_AUTOSTARTING = 5;
    protected static final int STATE_STARTING = 6;
    protected static final int STATE_STARTED = 7;
    protected static final int STATE_STOPPING = 8;
    protected static final int STATE_STOPPING_MEMBER = 9;
    protected static final int STATE_STOPPED = 10;
    protected static final int STATE_DESTROYING = 11;
    protected static final int STATE_DESTROYED = 12;
    protected static final int STATE_FAILED = 13;
    protected String[] states = new String[]{"Uninitialized", "Initializing", "Initialized", "Joining", "Joined", "Autostarting", "Starting", "Started", "Stopping", "StoppingMember", "Stopped", "Destroying", "Destroyed", "Failed!"};
    private String[] extendedStates = new String[]{"SIB_ME_STATE.Uninitialized", "SIB_ME_STATE.Initializing", "SIB_ME_STATE.Initialized", "SIB_ME_STATE.Joining", "SIB_ME_STATE.Joined", "SIB_ME_STATE.Autostarting", "SIB_ME_STATE.Starting", "SIB_ME_STATE.Started", "SIB_ME_STATE.Stopping", "SIB_ME_STATE.StoppingMember", "SIB_ME_STATE.Stopped", "SIB_ME_STATE.Destroying", "SIB_ME_STATE.Destroyed", "SIB_ME_STATE.Failed!"};
    protected int _state = 0;
    protected Vector jmeComponents = new Vector();
    protected static final int NUM_STOP_PHASES = 4;
    protected static final int STOP_PHASE_0 = 0;
    protected static final int STOP_PHASE_1 = 1;
    protected static final int STOP_PHASE_2 = 2;
    protected static final int STOP_PHASE_3 = 3;
    protected Vector[] stopSequence = new Vector[4];
    protected JsMainImpl _mainImpl;
    protected JsAdminFactory jsaf = null;
    protected JsBusImpl _bus;
    protected SIBMessagingEngineImpl _me = null;
    protected JsDatastoreImpl _ds = null;
    protected String _name;
    private SIBUuid8 _uuid = null;
    protected JsHealthState _recordedHealth;
    protected Administrator _mpAdmin = null;
    protected JsEngineComponent _messageProcessor;
    protected MessageStore _messageStore;
    private JsLocalizer _localizer = null;
    private ThreadPool _mediationThreadPool = null;
    protected ControllableRegistrationService _mbeanFactory = null;
    private boolean _disablerSeenOnPreviousHeartbeat = false;
    private ArrayList _lpConfig = new ArrayList();
    protected StatsGroup _meStatsGroup = null;
    protected String dumpDir = null;
    private Properties customProperties = new Properties();
    private Boolean lockObject = new Boolean(true);
    private static final String SIB_TAG = "sib";
    private static final String ADM_TAG = "admin";
    private static final String COM_TAG = "comms";
    private static final String MFP_TAG = "mfp";
    private static final String MSG_TAG = "msgstore";
    private static final String PRO_TAG = "processor";
    private static final String SEC_TAG = "security";
    private static final String TRM_TAG = "trm";
    private static final String encoding = "UTF-8";
    private static final DateFormat dateFormat;

    public BaseMessagingEngineImpl(JsMainImpl jsMainImpl, JsBusImpl jsBusImpl, SIBMessagingEngineImpl sIBMessagingEngineImpl, SIBDatastoreImpl sIBDatastoreImpl) {
        super(jsBusImpl, (EObject)sIBMessagingEngineImpl);
        this._mainImpl = jsMainImpl;
        this._bus = jsBusImpl;
        this._me = sIBMessagingEngineImpl;
        this._ds = new JsDatastoreImpl(sIBDatastoreImpl);
        this._name = sIBMessagingEngineImpl.getName();
        this._localizer = new JsLocalizer(this);
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl: a subclass has not overriden initialize()");
    }

    public void start(int n) {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl: a subclass has not overriden start()");
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Start ME, mode defaulting to ME_START_DEFAULT");
        }
        this.start(0);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void start(String string) throws InvalidArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)string);
        }
        int n = 0;
        if (string.equals("DEFAULT")) {
            n = 0;
        } else if (string.equals("FLUSH")) {
            n = 1;
        } else {
            throw new InvalidArgumentException("");
        }
        this.start(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void startConditional() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startConditional");
        }
        SibTr.debug((TraceComponent)tc, (String)("Activating MBean for ME " + this.getName()));
        this.activateMBean("SIBMessagingEngine", (EObject)this._me, this._me.getName(), null);
        if (this._enabled) {
            this.setState(6);
            this.start(0);
        } else {
            this.setState(10);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startConditional");
        }
    }

    public final void serverStarted() {
        if (this.okayToSendServerStarted()) {
            Enumeration enumeration = this.jmeComponents.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
                if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
                jsEngineComponent.serverStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okayToSendServerStarted() {
        Boolean bl = this.lockObject;
        synchronized (bl) {
            if (!this._sentServerStarted && this._state == 7 && this._mainImpl.isServerStarted()) {
                this._sentServerStarted = true;
            }
        }
        return this._sentServerStarted;
    }

    private synchronized boolean okayToSendServerStopping() {
        if (!this._sentServerStopping && this._state == 7 && this._mainImpl.isServerStopping()) {
            this._sentServerStopping = true;
        }
        return this._sentServerStopping;
    }

    public final void serverStopping() {
        if (this.okayToSendServerStopping()) {
            Enumeration enumeration = this.jmeComponents.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
                if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
                jsEngineComponent.serverStopping();
            }
        }
    }

    public void stop(int n) {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl: a subclass has not overriden stop()");
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Stop ME, mode defaulting to ME_STOP_IMMEDIATE");
        }
        this.stop(0);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void stop(String string) throws InvalidArgumentException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)string);
        }
        int n = 0;
        if (string.equals("IMMEDIATE")) {
            n = 0;
        } else if (string.equals("FORCE")) {
            n = 1;
        } else {
            throw new InvalidArgumentException("");
        }
        this.stop(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void stopConditional(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("stopConditional" + n));
        }
        if (this._enabled) {
            this.setState(8);
            this.stop(n);
            SibTr.debug((TraceComponent)tc, (String)("Deactivating MBean for ME " + this.getName()));
        }
        this.deactivateMBean();
        this.setState(2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopConditional");
        }
    }

    public void destroy() {
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl: a subclass has not overriden destroy()");
    }

    public final boolean datastoreExists() {
        return this._ds != null;
    }

    public final String getAttribute(String string) {
        return this._mainImpl.getAttribute(this, string);
    }

    public final JsEObject getBus() {
        return this.getParent();
    }

    public final String getBusName() {
        return this._bus.getName();
    }

    public final Map getChildren() {
        return null;
    }

    public final JsEObject getDatastore() {
        return this._ds;
    }

    public JsEngineComponent getEngineComponent(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEngineComponent", (Object)string);
        }
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!((ComponentList)e).getClassName().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getEngineComponent", (Object)"FOUND");
            }
            return ((ComponentList)e).getRef();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEngineComponent", (Object)"NULL");
        }
        return null;
    }

    public final Object getEObject() {
        return this._me;
    }

    public ControllableRegistrationService getMBeanFactory() {
        return this._mbeanFactory;
    }

    public final SIBMessagingEngineImpl getMeConfig() {
        return this._me;
    }

    public ThreadPool getMediationThreadPool() {
        if (this._mediationThreadPool == null) {
            ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            this._mediationThreadPool = threadPoolMgr.getThreadPool("SIB." + this._bus.getName() + "." + this.getName() + ".MediationThreadPool", this._me.getMediationThreadPool());
        }
        return this._mediationThreadPool;
    }

    public JsEngineComponent getMessageProcessor() {
        return this._messageProcessor;
    }

    public JsEngineComponent getMessageProcessor(String string) {
        return this._messageProcessor;
    }

    public Object getMessageStore() {
        return this._messageStore;
    }

    public JsEObject getMQClientLink(String string) {
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsMQClientLinkImpl) || !((JsMQClientLinkImpl)jsEngineComponent).getName().equals(string)) continue;
            return (JsEObject)jsEngineComponent;
        }
        return null;
    }

    public JsEObject getMQLink(String string) {
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsMQLinkImpl) || !((JsMQLinkImpl)jsEngineComponent).getName().equals(string)) continue;
            return (JsEObject)jsEngineComponent;
        }
        return null;
    }

    public JsEngineComponent getMQLinkEngineComponent(String string) {
        JsEngineComponent jsEngineComponent = null;
        JsMQLinkImpl jsMQLinkImpl = (JsMQLinkImpl)this.getMQLink(string);
        if (jsMQLinkImpl != null) {
            jsEngineComponent = jsMQLinkImpl.getEngineComponent();
        }
        return jsEngineComponent;
    }

    public JsEObject getGatewayLink(String string) {
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsGatewayLinkImpl) || !((JsGatewayLinkImpl)jsEngineComponent).getName().equals(string)) continue;
            return (JsEObject)jsEngineComponent;
        }
        return null;
    }

    public JsEngineComponent getGatewayLinkEngineComponent(String string) {
        JsEngineComponent jsEngineComponent = null;
        JsGatewayLinkImpl jsGatewayLinkImpl = (JsGatewayLinkImpl)this.getGatewayLink(string);
        if (jsGatewayLinkImpl != null) {
            jsEngineComponent = jsGatewayLinkImpl.getEngineComponent();
        }
        return jsEngineComponent;
    }

    public String getName() {
        return this._name;
    }

    public final Object getService(Class clazz) {
        return this._mainImpl.getService(clazz);
    }

    private void resolveExceptionDestination(BaseDestinationDefinition baseDestinationDefinition) {
        String string;
        if (baseDestinationDefinition.isLocal() && (string = ((DestinationDefinition)baseDestinationDefinition).getExceptionDestination()) != null && string.equals("$DEFAULT_EXCEPTION_DESTINATION")) {
            ((DestinationDefinition)baseDestinationDefinition).setExceptionDestination("_SYSTEM.Exception.Destination." + this.getName());
        }
    }

    public void getSIBDestination(String string, String string2, DestinationDefinition destinationDefinition) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        if (this.oldDestCache == null) {
            this._bus.getDestinationCache().getSIBDestination(string, string2, destinationDefinition);
        }
        this.oldDestCache.getSIBDestination(string, string2, destinationDefinition);
        this.resolveExceptionDestination((BaseDestinationDefinition)destinationDefinition);
    }

    public BaseDestinationDefinition getSIBDestination(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        BaseDestinationDefinition baseDestinationDefinition = null;
        baseDestinationDefinition = this.oldDestCache == null ? (BaseDestinationDefinition)this._bus.getDestinationCache().getSIBDestination(string, string2).clone() : (BaseDestinationDefinition)this.oldDestCache.getSIBDestination(string, string2).clone();
        this.resolveExceptionDestination(baseDestinationDefinition);
        return baseDestinationDefinition;
    }

    BaseDestinationDefinition getSIBDestinationByUuid(String string, String string2, boolean bl) throws SIBExceptionDestinationNotFound, SIBExceptionBase {
        BaseDestinationDefinition baseDestinationDefinition = null;
        baseDestinationDefinition = this.oldDestCache == null || bl ? (BaseDestinationDefinition)this._bus.getDestinationCache().getSIBDestinationByUuid(string, string2).clone() : (BaseDestinationDefinition)this.oldDestCache.getSIBDestinationByUuid(string, string2).clone();
        this.resolveExceptionDestination(baseDestinationDefinition);
        return baseDestinationDefinition;
    }

    public Set getSIBDestinationLocalitySet(String string, String string2, boolean bl) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        if (this.oldDestCache == null || bl) {
            return this._bus.getDestinationCache().getSIBDestinationLocalitySet(string, string2);
        }
        return this.oldDestCache.getSIBDestinationLocalitySet(string, string2);
    }

    public Set getSIBDestinationLocalitySet(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        return this.getSIBDestinationLocalitySet(string, string2, false);
    }

    public void getSIBMediation(String string, String string2, MediationDefinition mediationDefinition) throws SIBExceptionBase, SIBExceptionMediationNotFound {
        if (this.oldMedCache == null) {
            this._bus.getMediationCache().getSIBMediation(string, string2, mediationDefinition);
        }
        this.oldMedCache.getSIBMediation(string, string2, mediationDefinition);
    }

    public MediationDefinition getSIBMediation(String string, String string2) throws SIBExceptionBase, SIBExceptionMediationNotFound {
        if (this.oldMedCache == null) {
            return this._bus.getMediationCache().getSIBMediation(string, string2);
        }
        return this.oldMedCache.getSIBMediation(string, string2);
    }

    public Set getSIBMediationLocalitySet(String string, String string2, boolean bl) throws SIBExceptionBase, SIBExceptionMediationNotFound {
        if (this.oldMedCache == null || bl) {
            return this._bus.getMediationCache().getSIBMediationLocalitySet(string, string2);
        }
        return this.oldMedCache.getSIBMediationLocalitySet(string, string2);
    }

    public Set getSIBMediationLocalitySet(String string, String string2) throws SIBExceptionBase, SIBExceptionMediationNotFound {
        return this.getSIBMediationLocalitySet(string, string2, false);
    }

    public final String getState() {
        return this.states[this._state];
    }

    public final StatsGroup getStatsGroup() {
        return this._meStatsGroup;
    }

    public SIBUuid8 getUuid() {
        if (this._uuid == null) {
            String string = this.getAttribute("uuid");
            this._uuid = new SIBUuid8(string);
        }
        return this._uuid;
    }

    public final boolean isStarted() {
        return this._state == 7;
    }

    protected final JsEngineComponent loadClass(String string, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadClass", (Object)new Object[]{string, new Integer(n)});
        }
        Class<?> clazz = null;
        JsEngineComponent jsEngineComponent = null;
        int n2 = n;
        if (n2 < 0 || n2 > 4) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("loadClass: stopSeq is out of bounds " + n));
            }
        } else {
            block14: {
                try {
                    clazz = Class.forName(string);
                    jsEngineComponent = (JsEngineComponent)clazz.newInstance();
                    ComponentList componentList = new ComponentList(string, jsEngineComponent);
                    this.jmeComponents.addElement(componentList);
                    this.stopSequence[n2].addElement(componentList);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"3", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)string);
                        SibTr.exception((TraceComponent)tc, (Exception)classNotFoundException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"1", (Object)this);
                    if (bl) {
                        SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)string);
                        SibTr.exception((TraceComponent)tc, (Exception)instantiationException);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"2", (Object)this);
                    if (!bl) break block14;
                    SibTr.error((TraceComponent)tc, (String)"CLASS_LOAD_FAILURE_SIAS0013", (Object)string);
                    SibTr.exception((TraceComponent)tc, (Throwable)throwable);
                }
            }
            if (jsEngineComponent instanceof JsEObjectImpl) {
                ((JsEObjectImpl)jsEngineComponent).setParent(this);
            }
        }
        if (tc.isEntryEnabled()) {
            if (jsEngineComponent == null) {
                SibTr.exit((TraceComponent)tc, (String)"loadClass: failed");
            } else {
                SibTr.exit((TraceComponent)tc, (String)"loadClass: OK");
            }
        }
        return jsEngineComponent;
    }

    protected final JsEngineComponent loadClass(EObject eObject, String string, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadClass", (Object)new Object[]{string, new Integer(n)});
        }
        JsEngineComponent jsEngineComponent = null;
        int n2 = n;
        if (n2 < 0 || n2 > 4) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("loadClass: stopSeq is out of bounds " + n));
            }
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?>[] constructorArray = clazz.getConstructors();
                jsEngineComponent = (JsEngineComponent)constructorArray[0].newInstance(this, eObject);
                ComponentList componentList = new ComponentList(string, jsEngineComponent);
                this.jmeComponents.addElement(componentList);
                this.stopSequence[n2].addElement(componentList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"3", (Object)this);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"4", (Object)this);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"5", (Object)this);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"6", (Object)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl.loadClass", (String)"7", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            if (jsEngineComponent == null) {
                SibTr.exit((TraceComponent)tc, (String)"loadClass: failed");
            } else {
                SibTr.exit((TraceComponent)tc, (String)"loadClass: OK");
            }
        }
        return jsEngineComponent;
    }

    public final void loadLocalizations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadLocalizations");
        }
        this._localizer.loadLocalizations();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadLocalizations");
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttribute", (Object)(string + " " + string2));
        }
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
            jsEngineComponent.setAttribute(string, string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty", (Object)(string + " " + string2));
        }
        this.customProperties.put(string, string2);
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
            jsEngineComponent.setCustomProperty(string, string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    protected final void setState(int n) {
        this._state = n;
        if (this._state == 0 || this._state == 1 || this._state == 2 || this._state == 3 || this._state == 5 || this._state == 11 || this._state == 12) {
            SibTr.debug((TraceComponent)tc, (String)("Messaging Engine " + this._name + " is in state " + this.getState()));
        } else {
            SibTr.info((TraceComponent)tc, (String)"ME_STATE_CHANGE_SIAS0016", (Object)new Object[]{this._name, this.states[this._state]});
        }
    }

    public final String state() {
        return this.getState();
    }

    public final String stateExtended() {
        return this.extendedStates[this._state];
    }

    public String getHealth() {
        JsHealthState jsHealthState = this.assessHealth();
        return jsHealthState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsHealthState assessHealth() {
        JsHealthState jsHealthState;
        JsHealthState jsHealthState2 = this._recordedHealth;
        if (jsHealthState2.couldBeWorse() && (jsHealthState2 = jsHealthState2.moreSevere(jsHealthState = this._mainImpl.getHealthState())).couldBeWorse()) {
            Enumeration enumeration = this.jmeComponents.elements();
            while (jsHealthState2.couldBeWorse() && enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
                if (!(jsEngineComponent instanceof JsMonitoredComponent)) continue;
                jsHealthState = ((JsMonitoredComponent)jsEngineComponent).getHealthState();
                String string = jsEngineComponent.getClass().getName();
                SibTr.debug((TraceComponent)tc, (String)("MessagingEngine " + this._name + " component " + string + " reported health: " + jsHealthState));
                jsHealthState2 = jsHealthState2.moreSevere(jsHealthState);
            }
            SibTr.debug((TraceComponent)tc, (String)("MessagingEngine finished monitoring components; aggregate health is: " + jsHealthState2));
        }
        jsHealthState = this._recordedHealth;
        synchronized (jsHealthState) {
            this._recordedHealth = this._recordedHealth.moreSevere(jsHealthState2);
        }
        return this._recordedHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportLocalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportLocalError");
        }
        JsHealthState jsHealthState = JsHealthState.getLocalError();
        JsHealthState jsHealthState2 = this._recordedHealth;
        synchronized (jsHealthState2) {
            this._recordedHealth = this._recordedHealth.moreSevere(jsHealthState);
        }
        SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " recorded local error reported by component."));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportLocalError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reportGlobalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportGlobalError");
        }
        JsHealthState jsHealthState = JsHealthState.getGlobalError();
        JsHealthState jsHealthState2 = this._recordedHealth;
        synchronized (jsHealthState2) {
            this._recordedHealth = this._recordedHealth.moreSevere(jsHealthState);
        }
        SibTr.debug((TraceComponent)tc, (String)("ME " + this._name + " recorded global error reported by component."));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportGlobalError");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded");
        }
        if (this.isStarted()) {
            this._inDynConfigUpdate = true;
            this.oldDestCache = this._bus.getDestinationCache();
            this.oldMedCache = this._bus.getMediationCache();
            this.oldDestCache.setMediationCache(this.oldMedCache);
            this.oldMedCache.setDestinationCache(this.oldDestCache);
            Enumeration enumeration = this.jmeComponents.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
                if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
                jsEngineComponent.busReloaded(sIBus, bl, bl2, bl3);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("busReloaded: ME not started (state=" + this.getState() + ") call not passed to sub-components."));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded");
        }
        this.oldDestCache = null;
        this.oldMedCache = null;
        Enumeration enumeration = this.jmeComponents.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            JsEngineComponent jsEngineComponent = ((ComponentList)e).getRef();
            if (!(jsEngineComponent instanceof JsEngineComponent)) continue;
            jsEngineComponent.engineReloaded(jsMessagingEngine);
        }
        this._inDynConfigUpdate = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded");
        }
    }

    final void startLocalizationPointUpdates() {
        this._localizer.startUpdate();
    }

    final void endLocalizationPointUpdates() {
        this._localizer.endUpdate();
    }

    final void addLocalizationPoint(SIBLocalizationPoint sIBLocalizationPoint) {
        this._localizer.addLocalizationPoint(sIBLocalizationPoint);
    }

    final void alterLocalizationPoint(SIBLocalizationPoint sIBLocalizationPoint) {
        this._localizer.alterLocalizationPoint(sIBLocalizationPoint);
    }

    final void deleteLocalizationPoint(SIBLocalizationPoint sIBLocalizationPoint) {
        this._localizer.deleteLocalizationPoint(sIBLocalizationPoint);
    }

    protected final boolean isInDynConfigUpdate() {
        return this._inDynConfigUpdate;
    }

    final ArrayList getLPConfigObjects() {
        return this._lpConfig;
    }

    final void setLPConfigObjects(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLPConfigObjects", (Object)("Number of LPs =" + list.size()));
        }
        this._lpConfig.clear();
        this._lpConfig.addAll(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLPConfigObjects");
        }
    }

    private void dump(String string, String string2, JsEngineComponent jsEngineComponent, FormattedWriter formattedWriter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump", (Object)new String(string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string3;
            String string4;
            ++n;
            String string5 = stringTokenizer.nextToken();
            int n2 = string5.indexOf(61);
            if (n2 < 0) {
                string4 = string5.trim();
                string3 = "";
            } else {
                string4 = string5.substring(0, n2).trim();
                string3 = string5.substring(n2 + 1).trim();
            }
            boolean bl2 = true;
            if (string4.endsWith("*")) {
                bl2 = false;
                string4 = string4.substring(0, string4.length() - 1);
            }
            if (bl2) {
                if (string4.equals(string2)) {
                    bl = true;
                }
            } else {
                int n3 = string4.length();
                String string6 = string2;
                if (string4.endsWith(".") && !string6.endsWith(".")) {
                    string6 = string6 + ".";
                }
                if (string6.length() >= n3 && string4.equals(string6.substring(0, n3))) {
                    bl = true;
                }
            }
            if (!bl) continue;
            if (jsEngineComponent instanceof MessageStore) {
                ((MessageStore)jsEngineComponent).dump(formattedWriter, string3);
            }
            if (!(jsEngineComponent instanceof TrmMeMain)) continue;
            ((TrmMeMain)jsEngineComponent).dump(formattedWriter, string3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump", (Object)new Boolean(bl));
        }
    }

    public void dump(String string) {
        FileOutputStream fileOutputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump", (Object)new String(string));
        }
        FormattedWriter formattedWriter = null;
        Date date = new Date();
        String string2 = "SIBdump-" + this.getName() + "-" + dateFormat.format(date) + ".xml";
        try {
            fileOutputStream = new FileOutputStream(this.dumpDir + string2);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, encoding);
            formattedWriter = new FormattedWriter((Writer)outputStreamWriter);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpldump", (String)"1434", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
        }
        if (formattedWriter != null) {
            try {
                formattedWriter.introducer("xml version=\"1.0\" encoding=\"UTF-8\"");
                formattedWriter.comment(" Dump taken at " + new SimpleDateFormat("HH:mm:ss:SSS").format(date) + " on " + new SimpleDateFormat("dd MMMM yyyy").format(date) + " ");
                formattedWriter.newLine();
                formattedWriter.nameSpace("xmi");
                formattedWriter.startTag("XMI xmi:version=\"1.2\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:admin=\"?\" xmlns:comms=\"?\" xmlns:mfp=\"?\" xmlns:msgstore=\"?\" xmlns:processor=\"?\" xmlns:security=\"?\" xmlns:trm=\"?\"");
                formattedWriter.indent();
                formattedWriter.newLine();
                formattedWriter.nameSpace("");
                formattedWriter.startTag(SIB_TAG);
                formattedWriter.indent();
                formattedWriter.newLine();
                formattedWriter.nameSpace(MSG_TAG);
                if (this._messageStore != null) {
                    this.dump(string, "com.ibm.ws.sib.msgstore.impl.MessageStoreImpl", this._messageStore, formattedWriter);
                }
                formattedWriter.nameSpace(TRM_TAG);
                fileOutputStream = this.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
                if (fileOutputStream != null) {
                    this.dump(string, "com.ibm.ws.sib.trm.TrmMeMainImpl", (JsEngineComponent)fileOutputStream, formattedWriter);
                }
                formattedWriter.outdent();
                formattedWriter.newLine();
                formattedWriter.nameSpace("");
                formattedWriter.endTag(SIB_TAG);
                formattedWriter.outdent();
                formattedWriter.newLine();
                formattedWriter.nameSpace("xmi");
                formattedWriter.endTag("XMI");
                formattedWriter.newLine();
                formattedWriter.flush();
                formattedWriter.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpldump", (String)"1465", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump");
        }
    }

    public final void injectFault(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("injectFault fault=" + string));
        }
        if (string.equals("LocalError")) {
            this.reportLocalError();
        } else if (string.equals("GlobalError")) {
            this.reportGlobalError();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"unknown error type - will be ignored");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"injectFault");
        }
    }

    private byte[] getData(byte[] byArray, Integer n) {
        int n2 = 1024;
        if (n > 0) {
            n2 = n;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private byte[] getMessageData(SIMPQueuedMessageControllable sIMPQueuedMessageControllable, Integer n) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)n.toString());
        }
        try {
            JsMessage jsMessage = sIMPQueuedMessageControllable.getJsMessage();
            MessageType messageType = jsMessage.getJsMessageType();
            if (messageType == MessageType.JMS) {
                JsJmsMessage jsJmsMessage = jsMessage.makeInboundJmsMessage();
                if (jsJmsMessage instanceof JsJmsTextMessage) {
                    JsJmsTextMessage jsJmsTextMessage = (JsJmsTextMessage)jsJmsMessage;
                    return this.getData(jsJmsTextMessage.getText().getBytes(), n);
                }
                if (jsJmsMessage instanceof JsJmsBytesMessage) {
                    JsJmsBytesMessage jsJmsBytesMessage = (JsJmsBytesMessage)jsJmsMessage;
                    return this.getData(jsJmsBytesMessage.getBytes(), n);
                }
                if (jsJmsMessage instanceof JsJmsObjectMessage) {
                    JsJmsObjectMessage jsJmsObjectMessage = (JsJmsObjectMessage)jsJmsMessage;
                    return this.getData(jsJmsObjectMessage.getSerializedObject(), n);
                }
                if (jsJmsMessage instanceof JsJmsMapMessage) {
                    JsJmsMapMessage jsJmsMapMessage = (JsJmsMapMessage)jsJmsMessage;
                    return null;
                }
                if (jsJmsMessage instanceof JsJmsStreamMessage) {
                    JsJmsStreamMessage jsJmsStreamMessage = (JsJmsStreamMessage)jsJmsMessage;
                    return null;
                }
            } else if (messageType == MessageType.SDO) {
                JsSdoMessage jsSdoMessage = jsMessage.makeInboundSdoMessage();
                DataGraph dataGraph = jsSdoMessage.getDataGraph();
                return null;
            }
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return null;
    }

    public SIBQueuePoint[] listQueuePoints() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listQueuePoints");
        }
        SIMPIterator sIMPIterator = this._mpAdmin.getMPRuntimeControl().getLocalQueueIterator();
        Vector<SIBQueuePointImpl> vector = new Vector<SIBQueuePointImpl>();
        while (sIMPIterator.hasNext()) {
            SIMPQueueControllable sIMPQueueControllable = (SIMPQueueControllable)sIMPIterator.next();
            vector.add(new SIBQueuePointImpl(sIMPQueueControllable));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listQueuePoints", (Object)new Integer(vector.size()).toString());
        }
        if (vector.size() > 0) {
            return vector.toArray(new SIBQueuePointImpl[vector.size()]);
        }
        return null;
    }

    public SIBQueuePoint getQueuePoint(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePoint", (Object)string);
        }
        try {
            SIMPQueueControllable sIMPQueueControllable = this._mpAdmin.getMPRuntimeControl().getQueueControlByID(string);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuePoint");
            }
            return new SIBQueuePointImpl(sIMPQueueControllable);
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
    }

    public SIBQueuedMessage getQueuePointMessage(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessage", (Object)(string + " " + string2));
        }
        SIMPQueueControllable sIMPQueueControllable = null;
        SIMPQueuedMessageControllable sIMPQueuedMessageControllable = null;
        try {
            sIMPQueueControllable = this._mpAdmin.getMPRuntimeControl().getQueueControlByID(string);
            sIMPQueuedMessageControllable = sIMPQueueControllable.getLocalQueuePointControl().getQueuedMessageByID(string2);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessage");
            }
            return new SIBQueuedMessageImpl(sIMPQueuedMessageControllable);
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
    }

    public byte[] getQueuePointMessageData(String string, String string2, Integer n) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessageData", (Object)(string + " " + string2 + " " + n));
        }
        SIMPQueueControllable sIMPQueueControllable = null;
        SIMPQueuedMessageControllable sIMPQueuedMessageControllable = null;
        try {
            sIMPQueueControllable = this._mpAdmin.getMPRuntimeControl().getQueueControlByID(string);
            sIMPQueuedMessageControllable = sIMPQueueControllable.getLocalQueuePointControl().getQueuedMessageByID(string2);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessageData");
            }
            return this.getMessageData(sIMPQueuedMessageControllable, n);
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
        catch (Exception exception) {
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw exception;
        }
    }

    public SIBQueuedMessageDetail getQueuePointMessageDetail(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessageDetail", (Object)(string + " " + string2));
        }
        SIMPQueueControllable sIMPQueueControllable = null;
        SIMPQueuedMessageControllable sIMPQueuedMessageControllable = null;
        try {
            sIMPQueueControllable = this._mpAdmin.getMPRuntimeControl().getQueueControlByID(string);
            sIMPQueuedMessageControllable = sIMPQueueControllable.getLocalQueuePointControl().getQueuedMessageByID(string2);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessageDetail");
            }
            return new SIBQueuedMessageDetailImpl(sIMPQueuedMessageControllable);
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
    }

    public SIBQueuedMessage[] getQueuePointMessages(String string) throws Exception {
        SIBQueuedMessage[] sIBQueuedMessageArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointMessages", (Object)string);
        }
        SIMPLocalQueuePointControllable sIMPLocalQueuePointControllable = null;
        try {
            sIMPLocalQueuePointControllable = this._mpAdmin.getMPRuntimeControl().getLocalQueuePointControlByID(string);
        }
        catch (SIMPException sIMPException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
        ArrayList<SIBQueuedMessage[]> arrayList = new ArrayList<SIBQueuedMessage[]>();
        Iterator iterator = sIMPLocalQueuePointControllable.getQueuedMessageIterator();
        while (iterator.hasNext()) {
            sIBQueuedMessageArray = (SIBQueuedMessage[])iterator.next();
            arrayList.add(sIBQueuedMessageArray);
        }
        sIBQueuedMessageArray = new SIBQueuedMessage[arrayList.size()];
        iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            sIBQueuedMessageArray[n++] = new SIBQueuedMessageImpl((SIMPQueuedMessageControllable)e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuePointMessages", (Object)new Integer(sIBQueuedMessageArray.length).toString());
        }
        return sIBQueuedMessageArray;
    }

    public void resetDestination(String string) throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDestination");
        }
        if (this._messageProcessor != null) {
            try {
                this._mpAdmin.getMPRuntimeControl().resetDestination(string);
            }
            catch (SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                throw sIMPRuntimeOperationFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDestination");
        }
    }

    public Collection getPreparedTransactions() {
        Collection collection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreparedTransactions");
        }
        if (this._messageStore != null) {
            collection = this._messageStore.getPreparedTransactions();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreparedTransactions");
        }
        return collection;
    }

    public void commitPreparedTransaction(String string) throws TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitPreparedTransaction");
        }
        if (this._messageStore != null) {
            this._messageStore.commitPreparedTransaction(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitPreparedTransaction");
        }
    }

    public void rollbackPreparedTransaction(String string) throws TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackPreparedTransaction");
        }
        if (this._messageStore != null) {
            this._messageStore.rollbackPreparedTransaction(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackPreparedTransaction");
        }
    }

    public boolean isEventNotificationPropertySet() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEventNotificationPropertySet");
        }
        boolean bl = false;
        Boolean bl2 = this._bus.isEventNotificationPropertySet();
        if (bl2 == null || bl2.equals(Boolean.TRUE)) {
            if (this.customProperties.containsKey("sib.event.notification")) {
                String string = this.customProperties.getProperty("sib.event.notification");
                if (string != null) {
                    if (string.equals("enabled")) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Event Notification is enabled at the ME");
                        }
                        bl = true;
                    } else if (string.equals("disabled")) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Event Notification is disabled at the ME");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Event Notification ME property set to: " + string));
                        }
                        if (bl2 != null) {
                            bl = true;
                        }
                    }
                } else if (bl2 != null) {
                    bl = true;
                }
            } else if (bl2 != null) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEventNotificationPropertySet", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/BaseMessagingEngineImpl.java, SIB.admin, WAS602.SIB, o0610.11 1.29");
        }
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    }

    class ComponentList {
        private String _className;
        private JsEngineComponent _componentRef;

        ComponentList(String string, JsEngineComponent jsEngineComponent) {
            this._className = string;
            this._componentRef = jsEngineComponent;
        }

        String getClassName() {
            return this._className;
        }

        JsEngineComponent getRef() {
            return this._componentRef;
        }
    }
}

