/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.dynconfig;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.JsMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;

public class DynamicConfigManager
implements ConfigChangeListener {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.dynconfig.DynamicConfigManager";
    private static final TraceComponent tc = SibTr.register((Class)DynamicConfigManager.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final DynamicConfigManager _theManager = new DynamicConfigManager();
    private boolean enabled = false;
    private boolean started = false;
    private JsMainImpl _mainObject = null;
    private static String _configRoot = "";
    private String cellName = null;
    private HashMap _interestMappings = new HashMap();
    private HashMap busListeners = new HashMap();
    private ConfigChangeListener engineListener;
    private ConfigChangeListener securityListener;
    private ArrayList engineChangeSet = new ArrayList();
    private ArrayList securityChangeSet = new ArrayList();
    private ArrayList notifiedMEs = new ArrayList();

    private DynamicConfigManager() {
    }

    public static DynamicConfigManager getManager() {
        return _theManager;
    }

    public void initialize(Object object, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("initialize: JsMainImpl=" + object + " ConfigRootPath=" + string));
        }
        if (object != null && string != null && object instanceof JsMainImpl) {
            this.enabled = true;
            this._mainObject = (JsMainImpl)object;
            _configRoot = new File(string).toURI().toString();
            Repository repository = (Repository)this._mainObject.getService(Repository.class);
            this.cellName = repository.getCellName();
            this._mainObject.releaseService(repository);
            Admin admin = (Admin)this._mainObject.getService(Admin.class);
            admin.addConfigChangeListener((ConfigChangeListener)_theManager);
            this._mainObject.releaseService(admin);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("initialize: config root path: " + _configRoot));
                SibTr.debug((TraceComponent)tc, (String)("initialize: cell: " + this.cellName));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (this.enabled) {
            DynamicConfigManager dynamicConfigManager = this;
            synchronized (dynamicConfigManager) {
                this.started = true;
                this.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this.enabled) {
            Admin admin = (Admin)this._mainObject.getService(Admin.class);
            admin.removeConfigChangeListener((ConfigChangeListener)_theManager);
            this._mainObject.releaseService(admin);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        ConfigRepositoryEvent configRepositoryEvent2 = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configChanged", (Object)configRepositoryEvent);
        }
        DynamicConfigManager dynamicConfigManager = this;
        synchronized (dynamicConfigManager) {
            block28: {
                if (!this.started) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    ConfigChangeListener configChangeListener;
                    ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
                    ConfigRepository configRepository = this.getEventSource(configRepositoryEvent);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("configChanged: change count=" + configChangeNotifierArray.length));
                    }
                    boolean bl = false;
                    for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                        configChangeListener = configChangeNotifierArray[i].getUri();
                        if (!this._interestMappings.containsKey(configChangeListener)) continue;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("configChanged: mapping found for " + (String)configChangeListener));
                        }
                        ArrayList arrayList = (ArrayList)this._interestMappings.get(configChangeListener);
                        arrayList.add(configChangeNotifierArray[i]);
                        bl = true;
                    }
                    if (bl) {
                        if (this.securityListener != null) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("configChanged: tell security listener " + this.securityListener));
                            }
                            Iterator iterator = this.securityChangeSet.iterator();
                            configChangeListener = new ConfigChangeNotifier[this.securityChangeSet.size()];
                            int n = 0;
                            while (iterator.hasNext()) {
                                configChangeListener[n] = (ConfigChangeNotifier)iterator.next();
                                ++n;
                            }
                            configRepositoryEvent2 = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), (ConfigChangeNotifier[])configChangeListener);
                            this.securityListener.configChanged(configRepositoryEvent2);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"configChanged: no security listener, skipping notification.");
                        }
                        Iterator iterator = this.busListeners.keySet().iterator();
                        SibTr.info((TraceComponent)tc, (String)"DYN_CONFIG_BUS_BEGIN_SIAS0017");
                        while (iterator.hasNext()) {
                            configChangeListener = (ConfigChangeListener)iterator.next();
                            ArrayList arrayList = (ArrayList)this.busListeners.get(configChangeListener);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("configChanged: tell bus listener " + configChangeListener));
                            }
                            ConfigChangeNotifier[] configChangeNotifierArray2 = new ConfigChangeNotifier[arrayList.size()];
                            for (int i = 0; i < arrayList.size(); ++i) {
                                configChangeNotifierArray2[i] = (ConfigChangeNotifier)arrayList.get(i);
                            }
                            configRepositoryEvent2 = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), configChangeNotifierArray2);
                            configChangeListener.configChanged(configRepositoryEvent2);
                        }
                        SibTr.info((TraceComponent)tc, (String)"DYN_CONFIG_BUS_END_SIAS0018");
                        if (this.engineListener != null) {
                            SibTr.info((TraceComponent)tc, (String)"DYN_CONFIG_ENGINE_BEGIN_SIAS0019");
                            configChangeListener = new ConfigChangeNotifier[this.engineChangeSet.size()];
                            for (int i = 0; i < this.engineChangeSet.size(); ++i) {
                                configChangeListener[i] = (ConfigChangeNotifier)this.engineChangeSet.get(i);
                            }
                            configRepositoryEvent2 = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), (ConfigChangeNotifier[])configChangeListener);
                            this.engineListener.configChanged(configRepositoryEvent2);
                            SibTr.info((TraceComponent)tc, (String)"DYN_CONFIG_ENGINE_END_SIAS0020");
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"configChanged: cleaning up");
                        }
                        this.securityChangeSet.clear();
                        iterator = this.busListeners.keySet().iterator();
                        while (iterator.hasNext()) {
                            configChangeListener = (ConfigChangeListener)iterator.next();
                            ArrayList arrayList = (ArrayList)this.busListeners.get(configChangeListener);
                            arrayList.clear();
                        }
                        this.engineChangeSet.clear();
                        this.notifiedMEs.clear();
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"configChanged: no interesting changes detected, exiting");
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.admin.dynconfig.DynamicConfigManager.configChanged", (String)"288", (Object)this);
                    if (!tc.isDebugEnabled()) break block28;
                    SibTr.debug((TraceComponent)tc, (String)("configChanged: exception thrown, " + throwable));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    private ConfigRepository getEventSource(ConfigRepositoryEvent configRepositoryEvent) throws AdminException {
        ConfigRepository configRepository;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEventSource");
        }
        if ((configRepository = (ConfigRepository)configRepositoryEvent.getSource()) == null) {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEventSource", (Object)configRepository);
        }
        return configRepository;
    }

    public void registerSecurity(URI uRI, ConfigChangeListener configChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerSecurity");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("registerSecurity: uri=" + uRI + " listener=" + configChangeListener));
        }
        if (uRI != null && configChangeListener != null) {
            this.securityListener = configChangeListener;
            String string = uRI.toString();
            string = string.startsWith(_configRoot) ? string.substring(_configRoot.length(), string.length()) : "cells/" + this.cellName + "/" + string;
            this._interestMappings.put(string, this.securityChangeSet);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerSecurity");
        }
    }

    public void registerBus(URI[] uRIArray, ConfigChangeListener configChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerBus");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("registerBus: uri=" + uRIArray + " listener=" + configChangeListener));
        }
        ArrayList arrayList = new ArrayList();
        this.busListeners.put(configChangeListener, arrayList);
        for (int i = 0; i < uRIArray.length; ++i) {
            String string = uRIArray[i].toString();
            string = string.startsWith(_configRoot) ? string.substring(_configRoot.length(), string.length()) : "cells/" + this.cellName + "/" + string;
            this._interestMappings.put(string, arrayList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerBus");
        }
    }

    public void registerEngine(URI uRI, ConfigChangeListener configChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerEngine");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("registerEngine: uri=" + uRI + " listener=" + configChangeListener));
        }
        if (uRI != null && configChangeListener != null) {
            this.engineListener = configChangeListener;
            String string = uRI.toString();
            if (string.startsWith(_configRoot)) {
                string = string.substring(_configRoot.length(), string.length());
            }
            this._interestMappings.put(string, this.engineChangeSet);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerEngine");
        }
    }

    public ArrayList getNotifiedMEs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNotifiedMEs");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNotifiedMEs", (Object)this.notifiedMEs);
        }
        return this.notifiedMEs;
    }

    public void addNotifiedME(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNotifiedME", (Object)jsMessagingEngine);
        }
        this.notifiedMEs.add(jsMessagingEngine);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNotifiedME");
        }
    }

    public void removeNotifiedME(BaseMessagingEngineImpl baseMessagingEngineImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeNotifiedME", (Object)baseMessagingEngineImpl);
        }
        this.notifiedMEs.remove(baseMessagingEngineImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeNotifiedME");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/dynconfig/DynamicConfigManager.java, SIB.admin, WAS602.SIB, o0610.11 1.13");
        }
    }
}

