/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sib.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBMessagingEngine;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.models.config.sibresources.SIBusMember;
import com.ibm.websphere.models.config.sibresources.SIBusMemberTarget;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sib.level60.SIBValidationConstants_60;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class SIBusCrossValidator_60
extends WebSphereLevelCrossValidator
implements SIBValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    private String currentCellName = null;
    private String currentBusName = null;
    private SIBus currentBus = null;

    public SIBusCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sib.level60.sibvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SIBServiceCrossValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBus) {
            this.validateAcross((SIBus)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    private void validateAcross(SIBus sIBus) {
        this.currentBus = sIBus;
        this.currentCellName = this.getCurrentCellName();
        this.currentBusName = this.getCurrentBusName();
        HashMap hashMap = this.getNodeServerNames();
        EList eList = sIBus.getBusMembers();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SIBusMember sIBusMember = (SIBusMember)iterator.next();
            this.validateBusMember(sIBusMember);
        }
    }

    private void validateBusMember(SIBusMember sIBusMember) {
        String string;
        String string2;
        if (sIBusMember == null) {
            return;
        }
        String string3 = sIBusMember.getNode();
        if (!this.isValidBusMember(string3, string2 = sIBusMember.getServer(), string = sIBusMember.getCluster())) {
            return;
        }
        if (this.isServer(string3, string2, string)) {
            this.validateServerBusMember(sIBusMember, string3, string2, string);
        } else if (this.isCluster(string3, string2, string)) {
            this.validateClusterBusMember(sIBusMember, string3, string2, string);
        }
        EList eList = sIBusMember.getTarget();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SIBusMemberTarget sIBusMemberTarget = (SIBusMemberTarget)iterator.next();
            this.validateBusMemberTarget(sIBusMemberTarget, string3, string2, string);
        }
    }

    private void validateServerBusMember(SIBusMember sIBusMember, String string, String string2, String string3) {
        Object object;
        if (sIBusMember == null) {
            return;
        }
        HashMap hashMap = this.getNodeServerNames();
        Iterator<Object> iterator = hashMap.keySet().iterator();
        Object object2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string4 = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
            if (!string4.equals(string)) continue;
            bl = true;
            object2 = object;
            break;
        }
        if (!bl) {
            this.addError(this.getBundleId(), "BUS_MEMBER_NO_SUCH_NODE", new String[]{this.currentCellName, this.currentBusName, string, string2, string3}, this.currentBus);
        } else {
            object = (HashSet)hashMap.get(object2);
            iterator = ((HashSet)object).iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                if (!string5.equals(string2)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addError(this.getBundleId(), "BUS_MEMBER_NO_SUCH_SERVER", new String[]{this.currentCellName, this.currentBusName, string, string2, string3}, this.currentBus);
            }
        }
    }

    private void validateClusterBusMember(SIBusMember sIBusMember, String string, String string2, String string3) {
        if (sIBusMember == null) {
            return;
        }
        List list = this.getClusterNames();
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!string4.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addError(this.getBundleId(), "BUS_MEMBER_NO_SUCH_CLUSTER", new String[]{this.currentCellName, this.currentBusName, string, string2, string3}, this.currentBus);
        }
    }

    private void validateBusMemberTarget(SIBusMemberTarget sIBusMemberTarget, String string, String string2, String string3) {
        if (sIBusMemberTarget == null) {
            return;
        }
        if (!this.isValidBusMember(string, string2, string3)) {
            return;
        }
        String string4 = sIBusMemberTarget.getEngineUuid();
        String string5 = null;
        string5 = this.isServer(string, string2, string3) ? "cells/" + this.currentCellName + "/nodes/" + string + "/servers/" + string2 + "/sib-engines.xml" : "cells/" + this.currentCellName + "/clusters/" + string3 + "/sib-engines.xml";
        Object object = this.loadModel(string5);
        if (object instanceof EList && !((EList)object).isEmpty()) {
            Iterator iterator = ((EList)object).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                SIBMessagingEngine sIBMessagingEngine;
                String string6;
                Object e = iterator.next();
                if (!(e instanceof SIBMessagingEngine) || !(string6 = (sIBMessagingEngine = (SIBMessagingEngine)e).getUuid()).equals(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.isServer(string, string2, string3)) {
                    this.addError(this.getBundleId(), "BUS_MEMBER_TARGET_ENGINE_NOT_ON_SERVER", new String[]{this.currentBusName, string, string2, string3, string4}, this.currentBus);
                } else {
                    this.addError(this.getBundleId(), "BUS_MEMBER_TARGET_ENGINE_NOT_ON_CLUSTER", new String[]{this.currentBusName, string, string2, string3, string4}, this.currentBus);
                }
            }
        }
    }

    private String getCurrentCellName() {
        String string = this.getCurrentFileName();
        int n = string.indexOf("cells/") + new String("cells/").length();
        int n2 = string.indexOf("/buses/");
        String string2 = string.substring(n, n2);
        return string2;
    }

    private String getCurrentBusName() {
        String string = this.getCurrentFileName();
        int n = string.indexOf("/buses/") + new String("/buses/").length();
        int n2 = string.indexOf("/sib-bus.xml");
        String string2 = string.substring(n, n2);
        return string2;
    }

    private boolean isValidBusMember(String string, String string2, String string3) {
        boolean bl = false;
        if (this.isCluster(string, string2, string3) || this.isServer(string, string2, string3)) {
            bl = true;
        }
        return bl;
    }

    private boolean isCluster(String string, String string2, String string3) {
        boolean bl = false;
        if (!(string3 == null || string3.length() <= 0 || string != null && string.length() >= 1 || string2 != null && string2.length() >= 1)) {
            bl = true;
        }
        return bl;
    }

    private boolean isServer(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && (string3 == null || string3.length() < 1)) {
            bl = true;
        }
        return bl;
    }
}

