/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sib.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBDatastore;
import com.ibm.websphere.models.config.sibresources.SIBGatewayLink;
import com.ibm.websphere.models.config.sibresources.SIBLocalizationPoint;
import com.ibm.websphere.models.config.sibresources.SIBMQClientLink;
import com.ibm.websphere.models.config.sibresources.SIBMQLink;
import com.ibm.websphere.models.config.sibresources.SIBMessagingEngine;
import com.ibm.websphere.models.config.sibresources.SIBQueueLocalizationPoint;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextValidator_60;
import com.ibm.websphere.validation.sib.level60.SIBValidationConstants_60;
import java.util.HashMap;

public class SIBMessagingEnginesValidator_60_Default
extends ServerContextValidator_60
implements SIBValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    private String currentCell = null;
    private String currentNode = null;
    private String currentServer = null;
    private String currentCluster = null;

    public SIBMessagingEnginesValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sib.level60.sibvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SIBMessagingEnginesValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        this.setContext();
        boolean bl = true;
        if (object instanceof SIBMessagingEngine) {
            this.validateLocal((SIBMessagingEngine)object);
        } else if (object instanceof SIBDatastore) {
            this.validateLocal((SIBDatastore)object);
        } else if (object instanceof SIBQueueLocalizationPoint) {
            this.validateLocal((SIBLocalizationPoint)((SIBQueueLocalizationPoint)object));
        } else if (object instanceof SIBMQLink) {
            this.validateLocal((SIBMQLink)object);
        } else if (object instanceof SIBMQClientLink) {
            this.validateLocal((SIBMQClientLink)object);
        } else if (object instanceof SIBGatewayLink) {
            this.validateLocal((SIBGatewayLink)object);
        }
        return bl;
    }

    private void validateLocal(SIBMessagingEngine sIBMessagingEngine) {
        SIBDatastore sIBDatastore;
        String string;
        String string2;
        String string3;
        String string4 = sIBMessagingEngine.getName();
        if (string4 == null || string4.length() < 1) {
            this.addError(this.getBundleId(), "ENGINE_ATTRIBUTE_UNDEFINED", new String[]{"name"}, sIBMessagingEngine);
        }
        if ((string3 = sIBMessagingEngine.getUuid()) == null || string3.length() < 1) {
            this.addError(this.getBundleId(), "ENGINE_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBMessagingEngine);
        }
        if ((string2 = sIBMessagingEngine.getBusName()) == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "ENGINE_ATTRIBUTE_UNDEFINED", new String[]{"busName"}, sIBMessagingEngine);
        }
        if ((string = sIBMessagingEngine.getBusUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "ENGINE_ATTRIBUTE_UNDEFINED", new String[]{"busUuid"}, sIBMessagingEngine);
        }
        if ((sIBDatastore = sIBMessagingEngine.getDataStore()) == null) {
            this.addError(this.getBundleId(), "ENGINE_CONFIG_UNDEFINED", new String[]{string4, "dataStore"}, sIBMessagingEngine);
        }
    }

    private void validateLocal(SIBDatastore sIBDatastore) {
        String string;
        String string2 = sIBDatastore.getUuid();
        if (string2 == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "DATASTORE_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBDatastore);
        }
        if ((string = sIBDatastore.getDataSourceName()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "DATASTORE_ATTRIBUTE_UNDEFINED", new String[]{"dataSourceName"}, sIBDatastore);
        }
    }

    private void validateLocal(SIBLocalizationPoint sIBLocalizationPoint) {
        String string;
        String string2;
        String string3 = sIBLocalizationPoint.getIdentifier();
        if (string3 == null || string3.length() < 1) {
            this.addError(this.getBundleId(), "LOCALIZATION_POINT_ATTRIBUTE_UNDEFINED", new String[]{"identifier"}, sIBLocalizationPoint);
        }
        if ((string2 = sIBLocalizationPoint.getUuid()) == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "LOCALIZATION_POINT_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBLocalizationPoint);
        }
        if ((string = sIBLocalizationPoint.getTargetUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "LOCALIZATION_POINT_ATTRIBUTE_UNDEFINED", new String[]{"targetUuid"}, sIBLocalizationPoint);
        }
    }

    private void validateLocal(SIBMQLink sIBMQLink) {
        String string;
        String string2 = sIBMQLink.getName();
        if (string2 == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "MQ_LINK_ATTRIBUTE_UNDEFINED", new String[]{"name"}, sIBMQLink);
        }
        if ((string = sIBMQLink.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "MQ_LINK_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBMQLink);
        }
    }

    private void validateLocal(SIBMQClientLink sIBMQClientLink) {
        String string;
        String string2 = sIBMQClientLink.getName();
        if (string2 == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "MQ_CLIENT_LINK_ATTRIBUTE_UNDEFINED", new String[]{"name"}, sIBMQClientLink);
        }
        if ((string = sIBMQClientLink.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "MQ_CLIENT_LINK_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBMQClientLink);
        }
    }

    private void validateLocal(SIBGatewayLink sIBGatewayLink) {
        String string;
        String string2 = sIBGatewayLink.getName();
        if (string2 == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "GATEWAY_LINK_ATTRIBUTE_UNDEFINED", new String[]{"name"}, sIBGatewayLink);
        }
        if ((string = sIBGatewayLink.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "GATEWAY_LINK_ATTRIBUTE_UNDEFINED", new String[]{"uuid"}, sIBGatewayLink);
        }
    }

    private void validateAcross(Object object) {
    }

    private void setContext() {
        this.currentCell = null;
        this.currentNode = null;
        this.currentServer = null;
        this.currentCluster = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.trimLeadingChainOf(this.getCurrentFileName());
        String string2 = null;
        String string3 = null;
        while (string != null) {
            String string4 = this.nabHeadOf(string);
            if (string2 == null) {
                string2 = string4;
                string3 = null;
            } else if (string3 == null) {
                string3 = string4;
                hashMap.put(string2, string3);
                string2 = null;
                string3 = null;
            }
            string = this.nabTailOf(string);
        }
        this.currentCell = (String)hashMap.get("cells");
        this.currentNode = (String)hashMap.get("nodes");
        this.currentServer = (String)hashMap.get("servers");
        this.currentCluster = (String)hashMap.get("clusters");
    }
}

