/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnhancedEnumeration;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ws.ejb.portable.Constants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import javax.ejb.EJBObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PortableFinderEnumerator
implements EnhancedEnumeration,
Serializable {
    static final int PREFETCH_COUNT = 25;
    static final byte[] eyecatcher = Constants.FINDER_ENUMERATOR_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private transient RemoteEnumerator enum = null;
    private transient EJBObject[] elements = null;
    private transient int index = 0;
    private transient boolean exhausted = false;
    private static final long serialVersionUID = 4603100038030697154L;

    PortableFinderEnumerator(EJBObject[] eJBObjectArray) {
        this.elements = eJBObjectArray;
        this.exhausted = true;
    }

    PortableFinderEnumerator(EJBObject[] eJBObjectArray, boolean bl, RemoteEnumerator remoteEnumerator) {
        this.elements = eJBObjectArray;
        this.exhausted = bl;
        this.enum = remoteEnumerator;
    }

    public Object nextElement() {
        try {
            return this.nextElementR();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            throw new NoSuchElementException();
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMoreElementsR();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            return false;
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
    }

    public synchronized boolean hasMoreElementsR() throws RemoteException, EnumeratorException {
        if (this.elements != null && this.index < this.elements.length) {
            return true;
        }
        if (!this.exhausted) {
            try {
                this.elements = null;
                this.index = 0;
                this.elements = this.fetchElements(25);
                return true;
            }
            catch (NoMoreElementsException noMoreElementsException) {
                return false;
            }
        }
        return false;
    }

    public synchronized Object nextElementR() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        return this.elements[this.index++];
    }

    public synchronized Object[] nextNElements(int n) throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] eJBObjectArray = null;
        int n2 = this.elements.length - this.index;
        if (!this.exhausted && n2 < n) {
            try {
                eJBObjectArray = this.fetchElements(n - n2);
            }
            catch (NoMoreElementsException noMoreElementsException) {
                // empty catch block
            }
        }
        int n3 = eJBObjectArray != null ? eJBObjectArray.length : 0;
        int n4 = n2 + n3;
        int n5 = Math.min(n, n4);
        Object[] objectArray = new EJBObject[n5];
        int n6 = Math.min(n5, n2);
        System.arraycopy(this.elements, this.index, objectArray, 0, n6);
        this.index += n6;
        if (eJBObjectArray != null) {
            System.arraycopy(eJBObjectArray, 0, objectArray, n6, n3);
        }
        return objectArray;
    }

    public int size() {
        this.loadEntireCollection();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public EJBObject[] loadEntireCollection() {
        EJBObject[] eJBObjectArray = null;
        try {
            eJBObjectArray = (EJBObject[])this.allRemainingElements();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            return this.elements;
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
        this.elements = eJBObjectArray;
        return eJBObjectArray;
    }

    public synchronized Object[] allRemainingElements() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] eJBObjectArray = null;
        if (!this.exhausted) {
            try {
                eJBObjectArray = this.enum.allRemainingElements();
            }
            catch (NoMoreElementsException noMoreElementsException) {
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new CollectionCannotBeFurtherAccessedException("Cannot access finder result outside transaction");
            }
            finally {
                this.exhausted = true;
                this.enum = null;
            }
        }
        int n = this.elements.length - this.index;
        int n2 = eJBObjectArray != null ? eJBObjectArray.length : 0;
        Object[] objectArray = new EJBObject[n + n2];
        System.arraycopy(this.elements, this.index, objectArray, 0, n);
        if (eJBObjectArray != null) {
            System.arraycopy(eJBObjectArray, 0, objectArray, n, n2);
        }
        this.elements = null;
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final EJBObject[] fetchElements(int n) throws RemoteException, EnumeratorException {
        EJBObject[] eJBObjectArray;
        block8: {
            EJBObject[] eJBObjectArray2 = null;
            try {
                try {
                    if (this.enum != null) {
                        eJBObjectArray2 = this.enum.nextNElements(n);
                    }
                    eJBObjectArray = eJBObjectArray2;
                    Object var5_6 = null;
                    if (eJBObjectArray2 == null) break block8;
                }
                catch (NoMoreElementsException noMoreElementsException) {
                    throw noMoreElementsException;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new CollectionCannotBeFurtherAccessedException("Cannot access finder result outside transaction");
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (eJBObjectArray2 != null) {
                    if (eJBObjectArray2.length >= n) throw throwable;
                }
                this.exhausted = true;
                this.enum = null;
                throw throwable;
            }
            if (eJBObjectArray2.length >= n) return eJBObjectArray;
        }
        this.exhausted = true;
        this.enum = null;
        return eJBObjectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(eyecatcher);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        try {
            objectOutputStream.writeObject(this.enum);
        }
        catch (Throwable throwable) {
            throw new CollectionCannotBeFurtherAccessedException(throwable.toString());
        }
        objectOutputStream.writeObject(this.elements);
        objectOutputStream.writeInt(this.index);
        objectOutputStream.writeBoolean(this.exhausted);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[4];
        int n2 = 0;
        for (n = 0; n < 4; n += n2) {
            n2 = objectInputStream.read(byArray, n, 4 - n);
            if (n2 != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (n = 0; n < eyecatcher.length; ++n) {
            if (eyecatcher[n] == byArray[n]) continue;
            throw new IOException();
        }
        short s = objectInputStream.readShort();
        short s2 = objectInputStream.readShort();
        try {
            this.enum = (RemoteEnumerator)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throw new CollectionCannotBeFurtherAccessedException(throwable.toString());
        }
        this.elements = (EJBObject[])objectInputStream.readObject();
        this.index = objectInputStream.readInt();
        this.exhausted = objectInputStream.readBoolean();
    }
}

