/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.finder;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.container.finder.FinderResultClientCollection;
import com.ibm.ejs.container.finder.FinderResultServer;
import com.ibm.ws.ejb.portable.Constants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FinderResultClientBase
implements Serializable {
    static final byte[] eyecatcher = Constants.FINDER_RESULT_CLIENT_BASE_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private static final long serialVersionUID = 4403100038030697155L;
    private transient FinderResultServer server;
    protected transient Vector wrappers;
    private transient boolean exhausted;
    private transient Object parentCollection;
    private transient int chunkSize;
    private transient int itrIndex;
    private transient boolean collectionExceptionPending;

    public FinderResultClientBase(FinderResultServer finderResultServer, Vector vector, Object object, int n) {
        this.server = finderResultServer;
        this.chunkSize = n;
        this.itrIndex = 0;
        this.exhausted = vector.size() == 0;
        this.wrappers = vector;
        this.parentCollection = object;
        if (this.server != null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ejs.container.finder.FinderResultServerImpl");
                Method method = clazz.getMethod("exhaustedCollection", null);
                boolean bl = (Boolean)method.invoke((Object)finderResultServer, null);
                if (bl) {
                    this.server = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean hasMoreElements() {
        return !this.exhausted;
    }

    public Object nextElement() {
        if (this.hasMoreElements()) {
            if (this.collectionExceptionPending) {
                throw new CollectionCannotBeFurtherAccessedException();
            }
            Object e = this.wrappers.elementAt(this.itrIndex++);
            if (this.server == null || this.parentCollection != null && ((FinderResultClientCollection)this.parentCollection).hasAllWrappers()) {
                if (this.itrIndex >= this.wrappers.size()) {
                    this.exhausted = true;
                }
            } else if (this.itrIndex >= this.wrappers.size()) {
                try {
                    Vector vector = this.server.getNextWrapperCollection(this.wrappers.size(), this.chunkSize);
                    if (vector == null || vector.size() == 0) {
                        this.exhausted = true;
                        if (this.parentCollection != null) {
                            ((FinderResultClientCollection)this.parentCollection).allWrappersCached();
                        }
                    } else {
                        this.wrappers.addAll(vector);
                    }
                }
                catch (RemoteException remoteException) {
                    this.collectionExceptionPending = true;
                }
            }
            return e;
        }
        throw new NoSuchElementException();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(eyecatcher);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.server);
        objectOutputStream.writeObject(this.wrappers);
        objectOutputStream.writeBoolean(this.exhausted);
        objectOutputStream.writeInt(this.chunkSize);
        objectOutputStream.writeInt(this.itrIndex);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[4];
        int n2 = 0;
        for (n = 0; n < 4; n += n2) {
            n2 = objectInputStream.read(byArray, n, 4 - n);
            if (n2 != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (n = 0; n < eyecatcher.length; ++n) {
            if (eyecatcher[n] == byArray[n]) continue;
            throw new IOException("Invalid eye catcher '" + eyecatcher + "' in FinderResultClientBase input stream");
        }
        short s = objectInputStream.readShort();
        short s2 = objectInputStream.readShort();
        this.server = (FinderResultServer)objectInputStream.readObject();
        this.wrappers = (Vector)objectInputStream.readObject();
        this.exhausted = objectInputStream.readBoolean();
        this.chunkSize = objectInputStream.readInt();
        this.itrIndex = objectInputStream.readInt();
    }
}

