/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public final class FileSaveServiceImpl
implements FileSaveService {
    static FileSaveServiceImpl _sharedInstance = null;
    private SmartSecurityDialog _securityDialog = new SmartSecurityDialog(Resources.getString("APIImpl.file.save.message"));
    private String _lastPath;

    private FileSaveServiceImpl() {
    }

    public static synchronized FileSaveService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileSaveServiceImpl();
        }
        return _sharedInstance;
    }

    String getLastPath() {
        return this._lastPath;
    }

    void setLastPath(String string) {
        this._lastPath = string;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        return this.saveFileDialog(string, stringArray, fileContents.getInputStream(), fileContents.getName());
    }

    public FileContents saveFileDialog(final String string, String[] stringArray, final InputStream inputStream, String string2) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JFileChooser jFileChooser = null;
                FileSystemView fileSystemView = FileOpenServiceImpl.getFileSystemView();
                jFileChooser = string != null ? new JFileChooser(string, fileSystemView) : new JFileChooser(FileSaveServiceImpl.this.getLastPath(), fileSystemView);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogType(1);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 1) {
                    return null;
                }
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        byte[] byArray = new byte[8192];
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        int n2 = bufferedInputStream.read(byArray);
                        while (n2 != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                            n2 = bufferedInputStream.read(byArray);
                        }
                        bufferedOutputStream.close();
                        FileSaveServiceImpl.this.setLastPath(file.getPath());
                        return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                }
                return null;
            }
        });
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return (FileContents)t;
    }

    synchronized boolean askUser() {
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        return this._securityDialog.showDialog();
    }

    static long computeMaxLength(long l) {
        return l * 3L;
    }
}

