/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.BrowserSupport;
import com.sun.javaws.ConfigProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.Security;

public class UnixBrowserSupport
extends BrowserSupport {
    public String getNS6MailCapInfo() {
        return "user_pref(\"helpers.private_mailcap_file\", \"" + System.getProperty("user.home") + "/.mailcap\");\nuser_pref(\"helpers.private_mime_types_file\", \"" + System.getProperty("user.home") + "/.mime.types\");\n";
    }

    public boolean isWebBrowserSupportedImpl() {
        return true;
    }

    public SecureRandom getSecureRandomImpl() {
        try {
            File file = new File("/dev/urandom");
            if (file != null && file.exists()) {
                Security.setProperty("securerandom.source", "file:/dev/urandom");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SecureRandom();
    }

    public boolean showDocumentImpl(URL uRL) {
        try {
            Process process;
            String[] stringArray;
            ConfigProperties configProperties = ConfigProperties.getInstance();
            String string = configProperties.getBrowserPath();
            if (configProperties.isBrowserNetscape()) {
                stringArray = new String[]{string, "-raise", "-remote", "openURL(" + uRL.toString() + ")"};
                process = Runtime.getRuntime().exec(stringArray);
                InputStream inputStream = process.getErrorStream();
                byte[] byArray = new byte[1024];
                try {
                    int n = process.waitFor();
                    int n2 = inputStream.read(byArray, 0, 1024);
                    if (n == 0 && n2 == -1) {
                        return true;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            stringArray = new String[]{string, uRL.toString()};
            process = Runtime.getRuntime().exec(stringArray);
            if (process == null) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

