/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.util.VersionString;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LaunchSelection {
    static ConfigProperties.JREInformation selectJRE(LaunchDesc launchDesc) {
        final JREDesc[] jREDescArray = new JREDesc[1];
        final ConfigProperties.JREInformation[] jREInformationArray = new ConfigProperties.JREInformation[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (jREInformationArray[0] == null) {
                    LaunchSelection.handleJREDesc(jREDesc, jREInformationArray, jREDescArray);
                }
            }
        });
        jREDescArray[0].markAsSelected();
        return jREInformationArray[0];
    }

    private static void handleJREDesc(JREDesc jREDesc, ConfigProperties.JREInformation[] jREInformationArray, JREDesc[] jREDescArray) {
        URL uRL = jREDesc.getHref();
        String string = jREDesc.getVersion();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            LaunchSelection.matchJRE(jREDesc, stringArray, jREInformationArray, jREDescArray);
            if (jREInformationArray[0] != null) {
                return;
            }
        }
    }

    private static void matchJRE(JREDesc jREDesc, String[] stringArray, ConfigProperties.JREInformation[] jREInformationArray, JREDesc[] jREDescArray) {
        URL uRL = jREDesc.getHref();
        ConfigProperties configProperties = ConfigProperties.getInstance();
        ArrayList arrayList = configProperties.getJREInformationList();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            VersionString versionString = new VersionString(stringArray[i]);
            for (int j = 0; j < arrayList.size(); ++j) {
                ConfigProperties.JREInformation jREInformation = (ConfigProperties.JREInformation)arrayList.get(j);
                if (!jREInformation.isOsInfoMatch(Globals.osName, Globals.osArch) || !jREInformation.isEnabled()) continue;
                boolean bl = uRL == null && jREInformation.isPlatformMatch(versionString) || uRL != null && jREInformation.isProductMatch(uRL, versionString);
                boolean bl2 = jREInformation.isCurrentRunningJRE();
                boolean bl3 = JnlpxArgs.isCurrentRunningJREHeap(jREDesc.getMinHeap(), jREDesc.getMaxHeap());
                if (bl && bl2 && bl3) {
                    if (Globals.TraceStartup) {
                        Debug.println("LaunchSelection: findJRE: Match on current JRE");
                    }
                    jREInformationArray[0] = jREInformation;
                    jREDescArray[0] = jREDesc;
                    return;
                }
                if (!bl || jREInformationArray[0] != null) continue;
                if (Globals.TraceStartup) {
                    Debug.print("LaunchSelection: findJRE: No match on current JRE because ");
                    if (!bl) {
                        Debug.print("versions dont match, ");
                    }
                    if (!bl2) {
                        Debug.print("paths dont match, ");
                    }
                    if (!bl3) {
                        Debug.print("heap sizes dont match");
                    }
                    Debug.println("");
                }
                jREInformationArray[0] = jREInformation;
                jREDescArray[0] = jREDesc;
            }
        }
        if (jREDescArray[0] == null) {
            jREDescArray[0] = jREDesc;
        }
    }
}

