/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Main;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JPDA {
    private static final int NAPN = -1;
    public static final int JWS = 1;
    public static final int JWSJNL = 2;
    public static final int JNL = 3;
    private static String JWS_str = "1";
    private static String JWSJNL_str = "2";
    private static String JNL_str = "3";
    private static String dbgNotificationTitle = "JPDA Notification";
    private static JPDA o_envCurrentJRE = null;
    private static JPDA o_envNextJRE = null;
    private static String s_envCurrentJRE = null;
    private static int _debuggeeType = 0;
    private static boolean _jpdaConfigIsFromCmdLine = false;
    private static String _portsList = null;
    private static int[] _portsPool = null;
    private int _selectedPort = -1;
    private boolean _portIsAutoSelected = false;
    private String _excludedportsList = null;
    private int[] _excludedportsPool = null;
    private String _jreProductVersion = null;
    private int _jreNestingLevel = -1;
    private static boolean _jreUsesDashClassic = false;
    private String _javaMainArgsList = null;
    private static boolean _nextJreRunsInJpdaMode = false;

    public static int getDebuggeeType() {
        return _debuggeeType;
    }

    public static void setup() {
        s_envCurrentJRE = JPDA.getProperty("jnlpx.jpda.env");
        o_envCurrentJRE = JPDA.decodeJpdaEnv(s_envCurrentJRE);
        if (JPDA.getProperty("jpda.notification") != null) {
            JPDA.showJpdaNotificationWindow(o_envCurrentJRE);
            Main.systemExit(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static JPDA decodeJpdaEnv(String string) {
        int n;
        if (string == null) return null;
        if (string.equals("")) {
            return null;
        }
        JPDA jPDA = new JPDA();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        int n2 = stringTokenizer.countTokens();
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = true;
        }
        try {
            block3: while (stringTokenizer.hasMoreTokens()) {
                String[] stringArray;
                String[] stringArray2 = JPDA.tokenizeJpdaEnvEntry(stringTokenizer.nextToken(), "=");
                if (blArray[0] && stringArray2[0].equals("debuggeeType")) {
                    blArray[0] = false;
                    if (stringArray2[1].equals(JWS_str)) {
                        _debuggeeType = 1;
                        continue;
                    }
                    if (stringArray2[1].equals(JWSJNL_str)) {
                        _debuggeeType = 2;
                        continue;
                    }
                    if (!stringArray2[1].equals(JNL_str)) continue;
                    _debuggeeType = 3;
                    continue;
                }
                if (blArray[1] && stringArray2[0].equals("jpdaConfigIsFromCmdLine")) {
                    blArray[1] = false;
                    if (!stringArray2[1].equals("1")) continue;
                    _jpdaConfigIsFromCmdLine = true;
                    continue;
                }
                if (blArray[2] && stringArray2[0].equals("portsList")) {
                    blArray[2] = false;
                    _portsList = stringArray2[1];
                    if (_portsList.equals("NONE")) continue;
                    stringArray = JPDA.tokenizeJpdaEnvEntry(_portsList, ",");
                    _portsPool = new int[stringArray.length];
                    n = 0;
                    while (true) {
                        if (n >= stringArray.length) continue block3;
                        JPDA._portsPool[n] = JPDA.string2Int(stringArray[n]);
                        ++n;
                    }
                }
                if (blArray[3] && stringArray2[0].equals("selectedPort")) {
                    blArray[3] = false;
                    jPDA._selectedPort = JPDA.string2Int(stringArray2[1]);
                    continue;
                }
                if (blArray[4] && stringArray2[0].equals("portIsAutoSelected")) {
                    blArray[4] = false;
                    if (!stringArray2[1].equals("1")) continue;
                    jPDA._portIsAutoSelected = true;
                    continue;
                }
                if (blArray[5] && stringArray2[0].equals("excludedportsList")) {
                    blArray[5] = false;
                    jPDA._excludedportsList = stringArray2[1];
                    if (jPDA._excludedportsList.equals("NONE")) continue;
                    stringArray = JPDA.tokenizeJpdaEnvEntry(jPDA._excludedportsList, ",");
                    jPDA._excludedportsPool = new int[stringArray.length];
                    n = 0;
                    while (true) {
                        if (n >= stringArray.length) continue block3;
                        jPDA._excludedportsPool[n] = JPDA.string2Int(stringArray[n]);
                        ++n;
                    }
                }
                if (blArray[6] && stringArray2[0].equals("jreProductVersion")) {
                    blArray[6] = false;
                    jPDA._jreProductVersion = stringArray2[1];
                    continue;
                }
                if (blArray[7] && stringArray2[0].equals("jreNestingLevel")) {
                    blArray[7] = false;
                    jPDA._jreNestingLevel = JPDA.string2Int(stringArray2[1]);
                    continue;
                }
                if (blArray[8] && stringArray2[0].equals("jreUsesDashClassic")) {
                    blArray[8] = false;
                    if (!stringArray2[1].equals("1")) continue;
                    _jreUsesDashClassic = true;
                    continue;
                }
                if (!blArray[9] || !stringArray2[0].equals("javaMainArgsList")) continue;
                blArray[9] = false;
                jPDA._javaMainArgsList = stringArray2[1];
            }
            return jPDA;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static String encodeJpdaEnv(JPDA jPDA) {
        if (jPDA == null) {
            return "-Djnlpx.jpda.env";
        }
        return "-Djnlpx.jpda.env=debuggeeType=" + _debuggeeType + "&jpdaConfigIsFromCmdLine=" + (_jpdaConfigIsFromCmdLine ? "1" : "0") + "&portsList=" + _portsList + "&selectedPort=" + jPDA._selectedPort + "&portIsAutoSelected=" + (jPDA._portIsAutoSelected ? "1" : "0") + "&excludedportsList=" + jPDA._excludedportsList + "&jreProductVersion=" + jPDA._jreProductVersion + "&jreNestingLevel=" + jPDA._jreNestingLevel + "&jreUsesDashClassic=" + (_jreUsesDashClassic ? "1" : "0") + "&javaMainArgsList=" + jPDA._javaMainArgsList;
    }

    private static void setJpdaEnvForNextJRE(boolean bl, boolean bl2, String[] stringArray, ConfigProperties.JREInformation jREInformation) {
        int n;
        if (_debuggeeType == 0 || _debuggeeType == 1) {
            o_envNextJRE = o_envCurrentJRE;
            _nextJreRunsInJpdaMode = false;
            return;
        }
        JPDA jPDA = o_envCurrentJRE;
        JPDA jPDA2 = new JPDA();
        jPDA2._jreProductVersion = jREInformation.getProductVersionId();
        jPDA2._jreNestingLevel = 1 + jPDA._jreNestingLevel;
        jPDA2._javaMainArgsList = jPDA._javaMainArgsList;
        if (stringArray.length > 0) {
            jPDA2._javaMainArgsList = stringArray[0];
        }
        for (n = 1; n < stringArray.length; ++n) {
            jPDA2._javaMainArgsList = jPDA2._javaMainArgsList + "," + stringArray[n];
        }
        _nextJreRunsInJpdaMode = true;
        if (_debuggeeType == 3) {
            jPDA2._selectedPort = jPDA._selectedPort;
            jPDA2._portIsAutoSelected = jPDA._portIsAutoSelected;
            jPDA2._excludedportsList = jPDA._excludedportsList;
            jPDA2._excludedportsPool = jPDA._excludedportsPool;
            o_envNextJRE = jPDA2;
            return;
        }
        if (bl) {
            if (jPDA._excludedportsPool == null) {
                jPDA2._excludedportsList = "" + jPDA._selectedPort;
                jPDA2._excludedportsPool = new int[]{jPDA._selectedPort};
            } else {
                jPDA2._excludedportsList = jPDA._excludedportsList + "," + jPDA._selectedPort;
                jPDA2._excludedportsPool = new int[jPDA._excludedportsPool.length + 1];
                for (n = 0; n < jPDA._excludedportsPool.length; ++n) {
                    jPDA2._excludedportsPool[n] = jPDA._excludedportsPool[n];
                }
                jPDA2._excludedportsPool[n] = jPDA._selectedPort;
            }
        }
        jPDA2._selectedPort = jPDA2.getAvailableServerPort(bl, bl2);
        if (jPDA2._selectedPort < 0) {
            jPDA2 = null;
            _nextJreRunsInJpdaMode = false;
        }
        o_envNextJRE = jPDA2;
    }

    private static String[] tokenizeJpdaEnvEntry(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        try {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            return null;
        }
        return stringArray;
    }

    public static void showJpdaNotificationWindow(JPDA jPDA) {
        if (jPDA == null) {
            GeneralUtilities.showMessageDialog(null, "ERROR: No JPDA environment.", dbgNotificationTitle, 1);
        } else {
            GeneralUtilities.showMessageDialog(null, "Starting JRE (version " + jPDA._jreProductVersion + ") in JPDA debugging mode, trying server socket port " + jPDA._selectedPort + " on this host (" + JPDA.getLocalHostName() + ").\n\n        Main class  =  " + "com.sun.javaws.Main" + "\n        Arguments to main()  =  " + jPDA._javaMainArgsList + "\n\nTo start debugging, please connect a JPDA debugging client to this host at indicated port.\n\n\nDiagnostics:\n\n     Debugging directive was obtained from\n     " + (_jpdaConfigIsFromCmdLine ? "command line:" : "\"javaws-jpda.cfg\" configuration file:") + "\n        - JRE " + (_jreUsesDashClassic ? "uses" : "doesn't use") + "  -classic  option.\n        - Port " + (jPDA._portIsAutoSelected ? "automatically selected (by OS);\n          unable to find or use user-specified\n          ports list." : " selected from user-specified list:\n          " + _portsList + "."), dbgNotificationTitle + " (" + (jPDA._jreNestingLevel < 1 ? "JWS" : "JNL") + ")", 1);
        }
    }

    private static String getProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return string2;
        }
        return string2;
    }

    private static int string2Int(String string) {
        int n = -1;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
        return n;
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public int getAvailableServerPort(boolean bl, boolean bl2) {
        int n;
        int n2;
        if (_portsPool == null) {
            return -1;
        }
        this._portIsAutoSelected = false;
        for (n2 = 0; n2 < _portsPool.length; ++n2) {
            n = _portsPool[n2];
            if (n == 0 || bl && this.isExcludedPort(n)) continue;
            try {
                new ServerSocket(n).close();
                return n;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl2) {
            n2 = 0;
            try {
                do {
                    ServerSocket serverSocket = new ServerSocket(0);
                    n = serverSocket.getLocalPort();
                    serverSocket.close();
                } while (bl && this.isExcludedPort(n));
                this._portIsAutoSelected = true;
                return n;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean isExcludedPort(int n) {
        if (this._excludedportsPool == null) {
            return false;
        }
        for (int i = 0; i < this._excludedportsPool.length; ++i) {
            if (n != this._excludedportsPool[i]) continue;
            return true;
        }
        return false;
    }

    public static String[] JpdaSetup(String[] stringArray, ConfigProperties.JREInformation jREInformation) {
        JPDA.setJpdaEnvForNextJRE(true, true, stringArray, jREInformation);
        if (_nextJreRunsInJpdaMode) {
            int n = stringArray.length + (_jreUsesDashClassic ? 5 : 2);
            String[] stringArray2 = new String[n];
            int n2 = 0;
            stringArray2[n2++] = stringArray[0];
            if (_jreUsesDashClassic) {
                stringArray2[n2++] = "-classic";
                stringArray2[n2++] = "-Xnoagent";
                stringArray2[n2++] = "-Djava.compiler=NONE";
            }
            stringArray2[n2++] = "-Xdebug";
            stringArray2[n2++] = "-Xrunjdwp:transport=dt_socket,server=y,address=" + JPDA.o_envNextJRE._selectedPort + ",suspend=y";
            int n3 = 1;
            while (n3 < stringArray.length) {
                stringArray2[n2++] = stringArray[n3++];
            }
            JPDA.showJpdaNotificationWindow(o_envNextJRE);
            return stringArray2;
        }
        return stringArray;
    }
}

