/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.collaborator.TxCollaboratorConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionRolledbackException;

public class WebAppTransactionCollaborator {
    private static TraceComponent tc = Tr.register((Class)WebAppTransactionCollaborator.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final UOWCurrent uowCurrent = TransactionManagerFactory.getUOWCurrent();
    private static final LocalTransactionCurrent ltCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
    private static final WebSphereTransactionManager tranMgr = TransactionManagerFactory.getTransactionManager();
    private final String _webAppName;

    public WebAppTransactionCollaborator(WebApp webApp) {
        this._webAppName = webApp.getApplicationName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebAppTransactionCollaborator for --> " + this._webAppName));
        }
    }

    public Object preInvoke(HttpServletRequest httpServletRequest, boolean bl) throws ServletException {
        if (tc.isDebugEnabled()) {
            if (httpServletRequest != null) {
                Tr.debug((TraceComponent)tc, (String)("WebAppTransactionCollaborator.preInvoke() --> " + httpServletRequest.getRequestURI()), (Object)this._webAppName);
            } else {
                Tr.debug((TraceComponent)tc, (String)"WebAppTransactionCollaborator.preInvoke() --> null", (Object)this._webAppName);
            }
        }
        TxCollaboratorConfig txCollaboratorConfig = new TxCollaboratorConfig();
        if (bl || TxProperties.LTC_ALWAYS_REQUIRED) {
            UOWCoordinator uOWCoordinator = uowCurrent.getUOWCoord();
            if (uOWCoordinator == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No Global or Local Transaction exists so begin LTC");
                }
                try {
                    ltCurrent.begin();
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"preInvoke", "com.ibm.ws.webcontainer.webapp.WebAppTransactionCollaborator", exception});
                }
            } else if (!uOWCoordinator.isGlobal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LocalTransaction is active so suspend");
                }
                txCollaboratorConfig.setSuspendTx(ltCurrent.suspend());
                try {
                    ltCurrent.begin();
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"preInvoke", "com.ibm.ws.webcontainer.webapp.WebAppTransactionCollaborator", exception});
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Global Transaction is Active");
                }
                this.checkGlobalTxTimeout();
            }
        } else if (httpServletRequest != null) {
            this.checkGlobalTxTimeout();
        }
        return txCollaboratorConfig;
    }

    public void postInvoke(HttpServletRequest httpServletRequest, Object object, boolean bl) throws ServletException {
        if (tc.isDebugEnabled()) {
            if (httpServletRequest != null) {
                Tr.debug((TraceComponent)tc, (String)("WebAppTransactionCollaborator.postInvoke() --> " + httpServletRequest.getRequestURI()), (Object)this._webAppName);
            } else {
                Tr.debug((TraceComponent)tc, (String)"WebAppTransactionCollaborator.postInvoke() --> null", (Object)this._webAppName);
            }
        }
        if (bl || TxProperties.LTC_ALWAYS_REQUIRED) {
            Object object2;
            LocalTransactionCoordinator localTransactionCoordinator = ltCurrent.getLocalTranCoord();
            if (localTransactionCoordinator != null) {
                Throwable throwable;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"complete the LocalTransaction");
                }
                if ((object2 = ((TxCollaboratorConfig)object).getDispatchContext()) != null && object2 instanceof WebAppDispatcherContext && (throwable = ((WebAppDispatcherContext)object2).getCurrentException()) != null && throwable instanceof RuntimeException) {
                    localTransactionCoordinator.setRollbackOnly();
                }
                try {
                    localTransactionCoordinator.end(0);
                }
                catch (InconsistentLocalTranException inconsistentLocalTranException) {
                    Tr.event((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object)((Object)inconsistentLocalTranException));
                }
                catch (RolledbackException rolledbackException) {
                    Tr.event((TraceComponent)tc, (String)"RolledbackException", (Object)((Object)rolledbackException));
                }
            } else {
                this.checkGlobalTxTimeout();
            }
            object2 = ((TxCollaboratorConfig)object).getSuspendTx();
            if (object2 != null) {
                localTransactionCoordinator = (LocalTransactionCoordinator)object2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LocalTran suspended so resume");
                }
                try {
                    ltCurrent.resume(localTransactionCoordinator);
                }
                catch (IllegalStateException illegalStateException) {
                    Tr.event((TraceComponent)tc, (String)"IllegalStateException", (Object)illegalStateException);
                    try {
                        localTransactionCoordinator.cleanup();
                    }
                    catch (InconsistentLocalTranException inconsistentLocalTranException) {
                        Tr.event((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object)((Object)inconsistentLocalTranException));
                    }
                    catch (RolledbackException rolledbackException) {
                        ServletException servletException = new ServletException("LocalTransaction rolled-back due to setRollbackOnly", (Throwable)rolledbackException);
                        Tr.error((TraceComponent)tc, (String)"WTRN0043_LOCAL_TRAN_ROLLBACK", (Object)((Object)rolledbackException));
                        throw servletException;
                    }
                }
            }
        } else if (httpServletRequest != null) {
            this.checkGlobalTxTimeout();
        }
    }

    private void checkGlobalTxTimeout() throws ServletException {
        try {
            tranMgr.completeTxTimeout();
        }
        catch (TransactionRolledbackException transactionRolledbackException) {
            Tr.error((TraceComponent)tc, (String)"WTRN0042_GLOBAL_TRAN_ROLLBACK", (Object)((Object)transactionRolledbackException));
            ServletException servletException = new ServletException("GlobalTransaction rolled-back due to timeout or setRollbackOnly", (Throwable)transactionRolledbackException);
            throw servletException;
        }
    }
}

