/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class WebAppDispatcherContext
implements Cloneable {
    private Stack _servletReferenceStack = new Stack();
    private Stack exceptionStack = new Stack();
    private Request _request;
    SRTRequestContext reqContext = null;
    private WebAppDispatcherContext parentContext = null;
    private String relativeUri;
    private String _servletPath;
    private String _pathInfo;
    private String _requestUri;
    private String _contextPath = null;
    private String queryString = null;
    private boolean _useParent = false;
    private boolean enforceSecurity = true;
    private boolean _isInclude = false;
    private boolean isForward = false;
    private String decodedReqUri;
    private WebApp _webapp;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static TraceComponent tc = Tr.register((Class)WebAppDispatcherContext.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public WebAppDispatcherContext(WebApp webApp) {
        this.setWebApp(webApp);
    }

    public WebAppDispatcherContext(Request request) {
        this.initForNextDispatch(request);
    }

    public void setParentContext(WebAppDispatcherContext webAppDispatcherContext) {
        this.parentContext = webAppDispatcherContext;
    }

    public void finish() {
        this.resetObject();
    }

    public void setIsInclude(boolean bl) {
        this._isInclude = bl;
    }

    public void setUseParent(boolean bl) {
        this._useParent = bl;
    }

    public boolean getIsInclude() {
        return this._isInclude;
    }

    public WebApp getWebApp() {
        return this._webapp;
    }

    public void initForNextDispatch(Request request) {
        this._request = request;
        if (request != null) {
            this.reqContext = ((SRTServletRequest)this._request).getRequestContext();
        }
    }

    public void pushServletReference(IServletWrapper iServletWrapper) {
        this._servletReferenceStack.push(iServletWrapper);
    }

    public void popServletReference() {
        block2: {
            try {
                this._servletReferenceStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"EmptyStackException during popServletReference()");
            }
        }
    }

    public IServletWrapper getCurrentServletReference() {
        try {
            return (IServletWrapper)this._servletReferenceStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public Throwable getCurrentException() {
        if (this.exceptionStack.size() == 0) {
            return null;
        }
        try {
            return (Throwable)this.exceptionStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._request.getResponse();
    }

    void resetObject() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" ResetObject -->" + this));
        }
        this._servletReferenceStack.removeAllElements();
        this.exceptionStack.removeAllElements();
        this._isInclude = false;
        this._pathInfo = null;
        this._servletPath = null;
        this._webapp = null;
        this.relativeUri = null;
        this.queryString = null;
        this._requestUri = null;
        this.isForward = false;
        this.enforceSecurity = true;
    }

    private IHttpSessionContext getSessionContext() {
        return this._webapp.getSessionContext();
    }

    public String getRequestedSessionId() {
        return this.getSessionContext().getRequestedSessionId((HttpServletRequest)this._request);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getSessionContext().isRequestedSessionIdFromCookie((HttpServletRequest)this._request);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getSessionContext().isRequestedSessionIdFromUrl((HttpServletRequest)this._request);
    }

    public void sessionPreInvoke() {
        this.reqContext.sessionPreInvoke(this._webapp);
    }

    public void sessionPostInvoke() {
        try {
            this.reqContext.sessionPostInvoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String encodeURL(String string) {
        return this.reqContext.encodeURL(this._webapp, (HttpServletRequest)this._request, string);
    }

    public String getRelativeUri() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRelativeUri();
        }
        return this.relativeUri;
    }

    public void setRelativeUri(String string) {
        this.relativeUri = string;
    }

    public String getRealPath(String string) {
        return this.getWebApp().getRealPath(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return this.getWebApp().getRequestDispatcher(string);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if ((string3 = (String)this._request.getAttribute("javax.servlet.include.servlet_path")) == null) {
            String string4 = this.getPathInfo();
            string2 = this.getServletPath();
            if (string4 != null) {
                string2 = string2 + string4;
            }
        } else {
            String string5 = (String)this._request.getAttribute("javax.servlet.include.path_info");
            string2 = string3;
            if (string5 != null) {
                string2 = string2 + string5;
            }
        }
        string2 = string2.substring(0, string2.lastIndexOf("/"));
        string = string2 + '/' + string;
        return this.getWebApp().getRequestDispatcher(string);
    }

    public Principal getUserPrincipal() {
        return this.getWebApp().getSecurityCollaborator().getUserPrincipal();
    }

    public boolean isUserInRole(String string, HttpServletRequest httpServletRequest) {
        try {
            WebApp webApp = this.getWebApp();
            ServletWrapper servletWrapper = null;
            servletWrapper = (ServletWrapper)this._servletReferenceStack.peek();
            if (servletWrapper == null) {
                servletWrapper = webApp.getServletWrapper(this.getServletPath());
            }
            ServletConfig servletConfig = (ServletConfig)servletWrapper.getServletConfig();
            return webApp.getSecurityCollaborator().isUserInRole(string, httpServletRequest);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPathInfo() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getPathInfo();
        }
        return this._pathInfo;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public String getRequestURI() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRequestURI();
        }
        return this._requestUri;
    }

    public String getContextPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getContextPath();
        }
        String string = null;
        string = this._contextPath != null ? this._contextPath : this.getWebApp().getContextPath();
        if (string.equals("/")) {
            return "";
        }
        return string;
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string == null) {
            return null;
        }
        return this.getWebApp().getRealPath(string);
    }

    public String getServletPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getServletPath();
        }
        return this._servletPath;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public boolean isInclude() {
        return this.getIsInclude();
    }

    public void sendRedirect303(String string) throws IOException {
        this.sendRedirectWithStatusCode(string, 303);
    }

    public void sendRedirect(String string) throws IOException {
        this.sendRedirectWithStatusCode(string, 302);
    }

    private void sendRedirectWithStatusCode(String string, int n) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.getResponse();
        if (!httpServletResponse.isCommitted()) {
            if (string == null) {
                throw new IllegalArgumentException("Location cannot be null in javax.servlet.http.HttpServletResponse.sendRedirect(location)");
            }
        } else {
            throw new IllegalStateException();
        }
        httpServletResponse.resetBuffer();
        string = this.convertRelativeURIToURL(string);
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setStatus(n);
        httpServletResponse.flushBuffer();
    }

    public void sendError(int n) throws IOException {
        IServletWrapper iServletWrapper = this.getCurrentServletReference();
        if (iServletWrapper != null) {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), iServletWrapper.getServletName()));
        } else {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), this.getWebApp().getConfiguration().getDisplayName()));
        }
    }

    public void sendError(int n, String string) throws IOException {
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this.getResponse().resetBuffer();
        int n2 = n;
        try {
            if (!this.getResponse().isCommitted()) {
                ((HttpServletResponse)this.getResponse()).setStatus(n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.sendError", (String)"112", (Object)this);
        }
        WebApp webApp = this.getWebApp();
        WebAppErrorReport webAppErrorReport = null;
        webAppErrorReport = new WebAppErrorReport(string);
        webAppErrorReport.setErrorCode(n2);
        IServletWrapper iServletWrapper = this.getCurrentServletReference();
        if (iServletWrapper != null) {
            webAppErrorReport.setTargetServletName(iServletWrapper.getServletName());
        }
        this.getWebApp().sendError((HttpServletRequest)this._request, (HttpServletResponse)this.getResponse(), webAppErrorReport);
        this.getResponse().flushBuffer();
    }

    private String convertRelativeURIToURL(String string) {
        block18: {
            int n;
            if (string == null) {
                throw new IllegalStateException();
            }
            String string2 = string;
            int n2 = (string = string.trim()).indexOf("://");
            if (n2 != -1 && ((n = string.indexOf(63)) == -1 || n2 < n)) {
                return string;
            }
            String string3 = null;
            boolean bl = false;
            try {
                string3 = this.getWebApp().getContextPath().trim();
                if (!string3.startsWith("/")) {
                    string3 = "/" + string3;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"184", (Object)this);
                string3 = "/";
            }
            try {
                bl = string.startsWith("/");
                if (string.startsWith("./")) {
                    string = string.substring(2);
                }
                Request request = this._request;
                String string4 = request.getScheme();
                int n3 = request.getServerPort();
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append("://");
                stringBuffer.append(request.getServerName());
                if (string4.equals("http") && n3 != 80 || string4.equals("https") && n3 != 443) {
                    stringBuffer.append(":");
                    stringBuffer.append(n3);
                }
                String string5 = null;
                if (bl) {
                    if (WebContainerSystemProps.getSendRedirectCompatibilty()) {
                        stringBuffer.append(string3);
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(string);
                    }
                    string5 = stringBuffer.toString();
                } else {
                    String string6 = HttpUtils.getRequestURL((HttpServletRequest)((HttpServletRequest)request)).toString();
                    String string7 = request.getPathInfo();
                    if (string7 != null && string7.length() > 0) {
                        if (!string7.startsWith("/")) {
                            string7 = "/" + string7;
                        }
                        string6 = string6.substring(0, string6.lastIndexOf(string7));
                        string5 = string6 + "/" + string;
                    } else {
                        string5 = string6.substring(0, string6.lastIndexOf(47) + 1) + string;
                    }
                }
                if (string5.indexOf("..") > -1) {
                    int n4 = new String(string4 + "://").length();
                    int n5 = string5.indexOf("/", n4);
                    String string8 = string5.substring(0, n5);
                    String string9 = string5.substring(n5);
                    string9 = this.getWebApp().normalize(string9);
                    if (string9 != null) {
                        return string8 + string9;
                    }
                    break block18;
                }
                return string5;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"256", (Object)this);
            }
        }
        return string;
    }

    public void callPage(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        ServletContext servletContext = this.getWebApp().getContext(string);
        WebApp webApp = (WebApp)servletContext;
        String string2 = string.substring(webApp.getContextPath().length());
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string2);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)this.getResponse());
    }

    public void _include(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)this.getResponse());
    }

    public void _forward(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)this.getResponse());
    }

    public boolean isAutoRequestEncoding() {
        return this.getWebApp().getConfiguration().isAutoResponseEncoding();
    }

    public void setRequestURI(String string) {
        if (string == null) {
            this._requestUri = string;
            return;
        }
        int n = string.indexOf("?");
        if (n != -1) {
            this.queryString = string.substring(n + 1);
            this._requestUri = string.substring(0, n);
        } else {
            this._requestUri = string;
        }
    }

    public void setPathElements(String string, String string2) {
        if (string.length() == 1 && string.charAt(0) == '/') {
            this._servletPath = "";
            this._pathInfo = string2 == null ? "/" : "/" + string2;
        } else {
            this._servletPath = string;
            this._pathInfo = string2;
        }
        this.relativeUri = this._servletPath;
        if (this._pathInfo != null) {
            this.relativeUri = this.relativeUri + this._pathInfo;
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean bl) {
        this.isForward = bl;
    }

    public String getQueryString() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getQueryString();
        }
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void pushException(Throwable throwable) {
        this.exceptionStack.push(throwable);
    }

    public void setWebApp(WebApp webApp) {
        this._webapp = webApp;
        if (this.reqContext != null) {
            this.reqContext.setCurrWebAppBoundary(webApp);
        }
    }

    public void setContextPath(String string) {
        this._contextPath = string;
    }

    public boolean isEnforceSecurity() {
        return this.enforceSecurity;
    }

    public void setEnforceSecurity(boolean bl) {
        this.enforceSecurity = bl;
    }

    public void setDecodedReqUri(String string) {
        this.decodedReqUri = string;
    }

    public String getDecodedReqUri() {
        return this.decodedReqUri;
    }

    public void dumpDispatchContextHierarchy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current context -->" + this));
        }
        WebAppDispatcherContext webAppDispatcherContext = this.parentContext;
        while (webAppDispatcherContext != null) {
            Tr.debug((TraceComponent)tc, (String)("parent context -->" + webAppDispatcherContext));
            webAppDispatcherContext = webAppDispatcherContext.parentContext;
        }
    }

    public Object clone(SRTServletRequest sRTServletRequest, SRTRequestContext sRTRequestContext) throws CloneNotSupportedException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DispatcherContext::Original-->WebAppDispatcherContext::" + this + "requestContext::" + this.reqContext + "_request::" + this._request));
        }
        WebAppDispatcherContext webAppDispatcherContext = (WebAppDispatcherContext)super.clone();
        webAppDispatcherContext._request = sRTServletRequest;
        webAppDispatcherContext.reqContext = sRTRequestContext;
        if (this._servletReferenceStack != null) {
            webAppDispatcherContext._servletReferenceStack = (Stack)this._servletReferenceStack.clone();
        }
        if (this.exceptionStack != null) {
            webAppDispatcherContext.exceptionStack = (Stack)this.exceptionStack.clone();
        }
        if (this.parentContext != null) {
            webAppDispatcherContext.parentContext = (WebAppDispatcherContext)this.parentContext.clone(sRTServletRequest, sRTRequestContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DispatcherContext::Cloned-->WebAppDispatcherContext::" + webAppDispatcherContext + "requestContext::" + sRTRequestContext + "_request::" + sRTServletRequest));
        }
        return webAppDispatcherContext;
    }
}

