/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.transport;

import com.ibm.ws.webcontainer.http.HttpConnection;
import com.ibm.ws.webcontainer.transport.CookieHandler;
import com.ibm.ws.webcontainer.transport.HttpHeader;
import com.ibm.ws.webcontainer.transport.HttpResponse;
import com.ibm.ws.webcontainer.transport.IProtocolHeader;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class HttpRequest
implements IRequest {
    HttpConnection _conn = null;
    IResponse _response = null;
    boolean _headerPrepared = false;
    IProtocolHeader _header = null;

    public HttpRequest(HttpConnection httpConnection) {
        this._conn = httpConnection;
        this._response = new HttpResponse(httpConnection);
        this._header = new HttpHeader();
        this._headerPrepared = false;
    }

    public String getQueryString() {
        return this._conn.getQueryString();
    }

    public String getAuthType() {
        return this._conn.getAuthType();
    }

    public String getConnectionCipherSuite() {
        return this._conn.getConnectionCipherSuite();
    }

    public String getMethod() {
        return this._conn.getMethod();
    }

    public String getRequestURI() {
        return this._conn.getRequestURI();
    }

    public String getRemoteUser() {
        return this._conn.getRemoteUser();
    }

    public String getHeader(String string) {
        return this._conn.getHttpRequest().getHeader(string);
    }

    public String[][] getAllHeaders() {
        String[][] stringArray = new String[2][0];
        this._conn.getHttpRequest().getHeaders(stringArray);
        return stringArray;
    }

    public int getContentLength() {
        return this._conn.getContentLength();
    }

    public String getProtocol() {
        return this._conn.getProtocol();
    }

    public String getServerName() {
        return this._conn.getServerName();
    }

    public int getServerPort() {
        return this._conn.getServerPort();
    }

    public String getRemoteHost() {
        return this._conn.getRemoteHost();
    }

    public String getRemoteAddr() {
        return this._conn.getRemoteAddr();
    }

    public int getRemotePort() {
        return this._conn.getConnectionRemotePort();
    }

    public String getScheme() {
        return this._conn.getScheme();
    }

    public InputStream getInputStream() {
        try {
            return this._conn.getHttpRequest().getInputStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getLocalAddr() {
        return this._conn.getConnectionLocalAddr();
    }

    public String getLocalName() {
        return this._conn.getConnectionLocalName();
    }

    public int getLocalPort() {
        return this._conn.getConnectionLocalPort();
    }

    public boolean isSSL() {
        return this._conn.isSSL();
    }

    public byte[] getSSLSessionID() {
        return this._conn.getSessionId();
    }

    public boolean isProxied() {
        return this._conn.getHttpRequest().isProxied();
    }

    public String getSessionID() {
        return null;
    }

    public IResponse getWCCResponse() {
        return this._response;
    }

    public String getCipherSuite() {
        return this._conn.getCipherSuite();
    }

    public X509Certificate[] getPeerCertificates() {
        return this._conn.getPeerCertificates();
    }

    public String getContentType() {
        return this._conn.getContentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareHeader() {
        if (!this._headerPrepared) {
            IProtocolHeader iProtocolHeader = this._header;
            synchronized (iProtocolHeader) {
                String[][] stringArray = this.getAllHeaders();
                String[] stringArray2 = stringArray[0];
                String[] stringArray3 = stringArray[1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    this._header.appendField(stringArray2[i], stringArray3[i]);
                }
            }
        }
        this._headerPrepared = true;
    }

    public void clearHeaders() {
        this._header.clear();
        this._headerPrepared = false;
    }

    public Cookie[] getCookies() {
        if (!this._headerPrepared) {
            this.prepareHeader();
        }
        return CookieHandler.getCookies(this._header);
    }

    public byte[] getCookieValue(String string) {
        String string2 = this.getHeader("Cookie");
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = null;
            String string4 = null;
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf(61);
            if (n == -1) {
                string3 = string5;
            } else {
                string3 = string5.substring(0, n).trim();
                string4 = string5.substring(n + 1);
            }
            if (!string3.equalsIgnoreCase(string)) continue;
            return string4.getBytes();
        }
        return null;
    }

    public Enumeration getHeaders(String string) {
        if (!this._headerPrepared) {
            this.prepareHeader();
        }
        Object[] objectArray = this._header.getFields(string);
        return new ArrayEnumeration(objectArray);
    }

    public long getDateHeader(String string) {
        if (!this._headerPrepared) {
            this.prepareHeader();
        }
        return this._header.getDateField(string);
    }

    public int getIntHeader(String string) {
        if (!this._headerPrepared) {
            this.prepareHeader();
        }
        return this._header.getIntField(string);
    }

    public Enumeration getHeaderNames() {
        if (!this._headerPrepared) {
            this.prepareHeader();
        }
        return this._header.getFieldNames();
    }
}

