/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.transport.CacheControlHeader;
import com.ibm.ws.webcontainer.transport.DateTool;
import com.ibm.ws.webcontainer.transport.IProtocolHeader;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class CookieHandler {
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?={} \t";
    private static TraceComponent tc = Tr.register((Class)CookieHandler.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static boolean noAdditionalHeaders = false;

    public static void addCookie(Cookie cookie, IProtocolHeader iProtocolHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCookie", (Object)cookie);
        }
        String string = CookieHandler.toString(cookie);
        if (cookie.getVersion() == 1) {
            iProtocolHeader.appendField("Set-Cookie2", string);
        }
        iProtocolHeader.appendField("Set-Cookie", string);
        if (!noAdditionalHeaders) {
            String string2 = iProtocolHeader.getField("Cache-Control");
            CacheControlHeader cacheControlHeader = new CacheControlHeader(string2);
            Enumeration enumeration = cacheControlHeader.getStringDirective("no-cache");
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.equals("set-cookie")) continue;
                return;
            }
            cacheControlHeader.addStringDirective("no-cache", "set-cookie");
            cacheControlHeader.addStringDirective("no-cache", "set-cookie2");
            iProtocolHeader.setField("Cache-Control", cacheControlHeader.toString());
            if (iProtocolHeader.getField("Expires") == null) {
                iProtocolHeader.setField("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCookie");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Cookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toString", (Object)cookie);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = cookie.getName();
        String string2 = cookie.getValue();
        String string3 = cookie.getDomain();
        String string4 = cookie.getPath();
        String string5 = cookie.getComment();
        int n = cookie.getMaxAge();
        int n2 = cookie.getVersion();
        boolean bl = cookie.getSecure();
        stringBuffer.append(string).append("=");
        CookieHandler.maybeQuote(n2, stringBuffer, string2);
        if (n2 == 1) {
            stringBuffer.append(";Version=1");
            if (string5 != null) {
                stringBuffer.append(";Comment=");
                CookieHandler.maybeQuote(n2, stringBuffer, string5);
            }
        }
        if (string3 != null) {
            stringBuffer.append(";Domain=");
            CookieHandler.maybeQuote(n2, stringBuffer, string3);
        }
        if (n >= 0) {
            if (n2 == 0) {
                stringBuffer.append(";Expires=");
                DateFormat dateFormat = DateTool.oldCookieFormat;
                synchronized (dateFormat) {
                    if (n == 0) {
                        DateTool.oldCookieFormat.format(new Date(10000L), stringBuffer, new FieldPosition(0));
                    } else {
                        DateTool.oldCookieFormat.format(new Date(System.currentTimeMillis() + (long)n * 1000L), stringBuffer, new FieldPosition(0));
                    }
                }
            } else {
                stringBuffer.append(";Max-Age=");
                stringBuffer.append(n);
            }
        }
        if (string4 != null) {
            stringBuffer.append(";Path=");
            CookieHandler.maybeQuote(n2, stringBuffer, string4);
        }
        if (bl) {
            stringBuffer.append("; Secure");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toString");
        }
        return stringBuffer.toString();
    }

    public static Cookie getCookie(String string, IProtocolHeader iProtocolHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookie", (Object)string);
        }
        Cookie[] cookieArray = CookieHandler.getCookies(iProtocolHeader);
        Cookie cookie = null;
        if (cookieArray == null) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(string)) continue;
            cookie = (Cookie)cookieArray[i].clone();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookie");
        }
        return cookie;
    }

    public static Cookie[] getSetCookies(IProtocolHeader iProtocolHeader) {
        return CookieHandler.getCookiesFromHeaderField("Set-Cookie", iProtocolHeader);
    }

    public static Cookie[] getCookies(IProtocolHeader iProtocolHeader) {
        return CookieHandler.getCookiesFromHeaderField("Cookie", iProtocolHeader);
    }

    private static Cookie[] getCookiesFromHeaderField(String string, IProtocolHeader iProtocolHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookiesFromHeaderField", (Object)string);
        }
        String[] stringArray = null;
        stringArray = iProtocolHeader.getFields(string);
        if (stringArray == null) {
            return null;
        }
        Object[] objectArray = null;
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            CookieHandler.getCookiesFromString(stringArray[i], vector);
        }
        objectArray = new Cookie[vector.size()];
        vector.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookiesFromHeaderField");
        }
        return objectArray;
    }

    public static Cookie[] getCookiesFromString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookiesFromString");
        }
        Vector vector = new Vector();
        CookieHandler.getCookiesFromString(string, vector);
        Object[] objectArray = new Cookie[vector.size()];
        vector.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookiesFromString");
        }
        return objectArray;
    }

    private static void getCookiesFromString(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookiesFromString");
        }
        if (string == null) {
            return;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        Cookie cookie = null;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = null;
            String string3 = null;
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf(61);
            if (n2 == -1 || n2 == string4.length() - 1) {
                string2 = string4.trim();
            } else {
                string2 = string4.substring(0, n2).trim();
                string3 = string4.charAt(n2 + 1) == '\"' ? string4.substring(n2 + 2, string4.length() - 1) : string4.substring(n2 + 1);
            }
            if (string2.length() > 0 && string2.charAt(0) == '$') {
                if (string2.equalsIgnoreCase("$Version")) {
                    n = Integer.parseInt(string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("$Domain") && cookie != null) {
                    cookie.setDomain(string3);
                    continue;
                }
                if (!string2.equalsIgnoreCase("$Path") || cookie == null) continue;
                cookie.setPath(string3);
                continue;
            }
            try {
                cookie = new Cookie(string2, string3);
                cookie.setVersion(n);
                vector.addElement(cookie);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.webcontainer.srt.CookieHandler.getCookiesFromString", (String)"325");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookiesFromString");
        }
    }

    private static boolean isToken(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isToken", (Object)string);
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isToken: false");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isToken: true");
        }
        return false;
    }

    private static void maybeQuote(int n, StringBuffer stringBuffer, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"maybeQuote");
        }
        if (n == 0) {
            stringBuffer.append(string);
        } else if (!CookieHandler.isToken(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"maybeQuote");
        }
    }

    static {
        try {
            String string = System.getProperty("com.ibm.websphere.cookies.no.header");
            if (string != null) {
                noAdditionalHeaders = new Boolean(string);
            }
            Tr.debug((TraceComponent)tc, (String)("No additional headers flag for cookies set to " + noAdditionalHeaders));
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"{0}", (Object)throwable);
        }
    }
}

