/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.srt.BufferedServletOutputStream;
import com.ibm.ws.webcontainer.srt.BufferedWriter;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.srt.IOutputStreamObserver;
import com.ibm.ws.webcontainer.srt.IResponseOutput;
import com.ibm.ws.webcontainer.srt.ResponseBuffer;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SRTServletResponse
implements HttpServletResponse,
IResponseOutput,
IExtendedResponse,
IServletResponse,
Response,
IOutputStreamObserver {
    private boolean isCharEncodingExplicit;
    private static final byte[] REASON_OK = "OK".getBytes();
    private static final String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static final byte[] CONTENT_LANGUAGE_HEADER_BYTES = "Content-Language".getBytes();
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final byte[] HEADER_CONTENT_TYPE_BYTES = "Content-Type".getBytes();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final byte[] HEADER_CONTENT_LENGTH_BYTES = "Content-Length".getBytes();
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final byte[] HEADER_CONTENT_ENCODING_BYTES = "Content-Encoding".getBytes();
    private static final boolean keepContentLength = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("keepcontentlength"));
    protected static final TraceComponent tc = Tr.register((Class)SRTServletResponse.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static final NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Locale _defaultLocale = Locale.getDefault();
    public static final String _defaultEncoding = "ISO-8859-1";
    protected IResponse _response = null;
    protected boolean writerClosed = false;
    protected SRTOutputStream _rawOut = new SRTOutputStream();
    protected ResponseBuffer _responseBuffer = null;
    protected BufferedServletOutputStream _bufferedOut = new BufferedServletOutputStream(4096);
    protected BufferedWriter _bufferedWriter = new BufferedWriter(4096);
    protected PrintWriter _pwriter;
    protected boolean _firstWrite = false;
    protected int _bufferSize = 4096;
    protected boolean _gotWriter = false;
    protected boolean _gotOutputStream = false;
    protected OutputStreamWriter _outWriter = null;
    protected String _outWriterEncoding;
    protected boolean writerException = false;
    protected boolean _ignoreStateErrors;
    protected boolean _headersWritten = false;
    protected Locale _locale;
    protected String _encoding;
    protected int _contentLength = -1;
    protected int _statusCode = 200;
    private SRTConnectionContext _connContext;

    public SRTServletResponse() {
        this._bufferedWriter.setObserver(this);
        this._bufferedOut.setObserver(this);
    }

    public SRTServletResponse(SRTConnectionContext sRTConnectionContext) {
        this();
        this._connContext = sRTConnectionContext;
    }

    public void alertClose() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("alertClose _outWriter: --> " + this._outWriter));
        }
        this.writerClosed = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertClose");
        }
    }

    public void alertFirstWrite() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertFirstWrite");
        }
        this._firstWrite = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertFirstWrite");
        }
    }

    public void alertFirstFlush() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertFirstFlush");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertFirstFlush");
        }
    }

    public void alertException() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("alertException  _outWriter: --> " + this._outWriter));
        }
        this.writerException = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertException");
        }
    }

    public boolean writerObtained() {
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        return this._gotOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"finish");
            }
            if (!this.isCommitted()) {
                this.commit();
            }
            try {
                try {
                    this.flushBuffer(false);
                    this._rawOut.close();
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Servlet.Exception:.Error.while.finishing.response", (Object)iOException);
                    }
                    Object var3_2 = null;
                    this._rawOut.reset();
                    this._response.clearHeaders();
                    this._response = null;
                    this._bufferSize = 4096;
                    this._encoding = null;
                    this._bufferedOut.reset();
                    this._bufferedWriter.reset();
                    this._responseBuffer = null;
                    this._gotOutputStream = false;
                    this._gotWriter = false;
                    this._pwriter = null;
                    this._responseBuffer = null;
                    break block8;
                }
                Object var3_1 = null;
                this._rawOut.reset();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._rawOut.reset();
                this._response.clearHeaders();
                this._response = null;
                this._bufferSize = 4096;
                this._encoding = null;
                this._bufferedOut.reset();
                this._bufferedWriter.reset();
                this._responseBuffer = null;
                this._gotOutputStream = false;
                this._gotWriter = false;
                this._pwriter = null;
                this._responseBuffer = null;
                throw throwable;
            }
            this._response.clearHeaders();
            this._response = null;
            this._bufferSize = 4096;
            this._encoding = null;
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            this._pwriter = null;
            this._responseBuffer = null;
        }
        this.resetState();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        this._connContext = null;
        this._rawOut = null;
        this._bufferedOut = null;
        this._bufferedWriter = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    protected void resetState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetState");
        }
        this._headersWritten = false;
        this._firstWrite = false;
        this._ignoreStateErrors = false;
        this._contentLength = -1;
        this._locale = _defaultLocale;
        this.writerClosed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetState");
        }
    }

    public void addField(String string, String string2) {
        this._response.addHeader(string, string2);
    }

    public void addDateField(String string, long l) {
        this._response.addDateHeader(string, l);
    }

    public void addIntField(String string, int n) {
        this._response.addIntHeader(string, n);
    }

    protected String getHeader(String string) {
        return this._response.getHeader(string);
    }

    protected String getHeader(byte[] byArray) {
        return this._response.getHeader(byArray);
    }

    public boolean containsHeader(String string) {
        return this._response.containsHeader(string);
    }

    public boolean containsHeader(byte[] byArray) {
        return this._response.containsHeader(byArray);
    }

    protected void removeHeader(String string) {
        this._response.removeHeader(string);
    }

    protected void removeHeader(byte[] byArray) {
        this._response.removeHeader(byArray);
    }

    public void resetBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetBuffer");
        }
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetBuffer");
        }
    }

    public void closeResponseOutput() {
        if (!this.writerClosed) {
            try {
                if (this._gotOutputStream) {
                    this._bufferedOut.close();
                    this._rawOut.close();
                } else if (this._gotWriter) {
                    this._pwriter.close();
                    this._rawOut.close();
                }
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"Error while closing response output.");
            }
        }
    }

    public void setIgnoreStateErrors(boolean bl) {
        this._ignoreStateErrors = bl;
    }

    public void setBufferSize(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferSize - {0}", (Object)String.valueOf(n));
        }
        this._bufferSize = n;
        if (this._responseBuffer != null) {
            if (!this._firstWrite) {
                this._responseBuffer.setBufferSize(n);
            } else {
                Tr.error((TraceComponent)tc, (String)"setbuffer.size.called.after.write");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setBufferSize");
                }
                throw new IllegalStateException("setBufferSize() called after first write to Output Stream/Writer");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferSize");
        }
    }

    public int getBufferSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBufferSize");
        }
        if (this._responseBuffer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBufferSize");
            }
            return this._bufferSize;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBufferSize");
        }
        return this._responseBuffer.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer(boolean bl) throws IOException {
        boolean bl2 = false;
        if (!bl) {
            this._response.setFlushMode(false);
        }
        try {
            if (this._pwriter != null && !this.writerClosed) {
                this._pwriter.flush();
                bl2 = true;
            }
            if (this._gotOutputStream) {
                this._responseBuffer.flushBuffer();
                bl2 = true;
            }
            if (!this.isCommitted() && !bl2) {
                this.commit();
                this._response.writeHeaders();
            }
        }
        finally {
            if (!bl) {
                this._response.setFlushMode(true);
            }
        }
    }

    public boolean isCommitted() {
        if (this._headersWritten) {
            return true;
        }
        if (this._gotWriter || this._gotOutputStream) {
            if (this._responseBuffer == null) {
                return false;
            }
            return this._responseBuffer.isCommitted();
        }
        return false;
    }

    public Request getRequest() {
        return this._connContext.getRequest();
    }

    public ServletOutputStream getOutputStream() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream");
        }
        if (!this._ignoreStateErrors && this._gotWriter) {
            throw new IllegalStateException(nls.getString("Writer.already.obtained", "Writer already obtained"));
        }
        this._gotOutputStream = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        this._bufferedOut.init((OutputStream)((Object)this._rawOut), this.getBufferSize());
        this._bufferedOut.setLimit(this._contentLength);
        this._bufferedOut.setResponse(this._response);
        this._responseBuffer = this._bufferedOut;
        return this._bufferedOut;
    }

    public PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriter");
        }
        if (!this._ignoreStateErrors && this._gotOutputStream) {
            throw new IllegalStateException(nls.getString("OutputStream.already.obtained", "OutputStream already obtained"));
        }
        if (!this._gotWriter) {
            String string = this.getCharacterEncoding();
            String string2 = this.getContentType();
            if (string2 != null && string2.indexOf("charset") == -1) {
                if (string2.endsWith(";")) {
                    this.setContentType(string2 + "charset=" + string);
                } else {
                    this.setContentType(string2 + ";charset=" + string);
                }
            }
            if (this._outWriter == null || this.writerException || !string.equals(this._outWriterEncoding)) {
                if (tc.isDebugEnabled() && this.writerException) {
                    Tr.debug((TraceComponent)tc, (String)("writerException: " + this.writerException + "--> creating new OutputStreamWriter"));
                }
                this._outWriter = new OutputStreamWriter((OutputStream)((Object)this._rawOut), SRTRequestUtils.getJvmConverter(string));
                this._outWriterEncoding = string;
                this.writerException = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("reusing _outWriter: --> " + this._outWriter));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created writer with encoding: " + this._outWriter.getEncoding()));
            }
            this._bufferedWriter.init(this._outWriter, this.getBufferSize());
            this._bufferedWriter.setLimit(this._contentLength);
            this._bufferedWriter.setResponse(this._response);
            this._pwriter = new PrintWriter((Writer)this._bufferedWriter, false);
            this._responseBuffer = this._bufferedWriter;
            this._gotWriter = true;
            this.writerClosed = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriter");
        }
        return this._pwriter;
    }

    public void start() {
        this.setDefaultResponseEncoding();
    }

    protected SRTConnectionContext getConnectionContext() {
        return this._connContext;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addCookie(Cookie cookie) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding cookie --> " + cookie.getName()));
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addCookie");
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
    }

    protected synchronized void commit() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Commit");
        }
        if (!this._headersWritten && !this.isCommitted()) {
            this.addLocaleHeader();
            if (this.containsHeader(HEADER_CONTENT_ENCODING_BYTES) && this.containsHeader(HEADER_CONTENT_LENGTH_BYTES)) {
                if (keepContentLength) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"WebContainer custom property set to keep Content-Length header w/presence of Content-Encoding header");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Content-Length header disallowed w/presence of Content-Encoding header");
                    }
                    this.removeHeader(HEADER_CONTENT_LENGTH_BYTES);
                }
            }
            WebContainer.notifyHttpServletResponseListenersPreHeaderCommit((HttpServletRequest)this._connContext.getRequest(), this);
            this._response.prepareHeadersForWrite();
            this._headersWritten = true;
        }
    }

    private void addLocaleHeader() {
        this._response.setContentLanguage(this._locale.toString().replace('_', '-'));
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeURL(String string) {
        return this.getRequest().getWebAppDispatcherContext().encodeURL(string);
    }

    protected void setDefaultResponseEncoding() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting the default response encoding");
        }
        if (this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().isAutoResponseEncoding()) {
            this._locale = this.getRequest().getLocale();
            if (this._locale == null) {
                this._locale = _defaultLocale;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_locale is null: default to " + this._locale.toString()));
                }
            }
            this._encoding = this.getRequest().getCharacterEncoding();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encoding from request: " + this._encoding));
            }
            if (this._encoding == null) {
                this._encoding = this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().getLocaleEncoding(this._locale);
                if (this._encoding == null) {
                    this._encoding = SRTRequestUtils.getEncodingFromLocale(this._locale);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Encoding from locale: " + this._encoding));
                    }
                    if (this._encoding == null) {
                        this._encoding = _defaultEncoding;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("_encoding is null: default to " + this._encoding));
                        }
                    }
                }
            }
            this.setContentType("text/html; charset=" + this._encoding);
        } else {
            this._locale = _defaultLocale;
            this._encoding = _defaultEncoding;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_locale: " + this._locale.toString()));
            Tr.debug((TraceComponent)tc, (String)("_encoding: " + this._encoding));
        }
    }

    public void reset() {
        this._response.setReason(REASON_OK);
        this._response.setStatusCode(200);
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._response.clearHeaders();
        this.resetState();
        this.setDefaultResponseEncoding();
    }

    public String getCharacterEncoding() {
        if (this._encoding == null) {
            this.setDefaultResponseEncoding();
        }
        return this._encoding;
    }

    public String getContentType() {
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            return this.getHeader(HEADER_CONTENT_TYPE_BYTES);
        }
        return null;
    }

    public void setCharacterEncoding(String string) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setCharacterEncoding");
            }
            return;
        }
        if (this._gotWriter || this._headersWritten) {
            return;
        }
        if (string != null) {
            if (string != null) {
                if (string.startsWith("\"") || string.startsWith("'")) {
                    string = string.substring(1);
                }
                if (string.endsWith("\"") || string.endsWith("'")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            this._encoding = string;
            this.isCharEncodingExplicit = true;
        }
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            String string2 = this.getHeader(HEADER_CONTENT_TYPE_BYTES);
            int n = string2.indexOf("charset=");
            string2 = n != -1 ? string2.substring(0, n) + "charset=" + this._encoding : string2 + "; charset=" + this._encoding;
            this._response.setContentType(string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set response character encoding: " + this.getCharacterEncoding()));
        }
    }

    public Cookie[] getCookies() {
        return this._response.getCookies();
    }

    public void sendError(int n) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendError --> ", (Object)String.valueOf(n));
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        this.sendError(n, MessageFormat.format(nls.getString("Error.reported.{0}", "Error reported: {0}"), objectArray));
    }

    public void sendError(int n, String string) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendError", (Object)(n + " " + string));
        }
        this.getRequest().getWebAppDispatcherContext().sendError(n, string);
        this.closeResponseOutput();
    }

    public void setReason(String string) {
        this._response.setReason(string);
    }

    public void sendRedirect(String string) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendRedirect --> ", (Object)string);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"sendRedirect");
            }
        } else {
            this.getRequest().getWebAppDispatcherContext().sendRedirect(string);
        }
        this.closeResponseOutput();
    }

    public void sendRedirect303(String string) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendRedirect303 --> ", (Object)string);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"sendRedirect303");
            }
        } else {
            this.getRequest().getWebAppDispatcherContext().sendRedirect303(string);
        }
        this.closeResponseOutput();
    }

    public void setContentLength(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setContentLength --> ", (Object)String.valueOf(n));
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setContentLength");
            }
        } else {
            this._contentLength = n;
            this._bufferedOut.setLimit(this._contentLength);
            this._bufferedWriter.setLimit(this._contentLength);
            this.setIntHeader(HEADER_CONTENT_LENGTH, n);
        }
    }

    public void setContentType(String string) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setContentType");
            }
        } else {
            String string2 = string.toLowerCase();
            int n = string2.indexOf("charset=");
            if (n != -1) {
                if (!this._gotWriter && !this.isCommitted()) {
                    this.isCharEncodingExplicit = true;
                    this._encoding = string.substring(n + 8);
                    string = string.substring(0, n) + "charset=" + this._encoding;
                } else if ((string = string.substring(0, n).trim()).endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            this._response.setContentType(string);
        }
    }

    public void setDateHeader(String string) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setDateHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this.setHeader(string, new HttpDate(System.currentTimeMillis()).toString());
        }
    }

    public void setDateHeader(String string, long l) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setDateHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.setDateHeader(string, l);
        }
    }

    public void setHeader(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader name --> " + string + " value --> " + string2));
        }
        this.setHeader(string, string2, true);
    }

    public void setHeader(String string, String string2, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader name --> " + string + " value --> " + string2 + " checkInclude --> " + bl));
        }
        if (bl && this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setHeader");
            }
        } else {
            if (string == null) {
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string2 == null) {
                this.removeHeader(string);
            } else {
                if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    String string3 = string2.toLowerCase();
                    int n = string3.indexOf("charset=");
                    if (n != -1) {
                        this._encoding = string2.substring(n + 8);
                        string2 = string2.substring(0, n) + "charset=" + this._encoding;
                    } else if (this.getRequest().getWebAppDispatcherContext().isAutoRequestEncoding()) {
                        string2 = string2.endsWith(";") ? string2 + "charset=" + this.getCharacterEncoding() : string2 + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._response.setHeader(string, string2);
            }
        }
    }

    public void setInternalHeader(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInternalHeader name --> " + string + " value --> " + string2));
        }
        this.setHeader(string, string2, false);
    }

    protected void setHeader(byte[] byArray, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader name --> " + byArray + " value --> " + string));
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setHeader");
            }
        } else {
            if (byArray == null) {
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string == null) {
                this.removeHeader(byArray);
            } else {
                if (Arrays.equals(byArray, HEADER_CONTENT_TYPE_BYTES)) {
                    String string2 = string.toLowerCase();
                    int n = string2.indexOf("charset=");
                    if (n != -1) {
                        this._encoding = string.substring(n + 8);
                        string = string.substring(0, n) + "charset=" + this._encoding;
                    } else if (this.getRequest().getWebAppDispatcherContext().isAutoRequestEncoding()) {
                        string = string2.endsWith(";") ? string + "charset=" + this.getCharacterEncoding() : string + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._response.setHeader(byArray, string.getBytes());
            }
        }
    }

    public void setIntHeader(String string, int n) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setIntHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.setIntHeader(string, n);
        }
    }

    public void setStatus(int n) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setStatus");
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(n);
            this._statusCode = n;
        }
    }

    public void setStatus(int n, String string) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setStatus");
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(n);
            this._response.setReason(string);
            this._statusCode = n;
        }
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setLocale(Locale locale) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setLocale");
            }
            return;
        }
        this._locale = locale;
        if (this.isCharEncodingSet() || this._gotWriter || this._headersWritten) {
            return;
        }
        this.isCharEncodingExplicit = false;
        this._encoding = this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().getLocaleEncoding(this._locale);
        if (this._encoding == null) {
            this._encoding = SRTRequestUtils.getEncodingFromLocale(this._locale);
            if (this._encoding == null) {
                this._encoding = _defaultEncoding;
            }
        }
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            String string = this.getHeader(HEADER_CONTENT_TYPE_BYTES);
            int n = string.indexOf("charset=");
            string = n != -1 ? string.substring(0, n) + "charset=" + this._encoding : string + "; charset=" + this._encoding;
            this._response.setContentType(string);
        }
    }

    private boolean isCharEncodingSet() {
        String string;
        int n;
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES) && (n = (string = this.getHeader(HEADER_CONTENT_TYPE_BYTES)).indexOf("charset=")) != -1) {
            return this.isCharEncodingExplicit;
        }
        return false;
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this.setDefaultResponseEncoding();
        }
        return this._locale;
    }

    public void addDateHeader(String string, long l) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addDateHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                throw new IllegalArgumentException("Cannot Set Content-Type to a Date value");
            }
            this.setHeader(string, new HttpDate(l).toString());
        }
    }

    public void addHeader(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addHeader --> " + string + " with value --> " + string2));
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                this._response.setContentType(string2);
            } else {
                this.addField(string, string2);
            }
        }
    }

    public void addHeader(byte[] byArray, byte[] byArray2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addHeader(byte) --> " + new String(byArray) + " with value --> " + new String(byArray2)));
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addHeader(byte)");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.addHeader(byArray, byArray2);
        }
    }

    public void addIntHeader(String string, int n) {
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addIntHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                throw new IllegalArgumentException("Cannot Set Content-Type to an Int value");
            }
            this.addIntField(string, n);
        }
    }

    public void addSessionCookie(Cookie cookie) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addSessionCookie --> " + cookie.getName()));
        }
        if (this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set session cookie. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
    }

    public void initForNextResponse(IResponse iResponse) {
        if (iResponse == null) {
            this._rawOut.init(null);
            return;
        }
        iResponse.setStatusCode(200);
        iResponse.setReason(REASON_OK);
        this._statusCode = 200;
        this._response = iResponse;
        try {
            this._rawOut.init(this._response.getOutputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._bufferedOut.reset();
        this._bufferedWriter.reset();
        this._responseBuffer = null;
        this.resetState();
    }

    public Vector[] getHeaderTable() {
        return this._response.getHeaderTable();
    }
}

