/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.servlet.util.EmptyEnumeration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.srt.IExtendedRequest;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import com.ibm.ws.webcontainer.srt.http.HttpInputStream;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SRTServletRequest
implements Request,
HttpServletRequest,
IExtendedRequest,
IServletRequest,
IPrivateRequestAttributes {
    protected static TraceComponent tc = Tr.register((Class)SRTServletRequest.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private Stack paramStack = new Stack();
    private SRTRequestContext _requestContext = null;
    protected WebAppDispatcherContext _dispatchContext = null;
    private SRTServletRequestHelper _srtRequestHelper;
    private SRTConnectionContext _connContext;
    private static String CLIENT_ENCODING_OVERRIDE = System.getProperty("client.encoding.override");
    private static String DEFAULT_CLIENT_ENCODING = System.getProperty("default.client.encoding");
    private static final String JAVAX_NET_SSL_PEER_CERTS = "javax.net.ssl.peer_certificates";
    private static final String JAVAX_NET_SSL_CIPHER_SUITE = "javax.net.ssl.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "javax.servlet.request.X509Certificate";
    protected IRequest _request = null;
    protected HttpInputStream _in = new HttpInputStream();
    private boolean _runningCollaborators = false;
    private Thread originalThreadID;
    private String originalThreadName;

    public SRTServletRequest(SRTConnectionContext sRTConnectionContext) {
        this._connContext = sRTConnectionContext;
        this._requestContext = new SRTRequestContext(this);
        this.originalThreadID = Thread.currentThread();
        this.originalThreadName = "ID: [" + this.originalThreadID + "] SRTServletRequest [" + this + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SRTServletRequest thread [" + this.originalThreadName + "]"));
        }
    }

    public Object getPrivateAttribute(String string) {
        if (this._srtRequestHelper._privateAttributes == null) {
            return null;
        }
        return this._srtRequestHelper._privateAttributes.get(string);
    }

    public Enumeration getPrivateAttributeNames() {
        if (this._srtRequestHelper._privateAttributes == null) {
            return EmptyEnumeration.instance();
        }
        return this._srtRequestHelper._privateAttributes.keys();
    }

    public void setPrivateAttribute(String string, Object object) {
        if (this._srtRequestHelper._privateAttributes == null) {
            this._srtRequestHelper._privateAttributes = new Hashtable();
        }
        this._srtRequestHelper._privateAttributes.put(string, object);
    }

    public void initForNextRequest(IRequest iRequest) {
        this.originalThreadID = Thread.currentThread();
        this.originalThreadName = "ID: [" + this.originalThreadID + "] SRTServletRequest [" + this + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initForNextRequest thread [" + this.originalThreadName + "]"));
        }
        try {
            if (iRequest == null) {
                this._in.init(null);
                return;
            }
            this._request = iRequest;
            this._srtRequestHelper = new SRTServletRequestHelper();
            this._in.init(this._request.getInputStream());
            if (this.getContentLength() > 0) {
                this._in.setContentLength(this.getContentLength());
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.initForNextRequest", (String)"828", (Object)this);
        }
    }

    public Object getAttribute(String string) {
        Object object = this._srtRequestHelper._attributes.get(string);
        if (object == null) {
            if (string.equals(JAVAX_NET_SSL_PEER_CERTS) || string.equals(JAVAX_SERVLET_REQUEST_X509CERTIFICATE)) {
                object = this.getPeerCertificates();
            } else if (string.equals(JAVAX_NET_SSL_CIPHER_SUITE)) {
                object = this.getCipherSuite();
            }
        }
        return object;
    }

    public Enumeration getAttributeNames() {
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._attributes.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        boolean bl = SRTRequestUtils.isCharsetSupported(string);
        if (!bl) {
            String string2 = nls.getFormattedMessage("unsupported.request.encoding.[{0}]", new Object[]{string}, "Unsupported encoding specified [" + string + "]");
            throw new UnsupportedEncodingException(string2);
        }
        this._srtRequestHelper._characterEncoding = string;
    }

    public long getDateHeader(String string) {
        return this._request.getDateHeader(string);
    }

    public String getHeader(String string) {
        return this._request.getHeader(string);
    }

    public String getHeaderDirect(String string) {
        return this._request.getHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this._request.getHeaderNames();
    }

    public int getIntHeader(String string) {
        return this._request.getIntHeader(string);
    }

    public Enumeration getHeaders(String string) {
        return this._request.getHeaders(string);
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public int getContentLength() {
        return this._request.getContentLength();
    }

    public String getContentType() {
        return this._request.getContentType();
    }

    public String getProtocol() {
        return this._request.getProtocol();
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    public void setAttribute(String string, Object object) {
        Object object2 = this._srtRequestHelper._attributes.put(string, object);
        if (object2 != null) {
            this.attributeReplaced(string, object2);
        } else {
            this.attributeAdded(string, object);
        }
    }

    public void removeAttribute(String string) {
        Object v = this._srtRequestHelper._attributes.remove(string);
        if (v != null) {
            this.attributeRemoved(string, v);
        }
    }

    public Locale getLocale() {
        this.processLocales();
        return this._srtRequestHelper._locales.size() > 0 ? this._srtRequestHelper._locales.get(0) : null;
    }

    public Enumeration getLocales() {
        this.processLocales();
        return new Enumeration(){
            Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._locales.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public boolean isSecure() {
        return this._request.isSSL();
    }

    public String getCipherSuite() {
        return this._request.getCipherSuite();
    }

    public X509Certificate[] getPeerCertificates() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerCertificates");
        }
        X509Certificate[] x509CertificateArray = this._request.getPeerCertificates();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerCertificates", (Object)x509CertificateArray);
        }
        return x509CertificateArray;
    }

    public void setRequest(IRequest iRequest) {
        this._request = iRequest;
    }

    public void attributeAdded(String string, Object object) {
        WebApp webApp = this._dispatchContext.getWebApp();
        if (webApp != null) {
            webApp.notifyServletRequestAttrAdded(this, string, object);
        }
    }

    public void attributeRemoved(String string, Object object) {
        WebApp webApp = this._dispatchContext.getWebApp();
        if (webApp != null) {
            webApp.notifyServletRequestAttrRemoved(this, string, object);
        }
    }

    public void attributeReplaced(String string, Object object) {
        WebApp webApp = this._dispatchContext.getWebApp();
        if (webApp != null) {
            webApp.notifyServletRequestAttrReplaced(this, string, object);
        }
    }

    protected void setLocales(Iterator iterator) {
        while (iterator.hasNext()) {
            this._srtRequestHelper._locales.add(iterator.next());
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._srtRequestHelper._gotReader) {
            throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._srtRequestHelper._gotInputStream = true;
        return this._in;
    }

    public synchronized BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this._srtRequestHelper._gotInputStream) {
            throw new IllegalStateException(nls.getString("InputStream.already.obtained", "Input Stream already obtained"));
        }
        if (this._srtRequestHelper._reader == null) {
            this._srtRequestHelper._gotReader = true;
            this._srtRequestHelper._reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this._in), this.getReaderEncoding()));
        }
        return this._srtRequestHelper._reader;
    }

    protected void releaseInputStream() {
        if (this._srtRequestHelper._gotInputStream) {
            this._srtRequestHelper._gotInputStream = false;
        }
    }

    protected void releaseReader() {
        if (this._srtRequestHelper._gotReader) {
            this._srtRequestHelper._gotReader = false;
        }
    }

    protected SRTConnectionContext getConnectionContext() {
        return this._connContext;
    }

    public WebAppDispatcherContext getWebAppDispatcherContext() {
        return this._dispatchContext;
    }

    public void setWebAppDispatcherContext(WebAppDispatcherContext webAppDispatcherContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setWebAppDispatcherContext old context [" + this._dispatchContext + "] new context [" + webAppDispatcherContext + "]"));
        }
        this._dispatchContext = webAppDispatcherContext;
    }

    public String getLocalAddr() {
        return this._request.getLocalAddr();
    }

    public String getLocalName() {
        return this._request.getLocalName();
    }

    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    public int getRemotePort() {
        return this._request.getRemotePort();
    }

    public Response getResponse() {
        return this._connContext.getResponse();
    }

    public void start() {
    }

    public Object clone() throws CloneNotSupportedException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SRTServletRequest::Original-->SRTServletRequest::" + this + "SRTConnectionContext" + this._connContext.hashCode()));
        }
        SRTServletRequest sRTServletRequest = (SRTServletRequest)super.clone();
        SRTRequestContext sRTRequestContext = null;
        if (this._requestContext != null) {
            sRTServletRequest._requestContext = sRTRequestContext = (SRTRequestContext)this._requestContext.clone(sRTServletRequest);
        }
        WebAppDispatcherContext webAppDispatcherContext = null;
        if (this._dispatchContext != null) {
            sRTServletRequest._dispatchContext = webAppDispatcherContext = (WebAppDispatcherContext)this._dispatchContext.clone(sRTServletRequest, sRTRequestContext);
        }
        SRTConnectionContext sRTConnectionContext = null;
        if (this._connContext != null) {
            sRTServletRequest._connContext = sRTConnectionContext = (SRTConnectionContext)this._connContext.clone(sRTServletRequest, webAppDispatcherContext);
        }
        SRTServletRequestHelper sRTServletRequestHelper = null;
        if (this._srtRequestHelper != null) {
            sRTServletRequest._srtRequestHelper = sRTServletRequestHelper = (SRTServletRequestHelper)this._srtRequestHelper.clone();
        }
        if (this.paramStack != null) {
            sRTServletRequest.paramStack = (Stack)this.paramStack.clone();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SRTServletRequest::Cloned-->SRTServletRequest::" + sRTServletRequest + "SRTConnectionContext::" + sRTConnectionContext + "::" + sRTConnectionContext.hashCode()));
        }
        return sRTServletRequest;
    }

    public String getAuthType() {
        String string = null;
        string = SecurityContext.isSecurityEnabled() ? (String)this.getPrivateAttribute("AUTH_TYPE") : this._request.getAuthType();
        if (string != null) {
            if (string.equals("BASIC")) {
                return "BASIC";
            }
            if (string.equals("CLIENT_CERT")) {
                return "CLIENT_CERT";
            }
            if (string.equals("DIGEST")) {
                return "DIGEST";
            }
            if (string.equals("FORM")) {
                return "FORM";
            }
        }
        return string;
    }

    public String getCharacterEncoding() {
        if (this._srtRequestHelper._characterEncoding != null) {
            return this._srtRequestHelper._characterEncoding;
        }
        String string = this.getContentType();
        if (string != null && string.indexOf("charset=") > -1) {
            String string2;
            block7: {
                string2 = string.substring(string.indexOf("charset=") + 8);
                if (string2 != null) {
                    if (string2.startsWith("\"") || string2.startsWith("'")) {
                        string2 = string2.substring(1);
                    }
                    if (string2.endsWith("\"") || string2.endsWith("'")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                }
                try {
                    this.setCharacterEncoding(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"Unable to set request character encoding based upon request header ", (Object)unsupportedEncodingException);
                }
            }
            return string2;
        }
        return null;
    }

    public String getReaderEncoding() {
        if (this._srtRequestHelper._readerEncoding != null) {
            return this._srtRequestHelper._readerEncoding;
        }
        String string = CLIENT_ENCODING_OVERRIDE;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: client encoding override [" + string + "]"));
        }
        if (string == null) {
            string = this.getCharacterEncoding();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: content-type header [" + string + "]"));
            }
        }
        if (string == null && this.getWebAppDispatcherContext().getWebApp().getConfiguration().isAutoRequestEncoding()) {
            String string2 = this.getHeader("Accept-Language");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: accept-language [" + string2 + "]"));
            }
            if (string2 != null && !string2.equals("*")) {
                string = SRTRequestUtils.getEncodingFromLocale(this.getLocale());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: encoding from locale [" + string + "]"));
                }
            }
        }
        if (string == null) {
            string = DEFAULT_CLIENT_ENCODING;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: default client encoding [" + string + "]"));
            }
        }
        if (string == null) {
            string = "ISO-8859-1";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: default encoding [" + string + "]"));
            }
        }
        this._srtRequestHelper._readerEncoding = SRTRequestUtils.getJvmConverter(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: encoding  converted [" + this._srtRequestHelper._readerEncoding + "]"));
        }
        return this._srtRequestHelper._readerEncoding;
    }

    public Cookie[] getCookies() {
        if (!this._srtRequestHelper._cookiesParsed) {
            SRTServletRequestHelper.access$1102(this._srtRequestHelper, this._request.getCookies());
            this._srtRequestHelper._cookiesParsed = true;
        }
        return this._srtRequestHelper._cookies;
    }

    public void setRawParameters(Hashtable hashtable) {
        this._srtRequestHelper._parameters = hashtable;
    }

    public Hashtable getRawParameters() {
        this.parseParameters();
        return (Hashtable)this._srtRequestHelper._parameters;
    }

    public String getParameter(String string) {
        this.parseParameters();
        String[] stringArray = (String[])this._srtRequestHelper._parameters.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return ((Hashtable)this._srtRequestHelper._parameters).keys();
    }

    public String[] getParameterValues(String string) {
        this.parseParameters();
        return (String[])this._srtRequestHelper._parameters.get(string);
    }

    public String getPathInfo() {
        String string = this.getWebAppDispatcherContext().getPathInfo();
        if (string == null) {
            return null;
        }
        return WebGroup.stripURL(string, false);
    }

    public String getServletPath() {
        return this.getWebAppDispatcherContext().getServletPath();
    }

    public String getPathTranslated() {
        return this.getWebAppDispatcherContext().getPathTranslated();
    }

    public String getQueryString() {
        if (this._srtRequestHelper._queryString == null && !this._srtRequestHelper._qsSetExplicit) {
            this._srtRequestHelper._queryString = this._request.getQueryString();
        }
        return this._srtRequestHelper._queryString;
    }

    public void setQueryString(String string) {
        this._srtRequestHelper._qsSetExplicit = true;
        this._srtRequestHelper._queryString = string;
    }

    public String getRealPath(String string) {
        return this.getWebAppDispatcherContext().getRealPath(string);
    }

    public String getRemoteUser() {
        if (SecurityContext.isSecurityEnabled()) {
            return SecurityContext.getName();
        }
        return this._request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.getWebAppDispatcherContext().getRequestedSessionId();
    }

    public String getRequestURI() {
        String string = this.getEncodedRequestURI();
        if (string == null) {
            return null;
        }
        return WebGroup.stripURL(string);
    }

    public String getServerName() {
        String string = this._request.getServerName();
        if (string == null || string.length() == 0) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string.charAt(0) != '[' && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        return string;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        return this._requestContext.getSession(bl, this.getWebAppDispatcherContext().getWebApp());
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getWebAppDispatcherContext().isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getWebAppDispatcherContext().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this._requestContext.isRequestedSessionIdValid(this.getWebAppDispatcherContext().getWebApp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseParameters() {
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"parseParameters");
        }
        if (this._srtRequestHelper._parameters != null) {
            return;
        }
        try {
            this._srtRequestHelper._parameters = new Hashtable();
            string = this.getContentType();
            if (string != null) {
                string = string.toLowerCase();
                Tr.debug((TraceComponent)tc, (String)("Content type:" + string));
                if (string.startsWith("java-internal")) {
                    String[] stringArray = new String[]{string};
                    this._srtRequestHelper._parameters.put(new String("Application specific data. Content-type "), stringArray);
                    return;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", (String)"667", (Object)this);
            Tr.debug((TraceComponent)tc, (String)("Exception thrown during parsing of parameters: " + exception.toString()));
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Content type is not java-internal");
        }
        if ((string = this.getMethod().toLowerCase()).equals("post")) {
            String string2 = this.getContentType();
            if (string2 != null && string2.startsWith("application/x-www-form-urlencoded")) {
                try {
                    this._srtRequestHelper._parameters = RequestUtils.parsePostData(this.getContentLength(), this.getInputStream(), this.getReaderEncoding());
                    if (this._srtRequestHelper._parameters == null) {
                        this._srtRequestHelper._readInputStreamInFinishMethod = false;
                    } else {
                        this._srtRequestHelper._readInputStreamInFinishMethod = true;
                    }
                }
                catch (IOException iOException) {
                    this._srtRequestHelper._readInputStreamInFinishMethod = false;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", (String)"765", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"Error.Parsing.Parameters", (Object)iOException);
                }
                finally {
                    this.releaseInputStream();
                }
                if (this._srtRequestHelper._parameters != null) {
                    this.parseQueryStringList();
                }
            }
            if (string2 != null && string2.startsWith("multipart/form-data") && this._srtRequestHelper._parameters != null) {
                this.parseQueryStringList();
            }
            if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                this.parseQueryStringList();
            }
        } else {
            this.parseQueryStringList();
        }
        if (this._srtRequestHelper._parameters == null) {
            this._srtRequestHelper._parameters = new Hashtable();
        }
    }

    private void parseQueryStringList() {
        Hashtable hashtable = null;
        if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
            String string = this.getQueryString();
            if (string != null && string.indexOf("=") != -1) {
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    this._srtRequestHelper._parameters = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                } else {
                    hashtable = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                    this.mergeQueryParams(hashtable);
                }
            }
        } else {
            Iterator iterator = this._srtRequestHelper._queryStringList.iterator();
            QSListItem qSListItem = null;
            while (iterator.hasNext()) {
                qSListItem = (QSListItem)iterator.next();
                String string = qSListItem._qs;
                if (qSListItem._qsHashtable != null) {
                    this.mergeQueryParams(qSListItem._qsHashtable);
                    continue;
                }
                if (string == null || string.indexOf(61) == -1) continue;
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    qSListItem._qsHashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
                    this._srtRequestHelper._parameters = qSListItem._qsHashtable;
                    qSListItem._qs = null;
                    continue;
                }
                qSListItem._qsHashtable = hashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
                qSListItem._qs = null;
                this.mergeQueryParams(hashtable);
            }
        }
    }

    private void mergeQueryParams(Hashtable hashtable) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mergeQueryParams");
        }
        if (hashtable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams.size() " + hashtable.size()));
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams " + hashtable));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (this._srtRequestHelper._parameters.containsKey(k)) {
                    int n;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("_paramaters contains key " + k));
                    }
                    String[] stringArray = (String[])this._srtRequestHelper._parameters.get(k);
                    String[] stringArray2 = (String[])hashtable.get(k);
                    String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                    int n2 = 0;
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray3[n2++] = stringArray2[n];
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray3[n2++] = stringArray[n];
                    }
                    this._srtRequestHelper._parameters.put(k, stringArray3);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters."));
                    continue;
                }
                this._srtRequestHelper._parameters.put(k, hashtable.get(k));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters. "));
            }
        }
    }

    private void removeQueryParams(Hashtable hashtable) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mergeQueryParams");
        }
        if (hashtable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams.size() " + hashtable.size()));
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams " + hashtable));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String[] stringArray;
                String[] stringArray2;
                Object k = enumeration.nextElement();
                if (!this._srtRequestHelper._parameters.containsKey(k)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_paramaters contains key " + k));
                }
                if ((stringArray2 = (String[])this._srtRequestHelper._parameters.get(k)).length - (stringArray = (String[])hashtable.get(k)).length > 0) {
                    String[] stringArray3 = new String[stringArray2.length - stringArray.length];
                    int n = 0;
                    for (int i = stringArray.length; i < stringArray2.length; ++i) {
                        stringArray3[n++] = stringArray2[i];
                    }
                    this._srtRequestHelper._parameters.put(k, stringArray3);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters."));
                    continue;
                }
                this._srtRequestHelper._parameters.remove(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finish");
        }
        try {
            try {
                int n = this.getContentLength();
                if (n > 0) {
                    this._in.close();
                }
                this._in.finish();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.finish", (String)"875", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error occurred while finishing request", (Object)iOException);
                }
                Object var3_4 = null;
                this._srtRequestHelper = null;
                this._request.clearHeaders();
                this._requestContext.finish();
                return;
            }
            Object var3_3 = null;
            this._srtRequestHelper = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this._srtRequestHelper = null;
            this._request.clearHeaders();
            this._requestContext.finish();
            throw throwable;
        }
        this._request.clearHeaders();
        this._requestContext.finish();
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        this._requestContext.destroy();
        this._requestContext = null;
        this._connContext = null;
        this._dispatchContext = null;
        this._srtRequestHelper = null;
        this.paramStack = null;
        this._in = null;
        if (this._request instanceof IPoolable) {
            ((IPoolable)this._request).destroy();
        }
        this._request = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    protected void processLocales() {
        if (this._srtRequestHelper._localesProcessed) {
            return;
        }
        if (this._srtRequestHelper._locales == null) {
            this._srtRequestHelper._locales = new LinkedList();
        }
        this.setLocales(SRTRequestUtils.getLocales(this).iterator());
        this._srtRequestHelper._localesProcessed = true;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this.getWebAppDispatcherContext().getRequestDispatcher(string);
    }

    public String getContextPath() {
        return this.getWebAppDispatcherContext().getContextPath();
    }

    public boolean isUserInRole(String string) {
        return this.getWebAppDispatcherContext().isUserInRole(string, this);
    }

    public Principal getUserPrincipal() {
        return this.getWebAppDispatcherContext().getUserPrincipal();
    }

    public void pushParameterStack() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"storeParameterStack");
        }
        if (this._srtRequestHelper._parameters == null) {
            this.paramStack.push(null);
        } else {
            this.paramStack.push(((Hashtable)this._srtRequestHelper._parameters).clone());
        }
        if (tc.isDebugEnabled() && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    public void popParameterStack() {
        block4: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"popParameterStack");
            }
            try {
                this._srtRequestHelper._parameters = (Hashtable)this.paramStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unable to remove item from stack", (Object)emptyStackException);
            }
        }
        if (tc.isDebugEnabled() && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    private void debugParams(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"debugParam");
        }
        if (map != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Only displaying value retrieved by request.getParameter(). More parameters may exist for parameter name");
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.isSecure() || string.toUpperCase().indexOf("PASSWORD") > -1) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("param: paramName = [" + string + "] paramValue [**********]"));
                    continue;
                }
                String string2 = this.getParameter(string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("param: paramName = [" + string + "] paramValue [" + string2 + "]"));
            }
        }
    }

    public void removeQSFromList() {
        if (this._srtRequestHelper._queryStringList != null && !this._srtRequestHelper._queryStringList.isEmpty()) {
            Map map = this._srtRequestHelper._parameters;
            this.popParameterStack();
            if (this._srtRequestHelper._parameters == null && map != null) {
                this._srtRequestHelper._parameters = map;
                Hashtable hashtable = ((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qsHashtable;
                if (hashtable == null) {
                    hashtable = RequestUtils.parseQueryString(((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qs, this.getReaderEncoding());
                }
                this.removeQueryParams(hashtable);
            }
            this._srtRequestHelper._queryStringList.removeLast();
        } else {
            this.popParameterStack();
        }
    }

    public void aggregateQueryStringParams(String string, boolean bl) {
        QSListItem qSListItem = null;
        if (this._srtRequestHelper._parameters == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The paramater stack is currently null");
            }
            if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The queryStringList is empty");
                }
                if (this._srtRequestHelper._queryStringList == null) {
                    this._srtRequestHelper._queryStringList = new LinkedList();
                }
                if (this.getQueryString() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getQueryString will be added first in the QSList wih value->" + this.getQueryString()));
                    }
                    qSListItem = new QSListItem(this.getQueryString(), null);
                    this._srtRequestHelper._queryStringList.add(qSListItem);
                }
            }
            if (string != null) {
                qSListItem = new QSListItem(string, null);
                this._srtRequestHelper._queryStringList.add(qSListItem);
            }
        }
        if (bl) {
            this.setQueryString(string);
        }
        if (this._srtRequestHelper._parameters != null && string != null) {
            Hashtable hashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string2);
                if (this._srtRequestHelper._parameters.containsKey(string2)) {
                    int n;
                    String[] stringArray2 = (String[])this._srtRequestHelper._parameters.get(string2);
                    Vector<String> vector = new Vector<String>();
                    for (n = 0; n < stringArray.length; ++n) {
                        vector.add(stringArray[n]);
                    }
                    for (n = 0; n < stringArray2.length; ++n) {
                        vector.add(stringArray2[n]);
                    }
                    String[] stringArray3 = new String[vector.size()];
                    vector.toArray(stringArray3);
                    this._srtRequestHelper._parameters.put(string2, stringArray3);
                    continue;
                }
                this._srtRequestHelper._parameters.put(string2, stringArray);
            }
        }
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this._srtRequestHelper._parameters;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getScheme();
        int n = this.getServerPort();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(this.getServerPort());
        }
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    public byte[] getSSLId() {
        return this._request.getSSLSessionID();
    }

    public byte[] getCookieValueAsBytes(String string) {
        return this._request.getCookieValue(string);
    }

    public String getUpdatedSessionId() {
        return this._srtRequestHelper._updatedSessionId;
    }

    public void setSessionId(String string) {
        this._srtRequestHelper._updatedSessionId = string;
    }

    public String getEncodedRequestURI() {
        if (this._dispatchContext == null) {
            return this._request.getRequestURI();
        }
        return this._dispatchContext.getRequestURI();
    }

    public SRTRequestContext getRequestContext() {
        return this._requestContext;
    }

    public boolean getRunningCollaborators() {
        return this._runningCollaborators;
    }

    public void setRunningCollaborators(boolean bl) {
        this._runningCollaborators = bl;
    }

    class QSListItem {
        String _qs = null;
        Hashtable _qsHashtable = null;

        QSListItem(String string, Hashtable hashtable) {
            this._qs = string;
            this._qsHashtable = hashtable;
        }
    }

    private class SRTServletRequestHelper
    implements Cloneable {
        private Hashtable _privateAttributes = null;
        private LinkedList _queryStringList = null;
        private Map _attributes = new HashMap();
        private Map _parameters = null;
        private Stack _attrStack = null;
        private String _queryString = null;
        private boolean _cookiesParsed = false;
        private boolean _readInputStreamInFinishMethod = true;
        private String _updatedSessionId;
        private Cookie[] _cookies;
        private boolean _localesProcessed = false;
        private String _readerEncoding = null;
        private String _characterEncoding = null;
        private boolean _qsSetExplicit = false;
        private boolean _gotReader = false;
        private boolean _gotInputStream = false;
        private BufferedReader _reader = null;
        private LinkedList _locales = null;

        private SRTServletRequestHelper() {
        }

        public Object clone() throws CloneNotSupportedException {
            SRTServletRequestHelper sRTServletRequestHelper = null;
            sRTServletRequestHelper = (SRTServletRequestHelper)super.clone();
            if (this._privateAttributes != null) {
                sRTServletRequestHelper._privateAttributes = (Hashtable)this._privateAttributes.clone();
            }
            if (this._queryStringList != null) {
                sRTServletRequestHelper._queryStringList = (LinkedList)this._queryStringList.clone();
            }
            if (this._parameters != null) {
                sRTServletRequestHelper._parameters = (Hashtable)((Hashtable)this._parameters).clone();
            }
            if (this._attributes != null) {
                sRTServletRequestHelper._attributes = (HashMap)((HashMap)this._attributes).clone();
            }
            if (this._attrStack != null) {
                sRTServletRequestHelper._attrStack = (Stack)this._attrStack.clone();
            }
            return sRTServletRequestHelper;
        }

        static /* synthetic */ Cookie[] access$1102(SRTServletRequestHelper sRTServletRequestHelper, Cookie[] cookieArray) {
            sRTServletRequestHelper._cookies = cookieArray;
            return cookieArray;
        }
    }
}

