/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.facade.IFacade;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SRTRequestContext
implements Cloneable {
    protected static TraceComponent tc = Tr.register((Class)SRTRequestContext.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    Hashtable webappToSessionMap;
    SRTServletRequest request;
    Stack boundaries = new Stack();

    public SRTRequestContext(SRTServletRequest sRTServletRequest) {
        this.request = sRTServletRequest;
        this.webappToSessionMap = new Hashtable();
    }

    public void sessionPreInvoke(WebApp webApp) {
        HttpSession httpSession = (HttpSession)this.webappToSessionMap.get(webApp);
        if (httpSession == null && (httpSession = webApp.getSessionContext().sessionPreInvoke(this.request, (HttpServletResponse)this.request.getResponse())) != null) {
            this.webappToSessionMap.put(webApp, httpSession);
        }
    }

    public boolean isRequestedSessionIdValid(WebApp webApp) {
        HttpSession httpSession = this.getSession(false, webApp);
        return webApp.getSessionContext().isRequestedSessionIdValid(this.request, httpSession);
    }

    public void sessionPostInvoke() {
    }

    public HttpSession getSession(boolean bl, WebApp webApp) {
        SRTServletRequest sRTServletRequest = this.request;
        HttpSession httpSession = (HttpSession)this.webappToSessionMap.get(webApp);
        if (httpSession != null && webApp.getSessionContext().isValid(httpSession, sRTServletRequest)) {
            return (HttpSession)((IFacade)httpSession).getFacade();
        }
        httpSession = webApp.getSessionContext().getIHttpSession(sRTServletRequest, (HttpServletResponse)this.request.getResponse(), bl);
        if (httpSession == null) {
            return null;
        }
        this.webappToSessionMap.put(webApp, httpSession);
        return (HttpSession)((IFacade)httpSession).getFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            Enumeration enumeration = this.webappToSessionMap.keys();
            while (enumeration.hasMoreElements()) {
                WebApp webApp = (WebApp)enumeration.nextElement();
                HttpSession httpSession = (HttpSession)this.webappToSessionMap.get(webApp);
                webApp.getSessionContext().sessionPostInvoke(httpSession);
            }
        }
        finally {
            this.webappToSessionMap = new Hashtable();
            this.boundaries.clear();
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        this.request = null;
        this.webappToSessionMap = null;
        this.boundaries = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public String encodeURL(WebApp webApp, HttpServletRequest httpServletRequest, String string) {
        HttpSession httpSession = (HttpSession)this.webappToSessionMap.get(webApp);
        if (httpSession != null) {
            return webApp.getSessionContext().encodeURL(httpSession, httpServletRequest, string);
        }
        return string;
    }

    public void setCurrWebAppBoundary(WebApp webApp) {
        this.boundaries.push(webApp);
    }

    public void rollBackBoundary() {
        this.boundaries.pop();
    }

    public boolean isWithinModule(WebApp webApp) {
        WebApp webApp2 = (WebApp)this.boundaries.peek();
        return webApp2.equals(webApp);
    }

    public boolean isWithinApplication(WebApp webApp) {
        WebApp webApp2 = (WebApp)this.boundaries.peek();
        return webApp2.getApplicationName().equals(webApp.getApplicationName());
    }

    protected Object clone(SRTServletRequest sRTServletRequest) throws CloneNotSupportedException {
        SRTRequestContext sRTRequestContext = (SRTRequestContext)super.clone();
        if (this.boundaries != null) {
            sRTRequestContext.boundaries = (Stack)this.boundaries.clone();
        }
        if (this.webappToSessionMap != null) {
            sRTRequestContext.webappToSessionMap = (Hashtable)this.webappToSessionMap.clone();
        }
        sRTRequestContext.request = sRTServletRequest;
        return sRTRequestContext;
    }
}

