/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.srt.IOutputStreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class SRTOutputStream
extends ServletOutputStream {
    private OutputStream _conn;
    private IOutputStreamObserver _observer;
    private static TraceComponent tc = Tr.register((Class)SRTOutputStream.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public void init(OutputStream outputStream) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializing");
        }
        this._conn = outputStream;
    }

    public void flush() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Flushing");
        }
        this._conn.flush();
    }

    public void reset() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reseting");
        }
        this._conn = null;
    }

    public void close() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Closing");
        }
        if (this._observer != null) {
            this._observer.alertClose();
        }
        super.close();
    }

    protected void setObserver(IOutputStreamObserver iOutputStreamObserver) {
        this._observer = iOutputStreamObserver;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing");
        }
        if (this._observer != null) {
            this._observer.alertFirstWrite();
        }
        this._conn.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }
}

