/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ExtendedDocumentRootUtils;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 3905806383319298103L;
    public static final String PARAM_DEFAULT_PAGE = "default.page";
    public static final String PARAM_BUFFER_SIZE = "bufferSize";
    public static final String WEB_INF_DIR = "WEB-INF";
    public static final String META_INF_DIR = "META-INF";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private int defaultBufferSize = 4096;
    private String esiControl = null;
    String extendedDocumentRoot = null;
    private boolean redirectToWelcomeFile = false;

    public void init() throws ServletException {
        String string = this.getInitParameter(PARAM_BUFFER_SIZE);
        if (string != null) {
            try {
                int n;
                this.defaultBufferSize = n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.init", (String)"65", (Object)((Object)this));
            }
        }
        this.extendedDocumentRoot = this.getInitParameter("extendedDocumentRoot");
        String string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.timeOut", "300");
            }
        });
        if (!string2.equals("0")) {
            this.esiControl = "max-age=" + string2 + "," + "cacheid=\"URL\"," + "content=\"ESI/1.0+\"";
        }
        this.esiControl = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.control", SimpleFileServlet.this.esiControl);
            }
        });
        String string3 = this.getInitParameter("redirectToWelcomeFile");
        if (string3 != null) {
            this.redirectToWelcomeFile = string3.equalsIgnoreCase("true");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            File file;
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            boolean bl = false;
            ServletContext servletContext = this.getServletContext();
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = null;
            String string5 = null;
            if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                bl = true;
                string4 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
                string5 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            } else {
                string4 = httpServletRequest.getServletPath();
                string5 = httpServletRequest.getPathInfo();
            }
            stringBuffer.append(string4);
            if (string5 != null) {
                int n = string5.indexOf(59);
                if (n != -1) {
                    string5 = string5.substring(0, n);
                }
                stringBuffer.append(string5);
                if (string5.indexOf(WEB_INF_DIR) != -1 || string5.indexOf(META_INF_DIR) != -1) {
                    httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), stringBuffer.toString()));
                    return;
                }
            }
            if (stringBuffer.toString().indexOf(WebApp.DIR_BROWSING_MAPPING) != -1) {
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
            string3 = servletContext.getRealPath(stringBuffer.toString());
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            if (!this.isValidFilePath(string3)) {
                httpServletResponse.sendError(403, nls.getString("File.name.contains.illegal.character", "File path contains illegal character."));
                return;
            }
            File file2 = new File(string3);
            List list = (List)servletContext.getAttribute(WebApp.WELCOME_FILE_LIST);
            if (!file2.exists()) {
                string2 = new ExtendedDocumentRootUtils(this.getServletContext(), this.extendedDocumentRoot);
                if (!string2.searchPathExists()) {
                    int n = 0;
                    object3 = httpServletRequest.getAttribute("WelcomeFileListEntry");
                    if (object3 != null) {
                        n = Integer.parseInt((String)object3);
                        int n2 = stringBuffer.lastIndexOf((String)list.get(n));
                        if (n2 != -1) {
                            stringBuffer.delete(n2, stringBuffer.length());
                        }
                        ++n;
                    }
                    if (n != list.size()) {
                        object2 = (String)list.get(n);
                        if (((String)object2).charAt(0) == '/') {
                            object2 = ((String)object2).substring(1);
                        }
                        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                            stringBuffer.append('/');
                        }
                        string = stringBuffer.toString() + (String)object2;
                        httpServletRequest.setAttribute("WelcomeFileListEntry", (Object)("" + n));
                        object = servletContext.getRequestDispatcher(string);
                        if (object != null) {
                            object.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            return;
                        }
                    } else {
                        string3 = servletContext.getRealPath(stringBuffer.toString());
                        if (!string3.endsWith(File.separator)) {
                            string3 = string3 + File.separator;
                        }
                        if ((object2 = servletContext.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
                            httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)string3);
                            httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)stringBuffer.toString());
                            object2.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            return;
                        }
                    }
                } else {
                    string2.handleExtendedDocumentRoots(stringBuffer.toString());
                    boolean bl2 = true;
                    if (!bl) {
                        bl2 = this.setResponseHeaders(httpServletRequest, httpServletResponse, string2.getMatchedFile(), string2.useContentLength());
                    }
                    if (bl2) {
                        this.writeResponseToClient(httpServletResponse, string2.getInputStream());
                    }
                    return;
                }
            }
            if (file2.isDirectory()) {
                RequestDispatcher requestDispatcher;
                string2 = this.getURLWithRequestURIEncoded(httpServletRequest).toString();
                if (!string2.endsWith("/") && !bl) {
                    String string6 = string2 + "/";
                    object3 = httpServletRequest.getQueryString();
                    if (object3 != null) {
                        string6 = string6 + "?" + (String)object3;
                    }
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string6));
                    return;
                }
                if (list != null && list.size() != 0) {
                    Iterator iterator = list.iterator();
                    object3 = null;
                    object2 = null;
                    while (iterator.hasNext()) {
                        String string7;
                        object3 = (String)iterator.next();
                        if (((String)object3).charAt(0) == '/') {
                            object3 = ((String)object3).substring(1);
                        }
                        if (((File)(object2 = new File(string3 + (String)object3))).exists()) {
                            if (this.redirectToWelcomeFile) {
                                string = "";
                                if (httpServletRequest.getQueryString() != null) {
                                    string = "?" + httpServletRequest.getQueryString();
                                }
                                if ((object = this.removeLeadingSlashes(stringBuffer.toString())) == null) {
                                    object = "";
                                }
                                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL((String)object + (String)object3 + string));
                            } else {
                                servletContext.getRequestDispatcher(stringBuffer.toString() + (String)object3).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            }
                            return;
                        }
                        int n = 0;
                        object = httpServletRequest.getAttribute("WelcomeFileListEntry");
                        if (object != null) {
                            n = Integer.parseInt((String)object);
                            int n3 = stringBuffer.indexOf((String)list.get(n));
                            if (n3 != -1) {
                                stringBuffer.delete(n3, stringBuffer.length());
                            }
                            ++n;
                        }
                        if (n == list.size()) {
                            throw new FileNotFoundException(file2.getAbsolutePath());
                        }
                        if (((String)object3).charAt(0) == '/') {
                            object3 = ((String)object3).substring(1);
                        }
                        httpServletRequest.setAttribute("WelcomeFileListEntry", (Object)("" + n));
                        if (this.redirectToWelcomeFile) {
                            String string8;
                            string7 = "";
                            if (httpServletRequest.getQueryString() != null) {
                                string7 = "?" + httpServletRequest.getQueryString();
                            }
                            if ((string8 = this.removeLeadingSlashes(stringBuffer.toString())) == null) {
                                string8 = "";
                            }
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string8 + (String)object3 + string7));
                            continue;
                        }
                        string7 = servletContext.getRequestDispatcher(stringBuffer.toString() + (String)object3);
                        if (string7 != null) {
                            string7.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        }
                        if (!httpServletResponse.isCommitted()) continue;
                        return;
                    }
                }
                if ((requestDispatcher = servletContext.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)string3);
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)httpServletRequest.getRequestURI());
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
            string2 = stringBuffer.toString();
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
                String string9 = string2.substring(string2.lastIndexOf(46) + 1);
                if ((string9 = string9.substring(0, string9.indexOf(47)).toLowerCase()).equals("jsp") || string9.equals("jsv") || string9.equals("jsw")) {
                    httpServletResponse.sendError(403, nls.getString("Serving.JSP.Not.Allowed", "Serving contents of JSP files is not allowed."));
                    return;
                }
            }
            if (string2.lastIndexOf("..") != -1 && !string2.startsWith("/...") || string2.endsWith("\\") || httpServletRequest.getRequestURI().endsWith(".")) {
                httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), string5));
                return;
            }
            if (FileSystem.isCaseInsensitive && !FileSystem.uriCaseCheck((File)(file = new File(string3)), (String)stringBuffer.toString())) {
                throw new FileNotFoundException(stringBuffer.toString());
            }
            boolean bl3 = true;
            if (!bl) {
                bl3 = this.setResponseHeaders(httpServletRequest, httpServletResponse, file2, true);
            }
            if (bl3) {
                object3 = new FileInputStream(file2);
                this.writeResponseToClient(httpServletResponse, (InputStream)object3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.doGet", (String)"312", (Object)((Object)this));
            httpServletResponse.sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), fileNotFoundException.getMessage()));
        }
    }

    private boolean isValidFilePath(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) >= ' ') continue;
            return false;
        }
        return true;
    }

    private boolean setResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, boolean bl) {
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getServletContext().getMimeType(string);
        if (string2 != null) {
            httpServletResponse.setContentType(string2);
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            httpServletResponse.setContentType("text/html");
        } else {
            httpServletResponse.setContentType("text/plain");
        }
        if (this.esiControl != null && httpServletRequest.getHeader("Surrogate-Capability") != null && httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null && !httpServletResponse.containsHeader("Surrogate-Control") && httpServletRequest.getAuthType() == null) {
            httpServletResponse.addHeader("Surrogate-Control", this.esiControl);
        }
        long l = -1L;
        try {
            l = httpServletRequest.getDateHeader("If-Modified-Since") / 1000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = -1L;
        }
        long l2 = file.lastModified();
        httpServletResponse.setDateHeader("last-modified", l2);
        if (l == l2 / 1000L) {
            httpServletResponse.setStatus(304);
            return false;
        }
        if (bl) {
            httpServletResponse.setContentLength(new Long(file.length()).intValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseToClient(HttpServletResponse httpServletResponse, InputStream inputStream) throws ServletException, IOException {
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[this.defaultBufferSize];
            int n = inputStream.read(byArray);
            while (n != -1) {
                servletOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            char[] cArray = new char[this.defaultBufferSize];
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, httpServletResponse.getCharacterEncoding());
            int n = inputStreamReader.read(cArray);
            try {
                while (n != -1) {
                    printWriter.write(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"298", (Object)((Object)this));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"304", (Object)((Object)this));
        }
        finally {
            inputStream.close();
        }
    }

    public String removeLeadingSlashes(String string) {
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        while (!bl && n < n2) {
            if (string.charAt(n) == '/') {
                ++n;
                continue;
            }
            bl = true;
        }
        if (bl) {
            string2 = string.substring(n);
        }
        return string2;
    }

    private StringBuffer getURLWithRequestURIEncoded(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = null;
        try {
            string2 = new String(httpServletRequest.getRequestURI().getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = httpServletRequest.getRequestURI();
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }
}

