/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.http.os390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.webcontainer.http.os390.HttpConnection;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;

public class HttpRequest
extends com.ibm.ws390.wc.http.HttpRequest {
    private static TraceComponent tc = Tr.register((String)HttpRequest.class.getName(), (String)"Servlet_Engine");
    private static final int PRIVATE_HDR_AUTH_TYPE = 0;
    private static final int PRIVATE_HDR_CLIENT_CERTIFICATE = 1;
    private static final int PRIVATE_HDR_CIPHER_SUITE = 2;
    private static final int PRIVATE_HDR_IS_SECURE = 3;
    private static final int PRIVATE_HDR_PROTOCOL = 4;
    private static final int PRIVATE_HDR_REMOTE_ADDR = 5;
    private static final int PRIVATE_HDR_REMOTE_HOST = 6;
    private static final int PRIVATE_HDR_REMOTE_USER = 7;
    private static final int PRIVATE_HDR_SCHEME = 8;
    private static final int PRIVATE_HDR_SESSION_ID = 9;
    private static final int PRIVATE_HDR_SERVER_NAME = 10;
    private static final int PRIVATE_HDR_SERVER_PORT = 11;
    private static final int PRIVATE_HDR_REMOTE_PORT = 12;
    private static final int PRIVATE_HDR_LOCAL_ADDR = 13;
    private static final int PRIVATE_HDR_LOCAL_HOST = 14;
    private static final int PRIVATE_HDR_LOCAL_PORT = 15;
    private static final int PRIVATE_HDR_COUNT = 16;
    private static final String PRIVATE_HDR_PREFIX = "$ws";
    private static final HashMap hdrName2Idx = new HashMap();
    private final String[] privateHdrs = new String[16];
    private boolean isProxied;
    private boolean isSecureSet;
    private boolean isSecure;
    private boolean isServerPortSet;
    private int serverPort;

    public HttpRequest(HttpConnection httpConnection) {
        super((com.ibm.ws390.wc.http.HttpConnection)httpConnection);
    }

    public void start() {
        this.isServerPortSet = false;
        this.isSecureSet = false;
        this.isProxied = false;
        for (int i = 0; i < 16; ++i) {
            this.privateHdrs[i] = null;
        }
        super.start();
    }

    protected void addHeader(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addHeader", (Object)new Object[]{string, string2});
        }
        if (string.startsWith(PRIVATE_HDR_PREFIX)) {
            this.isProxied = true;
            Integer n = (Integer)hdrName2Idx.get(string);
            if (n != null) {
                this.privateHdrs[n.intValue()] = string2;
            } else {
                Tr.warning((TraceComponent)tc, (String)("Unknown private header: " + string));
            }
        } else {
            super.addHeader(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addHeader");
        }
    }

    public boolean isProxied() {
        return this.isProxied;
    }

    public String getScheme() {
        if (this.isProxied) {
            if (this.privateHdrs[8] == null) {
                if (this.isProxiedSecure()) {
                    return "https";
                }
                return "http";
            }
            return this.privateHdrs[8];
        }
        return super.getScheme();
    }

    public String getProtocol() {
        if (this.isProxied) {
            return this.privateHdrs[4];
        }
        return super.getProtocol();
    }

    public String getServerName() {
        if (this.isProxied && this.privateHdrs[10] != null) {
            return this.privateHdrs[10];
        }
        return super.getServerName();
    }

    public int getServerPort() {
        if (this.isProxied) {
            return this.getProxiedServerPort();
        }
        return super.getServerPort();
    }

    public boolean isProxiedSecure() {
        if (!this.isSecureSet) {
            this.isSecure = this.privateHdrs[3] != null && this.privateHdrs[3].equalsIgnoreCase("true");
            this.isSecureSet = true;
        }
        return this.isSecure;
    }

    public String getProxiedAuthType() {
        return this.privateHdrs[0];
    }

    public X509Certificate[] getProxiedPeerCertificates() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProxiedClientCertificate");
        }
        X509Certificate[] x509CertificateArray = null;
        String string = this.privateHdrs[1];
        if (string != null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.armor(string).getBytes());
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                x509CertificateArray = this.convertCertToChain(x509Certificate);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.http.HttpRequest.getProxiedPeerCertificates", (String)"245", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"No.certificates", (Object)exception);
                x509CertificateArray = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProxiedClientCertificate", x509CertificateArray);
        }
        return x509CertificateArray;
    }

    private String armor(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN CERTIFICATE-----\r\n");
        for (int i = 0; i < string.length(); i += 76) {
            int n = Math.min(i + 76, string.length());
            stringBuffer.append(string.substring(i, n) + "\r\n");
        }
        stringBuffer.append("-----END CERTIFICATE-----\r\n");
        return stringBuffer.toString();
    }

    private X509Certificate[] convertCertToChain(X509Certificate x509Certificate) throws Exception {
        X509Certificate[] x509CertificateArray = null;
        if (x509Certificate != null) {
            x509CertificateArray = new X509Certificate[]{x509Certificate};
        }
        return x509CertificateArray;
    }

    public String getProxiedCipherSuite() {
        return this.privateHdrs[2];
    }

    public byte[] getProxiedSessionId() {
        if (this.privateHdrs[9] == null) {
            return null;
        }
        return Base64Coder.base64Decode((byte[])this.privateHdrs[9].getBytes());
    }

    public String getProxiedRemoteAddr() {
        return this.privateHdrs[5];
    }

    public String getProxiedRemoteHost() {
        return this.privateHdrs[6];
    }

    public String getProxiedRemotePort() {
        return this.privateHdrs[12];
    }

    public String getProxiedLocalAddr() {
        return this.privateHdrs[13];
    }

    public String getProxiedLocalName() {
        return this.privateHdrs[14];
    }

    public String getProxiedLocalPort() {
        return this.privateHdrs[15];
    }

    public String getProxiedRemoteUser() {
        return this.privateHdrs[7];
    }

    public int getProxiedServerPort() {
        if (!this.isServerPortSet) {
            if (this.privateHdrs[11] == null) {
                Tr.warning((TraceComponent)tc, (String)"no private server port header");
                this.serverPort = -1;
            } else {
                this.serverPort = Integer.parseInt(this.privateHdrs[11]);
            }
            this.isServerPortSet = true;
        }
        return this.serverPort;
    }

    static {
        hdrName2Idx.put("$wsat", new Integer(0));
        hdrName2Idx.put("$wscc", new Integer(1));
        hdrName2Idx.put("$wscs", new Integer(2));
        hdrName2Idx.put("$wsis", new Integer(3));
        hdrName2Idx.put("$wspr", new Integer(4));
        hdrName2Idx.put("$wsra", new Integer(5));
        hdrName2Idx.put("$wsrh", new Integer(6));
        hdrName2Idx.put("$wsru", new Integer(7));
        hdrName2Idx.put("$wssc", new Integer(8));
        hdrName2Idx.put("$wssi", new Integer(9));
        hdrName2Idx.put("$wssn", new Integer(10));
        hdrName2Idx.put("$wssp", new Integer(11));
        hdrName2Idx.put("$wsrp", new Integer(12));
        hdrName2Idx.put("$wsla", new Integer(13));
        hdrName2Idx.put("$wslh", new Integer(14));
        hdrName2Idx.put("$wslp", new Integer(15));
    }
}

