/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.IRequestTransport;
import com.ibm.ws.webcontainer.exception.TransportException;
import com.ibm.ws.webcontainer.http.HttpServer;
import java.util.Enumeration;
import java.util.Properties;

public class HttpTransport
extends com.ibm.ws.http.HttpTransport
implements IRequestTransport {
    private static int transportCount = 0;
    private static HttpServer httpServer = null;
    private static boolean debugEnabledTest = false;
    private static boolean errorlogEnabledTest = false;
    private static TraceComponent tc = Tr.register((Class)HttpTransport.class, (String)"WebContainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public void startTransport(ThreadPool threadPool, Properties properties, Transport transport) throws TransportException {
        this.startTransport(threadPool, properties, transport, new Properties());
    }

    public void startTransport(ThreadPool threadPool, Properties properties, Transport transport, Properties properties2) throws TransportException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Thread Pool", (Object)threadPool);
            Tr.debug((TraceComponent)tc, (String)"Properties", (Object)properties);
        }
        try {
            if (transportCount == 0) {
                httpServer = new HttpServer(threadPool);
            }
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string.equalsIgnoreCase("MaxKeepAliveConnections")) {
                    if (string2.equals("0")) {
                        this.setIsKeepAlive(false);
                        continue;
                    }
                    httpServer.setMaxKeepAliveConnections(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("MaxKeepAliveRequests")) {
                    this.setMaxKeepAliveRequests(Integer.parseInt(string2));
                    continue;
                }
                if (string.equalsIgnoreCase("ConnectionIOTimeOut")) {
                    this.setConnectionIOTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equalsIgnoreCase("ConnectionKeepAliveTimeOut")) {
                    this.setConnectionKeepAliveTimeout(Integer.parseInt(string2));
                    continue;
                }
                if (string.equalsIgnoreCase("ErrorLog")) {
                    httpServer.setErrorLog(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("LogLevel")) {
                    httpServer.setLogLevel(string2);
                    HttpTransport.compareValue(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("ErrorLogDisable")) {
                    httpServer.setErrorLogDisable(new Boolean(string2));
                    HttpTransport.compareValue(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("AccessLog")) {
                    httpServer.setAccessLog(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("AccessLogDisable")) {
                    httpServer.setAccessLogDisable(new Boolean(string2));
                    continue;
                }
                if (string.equalsIgnoreCase("Host")) {
                    this.setHost(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("Port")) {
                    this.setPort(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("MaxConnectBacklog")) {
                    this.setMaxBacklog(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("TcpNoDelay")) {
                    this.setTcpNoDelay(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("KeepAliveEnabled")) {
                    this.setIsKeepAlive(new Boolean(string2));
                    continue;
                }
                throw new TransportException("unknown transport property: " + string);
            }
            super.initialize((com.ibm.ws.http.HttpServer)httpServer, transport, properties2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.http.HttpTransport.startTransport", (String)"103", (Object)this);
            throw new TransportException("Failed to start transport " + this.getScheme() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        ++transportCount;
        Tr.audit((TraceComponent)tc, (String)"transport.is.listening", (Object)new Object[]{this.getScheme(), new String("" + this.getPort())});
    }

    public static void compareValue(String string) {
        if (string.equalsIgnoreCase("false")) {
            errorlogEnabledTest = true;
        }
        if (string.equalsIgnoreCase("debug")) {
            debugEnabledTest = true;
        }
        if (errorlogEnabledTest && debugEnabledTest) {
            HttpServer.debugEnabled = true;
        }
    }

    public synchronized void stopTransport() throws TransportException {
        super.shutdown(true);
        if (--transportCount <= 0) {
            httpServer = null;
        }
        Tr.audit((TraceComponent)tc, (String)"transport.is.stopped", (Object)new Object[]{this.getScheme(), new Integer(this.getPort())});
    }
}

