/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.http.HttpRequest;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class HttpConnection
extends com.ibm.ws.http.HttpConnection {
    private com.ibm.ws.webcontainer.transport.HttpRequest _wccRequest = new com.ibm.ws.webcontainer.transport.HttpRequest(this);
    private static final String JAVAX_NET_SSL_PEER_CERTS = "javax.net.ssl.peer_certificates";
    private static final String JAVAX_NET_SSL_CIPHER_SUITE = "javax.net.ssl.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static TraceComponent tc = Tr.register((Class)HttpConnection.class, (String)"WebContainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public HttpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Constructor");
        }
    }

    protected void handleRequest() throws HttpException, IOException {
        WebContainer.getWebContainer().handleRequest(this._wccRequest, this._wccRequest.getWCCResponse());
    }

    protected void cleanup() {
        super.cleanup();
    }

    protected com.ibm.ws.http.HttpRequest createHttpRequest() {
        return new HttpRequest(this);
    }

    public Object getAttribute(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)string);
        }
        Object object = null;
        if (string.equals(JAVAX_NET_SSL_PEER_CERTS) || string.equals(JAVAX_SERVLET_REQUEST_X509CERTIFICATE)) {
            object = this.getPeerCertificates();
        } else if (string.equals(JAVAX_NET_SSL_CIPHER_SUITE)) {
            object = this.getCipherSuite();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)object);
        }
        return object;
    }

    public String getAuthType() {
        if (this.getRequest().isProxied()) {
            return this.getRequest().getProxiedAuthType();
        }
        if (super.getConnectionPeerCertificates() != null) {
            return "SSL";
        }
        return null;
    }

    public String getCookieValue(String string) {
        return this.getRequest().getCookieValue(string);
    }

    public int getContentLength() {
        return this.getRequest().getContentLength();
    }

    public String getContentType() {
        return this.getRequest().getHeader("Content-Type");
    }

    public String getHeaderDirect(String string) {
        return this.getRequest().getHeader(string);
    }

    public void getHeaders(String[][] stringArray) {
        this.getRequest().getHeaders(stringArray);
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public String getMimeType(String string) {
        throw new RuntimeException("get rid of this thing");
    }

    public String getProtocol() {
        return this.getRequest().getProtocol();
    }

    public String getQueryString() {
        return this.getRequest().getQueryString();
    }

    public String getRealPath(String string) {
        throw new RuntimeException("get rid of this thing");
    }

    public String getRemoteAddr() {
        if (this.getRequest().isProxied()) {
            return this.getRequest().getProxiedRemoteAddr();
        }
        return super.getConnectionRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.getRequest().isProxied()) {
            return this.getRequest().getProxiedRemoteHost();
        }
        return super.getConnectionRemoteHost();
    }

    public String getRemoteUser() {
        if (this.getRequest().isProxied()) {
            return this.getRequest().getProxiedRemoteUser();
        }
        return null;
    }

    public String getRequestURI() {
        return this.getRequest().getURI();
    }

    public String getScheme() {
        return this.getRequest().getScheme();
    }

    public String getServerName() {
        return this.getRequest().getServerName();
    }

    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    public byte[] getSessionId() {
        if (this.getRequest().isProxied()) {
            return this.getRequest().getProxiedSessionId();
        }
        return super.getConnectionSessionId();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.getRequest().getInputStream().read(byArray, n, n2);
    }

    public int read() throws IOException {
        return this.getRequest().getInputStream().read();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.response.getOutputStream().write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.response.getOutputStream().write(n);
    }

    public void flush() throws IOException {
        this.response.getOutputStream().flush();
    }

    public boolean isCredBufAvail() {
        throw new RuntimeException("get rid of this thing");
    }

    public byte[] getCredBuf() {
        throw new RuntimeException("get rid of this thing");
    }

    public boolean isSSL() {
        return this.isSecure();
    }

    public boolean isThreadSafe() {
        throw new RuntimeException("get rid of this thing");
    }

    public void prepareForWrite(int n, String string, String[] stringArray, String[] stringArray2, int n2) {
        this.response.setStatus(n);
        for (int i = 0; i < n2; ++i) {
            this.response.addHeader(stringArray[i], stringArray2[i]);
        }
    }

    public boolean sendError(int n, String string, String string2) throws IOException {
        throw new RuntimeException("get rid of this thing");
    }

    public boolean isServletInvoke() {
        throw new RuntimeException("get rid of this thing");
    }

    public String getServletName() {
        throw new RuntimeException("get rid of this thing");
    }

    public String getServletCode() {
        throw new RuntimeException("get rid of this thing");
    }

    public String getServletCodeBase() {
        throw new RuntimeException("get rid of this thing");
    }

    public Properties getServletInitProperties() {
        throw new RuntimeException("get rid of this thing");
    }

    public Properties getServletExtraParameters() {
        throw new RuntimeException("get rid of this thing");
    }

    public boolean isSecure() {
        boolean bl = this.getRequest().isProxied() ? this.getRequest().isProxiedSecure() : super.isConnectionSecure();
        return bl;
    }

    public X509Certificate[] getPeerCertificates() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerCertificates");
        }
        X509Certificate[] x509CertificateArray = this.getRequest().isProxied() ? this.getRequest().getProxiedPeerCertificates() : super.getConnectionPeerCertificates();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerCertificates", (Object)x509CertificateArray);
        }
        return x509CertificateArray;
    }

    public String getCipherSuite() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCipherSuite");
        }
        String string = this.getRequest().isProxied() ? this.getRequest().getProxiedCipherSuite() : super.getConnectionCipherSuite();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCipherSuite", (Object)string);
        }
        return string;
    }

    private HttpRequest getRequest() {
        return (HttpRequest)this.request;
    }
}

