/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterChainContents;
import com.ibm.ws.webcontainer.filter.FilterConfig;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.filter.WebAppFilterChain;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.util.LRUCache;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.beans.Beans;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletException;

public class WebAppFilterManager {
    private Hashtable _filterWrappers = new Hashtable();
    private LRUCache _chains = new LRUCache(20, 200);
    private LRUCache _forwardChains = new LRUCache(10, 100);
    private LRUCache _includeChains = new LRUCache(5, 100);
    private LRUCache _errorChains = new LRUCache(2, 100);
    private ArrayList _uriFilterMappings = new ArrayList();
    private ArrayList _servletFilterMappings = new ArrayList();
    public boolean _filtersDefined = false;
    static final int FMI_MAPPING_SINGLE_SLASH = 0;
    static final int FMI_MAPPING_PATH_MATCH = 1;
    static final int FMI_MAPPING_EXTENSION_MATCH = 2;
    static final int FMI_MAPPING_EXACT_MATCH = 3;
    private static TraceComponent tc = Tr.register((Class)WebAppFilterManager.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private boolean _entryEnabled = tc.isEntryEnabled();
    WebAppConfiguration webAppConfig;
    WebApp webApp;

    public WebAppFilterManager(WebAppConfiguration webAppConfiguration, WebApp webApp) {
        this.webAppConfig = webAppConfiguration;
        this.webApp = webApp;
    }

    public void init() {
        List list = this.webAppConfig.getFilterMappings();
        if (!list.isEmpty()) {
            this._filtersDefined = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterMapping filterMapping = (FilterMapping)iterator.next();
                this.addFilterMapping(filterMapping);
            }
        }
    }

    public void addFilterMapping(FilterMapping filterMapping) {
        if (filterMapping != null) {
            this._filtersDefined = true;
            FilterMappingInfo filterMappingInfo = new FilterMappingInfo();
            String string = filterMapping.getUrlPattern();
            if (string != null) {
                filterMappingInfo.setFilterName(filterMapping.getFilterConfig().getName());
                filterMappingInfo.setFilterURI(string);
                filterMappingInfo.setDispatchMode(filterMapping.getDispatchMode());
                this._uriFilterMappings.add(filterMappingInfo);
            } else {
                filterMappingInfo.setFilterName(filterMapping.getFilterConfig().getName());
                filterMappingInfo.setFilterServlet(filterMapping.getServletConfig().getServletName());
                filterMappingInfo.setDispatchMode(filterMapping.getDispatchMode());
                this._servletFilterMappings.add(filterMappingInfo);
            }
        }
    }

    public FilterInstanceWrapper getFilterInstanceWrapper(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getFilterInstance");
        }
        try {
            FilterInstanceWrapper filterInstanceWrapper = (FilterInstanceWrapper)this._filterWrappers.get(string);
            if (filterInstanceWrapper != null) {
                return filterInstanceWrapper;
            }
            return this.loadFilter(string);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", (String)"166", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", (String)"172", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
    }

    public synchronized WebAppFilterChain getFilterChain(String string, IServletWrapper iServletWrapper, int n) throws ServletException {
        String string2 = "null";
        if (iServletWrapper != null) {
            string2 = iServletWrapper.getServletName();
        }
        FilterChainContents filterChainContents = this.getFilterChainContents(string, string2, n);
        WebAppFilterChain webAppFilterChain = new WebAppFilterChain(this.webApp);
        if (filterChainContents._hasFilters) {
            ArrayList arrayList = filterChainContents.getFilterNames();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                webAppFilterChain.addFilter(this.getFilterInstanceWrapper((String)arrayList.get(i)));
            }
        }
        webAppFilterChain.setRequestedServlet(iServletWrapper);
        return webAppFilterChain;
    }

    public synchronized WebAppFilterChain getFilterChain(String string, ServletWrapper servletWrapper) throws ServletException {
        return this.getFilterChain(string, servletWrapper, 0);
    }

    public void shutdown() {
        Enumeration enumeration = this._filterWrappers.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((FilterInstanceWrapper)enumeration.nextElement()).destroy();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.shutdown", (String)"237", (Object)this);
            }
        }
        this._filterWrappers = null;
        this._chains = null;
    }

    private FilterInstanceWrapper loadFilter(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"createFilterInstance");
        }
        FilterInstanceWrapper filterInstanceWrapper = null;
        try {
            Filter filter;
            FilterConfig filterConfig = this.webAppConfig.getFilterInfo(string);
            filterConfig.setContext(this.webApp.getFacade());
            HashMap hashMap = filterConfig.getInitParams();
            String string2 = filterConfig.getFilterClassName();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Instantiating Filter Class: {0}", (Object)string2);
            }
            try {
                filter = (Filter)Beans.instantiate(this.webApp.getClassLoader(), string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"298", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Could.not.find.required.filter.class", "Filter [{0}]: Could not find required filter class - {1}.class"), string, string2), (Throwable)classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"303", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.not.a.filter.class", "Filter [{0}]: not a filter class"), string), (Throwable)classCastException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"308", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.was.found.but.is.missing.another.required.class", "Filter [{0}]: {1} was found, but is missing another required class.\n"), string, string2), (Throwable)noClassDefFoundError);
            }
            catch (ClassFormatError classFormatError) {
                FFDCFilter.processException((Throwable)classFormatError, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"313", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.corrupt", "Filter [{0}]: {1} was found, but is corrupt:\n"), string, string2), (Throwable)classFormatError);
            }
            filterInstanceWrapper = new FilterInstanceWrapper(string, filter);
            filterInstanceWrapper.init(filterConfig);
            this._filterWrappers.put(string, filterInstanceWrapper);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"380", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"385", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
        if (this._entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"loadFilter");
        }
        return filterInstanceWrapper;
    }

    private FilterChainContents getFilterChainContents(String string, String string2) {
        return this.getFilterChainContents(string, string2, 0);
    }

    private FilterChainContents getFilterChainContents(String string, String string2, int n) {
        int n2;
        FilterChainContents filterChainContents = null;
        String string3 = null;
        if (string != null) {
            n2 = string.indexOf("?");
            string3 = n2 > 0 ? string.substring(0, n2) : string;
            int n3 = string3.indexOf(59);
            if (n3 != -1) {
                string3 = string3.substring(0, n3);
            }
            if (n == 0) {
                filterChainContents = (FilterChainContents)this._chains.get(string3);
            } else if (n == 1) {
                filterChainContents = (FilterChainContents)this._forwardChains.get(string3);
            } else if (n == 2) {
                filterChainContents = (FilterChainContents)this._includeChains.get(string3);
            } else if (n == 3) {
                filterChainContents = (FilterChainContents)this._errorChains.get(string3);
            }
        } else if (n == 0) {
            filterChainContents = (FilterChainContents)this._chains.get(string2);
        } else if (n == 1) {
            filterChainContents = (FilterChainContents)this._forwardChains.get(string2);
        } else if (n == 2) {
            filterChainContents = (FilterChainContents)this._includeChains.get(string2);
        } else if (n == 3) {
            filterChainContents = (FilterChainContents)this._errorChains.get(string2);
        }
        if (filterChainContents == null) {
            int n4;
            filterChainContents = new FilterChainContents();
            if (string3 != null) {
                n4 = this._uriFilterMappings.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    FilterMappingInfo filterMappingInfo = (FilterMappingInfo)this._uriFilterMappings.get(n2);
                    if (!this.uriMatch(string3, filterMappingInfo, n)) continue;
                    filterChainContents.addFilter(filterMappingInfo._filterName);
                }
            }
            n4 = this._servletFilterMappings.size();
            block1: for (n2 = 0; n2 < n4; ++n2) {
                FilterMappingInfo filterMappingInfo = (FilterMappingInfo)this._servletFilterMappings.get(n2);
                if (!string2.equals(filterMappingInfo._filterServlet)) continue;
                for (int i = 0; i < filterMappingInfo.dispatchMode.length; ++i) {
                    if (n != filterMappingInfo.dispatchMode[i]) continue;
                    filterChainContents.addFilter(filterMappingInfo._filterName);
                    continue block1;
                }
            }
            if (string3 != null) {
                if (n == 0) {
                    this._chains.put((Object)string3, filterChainContents);
                } else if (n == 1) {
                    this._forwardChains.put((Object)string3, filterChainContents);
                } else if (n == 2) {
                    this._includeChains.put((Object)string3, filterChainContents);
                } else if (n == 3) {
                    this._errorChains.put((Object)string3, filterChainContents);
                }
            } else if (n == 0) {
                this._chains.put((Object)string2, filterChainContents);
            } else if (n == 1) {
                this._forwardChains.put((Object)string2, filterChainContents);
            } else if (n == 2) {
                this._includeChains.put((Object)string2, filterChainContents);
            } else if (n == 3) {
                this._errorChains.put((Object)string2, filterChainContents);
            }
        }
        return filterChainContents;
    }

    private boolean uriMatch(String string, FilterMappingInfo filterMappingInfo) {
        return this.uriMatch(string, filterMappingInfo, 0);
    }

    private boolean uriMatch(String string, FilterMappingInfo filterMappingInfo, int n) {
        int n2;
        boolean bl = false;
        switch (filterMappingInfo._mappingType) {
            case 0: {
                if (!string.equals("/")) break;
                bl = true;
                break;
            }
            case 1: {
                if (!string.startsWith(filterMappingInfo._filterURI + "/") && !string.equals(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
            case 2: {
                String string2 = filterMappingInfo._filterURI.substring(2);
                n2 = string.lastIndexOf(46);
                if (n2 == -1 || !string2.equals(string.substring(n2 + 1))) break;
                bl = true;
                break;
            }
            case 3: {
                if (!string.equals(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
        }
        boolean bl2 = false;
        if (bl) {
            for (n2 = 0; n2 < filterMappingInfo.dispatchMode.length; ++n2) {
                if (n != filterMappingInfo.dispatchMode[n2]) continue;
                bl2 = true;
                break;
            }
        }
        return bl2 && bl;
    }

    public boolean areFiltersDefined() {
        return this._filtersDefined;
    }

    protected class FilterMappingInfo {
        String _filterName;
        String _filterURI;
        String _filterServlet;
        int _mappingType;
        int[] dispatchMode;

        protected FilterMappingInfo() {
        }

        public void setFilterName(String string) {
            this._filterName = string;
        }

        public void setDispatchMode(int[] nArray) {
            this.dispatchMode = nArray;
        }

        public void setFilterURI(String string) {
            if (string.equals("/")) {
                this._mappingType = 0;
            } else if (string.startsWith("/") && string.endsWith("/*")) {
                this._mappingType = 1;
                string = string.substring(0, string.length() - 2);
            } else {
                this._mappingType = string.startsWith("*.") ? 2 : 3;
            }
            this._filterURI = string;
        }

        public void setFilterServlet(String string) {
            this._filterServlet = string;
        }
    }
}

