/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterConfig;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class FilterInstanceWrapper {
    public static final int FILTER_STATE_UNINITIALIZED = 0;
    public static final int FILTER_STATE_INITIALIZING = 1;
    public static final int FILTER_STATE_AVAILABLE = 2;
    public static final int FILTER_STATE_DESTROYING = 3;
    public static final int FILTER_STATE_DESTROYED = 4;
    public static final int FILTER_STATE_UNAVAILABLE = 5;
    private String _filterName;
    private Filter _filterInstance;
    private int _filterState = 0;
    private volatile int nServicing = 0;
    private static TraceComponent tc = Tr.register((Class)FilterInstanceWrapper.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    FilterInstanceWrapper(String string, Filter filter) {
        this._filterName = string;
        this._filterInstance = filter;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public Filter getFilterInstance() {
        return this._filterInstance;
    }

    public int getFilterState() {
        return this._filterState;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this._filterState = 1;
            this._filterInstance.init((javax.servlet.FilterConfig)filterConfig);
            this._filterState = 2;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.init", (String)"111", (Object)this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be initialized", this._filterName), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException {
        try {
            FilterInstanceWrapper filterInstanceWrapper;
            if (this._filterState != 2) {
                throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName));
            }
            FilterInstanceWrapper filterInstanceWrapper2 = this;
            synchronized (filterInstanceWrapper2) {
                ++this.nServicing;
            }
            try {
                try {
                    this._filterInstance.doFilter(servletRequest, servletResponse, filterChain);
                }
                catch (ServletException servletException) {
                    throw servletException;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                Object var7_9 = null;
                filterInstanceWrapper = this;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                FilterInstanceWrapper filterInstanceWrapper3 = this;
                synchronized (filterInstanceWrapper3) {
                    --this.nServicing;
                    throw throwable;
                }
            }
            synchronized (filterInstanceWrapper) {
                --this.nServicing;
                return;
            }
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", (String)"144", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", (String)"149", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName), throwable);
        }
    }

    public void destroy() throws ServletException {
        try {
            this._filterState = 3;
            for (int i = 0; this.nServicing > 0 && i < 60; ++i) {
                try {
                    if (i == 0) {
                        Tr.audit((TraceComponent)tc, (String)"waiting.to.destroy.filter.[{0}]", (Object)this._filterName);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", (String)"377", (Object)this);
                }
            }
            this._filterInstance.destroy();
            this._filterState = 4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.destroy", (String)"173", (Object)this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be destroyed", this._filterName), throwable);
        }
    }
}

