/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.cache.ServletCacheEngine;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheManager {
    private static TraceComponent tc = Tr.register((Class)CacheManager.class, (String)"Servlet Cache", (String)"com.ibm.ws.webcontainer.resources.Messages");
    public static boolean cacheEnabled = false;
    private static ServletCacheEngine cacheEngine = null;
    private static List staticCacheTable = null;

    public static synchronized void initialize() {
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.cache.servlet.ServletCacheEngine");
            cacheEngine = (ServletCacheEngine)clazz.newInstance();
            cacheEngine.initialize();
            cacheEnabled = true;
            staticCacheTable = cacheEngine.getAppsWithStaticCaching();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.cache.CacheManager.initialize", (String)"75");
            Tr.debug((TraceComponent)tc, (String)"dynacache initialization error", (Object)throwable);
        }
    }

    public static Servlet getProxiedServlet(Servlet servlet) {
        if (cacheEnabled) {
            return cacheEngine.getProxiedServlet(servlet);
        }
        return servlet;
    }

    public static void handleServlet(Servlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (cacheEnabled) {
            cacheEngine.handleServlet(servlet, httpServletRequest, httpServletResponse);
        } else {
            servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    public static Servlet getSingleThreadModelWrapper(Servlet servlet) {
        if (cacheEnabled) {
            return cacheEngine.getSingleThreadModelWrapper(servlet);
        }
        return servlet;
    }

    public static boolean isCachingEnabled(String string) {
        if (staticCacheTable == null) {
            return false;
        }
        for (int i = 0; i < staticCacheTable.size(); ++i) {
            if (!((String)staticCacheTable.get(i)).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

