/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.container.Container;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ThreadContextHelper;
import com.ibm.ws.runtime.component.WebContainerImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.RuntimeCtxImpl;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.WebSecurityCollaborator;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.IRequestTransport;
import com.ibm.ws.webcontainer.ReaperAlarmListener;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.VirtualHostConfigurationHelper;
import com.ibm.ws.webcontainer.WebContainerWorkloadRegulator;
import com.ibm.ws.webcontainer.cache.CacheManager;
import com.ibm.ws.webcontainer.collaborator.ConnectionHandleCollaborator;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.TransportException;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebContainerException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.extension.ExtHandshakeVHostExtensionFactory;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.objectpool.ObjectPoolFactory;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInitializationCollaborator;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.util.URIToServletWrapperCache;
import com.ibm.ws.webcontainer.util.VirtualHostMapper;
import com.ibm.ws.webcontainer.util.WASSystem;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorFactory;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorIntervalManager;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.emf.common.util.EList;

public final class WebContainer
extends BaseContainer
implements Runnable {
    private static final String ISO = "ISO-8859-1";
    private Hashtable threadData = new Hashtable();
    private static List applicationListeners = new ArrayList();
    private static List servletListeners = new ArrayList();
    private static List servletErrorListeners = new ArrayList();
    private static List servletInvocationListeners = new ArrayList();
    private static List servletRequestListeners = new ArrayList();
    private static List servletRequestAttributeListeners = new ArrayList();
    private static List servletContextListeners = new ArrayList();
    private static List servletContextAttributeListeners = new ArrayList();
    private static List sessionListeners = new ArrayList();
    private static List sessionAttributeListeners = new ArrayList();
    public static final String DEFAULT_HOST = "default_host";
    private boolean _initialized;
    protected static TraceComponent tc = Tr.register((Class)WebContainer.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static WebContainer self = null;
    private boolean production = false;
    public static final boolean isZOS = AdminHelper.getPlatformHelper().isZOS();
    private static String tempDir = null;
    private static boolean isDefaultTempDir = false;
    private HashMap _cipherToBit = new HashMap();
    private com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webConConfig;
    private RuntimeCtxImpl runtimeContext;
    private WebContainerImpl webConStateObject;
    private SecurityService securityService;
    private WebSecurityCollaborator securityCollaborator;
    private static String THREAD_POOL_NAME = "Migrated.Servlet.Engine.Transports";
    private ObjectPool srtConnectionObjectPool = null;
    private static ThreadLocal cacheKeyStringBuffer = new WSThreadLocal();
    private static ConnectionHandleCollaborator connectionHandleCollaborator;
    private static boolean listenersInitialized;
    private IInitializationCollaborator[] webAppInitializationCollaborators;
    private IInvocationCollaborator[] webAppInvocationCollaborators;
    private MetaDataService metaDataService;
    private ArrayList transports;
    private static Properties webConProperties;
    private SessionRegistry sessionRegistry;
    private List runningTransports;
    private boolean transportsAvailable;
    private boolean chainsAvailable = true;
    public static final String urlPrefix = ";jsessionid=";
    private HashMap moduleToVHostTable = new HashMap();
    private String encoding = null;
    private boolean decode = true;
    private Alarm reaperAlarm;
    private long reaperInterval = 0L;
    private long reaperInactiveLimit = 10000L;
    public static ArrayList extensionFactories;
    private static ArrayList httpResponseListeners;
    private static ArrayList virtualHostExtFactories;
    private static SmfWebContainerDataCollector Smf;
    private static SmfWebContainerDataCollectorIntervalManager intervalManager;
    private static int invocationCacheSize;
    private static HashMap _cacheMap;
    private static boolean _cacheIsFull;
    private boolean enableSecurityAtWARBoundary = false;
    private boolean enableSecurityAtEARBoundary = false;

    private WebContainer(String string, Container container) {
        super(string, container);
        this.requestMapper = new VirtualHostMapper();
        this.runningTransports = new ArrayList();
    }

    public void initialize(com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webContainer, RuntimeCtxImpl runtimeCtxImpl, WebContainerImpl webContainerImpl, IInitializationCollaborator[] iInitializationCollaboratorArray, IInvocationCollaborator[] iInvocationCollaboratorArray, SecurityService securityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.webConConfig = webContainer;
        if (!this._initialized) {
            Tr.audit((TraceComponent)tc, (String)"web.container.copyright");
            Tr.audit((TraceComponent)tc, (String)"web.container.servlet.spec.level");
            Tr.audit((TraceComponent)tc, (String)"web.container.jsp.spec.level");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Web Container Configuration: {0}", (Object)webContainer);
            }
            this.runtimeContext = runtimeCtxImpl;
            this.webConStateObject = webContainerImpl;
            this.securityService = securityService;
            Iterator iterator = webContainer.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                webConProperties.put(property.getName().toLowerCase(), property.getValue());
            }
            this.getURIEncoding();
            this.webAppInitializationCollaborators = iInitializationCollaboratorArray;
            this.webAppInvocationCollaborators = iInvocationCollaboratorArray;
            this.metaDataService = (MetaDataService)this.runtimeContext.getService(MetaDataService.class);
            this.transports = new ArrayList();
            if (webContainer.isEnableServletCaching()) {
                this.initializeDynamicCache();
            }
            this.loadCipherToBit();
            connectionHandleCollaborator = new ConnectionHandleCollaborator();
            WebContainerWorkloadRegulator.getRegulator();
            int n = -1;
            String string = (String)webConProperties.get("com.ibm.wsspi.webcontainer.connection.pooling.size");
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.warning((TraceComponent)tc, (String)("Failed to set connection pooling size :[" + string + "]. Use default pooling"), (Object)numberFormatException);
                }
            }
            this.srtConnectionObjectPool = ObjectPoolFactory.getPool(this.runtimeContext, SRTConnectionContext.class, n);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("init connection pool type -->" + this.srtConnectionObjectPool + " size -->" + n));
            }
            if (this.reaperInterval > 0L) {
                Tr.audit((TraceComponent)tc, (String)"reaper.with.interval.[{0}].limit.[{1}].started", (Object)new Object[]{new Long(this.reaperInterval), new Long(this.reaperInactiveLimit)});
                this.reaperAlarm = ReaperAlarmListener.startReaperAlarm(this, this.reaperInterval);
            }
            this._initialized = true;
            String string2 = SecurityContext.isSecurityEnabled() ? "com.ibm.ws.security.web.EJSWebCollaborator" : "com.ibm.ws.security.web.NullWebSecurityCollaborator";
            try {
                this.securityCollaborator = (WebSecurityCollaborator)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"59", (Object)this);
                Object[] objectArray = new Object[]{exception};
                Tr.error((TraceComponent)tc, (String)"instantiate.collaborator.exception", (Object)objectArray);
            }
        }
        WebContainer.addVirtualHostExtensionFactory(new ExtHandshakeVHostExtensionFactory());
        try {
            if (webConProperties.getProperty("enablesecurityatwarboundary") != null) {
                this.enableSecurityAtWARBoundary = "true".equalsIgnoreCase(webConProperties.getProperty("enablesecurityatwarboundary"));
            }
            if (webConProperties.getProperty("enablesecurityatearboundary") != null) {
                this.enableSecurityAtEARBoundary = "true".equalsIgnoreCase(webConProperties.getProperty("enablesecurityatearboundary"));
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)("Error in WebContainer custom property value: " + exception.getMessage()));
            exception.printStackTrace(System.err);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Web Container invocationCache -->" + invocationCacheSize));
        }
        this.processVirtualHostExtensionFactories();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public static void printCacheMap() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Inside printCacheMap");
            }
            Iterator iterator = _cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                CacheServletWrapper cacheServletWrapper = (CacheServletWrapper)_cacheMap.get(iterator.next());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)cacheServletWrapper.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendUnavailableException(IRequest iRequest, IResponse iResponse) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Inside sendUnavailableException");
        }
        iResponse.addHeader("Content-Type", "text/html");
        iResponse.setStatusCode(503);
        String string = "<H1>" + nls.getFormattedMessage("Servlet.has.become.temporarily.unavailable.for.service.{0}", new Object[]{this.truncateURI(iRequest.getRequestURI())}, "Servlet has become temporarily unavailable for service") + "</H1><BR><H3>" + "</H3><BR><I>IBM WebSphere Application Server</I>";
        byte[] byArray = string.getBytes();
        iResponse.getOutputStream().write(byArray, 0, byArray.length);
        Tr.error((TraceComponent)tc, (String)"Servlet.has.become.temporarily.unavailable.for.service", (Object)new Object[]{this.truncateURI(iRequest.getRequestURI())});
    }

    private static void registerGlobalWebAppListeners() {
        block16: {
            try {
                Properties properties = WebContainer.getWebContainerProperties();
                String string = properties.getProperty("listeners");
                String string2 = null;
                if (string == null) break block16;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                string2 = null;
                while (stringTokenizer.hasMoreElements()) {
                    try {
                        string2 = stringTokenizer.nextToken();
                        Object object = WebContainer.loadListener(string2);
                        if (object != null) {
                            if (object instanceof ApplicationListener) {
                                applicationListeners.add(object);
                            }
                            if (object instanceof ServletListener) {
                                servletListeners.add(object);
                            }
                            if (object instanceof ServletErrorListener) {
                                servletErrorListeners.add(object);
                            }
                            if (object instanceof ServletInvocationListener) {
                                servletInvocationListeners.add(object);
                            }
                            if (object instanceof ServletContextAttributeListener) {
                                servletContextAttributeListeners.add(object);
                            }
                            if (object instanceof ServletContextListener) {
                                servletContextListeners.add(object);
                            }
                            if (object instanceof ServletRequestAttributeListener) {
                                servletRequestAttributeListeners.add(object);
                            }
                            if (object instanceof ServletRequestListener) {
                                servletRequestListeners.add(object);
                            }
                            if (object instanceof HttpSessionListener) {
                                sessionListeners.add(object);
                            }
                            if (object instanceof HttpSessionAttributeListener) {
                                sessionAttributeListeners.add(object);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.webapp.WebApp.registerGlobalWebAppListeners", (String)"785", (Object)WebContainer.getWebContainer());
                    }
                    listenersInitialized = true;
                }
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"Error occured while processing global listeners for the WebApp. Check the error logs for details.");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static Object loadListener(String string) {
        Object object = null;
        try {
            object = Beans.instantiate(Thread.currentThread().getContextClassLoader(), string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1523", (Object)WebContainer.getWebContainer());
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1527", (Object)WebContainer.getWebContainer());
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1531", (Object)WebContainer.getWebContainer());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1535", (Object)WebContainer.getWebContainer());
        }
        catch (ClassFormatError classFormatError) {
            FFDCFilter.processException((Throwable)classFormatError, (String)"com.ibm.ws.webcontainer.srt.WebGroup.loadListener", (String)"1539", (Object)WebContainer.getWebContainer());
        }
        return object;
    }

    private void loadCipherToBit() {
        Properties properties = new Properties();
        try {
            String string = System.getProperty("server.root") + File.separator + "properties" + File.separator + "sslbitsizes.properties";
            properties.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"failed.to.load.sslbitsizes.properties", (Object)exception);
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer.loadCipherToBit", (String)"825", (Object)this);
        }
        this._cipherToBit.putAll(properties);
    }

    public void destroy() {
        this.stopTransports();
        this.stopChains(0);
        super.destroy();
        this.requestMapper = null;
        if (isZOS && !isDefaultTempDir) {
            File file;
            Tr.debug((TraceComponent)tc, (String)"deleting tempDirectory");
            if (tempDir != null && (file = new File(tempDir)).exists()) {
                try {
                    this.removeDir(file);
                }
                catch (SecurityException securityException) {
                    Tr.error((TraceComponent)tc, (String)"Did not have access to delete Directory");
                }
            }
        }
        if (this.reaperAlarm != null) {
            this.reaperAlarm.cancel();
        }
    }

    private boolean removeDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.removeDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private void initializeDynamicCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDynamicCache");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dynamic Caching Initializing");
        }
        CacheManager.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDynamicCache");
        }
    }

    private VirtualHost loadVirtualHost(com.ibm.ws.http.VirtualHost virtualHost) {
        VirtualHost virtualHost2 = new VirtualHost(virtualHost.getName(), this);
        virtualHost2.setName(virtualHost.getName());
        VirtualHostConfiguration virtualHostConfiguration = VirtualHostConfigurationHelper.createConfiguration(virtualHost);
        virtualHost2.init(virtualHostConfiguration, this.runtimeContext);
        Alias[] aliasArray = virtualHost.getAliases();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        for (int i = 0; i < aliasArray.length; ++i) {
            Alias alias = aliasArray[i];
            string = alias.getHostname().toLowerCase();
            string2 = alias.getPort();
            if (string2 == null) {
                string2 = "80";
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                this.requestMapper.addMapping(stringBuffer.toString(), virtualHost2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer.loadVirtualHosts", (String)"332");
                throw new RuntimeException(exception);
            }
            if (!string.equalsIgnoreCase("localhost")) continue;
            stringBuffer.setLength(0);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.WebContainer.loadVirtualHosts", (String)"348");
            }
            if (inetAddress == null) continue;
            stringBuffer.append(inetAddress.getHostName().toLowerCase());
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                this.requestMapper.addMapping(stringBuffer.toString(), virtualHost2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setLength(0);
            String string3 = inetAddress.getHostAddress().toLowerCase();
            stringBuffer.append(string3);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                this.requestMapper.addMapping(stringBuffer.toString(), virtualHost2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<MESSAGE> Adding VirtualHost " + stringBuffer.toString()));
        }
        return virtualHost2;
    }

    public void shutdown() {
        this.destroy();
    }

    public void addWebApplication(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        block11: {
            try {
                this.production = bl;
                if (isZOS) {
                    Thread thread;
                    block10: {
                        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        thread = new Thread(WebContainer.getWebContainer());
                        this.threadData.put(thread, deployedModule);
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                            public Object run() {
                                thread.setContextClassLoader(classLoader);
                                return null;
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Starting autoload thread");
                        }
                        thread.start();
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Entering join() on autoload thread");
                            }
                            thread.join();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Left join() on autoload thread");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) break block10;
                            Tr.debug((TraceComponent)tc, (String)"join() on autoload thread interrupted");
                        }
                    }
                    WebAppNotLoadedException webAppNotLoadedException = (WebAppNotLoadedException)this.threadData.remove(thread);
                    if (webAppNotLoadedException != null) {
                        throw webAppNotLoadedException;
                    }
                    break block11;
                }
                this.addWebApp(deployedModule, bl);
            }
            catch (WebAppNotLoadedException webAppNotLoadedException) {
                throw webAppNotLoadedException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"695", (Object)this);
                throw new WebAppNotLoadedException(throwable.getMessage());
            }
        }
    }

    public void run() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Running autoload on daughter thread");
        }
        DeployedModule deployedModule = (DeployedModule)this.threadData.remove(Thread.currentThread());
        try {
            ThreadContextHelper threadContextHelper = (ThreadContextHelper)ImplFactory.loadImplFromKey((Class)ThreadContextHelper.class);
            threadContextHelper.establishCredentials();
            this.addWebApp(deployedModule, this.production);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            this.threadData.put(Thread.currentThread(), webAppNotLoadedException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Autoload done");
        }
    }

    private void addWebApp(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        try {
            VirtualHost virtualHost;
            WebAppBinding webAppBinding = (WebAppBinding)deployedModule.getBinding();
            String string = webAppBinding.getVirtualHostName();
            if (string == null || string.equals("")) {
                string = DEFAULT_HOST;
            }
            if ((virtualHost = this.getVirtualHost(string)) == null) {
                throw new WebAppNotLoadedException("Virtual Host " + string + " not found");
            }
            virtualHost.addWebApplication(deployedModule, extensionFactories, this.webAppInitializationCollaborators, this.webAppInvocationCollaborators, bl);
            this.moduleToVHostTable.put(deployedModule.getModuleRef(), virtualHost);
        }
        catch (WebAppHostNotFoundException webAppHostNotFoundException) {
            FFDCFilter.processException((Throwable)webAppHostNotFoundException, (String)"com.ibm.ws.webcontainer.Webcontainer", (String)"732", (Object)this);
            throw new WebAppNotLoadedException(webAppHostNotFoundException.getMessage());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"736", (Object)this);
            throw new WebAppNotLoadedException(throwable.getMessage());
        }
    }

    private VirtualHost getVirtualHost(String string) throws WebAppHostNotFoundException {
        VirtualHost virtualHost;
        RequestProcessor requestProcessor;
        Iterator iterator = this.requestMapper.targetMappings();
        while (iterator.hasNext()) {
            requestProcessor = (RequestProcessor)iterator.next();
            if (!(requestProcessor instanceof VirtualHost) || !string.equalsIgnoreCase((virtualHost = (VirtualHost)requestProcessor).getName())) continue;
            return virtualHost;
        }
        requestProcessor = (VirtualHostMgr)this.runtimeContext.getService(VirtualHostMgr.class);
        virtualHost = requestProcessor.getVirtualHost(string);
        try {
            VirtualHost virtualHost2 = this.loadVirtualHost((com.ibm.ws.http.VirtualHost)virtualHost);
            return virtualHost2;
        }
        catch (Throwable throwable) {
            throw new WebAppHostNotFoundException(throwable, string);
        }
    }

    public void removeWebApplication(DeployedModule deployedModule) throws Exception {
        try {
            VirtualHost virtualHost = (VirtualHost)this.moduleToVHostTable.get(deployedModule.getModuleRef());
            if (virtualHost == null) {
                throw new WebAppHostNotFoundException("VirtualHost for app " + deployedModule.getModuleRef().getUri() + " not found");
            }
            virtualHost.removeWebApplication(deployedModule);
            this.moduleToVHostTable.remove(deployedModule.getModuleRef());
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Exception ", (Object)exception);
            throw exception;
        }
    }

    public static WebContainer getWebContainer() {
        if (self == null) {
            self = new WebContainer("WAS.webcontainer", null);
        }
        return self;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransports() throws RuntimeError {
        if (!this.transportsAvailable) {
            VariableMap variableMap = null;
            ThreadPoolMgr threadPoolMgr = null;
            try {
                variableMap = (VariableMap)this.webConStateObject.getService(VariableMap.class);
                threadPoolMgr = (ThreadPoolMgr)this.webConStateObject.getService(ThreadPoolMgr.class);
                this.startTransports(variableMap, threadPoolMgr);
                Object var4_3 = null;
                if (variableMap != null) {
                    this.webConStateObject.releaseService(variableMap);
                }
                if (threadPoolMgr != null) {
                    this.webConStateObject.releaseService(threadPoolMgr);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (variableMap != null) {
                    this.webConStateObject.releaseService(variableMap);
                }
                if (threadPoolMgr != null) {
                    this.webConStateObject.releaseService(threadPoolMgr);
                }
                throw throwable;
            }
        }
    }

    public void restartWebApplication(String string) throws WebAppNotLoadedException {
    }

    private void transformTransportsToChains(VariableMap variableMap, ThreadPoolMgr threadPoolMgr) {
        com.ibm.websphere.models.config.process.ThreadPool threadPool;
        if (isZOS) {
            return;
        }
        EList eList = this.webConConfig.getTransports();
        ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)this.runtimeContext.getService(ChannelFrameworkService.class);
        try {
            threadPool = this.webConConfig.getThreadPool();
        }
        catch (Throwable throwable) {
            threadPool = null;
        }
        if (eList.size() == 0) {
            if (threadPool != null) {
                Tr.warning((TraceComponent)tc, (String)"threadpool.not.used");
            }
            return;
        }
        ThreadPool threadPool2 = threadPoolMgr.getThreadPool(THREAD_POOL_NAME, threadPool);
        Tr.warning((TraceComponent)tc, (String)"transports.detected");
        Transport transport = null;
        for (int i = 0; i < eList.size(); ++i) {
            try {
                String[] stringArray;
                Object object;
                Serializable serializable;
                String string;
                Map<String, String> map;
                transport = (Transport)eList.get(i);
                EndPoint endPoint = transport.getAddress();
                String string2 = "*";
                String string3 = "";
                String string4 = null;
                if (endPoint != null) {
                    string3 = "" + endPoint.getPort();
                    if (endPoint.getHost() != null && !endPoint.getHost().equals("")) {
                        string2 = endPoint.getHost();
                    }
                }
                HashMap hashMap = this.flattenProps(transport.getProperties());
                if (transport.isSslEnabled()) {
                    map = new HashMap();
                    string = transport.getSslConfig();
                    ((HashMap)map).put("alias", string);
                    string4 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_SSL_" + string2 + ":" + string3;
                    try {
                        serializable = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                        channelFrameworkService.addChannel(string4, serializable, map, 100);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace(System.err);
                    }
                    catch (ChannelException channelException) {
                        channelException.printStackTrace(System.err);
                    }
                }
                map = new Properties();
                ((Properties)map).put("hostname", string2);
                ((Properties)map).put("port", string3);
                ((Properties)map).put("threadPoolName", THREAD_POOL_NAME);
                string = (String)hashMap.get("maxconnectbacklog");
                if (string != null) {
                    ((Properties)map).put("listenBacklog", string);
                }
                if ((string = (String)hashMap.get("connectioniotimeout")) != null) {
                    ((Properties)map).put("inactivityTimeout", string);
                }
                String string5 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_TCP_" + string2 + ":" + string3;
                try {
                    serializable = Class.forName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
                    channelFrameworkService.addChannel(string5, serializable, map, 100);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
                catch (ChannelException channelException) {
                    channelException.printStackTrace(System.err);
                }
                serializable = new Properties();
                string = (String)hashMap.get("maxkeepaliverequests");
                if (string != null) {
                    ((Properties)serializable).put("MaxKeepAliveRequests", string);
                }
                if ((string = (String)hashMap.get("keepaliveenabled")) != null) {
                    ((Properties)serializable).put("useKeepAlive", string);
                }
                if ((string = (String)hashMap.get("maxkeepaliveconnections")) != null) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n == 0) {
                        ((Properties)serializable).put("useKeepAlive", "false");
                    }
                }
                if ((string = (String)hashMap.get("errorlog")) != null) {
                    ((Properties)serializable).put("errorLogFileName", string);
                }
                if ((string = (String)hashMap.get("accesslog")) != null) {
                    ((Properties)serializable).put("accessLogFileName", string);
                }
                if ((string = (String)hashMap.get("loglevel")) != null) {
                    ((Properties)serializable).put("loggingLevel", string);
                }
                string = (String)hashMap.get("errorlogdisable");
                boolean bl = true;
                if (string != null) {
                    bl = "true".equalsIgnoreCase(string);
                }
                if ((string = (String)hashMap.get("accesslogdisable")) != null) {
                    bl = bl && "true".equalsIgnoreCase(string);
                }
                ((Properties)serializable).put("loggingDisable", "" + bl);
                string = (String)hashMap.get("connectioniotimeout");
                if (string != null) {
                    ((Properties)serializable).put("readTimeout", string);
                }
                if ((string = (String)hashMap.get("connectionresponsetimeout")) != null) {
                    ((Properties)serializable).put("writeTimeout", string);
                }
                if ((string = (String)hashMap.get("connectionkeepalivetimeout")) != null) {
                    ((Properties)serializable).put("persistTimeout", string);
                }
                String string6 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_HTTP_" + string2 + ":" + string3;
                try {
                    object = Class.forName("com.ibm.ws.http.channel.inbound.impl.WSHttpInboundChannelFactory");
                    channelFrameworkService.addChannel(string6, object, (Map)((Object)serializable), 100);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
                catch (ChannelException channelException) {
                    channelException.printStackTrace(System.err);
                }
                String string7 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_WCC_" + string2 + ":" + string3;
                try {
                    object = new Properties();
                    stringArray = Class.forName("com.ibm.ws.webcontainer.channel.WCChannelFactory");
                    channelFrameworkService.addChannel(string7, stringArray, object, 100);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
                catch (ChannelException channelException) {
                    channelException.printStackTrace(System.err);
                }
                object = "MIGRATED_HTTP_TRANSPORT_CHANNEL_Chain_" + string2 + ":" + string3;
                if (string4 != null) {
                    stringArray = new String[]{string5, string4, string6, string7};
                    try {
                        channelFrameworkService.addChain((String)object, FlowType.INBOUND, stringArray, (class$com$ibm$ws$runtime$component$WebContainerImpl == null ? WebContainer.class$("com.ibm.ws.runtime.component.WebContainerImpl") : class$com$ibm$ws$runtime$component$WebContainerImpl).getName());
                    }
                    catch (ChannelException channelException) {
                        Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. Check the error logs for details."));
                        channelException.printStackTrace(System.err);
                    }
                    catch (ChainException chainException) {
                        Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. Check the error logs for details."));
                        chainException.printStackTrace();
                    }
                    continue;
                }
                stringArray = new String[]{string5, string6, string7};
                try {
                    channelFrameworkService.addChain((String)object, FlowType.INBOUND, stringArray, (class$com$ibm$ws$runtime$component$WebContainerImpl == null ? WebContainer.class$("com.ibm.ws.runtime.component.WebContainerImpl") : class$com$ibm$ws$runtime$component$WebContainerImpl).getName());
                }
                catch (ChannelException channelException) {
                    Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. Check the error logs for details."));
                    channelException.printStackTrace(System.err);
                }
                catch (ChainException chainException) {
                    Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. Check the error logs for details."));
                    chainException.printStackTrace();
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                Tr.error((TraceComponent)tc, (String)"Error occured while migrating transport to the corresponding chain. Check the error logs for details.");
            }
        }
    }

    private HashMap flattenProps(EList eList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = WebContainer.getWebContainerProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string;
            Property property = (Property)iterator.next();
            String string2 = property.getName();
            if (string2.equalsIgnoreCase("maxconnectbacklog")) {
                hashMap.put("maxconnectbacklog", property.getValue());
            } else {
                string = properties.getProperty("maxconnectbacklog");
                if (string != null) {
                    hashMap.put("maxconnectbacklog", string);
                }
            }
            if (string2.equalsIgnoreCase("maxkeepaliveconnections")) {
                Tr.warning((TraceComponent)tc, (String)("The semantics for the " + string2 + " property on the transport, have changed. A thread is no longer tied to a single connection. Please refer to the infocenter for more details."));
                hashMap.put("maxkeepaliveconnections", property.getValue());
            } else {
                Tr.warning((TraceComponent)tc, (String)("The semantics for the " + string2 + " property on the transport, have changed. A thread is no longer tied to a single connection. Please refer to the infocenter for more details."));
                string = properties.getProperty("maxkeepaliveconnections");
                if (string != null) {
                    hashMap.put("maxkeepaliveconnections", string);
                }
            }
            if (string2.equalsIgnoreCase("maxkeepaliverequests")) {
                hashMap.put("maxkeepaliverequests", property.getValue());
            } else {
                string = properties.getProperty("maxkeepaliverequests");
                if (string != null) {
                    hashMap.put("maxkeepaliverequests", string);
                }
            }
            if (string2.equalsIgnoreCase("trustedproxy")) {
                Tr.warning((TraceComponent)tc, (String)("The " + string2 + " property is now configurable only at the WebContainer level, and not at the transports. "));
                hashMap.put("trustedproxy", property.getValue());
            } else {
                string = properties.getProperty("trustedproxy");
                if (string != null) {
                    hashMap.put("trustedproxy", string);
                }
            }
            if (string2.equalsIgnoreCase("connectioniotimeout")) {
                hashMap.put("connectioniotimeout", property.getValue());
            } else {
                string = properties.getProperty("connectioniotimeout");
                if (string != null) {
                    hashMap.put("connectioniotimeout", string);
                }
            }
            if (string2.equalsIgnoreCase("connectionkeepalivetimeout")) {
                hashMap.put("connectionkeepalivetimeout", property.getValue());
            } else {
                string = properties.getProperty("connectionkeepalivetimeout");
                if (string != null) {
                    hashMap.put("connectionkeepalivetimeout", string);
                }
            }
            if (!string2.equalsIgnoreCase("ErrorLog") && !string2.equalsIgnoreCase("LogLevel") && !string2.equalsIgnoreCase("AccessLog") && !string2.equalsIgnoreCase("ErrorLogDisable") && !string2.equalsIgnoreCase("AccessLogDisable")) continue;
            Tr.warning((TraceComponent)tc, (String)("The " + string2 + " attribute under the transport no longer applies. Please configure this property under the Logging Service (see infocenter for more details on HTTP Access Logger)."));
        }
        return hashMap;
    }

    public void startTransports(VariableMap variableMap, ThreadPoolMgr threadPoolMgr) throws RuntimeError {
        String string;
        Property property;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startTransports");
        }
        if (isZOS) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startTransports", (Object)"zOS");
            }
            return;
        }
        String string2 = WebContainer.getWebContainerProperties().getProperty("usetransports");
        if (!isZOS && string2 == null) {
            this.transformTransportsToChains(variableMap, threadPoolMgr);
            return;
        }
        int n = 5;
        int n2 = 10;
        int n3 = 5000;
        boolean bl = false;
        String string3 = "";
        String string4 = "";
        ThreadPool threadPool = null;
        if (!isZOS) {
            object = this.webConConfig.getThreadPool();
            if (object == null) {
                throw new RuntimeError("Thread pool is not set with web container");
            }
            threadPool = threadPoolMgr.getThreadPool(THREAD_POOL_NAME, (com.ibm.websphere.models.config.process.ThreadPool)object);
        }
        object = new Properties();
        EList eList = this.webConConfig.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            property = (Property)iterator.next();
            string = property.getName();
            if (!string.equalsIgnoreCase("MaxConnectBacklog") && !string.equalsIgnoreCase("MaxKeepAliveConnections") && !string.equalsIgnoreCase("MaxKeepAliveRequests") && !string.equalsIgnoreCase("ConnectionIOTimeout") && !string.equalsIgnoreCase("ConnectionKeepAliveTimeout") && !string.equalsIgnoreCase("serverHeader") && !string.equalsIgnoreCase("TrustedProxy") && !string.equalsIgnoreCase("ErrorLog") && !string.equalsIgnoreCase("LogLevel") && !string.equalsIgnoreCase("AccessLog") && !string.equalsIgnoreCase("ErrorLogDisable") && !string.equalsIgnoreCase("AccessLogDisable")) continue;
            ((Properties)object).setProperty(string, property.getValue());
        }
        property = this.webConConfig.getTransports();
        string = null;
        int n4 = property.size();
        if (isZOS && n4 > 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebContainer.startTransports detected " + n4 + " transport ports defined. Only the first two will be started."));
            }
            n4 = 2;
        }
        for (int i = 0; i < n4; ++i) {
            Object object2;
            string = (Transport)property.get(i);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)object);
            EndPoint endPoint = string.getAddress();
            if (endPoint != null) {
                properties.put("port", "" + endPoint.getPort());
                string4 = "" + endPoint.getPort();
                if (endPoint.getHost() != null) {
                    properties.put("host", endPoint.getHost());
                    string3 = endPoint.getHost();
                } else {
                    string3 = "UNDEFINED";
                }
            }
            EList eList2 = string.getProperties();
            for (int j = 0; j < eList2.size(); ++j) {
                object2 = (Property)eList2.get(j);
                properties.put(object2.getName(), object2.getValue());
            }
            Properties properties2 = new Properties();
            if (string.isSslEnabled() && !isZOS && (object2 = string.getSslConfig()) != null) {
                properties2 = this.securityService.getSecureSocketLayer((String)object2);
                if (variableMap != null) {
                    String string5 = properties2.getProperty("com.ibm.ssl.trustStore");
                    if (string5 != null) {
                        properties2.setProperty("com.ibm.ssl.trustStore", variableMap.expand(string5));
                    }
                    if ((string5 = properties2.getProperty("com.ibm.ssl.keyStore")) != null) {
                        properties2.setProperty("com.ibm.ssl.keyStore", variableMap.expand(string5));
                    }
                }
            }
            object2 = null;
            object2 = isZOS ? (IRequestTransport)WASSystem.createObject("com.ibm.ws.webcontainer.http.os390.HttpTransport") : (IRequestTransport)WASSystem.createObject("com.ibm.ws.webcontainer.http.HttpTransport");
            try {
                object2.startTransport(threadPool, properties, (Transport)string, properties2);
                this.runningTransports.add(object2);
                continue;
            }
            catch (TransportException transportException) {
                FFDCFilter.processException((Throwable)transportException, (String)"com.ibm.ws.webcontainer.WebContainer.startTransports", (String)"501", (Object)this);
                Tr.error((TraceComponent)tc, (String)"failed.to.start.transport", (Object)new Object[]{transportException, string3, string4});
                if (tc.isDebugEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"failed.to.start.transport", (Object)new Object[]{transportException, string3, string4});
                }
                throw new RuntimeError((Throwable)transportException);
            }
        }
        this.transportsAvailable = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startTransports");
        }
    }

    public void reload(DeployedModule deployedModule) throws WebAppNotLoadedException {
        this.restartWebApplication(deployedModule);
    }

    public void restartWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
        WebAppConfiguration webAppConfiguration = webModuleMetaDataImpl.getWebAppConfig();
        String string = webAppConfiguration.getDisplayName();
        if (string == null) {
            string = deployedModule.getName();
        }
        Tr.audit((TraceComponent)tc, (String)"Restarting Module: {0}", (Object)string);
        try {
            this.removeWebApplication(deployedModule);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)("Failed to remove webmodule " + string + ". Check error logs for details"));
            exception.printStackTrace(System.err);
            return;
        }
        this.addWebApplication(deployedModule, this.production);
    }

    public boolean areTransportsAvailable() {
        return this.transportsAvailable;
    }

    public void stopTransports() {
        this.transportsAvailable = false;
        for (int i = 0; i < this.runningTransports.size(); ++i) {
            IRequestTransport iRequestTransport = (IRequestTransport)this.runningTransports.get(i);
            try {
                iRequestTransport.stopTransport();
                continue;
            }
            catch (TransportException transportException) {
                FFDCFilter.processException((Throwable)transportException, (String)"com.ibm.ws.webcontainer.WebContainer.stopTransports", (String)"261", (Object)this);
                Tr.error((TraceComponent)tc, (String)"Unabled.to.cleanly.stop.the.Transport", (Object)transportException);
            }
        }
        this.runningTransports.clear();
    }

    public void stopChains(int n) {
        if (!this.chainsAvailable) {
            return;
        }
        try {
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)this.runtimeContext.getService(ChannelFrameworkService.class);
            channelFrameworkService.stopChainsByAcceptorID(WebContainerImpl.class.getName(), (long)n);
            this.chainsAvailable = false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.WebContainerImpl.startChannels", (String)"277", (Object)this);
        }
    }

    public boolean areRequestsOutstanding() {
        return false;
    }

    public static ConnectionHandleCollaborator getConnectionHandleCollaborator() {
        return connectionHandleCollaborator;
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, WebApp webApp, String string, ArrayList[] arrayListArray) throws Throwable {
        try {
            return this.getSessionRegistry().getSessionContext(deployedModule, webApp, string, arrayListArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(IRequest var1_1, IResponse var2_2) throws IOException {
        var3_3 = null;
        var3_3 = this.getConnectionContext();
        var4_4 = new StringBuffer();
        var5_5 = var1_1.getServerName();
        if (var5_5 != null && var5_5.length() > 0) {
            if (var5_5.charAt(0) == '[' && var5_5.charAt(var5_5.length() - 1) == ']') {
                var5_5 = var5_5.substring(1, var5_5.length() - 1);
            }
            var4_4.append(var5_5);
        }
        var4_4.append(':');
        var4_4.append(var1_1.getServerPort());
        if (WebContainer.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)WebContainer.tc, (String)("Handling request with virtual host key of --> " + var4_4.toString()));
        }
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = false;
        if (WebContainer.isZOS) {
            try {
                WebContainer.Smf.webContainerDispatchBegins();
                var9_9 = true;
            }
            catch (Throwable var10_10) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("webContainerDispatchBegins() failed " + var10_10));
            }
        }
        if ((var10_11 = (StringBuffer)WebContainer.cacheKeyStringBuffer.get()) == null) {
            var10_11 = new StringBuffer();
            WebContainer.cacheKeyStringBuffer.set(var10_11);
        }
        try {
            block65: {
                if (this.securityCollaborator == null) {
                    throw new WebGroupVHostNotFoundException("Not found.");
                }
                var8_8 = this.securityCollaborator.preInvoke();
                var3_3.prepareForNextConnection(var1_1, var2_2);
                var6_6 = var3_3.getRequest();
                var7_7 = var3_3.getResponse();
                var11_12 = var6_6.getWebAppDispatcherContext();
                var12_17 = var1_1.getRequestURI();
                var13_22 = URLDecoder.decode(var12_17, WebContainer.getWebContainer().getURIEncoding());
                var6_6.getWebAppDispatcherContext().setDecodedReqUri(var13_22);
                if (WebContainer.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WebContainer.tc, (String)("webcontainer.handleRequest request uri --> (not decoded=" + var12_17 + "), (decoded=" + var13_22 + ")"));
                }
                if (this.decode) {
                    var14_27 = new String(var12_17.getBytes(this.encoding), "ISO-8859-1");
                    var6_6.setAttribute("com.ibm.websphere.servlet.uri_non_decoded", var14_27);
                }
                var10_11.append(var4_4);
                var14_27 = this.removeExtraPathInfo(var12_17);
                var15_31 = null;
                var16_32 = null;
                if (var14_27 != null) {
                    var15_31 = PathInfoHelper.access$000((PathInfoHelper)var14_27);
                    var16_32 = PathInfoHelper.access$100((PathInfoHelper)var14_27);
                    if (WebContainer.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WebContainer.tc, (String)("PathInfoHelper strippedRequestURI --> " + var15_31 + " extraPath --> " + var16_32));
                    }
                }
                var10_11.append(var15_31);
                var17_33 = (CacheServletWrapper)WebContainer._cacheMap.get(var10_11.toString());
                if (var17_33 == null) break block65;
                var18_34 = var17_33.getWebApp();
                if (WebContainer.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WebContainer.tc, (String)("Found CacheServletWrapper with key --> " + var10_11.toString()));
                }
                try {
                    if (WebContainer.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WebContainer.tc, (String)("Check if webApp destroy is happening " + var18_34.destroyed));
                    }
                    if (var18_34.destroyed.booleanValue()) {
                        var17_33.invalidate();
                        if (WebContainer.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)WebContainer.tc, (String)("sending sendUnavailableException for servlet from :" + var17_33.getServletPath()));
                        }
                        this.sendUnavailableException(var1_1, var2_2);
                    }
                    ** GOTO lbl-1000
                }
                catch (InvalidCacheTargetException var19_65) {
                    var17_33 = null;
                    var20_68 = this.requestMapper.map(var4_4.toString());
                    if (var20_68 == null) throw new WebGroupVHostNotFoundException(var4_4.toString());
                    var20_68.handleRequest((ServletRequest)var6_6, (ServletResponse)var7_7);
                    ** GOTO lbl324
                }
                catch (Throwable var19_66) {
                    var17_33.invalidate();
                    if (WebContainer.tc.isDebugEnabled() == false) throw var19_66;
                    Tr.debug((TraceComponent)WebContainer.tc, (String)"removing cache wrapper because exception was thrown and rethrowing the exception.");
                    throw var19_66;
                }
                var24_36 = null;
                ** GOTO lbl296
lbl-1000:
                // 1 sources

                {
                    var11_12.setWebApp(var17_33.getWebApp());
                    var3_3.start();
                    var19_64 = var17_33.getWebApp().getContextPath();
                    if (var19_64 == null || var19_64.equals("/")) {
                        var19_64 = "";
                    }
                    var20_67 = var17_33.getServletPath();
                    var21_69 = var19_64.length() + var20_67.length();
                    var22_70 = var13_22.substring(var21_69);
                    var11_12.setRequestURI(var12_17);
                    var11_12.setPathElements(var17_33.getServletPath(), var22_70.equals("") != false ? null : var22_70);
                    if (WebContainer.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WebContainer.tc, (String)("CachedServletWrapper servletPath --> " + var11_12.getServletPath()));
                        Tr.debug((TraceComponent)WebContainer.tc, (String)("CachedServletWrapper pathInfo --> " + var11_12.getPathInfo()));
                    }
                    var11_12.setQueryString(((SRTServletRequest)var6_6).getQueryString());
                    var17_33.handleRequest(var6_6, var7_7);
                    ** GOTO lbl324
                }
            }
            var11_12.setRequestURI(var12_17);
            var11_12.setQueryString(var1_1.getQueryString());
            if (WebContainer.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WebContainer.tc, (String)("Looking for vhost with key --> " + var4_4.toString()));
            }
            if ((var18_35 = this.requestMapper.map(var4_4.toString())) == null) throw new WebGroupVHostNotFoundException(var4_4.toString());
            var18_35.handleRequest((ServletRequest)var6_6, (ServletResponse)var7_7);
            ** GOTO lbl324
        }
        catch (WebGroupVHostNotFoundException var11_13) {
            var2_2.addHeader("Content-Type", "text/html");
            var2_2.setStatusCode(404);
            var12_18 = "<H1>" + MessageFormat.format(WebContainer.nls.getString("Web.Group.VHost.Not.Found", "WebGroup Not Found"), new Object[]{ResponseUtils.encodeDataString((String)var1_1.getRequestURI())}) + "</H1><BR><H3>" + var11_13.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
            var13_23 = var12_18.getBytes();
            var2_2.getOutputStream().write(var13_23, 0, var13_23.length);
            Tr.error((TraceComponent)WebContainer.tc, (String)"Web.Group.VHost.Not.Found", (Object)new Object[]{this.truncateURI(var1_1.getRequestURI())});
            var24_38 = null;
            try {
                this.securityCollaborator.postInvoke(var8_8);
            }
            catch (Exception var25_47) {
                FFDCFilter.processException((Throwable)var25_47, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                var26_59 /* !! */  = new Object[]{var25_47};
                Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_59 /* !! */ );
            }
            var10_11.setLength(0);
            var3_3.finishConnection();
            var25_48 = this.releaseConnectionContext(var3_3);
            if (!var25_48) {
                var3_3.destroy();
            }
            var3_3 = null;
            if (WebContainer.isZOS == false) return;
            try {
                WebContainer.intervalManager.flush();
            }
            catch (Throwable var26_59 /* !! */ ) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_59 /* !! */ ));
            }
            if (var9_9 == false) return;
            try {
                WebContainer.Smf.webContainerDispatchEnds();
                return;
            }
            catch (Throwable var26_59 /* !! */ ) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_59 /* !! */ ));
                return;
            }
        }
        catch (WebContainerException var11_14) {
            block67: {
                block66: {
                    FFDCFilter.processException((Throwable)var11_14, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"134", (Object)this);
                    var2_2.addHeader("Content-Type", "text/html");
                    var2_2.setStatusCode(500);
                    var12_19 = "<H1>" + WebContainer.nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{var11_14.getMessage()}, "Internal Server Error. <br> Exception Message: " + var11_14.getMessage()) + "</H1><BR><H3>" + var11_14.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    var13_24 = var12_19.getBytes();
                    var2_2.getOutputStream().write(var13_24, 0, var13_24.length);
                    var14_28 = new Object[]{var11_14};
                    Tr.error((TraceComponent)WebContainer.tc, (String)"Engine.Exception.[{0}]", (Object)var14_28);
                    var24_39 = null;
                    ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl160:
                    // 1 sources

                    this.securityCollaborator.postInvoke(var8_8);
                    break block66;
lbl162:
                    // 1 sources

                    catch (Exception var25_49) {
                        FFDCFilter.processException((Throwable)var25_49, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        var26_60 /* !! */  = new Object[]{var25_49};
                        Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_60 /* !! */ );
                    }
                }
                var10_11.setLength(0);
                var3_3.finishConnection();
                var25_50 = this.releaseConnectionContext(var3_3);
                if (!var25_50) {
                    var3_3.destroy();
                }
                var3_3 = null;
                if (WebContainer.isZOS == false) return;
                ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl175:
                // 1 sources

                WebContainer.intervalManager.flush();
                break block67;
lbl177:
                // 1 sources

                catch (Throwable var26_60 /* !! */ ) {
                    Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_60 /* !! */ ));
                }
            }
            if (var9_9 == false) return;
            try {}
            catch (Throwable var26_60 /* !! */ ) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_60 /* !! */ ));
                return;
            }
            WebContainer.Smf.webContainerDispatchEnds();
            return;
        }
        catch (WebSecurityException var11_15) {
            block69: {
                block68: {
                    FFDCFilter.processException((Throwable)var11_15, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"148", (Object)this);
                    var2_2.addHeader("Content-Type", "text/html");
                    var2_2.setStatusCode(403);
                    var12_20 = "<H1>" + WebContainer.nls.getString("Forbidden.Web.Security.Exception", "Forbidden: Web Security Exception") + "</H1><BR><H3>" + var11_15.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    var13_25 = var12_20.getBytes();
                    var2_2.getOutputStream().write(var13_25, 0, var13_25.length);
                    var14_29 = new Object[]{var11_15};
                    Tr.error((TraceComponent)WebContainer.tc, (String)"preInvoke.Security.Exception.", (Object)var14_29);
                    var24_40 = null;
                    ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl199:
                    // 1 sources

                    this.securityCollaborator.postInvoke(var8_8);
                    break block68;
lbl201:
                    // 1 sources

                    catch (Exception var25_51) {
                        FFDCFilter.processException((Throwable)var25_51, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        var26_61 /* !! */  = new Object[]{var25_51};
                        Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_61 /* !! */ );
                    }
                }
                var10_11.setLength(0);
                var3_3.finishConnection();
                var25_52 = this.releaseConnectionContext(var3_3);
                if (!var25_52) {
                    var3_3.destroy();
                }
                var3_3 = null;
                if (WebContainer.isZOS == false) return;
                ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl214:
                // 1 sources

                WebContainer.intervalManager.flush();
                break block69;
lbl216:
                // 1 sources

                catch (Throwable var26_61 /* !! */ ) {
                    Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_61 /* !! */ ));
                }
            }
            if (var9_9 == false) return;
            try {}
            catch (Throwable var26_61 /* !! */ ) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_61 /* !! */ ));
                return;
            }
            WebContainer.Smf.webContainerDispatchEnds();
            return;
        }
        catch (Throwable var11_16) {
            block71: {
                block70: {
                    FFDCFilter.processException((Throwable)var11_16, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"162", (Object)this);
                    var2_2.addHeader("Content-Type", "text/html");
                    var2_2.setStatusCode(500);
                    var12_21 = "<H1>" + WebContainer.nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{var11_16.getMessage()}, "Engine Exception") + "</H1><BR><H3>" + var11_16.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    var13_26 = var12_21.getBytes();
                    var2_2.getOutputStream().write(var13_26, 0, var13_26.length);
                    var14_30 = new Object[]{var11_16};
                    Tr.error((TraceComponent)WebContainer.tc, (String)"Engine.Exception.[{0}]", (Object)var14_30);
                    var24_41 = null;
                    ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl238:
                    // 1 sources

                    this.securityCollaborator.postInvoke(var8_8);
                    break block70;
lbl240:
                    // 1 sources

                    catch (Exception var25_53) {
                        FFDCFilter.processException((Throwable)var25_53, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        var26_62 /* !! */  = new Object[]{var25_53};
                        Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_62 /* !! */ );
                    }
                }
                var10_11.setLength(0);
                var3_3.finishConnection();
                var25_54 = this.releaseConnectionContext(var3_3);
                if (!var25_54) {
                    var3_3.destroy();
                }
                var3_3 = null;
                if (WebContainer.isZOS == false) return;
                ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl253:
                // 1 sources

                WebContainer.intervalManager.flush();
                break block71;
lbl255:
                // 1 sources

                catch (Throwable var26_62 /* !! */ ) {
                    Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_62 /* !! */ ));
                }
            }
            if (var9_9 == false) return;
            try {}
            catch (Throwable var26_62 /* !! */ ) {
                Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_62 /* !! */ ));
                return;
            }
            WebContainer.Smf.webContainerDispatchEnds();
            return;
        }
        {
            block77: {
                block76: {
                    block75: {
                        block74: {
                            catch (Throwable var23_71) {
                                block73: {
                                    block72: {
                                        var24_42 = null;
                                        ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl269:
                                        // 1 sources

                                        this.securityCollaborator.postInvoke(var8_8);
                                        break block72;
lbl271:
                                        // 1 sources

                                        catch (Exception var25_55) {
                                            FFDCFilter.processException((Throwable)var25_55, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                                            var26_63 /* !! */  = new Object[]{var25_55};
                                            Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_63 /* !! */ );
                                        }
                                    }
                                    var10_11.setLength(0);
                                    var3_3.finishConnection();
                                    var25_56 = this.releaseConnectionContext(var3_3);
                                    if (!var25_56) {
                                        var3_3.destroy();
                                    }
                                    var3_3 = null;
                                    if (WebContainer.isZOS == false) throw var23_71;
                                    ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl284:
                                    // 1 sources

                                    WebContainer.intervalManager.flush();
                                    break block73;
lbl286:
                                    // 1 sources

                                    catch (Throwable var26_63 /* !! */ ) {
                                        Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_63 /* !! */ ));
                                    }
                                }
                                if (var9_9 == false) throw var23_71;
                                ** try [egrp 7[TRYBLOCK] [22 : 1811->1822)] { 
lbl291:
                                // 1 sources

                                WebContainer.Smf.webContainerDispatchEnds();
                                throw var23_71;
lbl293:
                                // 1 sources

                                catch (Throwable var26_63 /* !! */ ) {
                                    Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_63 /* !! */ ));
                                }
                                throw var23_71;
                            }
lbl296:
                            // 1 sources

                            ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl297:
                            // 1 sources

                            this.securityCollaborator.postInvoke(var8_8);
                            break block74;
lbl299:
                            // 1 sources

                            catch (Exception var25_43) {
                                FFDCFilter.processException((Throwable)var25_43, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                                var26_57 /* !! */  = new Object[]{var25_43};
                                Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_57 /* !! */ );
                            }
                        }
                        var10_11.setLength(0);
                        var3_3.finishConnection();
                        var25_44 = this.releaseConnectionContext(var3_3);
                        if (!var25_44) {
                            var3_3.destroy();
                        }
                        var3_3 = null;
                        if (WebContainer.isZOS == false) return;
                        ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl312:
                        // 1 sources

                        WebContainer.intervalManager.flush();
                        break block75;
lbl314:
                        // 1 sources

                        catch (Throwable var26_57 /* !! */ ) {
                            Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_57 /* !! */ ));
                        }
                    }
                    if (var9_9 == false) return;
                    try {}
                    catch (Throwable var26_57 /* !! */ ) {
                        Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_57 /* !! */ ));
                        return;
                    }
                    WebContainer.Smf.webContainerDispatchEnds();
                    return;
lbl324:
                    // 3 sources

                    var24_37 = null;
                    ** try [egrp 5[TRYBLOCK] [20 : 1685->1699)] { 
lbl326:
                    // 1 sources

                    this.securityCollaborator.postInvoke(var8_8);
                    break block76;
lbl328:
                    // 1 sources

                    catch (Exception var25_45) {
                        FFDCFilter.processException((Throwable)var25_45, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        var26_58 /* !! */  = new Object[]{var25_45};
                        Tr.error((TraceComponent)WebContainer.tc, (String)"postInvoke.Security.Exception.", (Object)var26_58 /* !! */ );
                    }
                }
                var10_11.setLength(0);
                var3_3.finishConnection();
                var25_46 = this.releaseConnectionContext(var3_3);
                if (!var25_46) {
                    var3_3.destroy();
                }
                var3_3 = null;
                if (WebContainer.isZOS == false) return;
                ** try [egrp 6[TRYBLOCK] [21 : 1768->1777)] { 
lbl341:
                // 1 sources

                WebContainer.intervalManager.flush();
                break block77;
lbl343:
                // 1 sources

                catch (Throwable var26_58 /* !! */ ) {
                    Tr.error((TraceComponent)WebContainer.tc, (String)("intervalManager.flush() failed " + var26_58 /* !! */ ));
                }
            }
            if (var9_9 == false) return;
            try {}
            catch (Throwable var26_58 /* !! */ ) {}
            Tr.error((TraceComponent)WebContainer.tc, (String)("Smf.webContainerDispatchEnds() failed " + var26_58 /* !! */ ));
            return;
            WebContainer.Smf.webContainerDispatchEnds();
            return;
        }
    }

    public static Properties getWebContainerProperties() {
        return webConProperties;
    }

    protected SRTConnectionContext getConnectionContext() {
        SRTConnectionContext sRTConnectionContext = null;
        if (this.srtConnectionObjectPool != null) {
            sRTConnectionContext = (SRTConnectionContext)this.srtConnectionObjectPool.getObject();
        }
        if (sRTConnectionContext == null) {
            sRTConnectionContext = new SRTConnectionContext();
        }
        return sRTConnectionContext;
    }

    protected boolean releaseConnectionContext(SRTConnectionContext sRTConnectionContext) {
        if (this.srtConnectionObjectPool != null) {
            this.srtConnectionObjectPool.returnObject((Object)sRTConnectionContext);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCache(HttpServletRequest httpServletRequest, RequestProcessor requestProcessor, WebApp webApp) {
        if (_cacheIsFull) {
            return;
        }
        RequestProcessor requestProcessor2 = requestProcessor;
        synchronized (requestProcessor2) {
            StringBuffer stringBuffer = (StringBuffer)cacheKeyStringBuffer.get();
            String string = stringBuffer.toString();
            if (_cacheMap.containsKey(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Already cached cacheKey --> " + stringBuffer));
                }
                return;
            }
            if (_cacheMap.size() < invocationCacheSize) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding to cache cacheKey --> " + stringBuffer + " uri -->" + httpServletRequest.getRequestURI() + " servletWrapper -->" + ((IServletWrapper)requestProcessor).getServletName()));
                }
                CacheServletWrapper cacheServletWrapper = new CacheServletWrapper((IServletWrapper)requestProcessor, httpServletRequest, _cacheMap, stringBuffer, webApp);
            } else {
                _cacheIsFull = true;
            }
        }
    }

    public static CacheServletWrapper getFromCache(StringBuffer stringBuffer) {
        return (CacheServletWrapper)_cacheMap.get(stringBuffer.toString());
    }

    public Integer getKeySize(String string) {
        String string2 = (String)this._cipherToBit.get(string);
        if (string2 == null || string2.equals("") || string2.equals("-1")) {
            return null;
        }
        return new Integer(string2);
    }

    private void processVirtualHostExtensionFactories() {
        for (int i = 0; i < virtualHostExtFactories.size(); ++i) {
            Object[] objectArray;
            ExtensionFactory extensionFactory = (ExtensionFactory)virtualHostExtFactories.get(i);
            try {
                ExtensionProcessor extensionProcessor = extensionFactory.createExtensionProcessor(null);
                objectArray = extensionFactory.getPatternList().iterator();
                while (objectArray.hasNext()) {
                    String string = (String)objectArray.next();
                    this.requestMapper.addMapping(string, extensionProcessor);
                }
                continue;
            }
            catch (Exception exception) {
                objectArray = new Object[]{exception};
                Tr.error((TraceComponent)tc, (String)"Engine.Exception.[{0}]", (Object)objectArray);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"1829", (Object)this);
            }
        }
    }

    public static void addVirtualHostExtensionFactory(ExtensionFactory extensionFactory) {
        List list = extensionFactory.getPatternList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer(32);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("VH:" + string);
            stringBuffer.append(' ');
        }
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].registered.successfully", (Object)new Object[]{extensionFactory.getClass().toString()});
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].associated.with.patterns.[{1}]", (Object)new Object[]{extensionFactory.getClass().toString(), stringBuffer.toString()});
        virtualHostExtFactories.add(extensionFactory);
    }

    public static void addExtensionFactory(ExtensionFactory extensionFactory) {
        List list = extensionFactory.getPatternList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer(32);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].registered.successfully", (Object)new Object[]{extensionFactory.getClass().toString()});
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].associated.with.patterns.[{1}]", (Object)new Object[]{extensionFactory.getClass().toString(), stringBuffer.toString()});
        extensionFactories.add(extensionFactory);
    }

    public static void addHttpServletResponseListener(IHttpServletResponseListener iHttpServletResponseListener) {
        if (iHttpServletResponseListener != null) {
            httpResponseListeners.add(iHttpServletResponseListener);
        }
    }

    public static void notifyHttpServletResponseListenersPreHeaderCommit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!httpResponseListeners.isEmpty()) {
            Iterator iterator = httpResponseListeners.iterator();
            while (iterator.hasNext()) {
                IHttpServletResponseListener iHttpServletResponseListener = (IHttpServletResponseListener)iterator.next();
                iHttpServletResponseListener.preHeaderCommit(httpServletRequest, httpServletResponse);
            }
        }
    }

    public void reap() {
        long l = System.currentTimeMillis();
        try {
            Iterator iterator = this.requestMapper.targetMappings();
            Iterator iterator2 = null;
            Iterator iterator3 = null;
            Iterator iterator4 = null;
            VirtualHost virtualHost = null;
            WebGroup webGroup = null;
            WebApp webApp = null;
            ArrayList arrayList = null;
            RequestProcessor requestProcessor = null;
            IServletWrapper iServletWrapper = null;
            ServletWrapper servletWrapper = null;
            IServletConfig iServletConfig = null;
            List list = null;
            ServletMapping servletMapping = null;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof VirtualHost)) continue;
                virtualHost = (VirtualHost)e;
                iterator2 = virtualHost.getRequestMapper().targetMappings();
                while (iterator2.hasNext()) {
                    webGroup = (WebGroup)iterator2.next();
                    arrayList = webGroup.getWebApps();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        webApp = (WebApp)arrayList.get(i);
                        iterator3 = webApp.getRequestMapper().targetMappings();
                        while (iterator3.hasNext()) {
                            requestProcessor = (RequestProcessor)iterator3.next();
                            if (!(requestProcessor instanceof IServletWrapper) || l - this.reaperInactiveLimit <= (iServletWrapper = (IServletWrapper)requestProcessor).getLastAccessTime()) continue;
                            if (iServletWrapper instanceof ServletWrapper) {
                                servletWrapper = (ServletWrapper)iServletWrapper;
                                Tr.audit((TraceComponent)tc, (String)"reaper.unloading.servlet.[{0}]", (Object)iServletWrapper.getServletName());
                                servletWrapper.unload();
                                continue;
                            }
                            iServletConfig = (IServletConfig)iServletWrapper.getServletConfig();
                            if (iServletConfig == null) continue;
                            list = iServletConfig.getMappings();
                            if (list != null) {
                                iterator4 = list.iterator();
                                while (iterator4.hasNext()) {
                                    servletMapping = (ServletMapping)iterator4.next();
                                    Tr.audit((TraceComponent)tc, (String)"reaper.removing.mapping.[{0}].for.servlet.[{1}]", (Object)new Object[]{servletMapping.getUrlPattern(), iServletWrapper.getServletName()});
                                    webApp.getRequestMapper().removeMapping(servletMapping.getUrlPattern());
                                }
                            } else {
                                webApp.getRequestMapper().removeMapping(iServletConfig.getFileName());
                            }
                            Tr.audit((TraceComponent)tc, (String)"reaper.destroying.servlet.[{0}]", (Object)iServletWrapper.getServletName());
                            iServletWrapper.destroy();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"1114", (Object)this);
            exception.printStackTrace(System.err);
            Tr.error((TraceComponent)tc, (String)"reaper.thread.error");
        }
        this.reaperAlarm = ReaperAlarmListener.startReaperAlarm(this, this.reaperInterval);
    }

    public static List getApplicationListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return applicationListeners;
    }

    public static List getServletErrorListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletErrorListeners;
    }

    public static List getServletInvocationListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletInvocationListeners;
    }

    public static List getServletContextAttributeListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextAttributeListeners;
    }

    public static List getServletContextListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextListeners;
    }

    public static List getServletRequestAttributeListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestAttributeListeners;
    }

    public static List getServletRequestListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestListeners;
    }

    public static List getSessionListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionListeners;
    }

    public static List getSessionAttributeListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionAttributeListeners;
    }

    public static List getServletListeners() {
        if (!listenersInitialized) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletListeners;
    }

    public List getTransports() {
        return this.runningTransports;
    }

    private String truncateURI(String string) {
        if (string.length() > 128) {
            string = string.substring(0, 127);
        }
        return string;
    }

    public String getURIEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        if (!isZOS) {
            this.encoding = "UTF-8";
            this.decode = true;
        } else {
            this.encoding = "UTF-8";
            this.decode = false;
        }
        Properties properties = WebContainer.getWebContainerProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase("DecodeUrlAsUTF8") || !(string = properties.getProperty(string2, "true")).equalsIgnoreCase("false")) continue;
            this.encoding = ISO;
            this.decode = false;
        }
        return this.encoding;
    }

    public boolean isEnableSecurityAtWARBoundary() {
        return this.enableSecurityAtWARBoundary;
    }

    public boolean isEnableSecurityAtEARBoundary() {
        return this.enableSecurityAtEARBoundary;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public static void setTempDir(String string) {
        tempDir = string;
    }

    public static boolean isDefaultTempDir() {
        return isDefaultTempDir;
    }

    public static void setIsDefaultTempDir(boolean bl) {
        isDefaultTempDir = bl;
    }

    private PathInfoHelper removeExtraPathInfo(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            return new PathInfoHelper(string2, string3);
        }
        return new PathInfoHelper(string, null);
    }

    static {
        listenersInitialized = false;
        webConProperties = new Properties();
        extensionFactories = new ArrayList();
        httpResponseListeners = new ArrayList();
        virtualHostExtFactories = new ArrayList();
        Smf = null;
        intervalManager = null;
        invocationCacheSize = 50;
        String string = System.getProperty("invocationCacheSize");
        if (string != null) {
            try {
                invocationCacheSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                invocationCacheSize = 50;
            }
        }
        invocationCacheSize *= 10;
        if (isZOS) {
            Smf = SmfWebContainerDataCollectorFactory.getInstance();
            intervalManager = SmfWebContainerDataCollectorIntervalManager.getInstance();
        }
        _cacheMap = new URIToServletWrapperCache(invocationCacheSize);
        _cacheIsFull = false;
    }

    private class PathInfoHelper {
        private String basePath = null;
        private String extraPathInfo = null;

        private PathInfoHelper(String string, String string2) {
            this.basePath = string;
            this.extraPathInfo = string2;
        }

        private String getExtraPathInfo() {
            return this.extraPathInfo;
        }

        private String getBasePath() {
            return this.basePath;
        }

        static /* synthetic */ String access$000(PathInfoHelper pathInfoHelper) {
            return pathInfoHelper.getBasePath();
        }

        static /* synthetic */ String access$100(PathInfoHelper pathInfoHelper) {
            return pathInfoHelper.getExtraPathInfo();
        }
    }
}

