/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.pmi.WebAppPerf;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;

public class WebAppPmiListener
implements ServletListener,
ServletInvocationListener,
ServletErrorListener,
ApplicationListener {
    J2EEName _appName = null;
    boolean areAppAggregatesInited = false;
    WebAppPerf appPmi = null;

    public void onApplicationAvailableForService(ApplicationEvent applicationEvent) {
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
    }

    public void onApplicationUnavailableForService(ApplicationEvent applicationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onApplicationUnavailableForService();
        }
    }

    public void onApplicationStart(ApplicationEvent applicationEvent) {
        String string = (String)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.application.host");
        WebApp webApp = (WebApp)applicationEvent.getSource();
        WebAppConfiguration webAppConfiguration = webApp.getConfiguration();
        ModuleMetaData moduleMetaData = webApp.getModuleMetaData();
        this._appName = moduleMetaData.getJ2EEName();
        ServletContextEventSource servletContextEventSource = (ServletContextEventSource)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
        servletContextEventSource.addServletErrorListener((ServletErrorListener)this);
        servletContextEventSource.addServletListener((ServletListener)this);
        servletContextEventSource.addServletInvocationListener((ServletInvocationListener)this);
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
        if (this.appPmi != null) {
            this.appPmi.onApplicationStart();
        }
    }

    public void onApplicationEnd(ApplicationEvent applicationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onApplicationEnd();
            PmiFactory.removePmiModule((Object)this.appPmi);
        }
    }

    public void onServletStartService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletStartService(servletInvocationEvent.getServletName());
        }
    }

    public void onServletFinishService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishService(servletInvocationEvent.getServletName(), servletInvocationEvent.getResponseTime());
        }
    }

    public void onServletStartInit(ServletEvent servletEvent) {
        WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2EEName = webComponentMetaData.getJ2EEName();
        if (this.appPmi != null) {
            this.appPmi.onServletStartInit(j2EEName.toString(), servletEvent.getServletName());
        }
    }

    public void onServletFinishInit(ServletEvent servletEvent) {
        WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (this.appPmi != null) {
            this.appPmi.onServletFinishInit(servletEvent.getServletName());
        }
    }

    public void onServletStartDestroy(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletStartDestroy(servletEvent.getServletName());
        }
    }

    public void onServletFinishDestroy(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishDestroy(servletEvent.getServletName());
        }
    }

    public void onServletUnloaded(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnloaded(servletEvent.getServletName());
        }
    }

    public void onServletAvailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletAvailableForService(servletEvent.getServletName());
        }
    }

    public void onServletUnavailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnavailableForService(servletEvent.getServletName());
        }
    }

    public void onServletInitError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletInitError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceDenied(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceDenied(servletErrorEvent.getServletName());
        }
    }

    public void onServletDestroyError(ServletErrorEvent servletErrorEvent) {
        if (servletErrorEvent != null && servletErrorEvent.getServletName() != null && this.appPmi != null) {
            this.appPmi.onServletDestroyError(servletErrorEvent.getServletName());
        }
    }

    public void InitializeAppCounters(String string) {
        this.appPmi = PmiFactory.createWebAppPerf((String)string);
    }

    public String getAppName() {
        return this._appName.toString();
    }
}

