/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.sdo;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.wsspi.sib.sdo.DataMediatorFactory;
import com.ibm.wsspi.sib.sdo.DataMediatorNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public abstract class DataMediatorRegistry {
    private static final TraceComponent tc = SibTr.register(DataMediatorRegistry.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private static String className = "com.ibm.ws.sib.sdo.config.impl.DataMediatorRegistryImpl";
    private static DataMediatorRegistry instance;
    private static Properties properties;

    public static DataMediatorRegistry instance() {
        return instance;
    }

    public void init() throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "init");
        }
        try {
            Properties properties = DataMediatorRegistry.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.register(string, properties.getProperty(string));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.sib.sdo.DataMediatorRegistry.init", (String)"105", (Object)this);
            throw new DataMediatorException(iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "init");
        }
    }

    public abstract void register(String var1, String var2) throws DataMediatorException;

    public abstract void deregister(String var1) throws DataMediatorException;

    public abstract DataMediatorFactory getDataMediatorFactory(String var1) throws DataMediatorException;

    public DataMediator getMediator(String string, String string2) throws DataMediatorException {
        DataMediatorFactory dataMediatorFactory;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMediator", new Object[]{string, string2});
        }
        if ((dataMediatorFactory = this.getDataMediatorFactory(string)) == null) {
            throw new DataMediatorNotFoundException(string);
        }
        DataMediator dataMediator = dataMediatorFactory.getDataMediator(string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMediator", dataMediator);
        }
        return dataMediator;
    }

    public DataMediator getMediator(String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMediator", (Object)string);
        }
        String string2 = string;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            string = null;
        }
        DataMediator dataMediator = this.getMediator(string2, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMediator", dataMediator);
        }
        return dataMediator;
    }

    public abstract void clear();

    static Properties getProperties() throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getProperties");
        }
        if (properties == null) {
            InputStream inputStream = DataMediatorRegistry.class.getClassLoader().getResourceAsStream("com/ibm/wsspi/sib/sdo/registry.properties");
            properties = new Properties();
            properties.load(inputStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getProperties", properties);
        }
        return properties;
    }

    static {
        try {
            instance = (DataMediatorRegistry)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sib.sdo.DataMediatorRegistry.instance", (String)"64");
            throw new RuntimeException("Creating DataMediatorRegistry: " + exception);
        }
        try {
            instance.init();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sib.sdo.DataMediatorRegistry.instance", (String)"71");
            throw new RuntimeException("Initialising DataMediatorRegistry: " + exception);
        }
    }
}

