/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.core.selector;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.core.selector.PrivateFactoryType;
import com.ibm.ws.sib.ra.SibRaFactory;
import com.ibm.ws.sib.trm.TrmSICoreConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import java.util.Collections;
import java.util.Map;

public final class SICoreConnectionFactorySelector {
    private static final String TRACE_MESSAGES = "com.ibm.wsspi.sib.core.selector.Messages";
    private static final String TRACE_GROUP = "SIBCore";
    private static final TraceComponent _tc = SibTr.register(SICoreConnectionFactorySelector.class, "SIBCore", "com.ibm.wsspi.sib.core.selector.Messages");
    private static final TraceNLS _nls = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.selector.Messages");

    public static final SICoreConnectionFactory getSICoreConnectionFactory(FactoryType factoryType) throws SIInsufficientDataForFactoryTypeException, SIIncorrectCallException, SIResourceException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry(_tc, "getSICoreConnectionFactory", factoryType);
        }
        SICoreConnectionFactory sICoreConnectionFactory = null;
        try {
            sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory(factoryType, Collections.EMPTY_MAP);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)"com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector.getSICoreConnectionFactory", (String)"151");
            if (_tc.isEventEnabled()) {
                SibTr.event(_tc, "rethrowing", sIIncorrectCallException);
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit(_tc, "getSICoreConnectionFactory");
            }
            throw sIIncorrectCallException;
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector.getSICoreConnectionFactory", (String)"151");
            if (_tc.isEventEnabled()) {
                SibTr.event(_tc, "rethrowing", sIResourceException);
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit(_tc, "getSICoreConnectionFactory");
            }
            throw sIResourceException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit(_tc, "getSICoreConnectionFactory", sICoreConnectionFactory);
        }
        return sICoreConnectionFactory;
    }

    public static final SICoreConnectionFactory getSICoreConnectionFactory(FactoryType factoryType, Map map) throws SIInsufficientDataForFactoryTypeException, SIIncorrectCallException, SIResourceException {
        SICoreConnectionFactory sICoreConnectionFactory = null;
        if (_tc.isEntryEnabled()) {
            SibTr.entry(_tc, "getSICoreConnectionFactory", new Object[]{factoryType, map});
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        if (factoryType == FactoryType.TRM_CONNECTION) {
            sICoreConnectionFactory = TrmSICoreConnectionFactory.getInstance();
        } else if (factoryType == PrivateFactoryType.LOCAL_CONNECTION) {
            String string = (String)map.get("BUS_NAME");
            String string2 = (String)map.get("ME_NAME");
            if (string == null || string2 == null) {
                String string3;
                String string4;
                if (string == null && string2 == null) {
                    string4 = _nls.getString("BUS_AND_ME_NAMES_ARE_NULL_CWSJC0001E");
                    string3 = "Both the Bus and ME names are null";
                } else if (string == null) {
                    string4 = _nls.getFormattedMessage("BUS_NAME_IS_NULL_CWSJC0002E", new Object[]{string2}, null);
                    string3 = "The bus name is null";
                } else {
                    string4 = _nls.getFormattedMessage("ME_NAME_IS_NULL_CWSJC0003E", new Object[]{string}, null);
                    string3 = "The ME name is null";
                }
                if (_tc.isDebugEnabled()) {
                    SibTr.debug(_tc, string3);
                }
                SIInsufficientDataForFactoryTypeException sIInsufficientDataForFactoryTypeException = new SIInsufficientDataForFactoryTypeException(string4);
                if (_tc.isEventEnabled()) {
                    SibTr.event(_tc, "throwing", sIInsufficientDataForFactoryTypeException);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit(_tc, "getSICoreConnectionFactory");
                }
                throw sIInsufficientDataForFactoryTypeException;
            }
            JsAdminService jsAdminService = JsAdminService.getInstance();
            if (jsAdminService == null) {
                if (_tc.isDebugEnabled()) {
                    SibTr.debug(_tc, "Unable to contact the admin service");
                }
                SIResourceException sIResourceException = new SIResourceException(_nls.getFormattedMessage("ADMIN_SERVICE_NULL_CWSJC0004E", new Object[]{string, string2}, null));
                if (_tc.isEventEnabled()) {
                    SibTr.event(_tc, "throwing", sIResourceException);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit(_tc, "getSICoreConnectionFactory");
                }
                throw sIResourceException;
            }
            JsMessagingEngine jsMessagingEngine = jsAdminService.getMessagingEngine(string, string2);
            if (jsMessagingEngine == null) {
                if (_tc.isDebugEnabled()) {
                    SibTr.debug(_tc, "Messaging Engine does not exists");
                }
                SIResourceException sIResourceException = new SIResourceException(_nls.getFormattedMessage("ME_NOT_FOUND_CWSJC0005E", new Object[]{string, string2}, null));
                if (_tc.isEventEnabled()) {
                    SibTr.event(_tc, "throwing", sIResourceException);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit(_tc, "getSICoreConnectionFactory");
                }
                throw sIResourceException;
            }
            sICoreConnectionFactory = (SICoreConnectionFactory)((Object)jsMessagingEngine.getMessageProcessor());
        } else if (factoryType == FactoryType.RA_CONNECTION) {
            sICoreConnectionFactory = SibRaFactory.getConnectionFactory(map);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit(_tc, "getSICoreConnectionFactory", sICoreConnectionFactory);
        }
        return sICoreConnectionFactory;
    }
}

