/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sdo.config.repository;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.RepositoryException;
import com.ibm.wsspi.sdo.config.repository.RepositoryResourceNotFoundException;
import com.ibm.wsspi.sib.sdo.SystemSDORepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class SDORepository {
    private static final TraceComponent tc = SibTr.register(SDORepository.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private static String className = "com.ibm.ws.sdo.config.repository.impl.SDORepositoryImpl";
    private static SystemSDORepository instance;

    public static SystemSDORepository instance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "instance");
        }
        if (instance == null) {
            try {
                instance = (SystemSDORepository)Class.forName(className).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sdo.config.repository.SDORepository.instance", (String)"72");
                throw new RuntimeException("Creating SDORepository: " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "instance", instance);
        }
        return instance;
    }

    public abstract InputStream getInputStream(String var1) throws RepositoryResourceNotFoundException;

    public abstract OutputStream getOutputStream(String var1, boolean var2) throws RepositoryException;

    public abstract Resource getResource(String var1) throws IOException, RepositoryResourceNotFoundException;

    public abstract void putResource(Resource var1, String var2, boolean var3) throws RepositoryException, IOException;

    public abstract void putResource(Resource var1, String var2, boolean var3, boolean var4) throws RepositoryException, IOException;

    public abstract void remove(String var1, boolean var2) throws IOException, RepositoryException;

    public abstract List listResources();

    public abstract Long getTimestamp(String var1);
}

