/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.collections.linkedlist;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.collections.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class Link {
    private static final String HEAD = "Head";
    private static final String LINKED = "Linked";
    private static final String LOGICALLY_UNLINKED = "LogicallyUnlinked";
    private static final String PHYSICALLY_UNLINKED = "PhysicallyUnlinked";
    private static final String TAIL = "Tail";
    private static TraceComponent tc = SibTr.register(Link.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private int _cursorCount = 0;
    private Link _nextLink;
    private LinkedList _parent;
    private Link _previousLink;
    private String _state = "PhysicallyUnlinked";

    final Link _getNextLink() {
        return this._nextLink;
    }

    final Link _getPreviousLink() {
        return this._previousLink;
    }

    final void _link(Link link, Link link2, LinkedList linkedList) {
        if (PHYSICALLY_UNLINKED != this._state) {
            throw new RuntimeException(this._state);
        }
        this._nextLink = link2;
        this._previousLink = link;
        this._parent = linkedList;
        this._state = LINKED;
    }

    final String _positionString() {
        Link link;
        StringBuffer stringBuffer = new StringBuffer();
        this._shortDebugString(stringBuffer);
        stringBuffer.append(" Forward:");
        int n = 10;
        for (link = this._getNextLink(); null != link && 0 < n--; link = link._getNextLink()) {
            stringBuffer.append(" ");
            link._shortDebugString(stringBuffer);
        }
        stringBuffer.append("; Backward:");
        n = 10;
        for (link = this._getPreviousLink(); null != link && 0 < n--; link = link._getPreviousLink()) {
            stringBuffer.append(" ");
            link._shortDebugString(stringBuffer);
        }
        return stringBuffer.toString();
    }

    final void _setAsHead(LinkedList linkedList, Link link) {
        this._nextLink = link;
        this._parent = linkedList;
        this._state = HEAD;
    }

    final void _setAsTail(LinkedList linkedList, Link link) {
        this._previousLink = link;
        this._parent = linkedList;
        this._state = TAIL;
    }

    final void _setNextLink(Link link) {
        this._nextLink = link;
    }

    final void _setPreviousLink(Link link) {
        this._previousLink = link;
    }

    final void _shortDebugString(StringBuffer stringBuffer) {
        long l = this.getSequence();
        if (-1L != l) {
            stringBuffer.append(l);
        }
        stringBuffer.append("(");
        stringBuffer.append(this._state);
        stringBuffer.append(")");
    }

    private final void _tryUnlink() {
        if (0 >= this._cursorCount && this._state == LOGICALLY_UNLINKED) {
            this._previousLink._nextLink = this._nextLink;
            this._nextLink._previousLink = this._previousLink;
            this._previousLink = null;
            this._nextLink = null;
            this._state = PHYSICALLY_UNLINKED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cursorRemoved() {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cursorRemoved");
        }
        if (null != (linkedList = this._parent)) {
            LinkedList linkedList2 = linkedList;
            synchronized (linkedList2) {
                if (LINKED == this._state || LOGICALLY_UNLINKED == this._state) {
                    --this._cursorCount;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "cursorCount decrement to " + this._cursorCount);
                    }
                    this._tryUnlink();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cursorRemoved");
        }
    }

    final void decrementCursorCount() {
        --this._cursorCount;
        this._tryUnlink();
    }

    public final int getCursorCount() {
        return this._cursorCount;
    }

    public final Link getNextLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextLink", this._positionString());
        }
        Link link = null;
        LinkedList linkedList = this._parent;
        if (null != linkedList) {
            link = this._parent.getNextLink(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextLink", link);
        }
        return link;
    }

    public final Link getNextPhysicalLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextPhysicalLink", this._positionString());
        }
        Link link = this._nextLink;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextPhysicalLink", link);
        }
        return link;
    }

    public final LinkedList getOwningList() {
        return this._parent;
    }

    public long getSequence() {
        return -1L;
    }

    final void incrementCursorCount() {
        ++this._cursorCount;
    }

    public final boolean isLinked() {
        return LINKED == this._state;
    }

    public final boolean isLogicallyUnlinked() {
        return LOGICALLY_UNLINKED == this._state;
    }

    public final boolean isPhysicallyUnlinked() {
        return PHYSICALLY_UNLINKED == this._state;
    }

    public final boolean isTail() {
        return TAIL == this._state;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Link link = this._previousLink;
        if (null != link) {
            link._shortDebugString(stringBuffer);
            stringBuffer.append("?<-");
        }
        this._shortDebugString(stringBuffer);
        link = this._nextLink;
        if (null != link) {
            stringBuffer.append("?->");
            link._shortDebugString(stringBuffer);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unlink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlink", this._positionString());
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "cursor count = " + this._cursorCount);
        }
        boolean bl = false;
        LinkedList linkedList = this._parent;
        if (null != linkedList) {
            LinkedList linkedList2 = linkedList;
            synchronized (linkedList2) {
                if (LINKED == this._state) {
                    this._state = LOGICALLY_UNLINKED;
                    this._tryUnlink();
                    bl = true;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "unlink while " + this._state);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlink", new Object[]{new Boolean(bl), this._positionString()});
        }
        return bl;
    }

    protected void xmlWriteAttributesOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write(" linkState=\"");
        formattedWriter.write(this._state);
        formattedWriter.write("\" cursorCount=\"");
        formattedWriter.write(Integer.toString(this._cursorCount));
        formattedWriter.write("\" sihc=\"");
        formattedWriter.write(Integer.toHexString(System.identityHashCode(this)));
        formattedWriter.write("\" ");
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        String string = "link";
        formattedWriter.write("<");
        formattedWriter.write(string);
        this.xmlWriteAttributesOn(formattedWriter);
        formattedWriter.write(" />");
    }
}

