/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Semaphore {
    private static final TraceComponent tc = SibTr.register(Semaphore.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private int count = 0;

    public Semaphore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.count = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public Semaphore(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", (Object)("" + n));
        }
        this.count = -n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public synchronized void waitOn() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "waitOn", (Object)("" + this.count));
        }
        ++this.count;
        if (this.count > 0) {
            int n = this.count--;
            this.wait();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "waitOn");
        }
    }

    public synchronized void post() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "post", (Object)("" + this.count));
        }
        --this.count;
        if (this.count >= 0) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "post");
        }
    }

    public synchronized void waitOnIgnoringInterruptions() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "waitOnIgnoringInterruptions");
        }
        do {
            bl = false;
            try {
                this.waitOn();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "waitOnIgnoringInterruptions");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.utils/src/com/ibm/ws/sib/utils/Semaphore.java, SIB.utils, WAS602.SIB, o0610.11 1.9");
        }
    }
}

