/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.Internals;
import com.ibm.ws.sib.utils.Runtime;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public final class RuntimeInfo {
    private static final String className = RuntimeInfo.class.getName();
    private static final TraceComponent tc = SibTr.register(className, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private static boolean isClustered;
    private static boolean isServer;
    private static boolean isClientContainer;
    private static boolean isThinClient;
    private static final String COMPONENTIMPL = "com.ibm.ws.sib.utils.ComponentImpl";
    private static Properties sib_properties;
    private static Properties sib_config_properties;
    private static boolean initialised;
    public static final String SIB_PROPERTY_SEPARATOR = ".";
    public static final String SIB_PROPERTY_PREFIX = "sib.";

    public static boolean isClusteredServer() {
        return isClustered;
    }

    public static boolean isServer() {
        return isServer;
    }

    public static boolean isClientContainer() {
        return isClientContainer;
    }

    public static boolean isThinClient() {
        return isThinClient;
    }

    public static String getProperty(String string) {
        return RuntimeInfo.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getProperty");
        }
        if (!initialised) {
            object = Thread.currentThread().getContextClassLoader();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction((ClassLoader)object){
                    private final /* synthetic */ ClassLoader val$cl;
                    {
                        this.val$cl = classLoader;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Properties properties;
                        URL uRL = this.val$cl.getResource("sib.config.properties");
                        if (uRL != null) {
                            try {
                                properties = sib_config_properties;
                                synchronized (properties) {
                                    sib_config_properties.load(uRL.openStream());
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)(className + ".getProperty"), (String)"3");
                                SibTr.exception(tc, exception);
                            }
                        }
                        if ((uRL = this.val$cl.getResource("sib.properties")) != null) {
                            try {
                                properties = sib_properties;
                                synchronized (properties) {
                                    sib_properties.load(uRL.openStream());
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)(className + ".getProperty"), (String)"1");
                                SibTr.exception(tc, exception);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".getProperty"), (String)"2");
                SibTr.exception(tc, exception);
            }
            initialised = true;
        }
        if ((object = (String)sib_config_properties.get(string)) == null) {
            object = (String)sib_properties.get(string);
        }
        if (object == null) {
            object = System.getProperty(string);
        }
        if (object == null) {
            object = string2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, string + "=" + (String)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getProperty");
        }
        return object;
    }

    public static String getPropertyWithMsg(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getPropertyWithMsg");
        }
        if (!(string3 = RuntimeInfo.getProperty(string, string2)).equals(string2)) {
            Runtime.changedPropertyValue(string, string3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getPropertyWithMsg");
        }
        return string3;
    }

    static {
        try {
            Class<?> clazz = Class.forName(COMPONENTIMPL);
            Internals internals = (Internals)clazz.newInstance();
            isClustered = internals.isClustered();
            isServer = internals.isServer();
        }
        catch (Exception exception) {
            SibTr.exception(tc, exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            SibTr.exception(tc, noClassDefFoundError);
        }
        if (!isClustered && !isServer) {
            if (System.getProperty("com.ibm.ws.container") != null && System.getProperty("com.ibm.ws.container").equals("client")) {
                isClientContainer = true;
            } else {
                isThinClient = true;
            }
        }
        sib_properties = new Properties();
        sib_config_properties = new Properties();
        initialised = false;
    }
}

