/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.ClientComponentHandshake;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.ClientConnectionFactory;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.EndPoint;
import com.ibm.ws.sib.mfp.trm.TrmClientAttachReply;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapReply;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.trm.TrmSICoreConnectionFactory;
import com.ibm.ws.sib.trm.client.ClientAttachHandler;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.ClientBootstrapHandler;
import com.ibm.ws.sib.trm.client.ClientHandler;
import com.ibm.ws.sib.trm.client.CredentialType;
import com.ibm.ws.sib.trm.client.FindTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.LocalConnectScope;
import com.ibm.ws.sib.trm.client.LocalTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.RemoteTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.TargetMessagingEngine;
import com.ibm.ws.sib.trm.client.TrmEndPoint;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.client.XMLEndPointFactory;
import com.ibm.ws.sib.trm.wlm.client.Select;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public final class TrmSICoreConnectionFactoryImpl2
extends TrmSICoreConnectionFactory {
    public static final String $ssccid = "@(#) 1.60.1.2 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/TrmSICoreConnectionFactoryImpl2.java, SIB.trm, WAS602.SIB, o0610.11 06/01/06 04:48:32 [3/13/06 13:38:59]";
    private static final String className = TrmSICoreConnectionFactoryImpl2.class.getName();
    private static final TraceComponent tc = SibTr.register(className, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static boolean enableXMemChannel;
    private static final String enableXMemChannelName = "sib.trm.enableXMemChannel";
    private static final String enableXMemChannelDefault = "true";

    public SICoreConnection createConnection(Subject subject, Map map) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        SICoreConnection sICoreConnection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createConnection");
        }
        sICoreConnection = this.createConnection(new CredentialType(subject), map);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnection");
        }
        return sICoreConnection;
    }

    public SICoreConnection createConnection(String string, String string2, Map map) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        SICoreConnection sICoreConnection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createConnection");
        }
        sICoreConnection = this.createConnection(new CredentialType(string, string2), map);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnection");
        }
        return sICoreConnection;
    }

    private SICoreConnection createConnection(CredentialType credentialType, Map map) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        Object object;
        SICoreConnection sICoreConnection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createConnection");
        }
        ClientAttachProperties clientAttachProperties = new ClientAttachProperties(map);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + clientAttachProperties.getBusName());
        }
        if (RuntimeInfo.isClusteredServer() || RuntimeInfo.isServer()) {
            TargetMessagingEngine targetMessagingEngine;
            object = LocalConnectScope.PROCESS;
            if (enableXMemChannel) {
                object = LocalConnectScope.SERVER;
            }
            if ((targetMessagingEngine = new FindTargetMessagingEngine().resolve(clientAttachProperties.getBusName(), clientAttachProperties.getTargetGroupName(), clientAttachProperties.getTargetGroupType(), clientAttachProperties.getTargetSignificance(), clientAttachProperties.getTargetTransportChain(), clientAttachProperties.getConnectionProximity(), (LocalConnectScope)object, clientAttachProperties.getConnectionMode().equals("Recovery"), true, true)).isLocal()) {
                sICoreConnection = this.localAttach(credentialType, clientAttachProperties, (LocalTargetMessagingEngine)targetMessagingEngine);
            } else if (targetMessagingEngine.isRemote()) {
                sICoreConnection = this.remoteAttach(credentialType, clientAttachProperties, (RemoteTargetMessagingEngine)targetMessagingEngine);
            }
            if (sICoreConnection == null && clientAttachProperties.isUserDefinedProviderEPs()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Falling back to remote (client) connection attempt");
                }
                sICoreConnection = this.remoteBootstrap(credentialType, clientAttachProperties);
            }
        } else {
            sICoreConnection = this.remoteBootstrap(credentialType, clientAttachProperties);
        }
        if (sICoreConnection == null) {
            object = Select.fromBus(clientAttachProperties.getBusName()) == null ? nls.getFormattedMessage("NO_MES_STARTED_CWSIT0088", new Object[]{clientAttachProperties.getBusName()}, null) : nls.getFormattedMessage("NO_SUITABLE_ME_CWSIT0019", new Object[]{clientAttachProperties.getBusName()}, null);
            throw new SIResourceException((String)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnection", (Object)("sc=" + sICoreConnection));
        }
        return sICoreConnection;
    }

    private SICoreConnection localAttach(CredentialType credentialType, ClientAttachProperties clientAttachProperties, LocalTargetMessagingEngine localTargetMessagingEngine) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        SICoreConnection sICoreConnection = null;
        JsMessagingEngine jsMessagingEngine = localTargetMessagingEngine.getLocal();
        SibTr.push(jsMessagingEngine);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "localAttach");
        }
        JsEngineComponent jsEngineComponent = jsMessagingEngine.getMessageProcessor();
        SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)((Object)jsEngineComponent);
        sICoreConnection = credentialType.getSubject() != null ? sICoreConnectionFactory.createConnection(credentialType.getSubject(), clientAttachProperties.getProperties()) : sICoreConnectionFactory.createConnection(credentialType.getUserid(), credentialType.getPassword(), clientAttachProperties.getProperties());
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "sc=" + sICoreConnection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "localAttach");
        }
        SibTr.pop();
        return sICoreConnection;
    }

    private SICoreConnection remoteAttach(CredentialType credentialType, ClientAttachProperties clientAttachProperties, RemoteTargetMessagingEngine remoteTargetMessagingEngine) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        SICoreConnection sICoreConnection = null;
        int n = -1;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remoteAttach");
        }
        ClientConnection clientConnection = null;
        ClientConnectionFactory clientConnectionFactory = ClientConnectionFactory.getReference();
        if (clientConnectionFactory == null) {
            throw new SIErrorException(nls.getString("NO_CCF_CWSIT0004"));
        }
        clientConnection = clientConnectionFactory.createClientConnection();
        if (clientConnection != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "enableXMemChannel=" + enableXMemChannel + ",isLocalServer=" + remoteTargetMessagingEngine.inLocalServer());
            }
            ConnectionProperties connectionProperties = null;
            if (!enableXMemChannel || !remoteTargetMessagingEngine.inLocalServer()) {
                if (remoteTargetMessagingEngine.getEndPoint() != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Using conventional inter-process communications");
                    }
                    connectionProperties = new ConnectionProperties(remoteTargetMessagingEngine.getEndPoint());
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Required end point is missing");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Using high performance X-memory communications");
                }
                connectionProperties = new ConnectionProperties();
            }
            if (connectionProperties != null) {
                connectionProperties.setClientConnectionPropertyMap(clientAttachProperties.getProperties());
                ClientAttachHandler clientAttachHandler = new ClientAttachHandler(clientAttachProperties, credentialType, remoteTargetMessagingEngine.getName(), remoteTargetMessagingEngine.getSubnet());
                try {
                    clientConnection.connect(connectionProperties, clientAttachHandler);
                    TrmFirstContactMessage trmFirstContactMessage = clientAttachHandler.getReply();
                    TrmClientAttachReply trmClientAttachReply = trmFirstContactMessage.makeInboundTrmClientAttachReply();
                    n = trmClientAttachReply.getReturnCode();
                    if (n == 0) {
                        sICoreConnection = clientConnection.getSICoreConnection();
                    }
                    clientConnection.close();
                    this.throwException(n, nls.getFormattedMessage("MIRRORED_FAILURE_CWSIT0010", new Object[]{remoteTargetMessagingEngine.getName(), clientAttachProperties.getBusName(), Utils.getFailureMessage(trmClientAttachReply.getFailureReason())}, null));
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    clientConnection.close();
                    throw new SIErrorException(nls.getFormattedMessage("ATTACH_FAILED_CWSIT0011", new Object[]{remoteTargetMessagingEngine.getName(), clientAttachProperties.getBusName()}, null));
                }
            }
        } else {
            throw new SIErrorException(nls.getString("NO_CC_CWSIT0005"));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "sc=" + sICoreConnection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remoteAttach");
        }
        return sICoreConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SICoreConnection remoteBootstrap(CredentialType credentialType, ClientAttachProperties clientAttachProperties) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SICoreConnection sICoreConnection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remoteBootstrap");
        }
        ClientConnection clientConnection = null;
        TrmClientBootstrapReply trmClientBootstrapReply = null;
        int n = -1;
        ClientConnectionFactory clientConnectionFactory = ClientConnectionFactory.getReference();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = false;
        if (clientConnectionFactory == null) {
            throw new SIErrorException(nls.getString("NO_CCF_CWSIT0004"));
        }
        List list = clientAttachProperties.getProviderEPs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object4 = (TrmEndPoint)iterator.next();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Making bootstrap request to " + ((TrmEndPoint)object4).toString());
            }
            if ((clientConnection = clientConnectionFactory.createClientConnection()) == null) throw new SIErrorException(nls.getString("NO_CC_CWSIT0005"));
            object3 = new ConnectionProperties(new EndPoint(((TrmEndPoint)object4).getHost(), ((TrmEndPoint)object4).getPort()), ((TrmEndPoint)object4).getChain());
            ((ConnectionProperties)object3).setClientConnectionPropertyMap(clientAttachProperties.getProperties());
            object2 = new ClientBootstrapHandler(clientAttachProperties, credentialType, ((TrmEndPoint)object4).getChain());
            try {
                clientConnection.connect((ConnectionProperties)object3, (ClientComponentHandshake)object2);
                object = ((ClientHandler)object2).getReply();
                trmClientBootstrapReply = object.makeInboundTrmClientBootstrapReply();
                n = trmClientBootstrapReply.getReturnCode();
                if (n == 0 || n == 1) {
                    bl = true;
                    break;
                }
                SibTr.warning(tc, "MIRRORED_FAILURE_CWSIT0009", new Object[]{((TrmEndPoint)object4).toString(), clientAttachProperties.getBusName(), Utils.getFailureMessage(trmClientBootstrapReply.getFailureReason())});
                arrayList2.add(object4);
                clientConnection.close();
            }
            catch (Exception exception) {
                SibTr.warning(tc, "BOOTSTRAP_FAILED_CWSIT0007", new Object[]{((TrmEndPoint)object4).toString(), exception.toString()});
                arrayList.add(object4);
            }
        }
        if (!bl) throw new SIResourceException(nls.getFormattedMessage("NO_BOOTSTRAP_CWSIT0006", new Object[]{clientAttachProperties.getBusName(), ((Object)arrayList).toString(), ((Object)arrayList2).toString()}, null));
        if (n == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Staying with bootstrap messaging engine");
            }
            sICoreConnection = clientConnection.getSICoreConnection();
        } else if (n == 1) {
            CFEndPoint cFEndPoint;
            Object object5;
            Object object6;
            object4 = trmClientBootstrapReply.getEndPointData();
            object3 = trmClientBootstrapReply.getBusName();
            object2 = trmClientBootstrapReply.getSubnetName();
            object = trmClientBootstrapReply.getMessagingEngineName();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Redirecting to bus=" + (String)object3 + " subnet=" + (String)object2 + " messagine engine=" + (String)object);
            }
            boolean bl2 = clientConnection.getMetaData().requiresNonJavaBootstrap();
            clientConnection.close();
            clientConnection = clientConnectionFactory.createClientConnection();
            if (clientConnection == null) throw new SIErrorException(nls.getString("NO_CC_CWSIT0005"));
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Java bootstrap performed");
                }
                try {
                    object6 = new ByteArrayInputStream((byte[])object4);
                    object5 = new ObjectInputStream((InputStream)object6);
                    cFEndPoint = (CFEndPoint)((ObjectInputStream)object5).readObject();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(className + ".remoteBootstrap"), (String)"2", (Object)this);
                    SibTr.exception(tc, exception);
                    clientConnection.close();
                    throw new SIErrorException(exception);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Non-Java bootstrap performed");
                }
                cFEndPoint = new XMLEndPointFactory().create((byte[])object4);
            }
            object6 = new ConnectionProperties(cFEndPoint);
            ((ConnectionProperties)object6).setClientConnectionPropertyMap(clientAttachProperties.getProperties());
            object5 = new ClientAttachHandler(clientAttachProperties, credentialType, (String)object, (String)object2);
            clientConnection.connect((ConnectionProperties)object6, (ClientComponentHandshake)object5);
            TrmFirstContactMessage trmFirstContactMessage = ((ClientHandler)object5).getReply();
            TrmClientAttachReply trmClientAttachReply = trmFirstContactMessage.makeInboundTrmClientAttachReply();
            n = trmClientAttachReply.getReturnCode();
            if (n == 0) {
                sICoreConnection = clientConnection.getSICoreConnection();
            } else {
                clientConnection.close();
                this.throwException(n, nls.getFormattedMessage("MIRRORED_FAILURE_CWSIT0010", new Object[]{object, object3, Utils.getFailureMessage(trmClientAttachReply.getFailureReason())}, null));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "*** shouldn't ever get here!");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "sc=" + sICoreConnection);
        }
        if (!tc.isEntryEnabled()) return sICoreConnection;
        SibTr.exit(tc, "remoteBootstrap");
        return sICoreConnection;
    }

    private void throwException(int n, String string) throws SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (n == -2) {
            throw new SIResourceException(string);
        }
        if (n == -3) {
            throw new SIConnectionLostException(string);
        }
        if (n == -4) {
            throw new SILimitExceededException(string);
        }
        if (n == -5) {
            throw new SIErrorException(string);
        }
        if (n == -6) {
            throw new SINotAuthorizedException(string);
        }
        if (n == -7) {
            throw new SINotPossibleInCurrentConfigurationException(string);
        }
        if (n == -8) {
            throw new SIIncorrectCallException(string);
        }
        if (n == -9) {
            throw new SIAuthenticationException(string);
        }
        throw new SIErrorException(string);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.60.1.2 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/TrmSICoreConnectionFactoryImpl2.java, SIB.trm, WAS602.SIB, o0610.11 06/01/06 04:48:32 [3/13/06 13:38:59]");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Determining xMemoryChannel enablement setting:");
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Running on z/OS");
            }
            String string = RuntimeInfo.getPropertyWithMsg(enableXMemChannelName, enableXMemChannelDefault);
            enableXMemChannel = string.equalsIgnoreCase(enableXMemChannelDefault);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "NOT Running on z/OS");
            }
            enableXMemChannel = false;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "  enableXMemChannel: " + enableXMemChannel);
        }
    }
}

