/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.trm.TrmMeMainClient;
import com.ibm.ws.sib.trm.client.FailedTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.LocalConnectScope;
import com.ibm.ws.sib.trm.client.LocalTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.RemoteTargetMessagingEngine;
import com.ibm.ws.sib.trm.client.TargetMessagingEngine;
import com.ibm.ws.sib.trm.wlm.client.Identities;
import com.ibm.ws.sib.trm.wlm.client.Select;
import com.ibm.ws.sib.trm.wlm.client.Selection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;

public final class FindTargetMessagingEngine {
    public static final String $ssccid = "@(#) 1.51.1.2 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/FindTargetMessagingEngine.java, SIB.trm, WAS602.SIB, o0610.11 05/08/10 11:24:59 [3/13/06 13:38:58]";
    private static final TraceComponent tc = SibTr.register(FindTargetMessagingEngine.class, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
    private static boolean clusterNameResolved;
    private static final Object lock2;
    private static String clusterName;
    private static JsAdminService jsas;
    private static boolean adminAvailable;
    private static boolean adminResolved;
    private static final Object lock1;

    public TargetMessagingEngine resolve(String string, String string2, String string3, String string4, String string5, String string6, LocalConnectScope localConnectScope, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "resolve");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",group=" + string2 + ",type=" + string3 + ",significance=" + string4 + ",transportChain=" + string5 + ",proximity=" + string6 + ",LocalConnectScope=" + localConnectScope + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        boolean bl4 = string4.equals("Preferred");
        if (string2 != null) {
            if (string3.equals("BusMember")) {
                selection = this.fromBusMember(localConnectScope, string, string2, string5, bl, bl2);
            } else if (string3.equals("Custom")) {
                selection = this.fromCustom(localConnectScope, string, string2, string5, bl, bl2);
            } else if (string3.equals("Destination")) {
                selection = this.fromDestination(localConnectScope, string, string2, string5, bl, bl2);
            } else if (string3.equals("ME")) {
                selection = this.meShortName(localConnectScope, string, string2, string5, bl, bl2);
            } else if (string3.equals("MEUuid")) {
                selection = this.meUuid(localConnectScope, string, string2, string5, bl, bl2);
            }
            if (selection != null && (string6.equals("Server") && !selection.isLocalServer() || string6.equals("Cluster") && !this.inLocalCluster(selection) || string6.equals("Host") && !selection.isLocalHost()) && bl4) {
                selection = null;
            }
        }
        if (string2 == null || selection == null && bl4) {
            selection = string6.equals("Cluster") ? this.fromBusMember(localConnectScope, string, string5, bl, bl2) : this.fromBus(localConnectScope, string, string5, bl, bl2);
        }
        TargetMessagingEngine targetMessagingEngine = new FailedTargetMessagingEngine();
        if (selection != null && (string6.equals("Server") && selection.isLocalServer() || string6.equals("Cluster") && this.inLocalCluster(selection) || string6.equals("Host") && selection.isLocalHost() || string6.equals("Bus"))) {
            targetMessagingEngine = this.targetMessagingEngine(selection, bl3);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, ((TargetMessagingEngine)targetMessagingEngine).toString());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "resolve");
        }
        return targetMessagingEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ourClusterName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ourClusterName");
        }
        if (!clusterNameResolved) {
            Object object = lock2;
            synchronized (object) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> clazz = classLoader.loadClass("com.ibm.ws.sib.trm.client.Cluster");
                            Method method = clazz.getMethod("getClusterName", new Class[0]);
                            String string = (String)method.invoke(null, new Object[0]);
                            if (string != null) {
                                clusterName = string;
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    SibTr.exception(tc, exception);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Cluster name=" + clusterName);
                }
                clusterNameResolved = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ourClusterName");
        }
        return clusterName;
    }

    private boolean inLocalCluster(Selection selection) {
        return this.inLocalCluster(selection.getBus(), selection.getSubnet(), selection.getName());
    }

    private boolean inLocalCluster(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "inLocalCluster");
        }
        boolean bl = false;
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        Identity[] identityArray = clusterService.getMemberIdentities(Identities.getBusMemberIdentity(string, this.ourClusterName()));
        for (int i = 0; i < identityArray.length && !bl; ++i) {
            String string4 = (String)identityArray[i].getProperties().get("bus");
            String string5 = (String)identityArray[i].getProperties().get("subnet");
            String string6 = (String)identityArray[i].getProperties().get("name");
            bl = string.equals(string4) && string2.equals(string5) && string3.equals(string6);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "inLocalCluster");
        }
        return bl;
    }

    private TargetMessagingEngine targetMessagingEngine(Selection selection, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "targetMessagingEngine");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "selection: " + selection);
            SibTr.debug(tc, "matchingBootstrapChain: " + bl);
        }
        TargetMessagingEngine targetMessagingEngine = null;
        if (selection != null) {
            Object object;
            if (bl && (object = this.inProcess(selection.getBus(), selection.getSubnet(), selection.getName())) != null) {
                targetMessagingEngine = new LocalTargetMessagingEngine((JsMessagingEngine)object);
            }
            if (targetMessagingEngine == null) {
                if (selection.getEndPoint() != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Returning a remote object");
                    }
                    targetMessagingEngine = new RemoteTargetMessagingEngine(selection);
                } else if (selection.isLocalServer() && !selection.isLocalProcess()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Returning a remote object with no endpoint (inServer && !inProcess)");
                    }
                    targetMessagingEngine = new RemoteTargetMessagingEngine(selection);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Failed due to create remote endpoint due to NULL endpoint");
                    }
                    object = new NoCFEndpointInSelectionException("Expected to obtain a CFEndpoint from the Selection but none was present (internal error)");
                    FFDCFilter.processException((Throwable)object, (String)"FindTargetMessagingEngine.targetMessagingEngine", (String)"targetMessagingEngine#1");
                    targetMessagingEngine = new FailedTargetMessagingEngine();
                }
            }
        } else {
            targetMessagingEngine = new FailedTargetMessagingEngine();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + targetMessagingEngine);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "targetMessagingEngine");
        }
        return targetMessagingEngine;
    }

    private JsMessagingEngine inProcess(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "inProcess");
        }
        JsMessagingEngine jsMessagingEngine = null;
        if (this.isAdministerable()) {
            Enumeration enumeration = jsas.listMessagingEngines(string);
            while (enumeration.hasMoreElements() && jsMessagingEngine == null) {
                JsMessagingEngine jsMessagingEngine2 = (JsMessagingEngine)enumeration.nextElement();
                TrmMeMainClient trmMeMainClient = (TrmMeMainClient)((Object)jsMessagingEngine2.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl"));
                if (trmMeMainClient == null || !trmMeMainClient.isStarted() || !trmMeMainClient.getBus().equals(string) || !trmMeMainClient.getSubnet().equals(string2) || !trmMeMainClient.getName().equals(string3)) continue;
                jsMessagingEngine = jsMessagingEngine2;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + jsMessagingEngine);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "inProcess");
        }
        return jsMessagingEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdministerable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isAdministerable");
        }
        if (!adminResolved) {
            Object object = lock1;
            synchronized (object) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return classLoader.loadClass("com.ibm.ws.sib.admin.impl.JsMainImpl");
                        }
                    });
                    jsas = JsAdminService.getInstance();
                    adminAvailable = jsas.isInitialized();
                }
                catch (Exception exception) {
                    SibTr.exception(tc, exception);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Jetstream Admin available=" + adminAvailable);
                }
                adminResolved = true;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + adminAvailable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isAdministerable");
        }
        return adminAvailable;
    }

    private Selection fromBusMember(LocalConnectScope localConnectScope, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromBusMember");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.fromBusMember(string, string2, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.fromBusMember(string, string2, string3, bl, bl2);
            }
        } else {
            selection = Select.fromBusMember(string, string2, string3, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromBusMember");
        }
        return selection;
    }

    private Selection fromCustom(LocalConnectScope localConnectScope, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromCustom");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.fromCustom(string, string2, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.fromCustom(string, string2, string3, bl, bl2);
            }
        } else {
            selection = Select.fromCustom(string, string2, string3, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromCustom");
        }
        return selection;
    }

    private Selection fromDestination(LocalConnectScope localConnectScope, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromDestination");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.fromDestination(string, string2, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.fromDestination(string, string2, string3, bl, bl2);
            }
        } else {
            selection = Select.fromDestination(string, string2, string3, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromDestination");
        }
        return selection;
    }

    private Selection meShortName(LocalConnectScope localConnectScope, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meShortName");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.meShortName(string, string2, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.meShortName(string, string2, string3, bl, bl2);
            }
        } else {
            selection = Select.meShortName(string, string2, string3, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meShortName");
        }
        return selection;
    }

    private Selection meUuid(LocalConnectScope localConnectScope, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meUuid");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.meUuid(string2, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.meUuid(string2, string3, bl, bl2);
            }
        } else {
            selection = Select.meUuid(string2, string3, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meUuid");
        }
        return selection;
    }

    private Selection fromBusMember(LocalConnectScope localConnectScope, String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromBusMember");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.fromBusMember(string, this.ourClusterName(), bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.fromBusMember(string, this.ourClusterName(), string2, bl, bl2);
            }
        } else {
            selection = Select.fromBusMember(string, this.ourClusterName(), string2, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromBusMember");
        }
        return selection;
    }

    private Selection fromBus(LocalConnectScope localConnectScope, String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromBus");
        }
        Selection selection = null;
        if (localConnectScope != LocalConnectScope.NONE) {
            selection = Select.fromBus(string, bl, bl2);
            if (selection != null && !this.inLocalConnectScope(selection, localConnectScope)) {
                selection = Select.fromBus(string, string2, bl, bl2);
            }
        } else {
            selection = Select.fromBus(string, string2, bl, bl2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=" + selection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromBus");
        }
        return selection;
    }

    private boolean inLocalConnectScope(Selection selection, LocalConnectScope localConnectScope) {
        return localConnectScope == LocalConnectScope.PROCESS && selection.isLocalProcess() || localConnectScope == LocalConnectScope.SERVER && (selection.isLocalProcess() || selection.isLocalServer());
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.51.1.2 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/FindTargetMessagingEngine.java, SIB.trm, WAS602.SIB, o0610.11 05/08/10 11:24:59 [3/13/06 13:38:58]");
        }
        clusterNameResolved = false;
        lock2 = new Object();
        clusterName = "";
        jsas = null;
        adminAvailable = false;
        adminResolved = false;
        lock1 = new Object();
    }

    private class NoCFEndpointInSelectionException
    extends Exception {
        public NoCFEndpointInSelectionException(String string) {
            super(string);
        }
    }
}

