/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.sib.trm.client.TrmEndPoint;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class ClientAttachProperties {
    public static final String $ssccid = "@(#) 1.69 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientAttachProperties.java, SIB.trm, WAS602.SIB, o0610.11 05/05/10 04:30:37 [3/13/06 13:39:16]";
    private static final TraceComponent tc = SibTr.register(ClientAttachProperties.class, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private Map props = null;
    private String busName = null;
    private String targetGroupName = null;
    private String targetGroupType = null;
    private String targetSignificance = null;
    private String targetTransportChain = null;
    private String connectionProximity = null;
    private List endpoints = new ArrayList();
    private String connectionMode = null;
    private boolean userDefinedEPs = false;

    public ClientAttachProperties(Map map) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ClientAttachProperties");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Connection properties=" + map);
        }
        this.props = map;
        this.busName = (String)this.props.get("busName");
        if (this.busName == null) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_PROPERTY_CWSIT0003", new Object[]{"busName"}, null));
        }
        this.targetGroupName = (String)this.props.get("targetGroup");
        if (this.targetGroupName != null && this.targetGroupName.trim().equals("")) {
            this.targetGroupName = null;
        }
        this.targetGroupType = (String)this.props.get("targetType");
        if (this.targetGroupType != null && this.targetGroupType.trim().equals("")) {
            this.targetGroupType = null;
        }
        if (this.targetGroupType == null) {
            this.targetGroupType = "BusMember";
        }
        if (!(this.targetGroupType.equals("BusMember") || this.targetGroupType.equals("Destination") || this.targetGroupType.equals("Custom") || this.targetGroupType.equals("ME") || this.targetGroupType.equals("MEUuid"))) {
            String string = "BusMember,Destination,Custom,ME,MEUuid";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.targetGroupType, "targetType", string}, null));
        }
        this.targetSignificance = (String)this.props.get("targetSignificance");
        if (this.targetSignificance != null && this.targetSignificance.trim().equals("")) {
            this.targetSignificance = null;
        }
        if (this.targetSignificance == null) {
            this.targetSignificance = "Preferred";
        }
        if (!this.targetSignificance.equals("Required") && !this.targetSignificance.equals("Preferred")) {
            String string = "Required,Preferred";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.targetSignificance, "targetSignificance", string}, null));
        }
        this.targetTransportChain = (String)this.props.get("targetTransportChain");
        if (this.targetTransportChain != null && this.targetTransportChain.trim().equals("")) {
            this.targetTransportChain = null;
        }
        if (this.targetTransportChain == null) {
            this.targetTransportChain = "InboundBasicMessaging";
        }
        this.connectionProximity = (String)this.props.get("connectionProximity");
        if (this.connectionProximity != null && this.connectionProximity.trim().equals("")) {
            this.connectionProximity = null;
        }
        if (this.connectionProximity == null) {
            this.connectionProximity = "Bus";
        }
        if (!(this.connectionProximity.equals("Server") || this.connectionProximity.equals("Cluster") || this.connectionProximity.equals("Host") || this.connectionProximity.equals("Bus"))) {
            String string = "Server,Cluster,Host,Bus";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.connectionProximity, "connectionProximity", string}, null));
        }
        String string = (String)this.props.get("providerEndpoints");
        this.userDefinedEPs = ClientAttachProperties.parseProviderEndpoints(string, this.endpoints);
        this.connectionMode = (String)this.props.get("connectionMode");
        if (this.connectionMode != null && this.connectionMode.trim().equals("")) {
            this.connectionMode = null;
        }
        if (this.connectionMode == null) {
            this.connectionMode = "Normal";
        }
        if (!this.connectionMode.equals("Normal") && !this.connectionMode.equals("Recovery")) {
            String string2 = "Normal,Recovery";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.connectionMode, "connectionMode", string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ClientAttachProperties");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parseProviderEndpoints(String string, List list) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseProviderEndpoints");
        }
        if (tc.isEntryEnabled()) {
            SibTr.debug(tc, string);
        }
        boolean bl = false;
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = stringTokenizer.nextToken();
                if (string5 == null) continue;
                bl = true;
                int n = 0;
                n = string5.indexOf("[");
                if (n != -1) {
                    int n2 = 0;
                    n2 = string5.indexOf("]");
                    if (n2 == -1) throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{string5, "providerEndpoints", "[<IPv6 address>]:<port>:<chain>"}, null));
                    string2 = string5.substring(n + 1, n2);
                    string5 = string5.substring(n2 + 1);
                } else if (string5.indexOf("]") != -1) {
                    throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{string5, "providerEndpoints", "[<IPv6 address>]:<port>:<chain>"}, null));
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ":");
                if (string2 == null && stringTokenizer2.hasMoreElements()) {
                    string2 = stringTokenizer2.nextToken();
                }
                if (stringTokenizer2.hasMoreElements()) {
                    string3 = stringTokenizer2.nextToken();
                }
                if (stringTokenizer2.hasMoreElements()) {
                    string4 = stringTokenizer2.nextToken();
                }
                if (string2 == null || string2.trim().equals("")) {
                    string2 = "localhost";
                }
                if (string3 == null || string3.trim().equals("")) {
                    string3 = "7276";
                }
                if (string4 == null || string4.trim().equals("")) {
                    string4 = "BootstrapBasicMessaging";
                }
                list.add(new TrmEndPoint(string2, new Integer(string3), string4));
            }
        } else {
            String string6 = System.getProperty("com.ibm.CORBA.BootstrapHost");
            if (string6 == null || string6.equals("")) {
                string6 = "localhost";
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Adding a default provider end point for host: " + string6);
            }
            list.add(new TrmEndPoint(string6, new Integer("7276"), "BootstrapBasicMessaging"));
        }
        if (tc.isEntryEnabled()) {
            SibTr.debug(tc, list.toString());
        }
        if (!tc.isEntryEnabled()) return bl;
        SibTr.exit(tc, "parseProviderEndpoints", new Boolean(bl));
        return bl;
    }

    Map getProperties() {
        return this.props;
    }

    String getBusName() {
        return this.busName;
    }

    String getTargetGroupName() {
        return this.targetGroupName;
    }

    String getTargetGroupType() {
        return this.targetGroupType;
    }

    String getTargetSignificance() {
        return this.targetSignificance;
    }

    String getTargetTransportChain() {
        return this.targetTransportChain;
    }

    String getConnectionProximity() {
        return this.connectionProximity;
    }

    List getProviderEPs() {
        return this.endpoints;
    }

    String getConnectionMode() {
        return this.connectionMode;
    }

    boolean isUserDefinedProviderEPs() {
        return this.userDefinedEPs;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.69 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientAttachProperties.java, SIB.trm, WAS602.SIB, o0610.11 05/05/10 04:30:37 [3/13/06 13:39:16]");
        }
    }
}

