/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.mfp.trm.TrmClientAttachRequest;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.ClientHandler;
import com.ibm.ws.sib.trm.client.CredentialType;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.utils.ras.SibTr;

final class ClientAttachHandler
extends ClientHandler {
    public static final String $ssccid = "@(#) 1.29 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientAttachHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/01/25 11:57:39 [3/13/06 13:38:58]";
    private String me = null;
    private String subnet = null;

    public ClientAttachHandler(ClientAttachProperties clientAttachProperties, CredentialType credentialType, String string, String string2) {
        super(clientAttachProperties, credentialType);
        this.me = string;
        this.subnet = string2;
    }

    public boolean connect(ClientConnection clientConnection) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "connect");
        }
        try {
            TrmMessageFactory trmMessageFactory = TrmMessageFactory.getInstance();
            TrmClientAttachRequest trmClientAttachRequest = trmMessageFactory.createNewTrmClientAttachRequest();
            trmClientAttachRequest.setBusName(this.cap.getBusName());
            trmClientAttachRequest.setCredentialType(this.credentialType.getCredentialType());
            trmClientAttachRequest.setUserid(this.credentialType.getUserid());
            trmClientAttachRequest.setPassword(this.credentialType.getPassword());
            trmClientAttachRequest.setMeName(this.me);
            trmClientAttachRequest.setSubnetName(this.subnet);
            byte[] byArray = trmClientAttachRequest.encode(clientConnection);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, Utils.outBound("client attach request"));
            }
            byte[] byArray2 = clientConnection.trmHandshakeExchange(byArray);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, Utils.inBound("client attach reply"));
            }
            this.fcm = trmMessageFactory.createInboundTrmFirstContactMessage(byArray2, 0, byArray2.length);
            if (this.fcm.getMessageType() != TrmFirstContactMessageType.CLIENT_ATTACH_REPLY) {
                SibTr.error(tc, "PROTOCOL_ERROR_CWSIT0036", new Object[]{this.me, this.cap.getBusName(), this.fcm.getMessageType().toString(), TrmFirstContactMessageType.CLIENT_ATTACH_REPLY.toString()});
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".connect"), (String)"2", (Object)this);
            SibTr.exception(tc, exception);
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "connect", (Object)("rc=" + bl));
        }
        return bl;
    }

    static {
        className = ClientAttachHandler.class.getName();
        tc = SibTr.register(className, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.29 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientAttachHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/01/25 11:57:39 [3/13/06 13:38:58]");
        }
    }
}

