/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.recovery;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.recovery.SibRaRecoveryManagerUnavailableException;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class SibRaRecoveryManager {
    private static SibRaRecoveryManager INSTANCE;
    private static Boolean AVAILABLE;
    private static String IMPLEMENTATION_CLASSNAME;
    private static String FFDC_PROBE_ID1;
    private static final TraceComponent TRACE;

    public abstract int getRecoveryToken(String var1, String var2, String var3, String var4);

    public abstract int getRecoveryToken(String var1, String var2, String var3, String var4, String var5);

    public static synchronized boolean isAvailable() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "isAvailable");
        }
        if (AVAILABLE == null) {
            try {
                SibRaRecoveryManager.getInstance();
            }
            catch (SibRaRecoveryManagerUnavailableException sibRaRecoveryManagerUnavailableException) {
                // empty catch block
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "isAvailable", AVAILABLE);
        }
        return AVAILABLE;
    }

    public static synchronized SibRaRecoveryManager getInstance() throws SibRaRecoveryManagerUnavailableException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getInstance");
        }
        if (INSTANCE == null) {
            try {
                Class<?> clazz = Class.forName(IMPLEMENTATION_CLASSNAME);
                INSTANCE = (SibRaRecoveryManager)clazz.newInstance();
                AVAILABLE = Boolean.TRUE;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.ra.recovery.SibRaRecoveryManager.getInstance", (String)FFDC_PROBE_ID1);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception(TRACE, throwable);
                }
                AVAILABLE = Boolean.FALSE;
                throw new SibRaRecoveryManagerUnavailableException(throwable);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getInstance", INSTANCE);
        }
        return INSTANCE;
    }

    static {
        IMPLEMENTATION_CLASSNAME = "com.ibm.ws.sib.ra.recovery.impl.SibRaRecoveryManagerImpl";
        FFDC_PROBE_ID1 = "1";
        TRACE = SibTr.register(SibRaRecoveryManager.class, "SIBRa", "com.ibm.ws.sib.ra.CWSIVMessages");
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.ra/src/com/ibm/ws/sib/ra/recovery/SibRaRecoveryManager.java, SIB.ra, WAS602.SIB, o0610.11 1.11");
        }
    }
}

