/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra;

import com.ibm.ejs.j2c.ConnectionFactoryBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryBuilderFactory;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.jca.TransactionSupportKind;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.security.PasswordCredential;

public final class SibRaFactory {
    private static final String MCF_CLASSNAME = "com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory";
    private static final TraceComponent TRACE = SibTr.register(SibRaFactory.class, "SIBRa", "com.ibm.ws.sib.ra.CWSIVMessages");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.ra.CWSIVMessages");
    private static final String FFDC_PROBE_1 = "1";

    private SibRaFactory() {
    }

    public static SICoreConnectionFactory getConnectionFactory(Map map) throws SIInsufficientDataForFactoryTypeException, SIIncorrectCallException, SIResourceException {
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getConnectionFactory", map);
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        int n = SibRaFactory.getAuthenticationMechanism(map);
        Properties properties = SibRaFactory.getJ2CProperties(map, n);
        int n2 = SibRaFactory.getSharingScope(map);
        ConnectorProperties connectorProperties = new ConnectorProperties();
        Properties properties2 = null;
        ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
        try {
            object = connectionFactoryBuilder.getConnectionFactory(properties, properties2, connectorProperties, n2, 0, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.SibRaFactory.getConnectionFactory", (String)FFDC_PROBE_1);
            if (TRACE.isEventEnabled()) {
                SibTr.exception(TRACE, exception);
            }
            SIResourceException sIResourceException = new SIResourceException(NLS.getFormattedMessage("CONNECTION_FACTORY_EXCEPTION_CWSIV0050", new Object[]{exception}, null), exception);
            throw sIResourceException;
        }
        if (!(object instanceof SICoreConnectionFactory)) {
            SIResourceException sIResourceException = new SIResourceException(NLS.getFormattedMessage("INCORRECT_FACTORY_TYPE_CWSIV0051", new Object[]{object}, null));
            if (TRACE.isEventEnabled()) {
                SibTr.exception(TRACE, sIResourceException);
            }
            throw sIResourceException;
        }
        SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)object;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getConnectionFactory", sICoreConnectionFactory);
        }
        return sICoreConnectionFactory;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getAuthenticationMechanism(Map map) throws SIIncorrectCallException {
        int n;
        block7: {
            block8: {
                Object v;
                if (TRACE.isEntryEnabled()) {
                    SibTr.entry(TRACE, "getAuthenticationMechanism", map);
                }
                if ((v = map.get("CREDENTIAL_PROVIDER")) == null) break block8;
                if ("CREDENTIAL_PROVIDER_CALLER".equals(v)) {
                    n = 1;
                    break block7;
                } else if ("CREDENTIAL_PROVIDER_CONTAINER".equals(v)) {
                    n = 0;
                    break block7;
                } else {
                    SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getFormattedMessage("INVALID_PROPERTY_CWSIV0052", new Object[]{v, "CREDENTIAL_PROVIDER", "CREDENTIAL_PROVIDER_CALLER", "CREDENTIAL_PROVIDER_CONTAINER"}, null));
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception(TRACE, sIIncorrectCallException);
                    }
                    throw sIIncorrectCallException;
                }
            }
            n = 1;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getAuthenticationMechanism", new Integer(n));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getSharingScope(Map map) throws SIIncorrectCallException {
        int n;
        block7: {
            block8: {
                Object v;
                if (TRACE.isEntryEnabled()) {
                    SibTr.entry(TRACE, "getSharingScope", map);
                }
                if ((v = map.get("CONNECTION_SHARING")) == null) break block8;
                if ("CONNECTION_SHARING_DISABLED".equals(v)) {
                    n = 1;
                    break block7;
                } else if ("CONNECTION_SHARING_ENABLED".equals(v)) {
                    n = 0;
                    break block7;
                } else {
                    SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getFormattedMessage("INVALID_PROPERTY_CWSIV0055", new Object[]{v, "CONNECTION_SHARING", "CONNECTION_SHARING_DISABLED", "CONNECTION_SHARING_ENABLED"}, null));
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception(TRACE, sIIncorrectCallException);
                    }
                    throw sIIncorrectCallException;
                }
            }
            n = 1;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getSharingScope", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Properties getJ2CProperties(Map map, int n) throws SIIncorrectCallException {
        Object object;
        Properties properties;
        block13: {
            block14: {
                if (TRACE.isEntryEnabled()) {
                    SibTr.entry(TRACE, "getJ2CProperties", new Object[]{map, new Integer(n)});
                }
                properties = new Properties();
                StringBuffer stringBuffer = new StringBuffer("SIB$SibRaConnectionFactory");
                if (map.containsKey("XA_RECOVERY_ALIAS")) {
                    String string = SibRaFactory.getProperty(map, "XA_RECOVERY_ALIAS");
                    stringBuffer.append('$');
                    stringBuffer.append(string);
                    properties.setProperty("XA_RECOVERY_AUTH_ALIAS", string);
                }
                if (0 == n) {
                    void var4_7;
                    if (map.containsKey("CONTAINER_MAPPING_MODULE")) {
                        String string = SibRaFactory.getProperty(map, "CONTAINER_MAPPING_MODULE");
                    } else {
                        String string = ConnectionFactoryRefBuilder.DEFAULT_MAPPING_MODULE_mappingConfigAlias;
                    }
                    stringBuffer.append('$');
                    stringBuffer.append((String)var4_7);
                    properties.setProperty("mappingConfigAlias", (String)var4_7);
                    if (ConnectionFactoryRefBuilder.DEFAULT_MAPPING_MODULE_mappingConfigAlias.equals(var4_7)) {
                        if (!map.containsKey("CONTAINER_AUTHENTICATION_ALIAS")) {
                            throw new SIInsufficientDataForFactoryTypeException(NLS.getString("ALIAS_REQUIRED_CWSIV0054"));
                        }
                        object = SibRaFactory.getProperty(map, "CONTAINER_AUTHENTICATION_ALIAS");
                        stringBuffer.append('$');
                        stringBuffer.append((String)object);
                        properties.setProperty("authDataAlias", (String)object);
                    }
                }
                properties.setProperty("name", stringBuffer.toString());
                properties.setProperty("managedConnectionFactoryClass", MCF_CLASSNAME);
                properties.setProperty("transactionSupport", TransactionSupportKind.XA_TRANSACTION_LITERAL.getName());
                properties.setProperty(ConnectionFactoryRefBuilder.SECURITY_BasicPassword, PasswordCredential.class.getName());
                properties.setProperty("maxConnections", "0");
                Object v = map.get("MISSING_TRANSACTION_CONTEXT");
                if (v == null) break block14;
                if ("MISSING_TRANSACTION_CONTEXT_LOG".equals(v)) {
                    object = Boolean.TRUE;
                    break block13;
                } else if ("MISSING_TRANSACTION_CONTEXT_IGNORE".equals(v)) {
                    object = Boolean.FALSE;
                    break block13;
                } else {
                    SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(NLS.getFormattedMessage("INVALID_PROPERTY_CWSIV0055", new Object[]{v, "MISSING_TRANSACTION_CONTEXT", "MISSING_TRANSACTION_CONTEXT_LOG", "MISSING_TRANSACTION_CONTEXT_IGNORE"}, null));
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception(TRACE, sIIncorrectCallException);
                    }
                    throw sIIncorrectCallException;
                }
            }
            object = Boolean.TRUE;
        }
        properties.setProperty("logMissingTransactionContext", ((Boolean)object).toString());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getJ2CProperties", properties);
        }
        return properties;
    }

    private static String getProperty(Map map, String string) throws SIIncorrectCallException {
        Object v = map.get(string);
        if (!(v instanceof String)) {
            throw new SIIncorrectCallException(NLS.getFormattedMessage("INVALID_PROPERTY_TYPE_CWSIV0053", new Object[]{string, String.class.getName()}, null));
        }
        return (String)v;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.ra/src/com/ibm/ws/sib/ra/SibRaFactory.java, SIB.ra, WAS602.SIB, o0610.11 1.14");
        }
    }
}

