/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class SibRaEngineComponent
implements JsEngineComponent {
    private JsMessagingEngine _messagingEngine;
    private static boolean _serverStopping;
    private static final Map MESSAGING_ENGINES;
    private static final Map ACTIVE_MESSAGING_ENGINES;
    private static final Map MESSAGING_ENGINE_LISTENERS;
    private static final Set RELOADING_MESSAGING_ENGINES;
    private static final TraceComponent TRACE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] registerMessagingEngineListener(SibRaMessagingEngineListener sibRaMessagingEngineListener, String string) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "registerMessagingEngineListener", new Object[]{sibRaMessagingEngineListener, string});
        }
        HashSet<SibRaMessagingEngineListener> hashSet = new HashSet<SibRaMessagingEngineListener>();
        JsMessagingEngine[] jsMessagingEngineArray = ACTIVE_MESSAGING_ENGINES;
        synchronized (ACTIVE_MESSAGING_ENGINES) {
            Set<SibRaMessagingEngineListener> set;
            Object object = MESSAGING_ENGINE_LISTENERS;
            synchronized (object) {
                set = (HashSet<SibRaMessagingEngineListener>)MESSAGING_ENGINE_LISTENERS.get(string);
                if (set == null) {
                    set = new HashSet<SibRaMessagingEngineListener>();
                    MESSAGING_ENGINE_LISTENERS.put(string, set);
                }
                set.add(sibRaMessagingEngineListener);
            }
            if (string == null) {
                object = ACTIVE_MESSAGING_ENGINES.values().iterator();
                while (object.hasNext()) {
                    set = (Set)object.next();
                    hashSet.addAll(set);
                }
            } else {
                object = (Set)ACTIVE_MESSAGING_ENGINES.get(string);
                if (object != null) {
                    hashSet.addAll((Collection<SibRaMessagingEngineListener>)object);
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            jsMessagingEngineArray = hashSet.toArray(new JsMessagingEngine[hashSet.size()]);
            if (TRACE.isEntryEnabled()) {
                SibTr.exit(TRACE, "registerMessagingEngineListener", jsMessagingEngineArray);
            }
            return jsMessagingEngineArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterMessagingEngineListener(SibRaMessagingEngineListener sibRaMessagingEngineListener, String string) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "deregisterMessagingEngineListener", new Object[]{sibRaMessagingEngineListener, string});
        }
        Map map = MESSAGING_ENGINE_LISTENERS;
        synchronized (map) {
            Set set = (Set)MESSAGING_ENGINE_LISTENERS.get(string);
            if (set != null) {
                set.remove(sibRaMessagingEngineListener);
                if (set.isEmpty()) {
                    MESSAGING_ENGINE_LISTENERS.remove(string);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "deregisterMessagingEngineListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] getMessagingEngines(String string) {
        JsMessagingEngine[] jsMessagingEngineArray;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getMessagingEngines", (Object)string);
        }
        Map map = MESSAGING_ENGINES;
        synchronized (map) {
            Set set = (Set)MESSAGING_ENGINES.get(string);
            jsMessagingEngineArray = set == null ? new JsMessagingEngine[]{} : set.toArray(new JsMessagingEngine[set.size()]);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getMessagingEngines", jsMessagingEngineArray);
        }
        return jsMessagingEngineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsMessagingEngine[] getActiveMessagingEngines(String string) {
        JsMessagingEngine[] jsMessagingEngineArray;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getActiveMessagingEngines", (Object)string);
        }
        Map map = ACTIVE_MESSAGING_ENGINES;
        synchronized (map) {
            Set set = (Set)ACTIVE_MESSAGING_ENGINES.get(string);
            jsMessagingEngineArray = set == null ? new JsMessagingEngine[]{} : set.toArray(new JsMessagingEngine[set.size()]);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getActiveMessagingEngines", jsMessagingEngineArray);
        }
        return jsMessagingEngineArray;
    }

    public static boolean isMessagingEngineReloading(String string) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "isMessagingEngineReloading", (Object)string);
        }
        boolean bl = RELOADING_MESSAGING_ENGINES.contains(string);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "isMessagingEngineReloading", bl);
        }
        return bl;
    }

    public static boolean isServerStopping() {
        return _serverStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(JsMessagingEngine jsMessagingEngine) {
        Set set;
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "initialize", jsMessagingEngine);
        }
        this._messagingEngine = jsMessagingEngine;
        Object object2 = MESSAGING_ENGINES;
        synchronized (object2) {
            object = (HashSet<JsMessagingEngine>)MESSAGING_ENGINES.get(jsMessagingEngine.getBusName());
            if (object == null) {
                object = new HashSet<JsMessagingEngine>();
                MESSAGING_ENGINES.put(jsMessagingEngine.getBusName(), object);
            }
            object.add(jsMessagingEngine);
            set = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (SibRaMessagingEngineListener)object2.next();
            object.messagingEngineInitializing(this._messagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n) {
        Set set;
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "start");
        }
        Object object2 = ACTIVE_MESSAGING_ENGINES;
        synchronized (object2) {
            object = (HashSet<JsMessagingEngine>)ACTIVE_MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (object == null) {
                object = new HashSet<JsMessagingEngine>();
                ACTIVE_MESSAGING_ENGINES.put(this._messagingEngine.getBusName(), object);
            }
            object.add(this._messagingEngine);
            set = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (SibRaMessagingEngineListener)object2.next();
            object.messagingEngineStarting(this._messagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        Set set;
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "stop");
        }
        RELOADING_MESSAGING_ENGINES.remove(this._messagingEngine.getUuid().toString());
        Object object2 = ACTIVE_MESSAGING_ENGINES;
        synchronized (object2) {
            object = (Set)ACTIVE_MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (object != null) {
                object.remove(this._messagingEngine);
                if (object.isEmpty()) {
                    ACTIVE_MESSAGING_ENGINES.remove(this._messagingEngine.getBusName());
                }
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "Received stop for inactive ME:", this._messagingEngine);
            }
            set = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (SibRaMessagingEngineListener)object2.next();
            object.messagingEngineStopping(this._messagingEngine, n);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "destroy");
        }
        RELOADING_MESSAGING_ENGINES.remove(this._messagingEngine.getUuid().toString());
        Object object2 = MESSAGING_ENGINES;
        synchronized (object2) {
            object = (Set)MESSAGING_ENGINES.get(this._messagingEngine.getBusName());
            if (object != null) {
                object.remove(this._messagingEngine);
                if (object.isEmpty()) {
                    MESSAGING_ENGINES.remove(this._messagingEngine.getBusName());
                }
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "Received destroy for unknown ME:", this._messagingEngine);
            }
        }
        object2 = SibRaEngineComponent.getListeners(this._messagingEngine.getBusName());
        object = object2.iterator();
        while (object.hasNext()) {
            SibRaMessagingEngineListener sibRaMessagingEngineListener = (SibRaMessagingEngineListener)object.next();
            sibRaMessagingEngineListener.messagingEngineDestroyed(this._messagingEngine);
        }
        this._messagingEngine = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "destroy");
        }
    }

    public void setCustomProperty(String string, String string2) {
    }

    public void setAttribute(String string, String string2) {
    }

    public void serverStarted() {
    }

    public void serverStopping() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "serverStopping");
            SibTr.exit(TRACE, "serverStopping");
        }
        _serverStopping = true;
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "busReloaded", new Object[]{sIBus, bl, bl2, bl3});
        }
        RELOADING_MESSAGING_ENGINES.add(this._messagingEngine.getUuid().toString());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "engineReloaded", jsMessagingEngine);
        }
        RELOADING_MESSAGING_ENGINES.remove(jsMessagingEngine.getUuid().toString());
        Set set = SibRaEngineComponent.getListeners(jsMessagingEngine.getBusName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SibRaMessagingEngineListener sibRaMessagingEngineListener = (SibRaMessagingEngineListener)iterator.next();
            sibRaMessagingEngineListener.messagingEngineReloaded(jsMessagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "engineReloaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getListeners(String string) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getListeners", (Object)string);
        }
        HashSet hashSet = new HashSet();
        Map map = MESSAGING_ENGINE_LISTENERS;
        synchronized (map) {
            Set set;
            Set set2 = (Set)MESSAGING_ENGINE_LISTENERS.get(string);
            if (set2 != null) {
                hashSet.addAll(set2);
            }
            if ((set = (Set)MESSAGING_ENGINE_LISTENERS.get(null)) != null) {
                hashSet.addAll(set);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getListeners", hashSet);
        }
        return hashSet;
    }

    static {
        MESSAGING_ENGINES = new HashMap();
        ACTIVE_MESSAGING_ENGINES = new HashMap();
        MESSAGING_ENGINE_LISTENERS = new HashMap();
        RELOADING_MESSAGING_ENGINES = Collections.synchronizedSet(new HashSet());
        TRACE = SibTr.register(SibRaEngineComponent.class, "SIBRa", "com.ibm.ws.sib.ra.CWSIVMessages");
    }
}

