/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.multicast.rmm.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.multicast.MulticastFactory;
import com.ibm.ws.sib.multicast.MulticastReceiver;
import com.ibm.ws.sib.multicast.MulticastTransmitter;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMConstants;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMReceiver;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMTransmitter;
import com.ibm.ws.sib.multicast.rmm.impl.StreamWrapper;
import com.ibm.ws.sib.processor.MulticastProperties;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Map;

public class RMMFactory
extends MulticastFactory
implements JSRMMConstants {
    private static final TraceComponent tc = SibTr.register(RMMFactory.class, "SIBCommunications", "com.ibm.ws.sib.multicast.SICMMessages");
    private HashMap transmitters = new HashMap();
    private HashMap receivers = new HashMap();
    private HashMap siCoreConnections = new HashMap();
    private boolean closed = false;

    public synchronized MulticastTransmitter getTransmitter(String string, MulticastProperties multicastProperties) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getTransmitter", new Object[]{string, multicastProperties});
        }
        MulticastTransmitter multicastTransmitter = null;
        if (!this.closed) {
            StreamWrapper streamWrapper = new StreamWrapper(multicastProperties.getMulticastGroupAddress(), string, multicastProperties.isReliable(), multicastProperties.getMulticastPort());
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Searching for transmitter with ID: " + streamWrapper);
            }
            if ((multicastTransmitter = (MulticastTransmitter)this.transmitters.get(streamWrapper)) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "No transmitter was available, creating a new one.");
                }
                multicastTransmitter = new JSRMMTransmitter(string, multicastProperties, streamWrapper, this);
                this.transmitters.put(streamWrapper, multicastTransmitter);
            }
            multicastTransmitter.incrementUseCount();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Closed");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getTransmitter", multicastTransmitter);
        }
        return multicastTransmitter;
    }

    public synchronized MulticastReceiver getReceiver(String string, String string2, String string3, boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getReceiver", new Object[]{string, string2, string3, "" + bl, "" + n});
        }
        MulticastReceiver multicastReceiver = null;
        if (!this.closed) {
            StreamWrapper streamWrapper = new StreamWrapper(string, string3, bl, n);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Searching for receiver with ID: " + streamWrapper);
            }
            if ((multicastReceiver = (MulticastReceiver)this.receivers.get(streamWrapper)) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "No receiver was available, creating a new one.");
                }
                multicastReceiver = new JSRMMReceiver(string, string2, string3, bl, n, streamWrapper, this);
                this.receivers.put(streamWrapper, multicastReceiver);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getReceiver", multicastReceiver);
        }
        return multicastReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit(this, tc, "close");
                }
                return;
            }
            this.closed = true;
        }
        object2 = this.receivers.entrySet().iterator();
        while (object2.hasNext()) {
            object = (MulticastReceiver)object2.next();
            object.close();
        }
        object = this.transmitters.entrySet().iterator();
        while (object.hasNext()) {
            MulticastTransmitter multicastTransmitter = (MulticastTransmitter)object.next();
            multicastTransmitter.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    synchronized void closed(JSRMMTransmitter jSRMMTransmitter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closed", jSRMMTransmitter);
        }
        if (!this.closed) {
            this.transmitters.remove(jSRMMTransmitter.getId());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closed");
        }
    }

    synchronized void closed(JSRMMReceiver jSRMMReceiver) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closed", jSRMMReceiver);
        }
        if (!this.closed) {
            this.receivers.remove(jSRMMReceiver.getId());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closed");
        }
    }

    public Map getReceivers() {
        return this.receivers;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.multicast.rmm.impl/src/com/ibm/ws/sib/multicast/rmm/impl/RMMFactory.java, SIB.comms, WAS602.SIB, o0610.11 1.7");
        }
    }
}

