/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.multicast.rmm.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.MessageListener;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.receiver.TopicR;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.multicast.MulticastReceiveListener;
import com.ibm.ws.sib.multicast.MulticastReceiver;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMConstants;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMLogEventListener;
import com.ibm.ws.sib.multicast.rmm.impl.RMMFactory;
import com.ibm.ws.sib.multicast.rmm.impl.StreamWrapper;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class JSRMMReceiver
implements MulticastReceiver,
MessageListener,
JSRMMConstants {
    private static final String CLASS_NAME;
    private static final TraceComponent tc;
    private static final TraceNLS nls;
    private static WsByteBufferPoolManager poolMgr;
    private static RMReceiver rmmR;
    private static HashMap groups;
    private static int rmmReceiverUseCount;
    private String multicastGroup;
    private String streamId;
    private boolean isReliable;
    private StreamWrapper id;
    private boolean closed = false;
    private TopicR topicR;
    private List listeners = new ArrayList();
    private RMMFactory factory = null;

    private static synchronized void joinGroup(String string, String string2, int n) {
        GroupCounter groupCounter;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "joinGroup", new Object[]{string, string2, "" + n});
        }
        if ((groupCounter = (GroupCounter)groups.get(string)) != null) {
            groupCounter.count++;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Already joined. Use count: " + groupCounter.count);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "We are not joined to this group - joining now.");
            }
            if (rmmR == null) {
                rmmR = JSRMMReceiver.instantiateReceiver(string2, n);
            }
            rmmR.joinMulticastGroup(string);
            groups.put(string, new GroupCounter());
            ++rmmReceiverUseCount;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "RMMReceiver use count: " + rmmReceiverUseCount);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "joinGroup");
        }
    }

    private static synchronized void leaveGroup(String string) {
        GroupCounter groupCounter;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "leaveGroup", (Object)string);
        }
        if ((groupCounter = (GroupCounter)groups.get(string)) != null) {
            groupCounter.count--;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Use count is now: " + groupCounter.count);
            }
            if (groupCounter.count <= 0) {
                rmmR.leaveMulticastGroup(string);
                groups.remove(string);
                --rmmReceiverUseCount;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "RMMReceiver use count: " + rmmReceiverUseCount);
                }
                if (rmmReceiverUseCount == 0) {
                    rmmR.stop();
                    rmmR = null;
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "We are not joined to this group??");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "leaveGroup");
        }
    }

    private static RMReceiver instantiateReceiver(String string, int n) {
        if (tc.isDebugEnabled()) {
            SibTr.entry(tc, "instantiateReceiver", new Object[]{string, "" + n});
        }
        Properties properties = new Properties();
        properties.setProperty("DataPort", "" + n);
        properties.setProperty("MulticastInterface", string);
        properties.setProperty("PacketBufferSizeBytes", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxPacketBufferSizeBytes", "8000"));
        properties.setProperty("BackoffTimeMillis", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxBackoffTimeMillis", "0"));
        properties.setProperty("NackCheckPeriodMillis", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxNackCheckPeriodMillis", "300"));
        properties.setProperty("SocketBufferSizeKbyte", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxSocketBufferSizeKBytes", "3000"));
        properties.setProperty("PacketBuffers", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxPacketBuffers", "500"));
        properties.setProperty("FirstSourceTimeoutSec", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastRxFirstSourceTimeoutSec", "10"));
        properties.setProperty("LogLevel", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastLogLevel", "none"));
        properties.setProperty("DebugLevel", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastDebugLevel", "none"));
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Getting receiver with the following params:", properties);
        }
        RMReceiver rMReceiver = RMReceiver.getInstance((Properties)properties, (int)2, (int)0, (LogEventListener)new JSRMMLogEventListener());
        if (tc.isDebugEnabled()) {
            SibTr.exit(tc, "instantiateReceiver", rMReceiver);
        }
        return rMReceiver;
    }

    public JSRMMReceiver(String string, String string2, String string3, boolean bl, int n, StreamWrapper streamWrapper, RMMFactory rMMFactory) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{string, string2, string3, "" + bl, "" + n, streamWrapper, rMMFactory});
        }
        this.multicastGroup = string;
        this.streamId = string3;
        this.isReliable = bl;
        this.id = streamWrapper;
        this.factory = rMMFactory;
        JSRMMReceiver.joinGroup(string, string2, n);
        this.topicR = rmmR.createTopicReceiver(string3, bl);
        this.topicR.setMessageListener((MessageListener)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public synchronized void registerListener(MulticastReceiveListener multicastReceiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "registerListener", multicastReceiveListener);
        }
        this.listeners.add(multicastReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "registerListener");
        }
    }

    public synchronized void deregisterListener(MulticastReceiveListener multicastReceiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deregisterListener", multicastReceiveListener);
        }
        this.listeners.remove(multicastReceiveListener);
        if (this.listeners.isEmpty()) {
            this.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deregisterListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        JSRMMReceiver jSRMMReceiver = this;
        synchronized (jSRMMReceiver) {
            if (!this.closed) {
                this.closed = true;
                this.topicR.close();
                this.topicR = null;
                JSRMMReceiver.leaveGroup(this.multicastGroup);
                this.factory.closed(this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    protected StreamWrapper getId() {
        return this.id;
    }

    public synchronized void onMessage(byte[] byArray) {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "onMessage", "Data length: " + byArray.length);
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes(this, tc, byArray);
        }
        boolean bl = true;
        if (byArray.length < JFAP_PROXY_MESSAGE_HEADER_END) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Received a message with an invalid header length", "" + byArray.length);
            }
            bl = false;
        }
        if (bl) {
            for (n = 0; n < HDR_EYE_CATCHER.length; ++n) {
                if (byArray[0 + n] == HDR_EYE_CATCHER[n]) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Bad eyecatcher received");
                }
                bl = false;
            }
        }
        if (bl) {
            n = this.getIntFromByteArray(byArray, HDR_LENGTH_OFFSET);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Message length", "" + n);
            }
            if (n != byArray.length) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Invalid message length", "" + n);
                }
                bl = false;
            }
        }
        if (bl) {
            n = 0xFF & byArray[HDR_SEGMENT_TYPE_OFFSET];
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Received segment", "" + n);
            }
            if (n != 241) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Invalid segment type", "" + n);
                }
                bl = false;
            }
        }
        if (bl) {
            long l = this.getLongFromByteArray(byArray, JFAP_PROXY_MESSAGE_JMO_LENGTH_OFFSET);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "JMO Length", "" + l);
            }
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                MulticastReceiveListener multicastReceiveListener = (MulticastReceiveListener)iterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Delivering message to ", multicastReceiveListener);
                }
                WsByteBuffer wsByteBuffer = poolMgr.wrap(byArray, JFAP_PROXY_MESSAGE_HEADER_END, (int)l);
                multicastReceiveListener.onMessage(wsByteBuffer, this);
            }
        }
        if (!bl) {
            SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("BAD_MULTICAST_DATA_RECEIVED_SICO4001", null, null));
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".onMessage"), (String)"1-002", (Object[])new Object[]{SibTr.formatBytes(byArray, 0, byArray.length), this});
            this.closeConsumerWithException(sIConnectionLostException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "onMessage");
        }
    }

    public long getLongFromByteArray(byte[] byArray, int n) {
        return ((0xFF & byArray[n + 0]) << 56) + ((0xFF & byArray[n + 1]) << 28) + ((0xFF & byArray[n + 2]) << 40) + ((0xFF & byArray[n + 3]) << 32) + this.getIntFromByteArray(byArray, n + 4);
    }

    public int getIntFromByteArray(byte[] byArray, int n) {
        return ((0xFF & byArray[n + 0]) << 24) + ((0xFF & byArray[n + 1]) << 16) + ((0xFF & byArray[n + 2]) << 8) + ((0xFF & byArray[n + 3]) << 0);
    }

    public void onEvent(Event event) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "onEvent", event);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Received event (" + event.getType() + "): " + this.getEventName(event.getType()));
        }
        switch (event.getType()) {
            case 100: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Total reception buffer size:", "" + event.getLongField());
                    SibTr.debug(this, tc, "FIFO buffer size:", "" + event.getIntField());
                }
                this.closeConsumerWithEvent(event);
                break;
            }
            case 5: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Source address of transmiiter:", event.getSourceAddress());
                    SibTr.debug(this, tc, "Source port of transmitter:", "" + event.getSourcePort());
                }
                this.closeConsumerWithEvent(event);
                break;
            }
            case 2: {
                this.closeConsumerWithEvent(event);
                break;
            }
            case 103: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Total reception buffer size:", "" + event.getLongField());
                    SibTr.debug(this, tc, "FIFO buffer size:", "" + event.getIntField());
                }
                this.closeConsumerWithEvent(event);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Number of packets lost:", "" + event.getIntField());
                }
                this.closeConsumerWithEvent(event);
                break;
            }
            case 3: {
                this.closeConsumerWithEvent(event);
                break;
            }
            case 18: {
                break;
            }
            case 10: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug(this, tc, "Source address of transmiiter:", event.getSourceAddress());
                SibTr.debug(this, tc, "Source port of transmitter:", "" + event.getSourcePort());
                SibTr.debug(this, tc, "Topic tag:", new String((byte[])event.getObjectField()));
                break;
            }
            case 17: {
                break;
            }
            case 4: {
                break;
            }
            case 102: {
                break;
            }
            case 101: {
                break;
            }
            case 14: {
                break;
            }
            case 13: {
                break;
            }
            case 12: {
                break;
            }
            case 11: {
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "onEvent");
        }
    }

    private void closeConsumerWithEvent(Event event) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeConsumerWithEvent", event);
        }
        SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("MULTICAST_CONNECTION_CLOSED_SICO4002", new Object[]{this.getEventName(event.getType()), event.getDescription()}, null));
        this.closeConsumerWithException(sIConnectionLostException);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeConsumerWithEvent");
        }
    }

    private void closeConsumerWithException(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeConsumerWithException", throwable);
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MulticastReceiveListener multicastReceiveListener = (MulticastReceiveListener)iterator.next();
            multicastReceiveListener.closed(this, throwable);
        }
        this.listeners.clear();
        this.close();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeConsumerWithException");
        }
    }

    private String getEventName(int n) {
        String string = "[Unknown event name]";
        try {
            Class clazz = Event.class;
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    int n2 = fieldArray[i].getInt(null);
                    if (n2 != n) continue;
                    string = "[" + fieldArray[i].getName() + "]";
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    static {
        block3: {
            CLASS_NAME = JSRMMReceiver.class.getName();
            tc = SibTr.register(JSRMMReceiver.class, "SIBCommunications", "com.ibm.ws.sib.multicast.SICMMessages");
            nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
            poolMgr = null;
            rmmR = null;
            groups = new HashMap();
            rmmReceiverUseCount = 0;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "@(#)SIB/ws/code/sib.multicast.rmm.impl/src/com/ibm/ws/sib/multicast/rmm/impl/JSRMMReceiver.java, SIB.comms, WAS602.SIB, o0610.11 1.11");
            }
            try {
                ClientConnectionManager.initialise();
                poolMgr = ClientConnectionManager.getRef().getBufferPoolManager();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.multicast.rmm.impl.JSRMMReceiver", (String)"3-001");
                if (!tc.isDebugEnabled()) break block3;
                SibTr.debug(tc, "Unable to initialise Client connection manager", sIException);
            }
        }
    }

    private static class GroupCounter {
        private int count = 1;

        private GroupCounter() {
        }
    }
}

