/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class HexString {
    private static final TraceComponent tc = SibTr.register(HexString.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    public static void binToHex(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "binToHex " + n + ", " + n2 + ", " + stringBuffer);
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        boolean bl = false;
        for (int i = n; i < n + n2; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            stringBuffer.append(cArray[n3 / 16]);
            stringBuffer.append(cArray[n3 % 16]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "binToHex " + stringBuffer);
        }
    }

    public static byte[] hexToBin(String string, int n) {
        int n2 = string.length() - n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "hexToBin " + string + ", " + n);
        }
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 0 || n2 % 2 != 0) {
            String string2 = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0200", new Object[]{string}, "The hexadecimal string " + string + " is incorrectly formatted.");
            throw new IllegalArgumentException(string2);
        }
        byte[] byArray = new byte[n2 /= 2];
        for (int i = 0; i < n2; ++i) {
            int n3 = Character.digit(string.charAt(2 * i + n), 16) << 4;
            int n4 = Character.digit(string.charAt(2 * i + n + 1), 16);
            if (n3 < 0 || n4 < 0) {
                String string3 = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0200", new Object[]{string}, "The hexadecimal string " + string + " is incorrectly formatted.");
                throw new IllegalArgumentException(string3);
            }
            byArray[i] = (byte)(n3 + n4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "hexToBin");
        }
        return byArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp/src/com/ibm/ws/sib/mfp/util/HexString.java, SIB.mfp, WAS602.SIB, o0610.11 1.8");
        }
    }
}

