/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElement;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElementList;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.QName;
import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class MIMEPartHandler
extends HandlerStack.HandlerBase {
    private static final TraceComponent tc = SibTr.register(MIMEPartHandler.class, "com.ibm.ws.sib.mfp.CWSIFMessages", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static Pattern ap10Pattern = Pattern.compile("=.+@.+");
    private SOAPParser.BasicState basicState;
    private String partName;
    private XSDMetaData xsdMeta;
    private Map mimeParts;
    private EStructuralFeature expectedPart;

    public MIMEPartHandler(SOAPParser.BasicState basicState) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "MIMEPartHandler", basicState);
        }
        this.basicState = basicState;
        this.xsdMeta = this.basicState.getXsdMetaData();
        WSDLMetaData wSDLMetaData = this.basicState.getWsdlMetaData();
        this.mimeParts = wSDLMetaData.getMIMEParts(this.basicState.getDescriptor());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "MIMEPartHandler", this);
        }
    }

    boolean allowText() {
        return false;
    }

    public void handleUnreferencedParts() throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleUnreferencedParts");
        }
        DataObject dataObject = this.basicState.getInfoNode();
        List list = dataObject.getList("attachments");
        EClass eClass = (EClass)this.xsdMeta.getGlobalType("MIMEAttachmentEntryType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", null);
        EClass eClass2 = (EClass)this.xsdMeta.getGlobalType("BoundMIMEAttachmentEntryType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", null);
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        Iterator iterator = this.basicState.getMimeElements().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            MimeElement mimeElement = (MimeElement)iterator.next();
            if (mimeElement.isStart()) continue;
            DataObject dataObject2 = null;
            if (this.mimeParts != null) {
                object3 = this.mimeParts.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (!MIMEPartHandler.matchesPartName((String)object2, mimeElement.getContentID()) || (object = dataObject.getDataObject("body")).isSet((String)object2)) continue;
                    dataObject2 = (DataObject)eFactory.create(eClass2);
                    dataObject2.setString("messagePart", (String)object2);
                    object.set((String)object2, mimeElement.getContent());
                    break;
                }
            }
            if (dataObject2 == null) {
                try {
                    object2 = mimeElement.getInputStream();
                    object3 = new byte[((InputStream)object2).available()];
                    ((InputStream)object2).read((byte[])object3);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler.handleUnreferencedParts", (String)"158", (Object)this);
                    object = nls.getFormattedMessage("MIME_IO_ERROR_CWSIF0358", new Object[]{mimeElement.getContentID(), mimeElement.getContentType(), iOException}, "IOException handling MIME element");
                    throw new DataMediatorException((String)object, iOException);
                }
                dataObject2 = (DataObject)eFactory.create(eClass);
                dataObject2.setBytes("data", (byte[])object3);
            }
            dataObject2.setString("contentType", mimeElement.getContentType());
            dataObject2.setString("contentTransferEncoding", mimeElement.getEncoding());
            dataObject2.setString("contentId", mimeElement.getContentID());
            list.add(dataObject2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleUnreferencedParts");
        }
    }

    public void endElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    private void handleBoundMessagePart() throws DataMediatorException, ResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleBoundMessagePart");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        boolean[] blArray = handlerStack.getProcessedAttributes();
        String string = null;
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            if (blArray[i]) continue;
            object = documentScannerSupport.attrNames[i];
            if ("href".equals(((QName)object).localPart) && "".equals(((QName)object).namespaceURI)) {
                string = documentScannerSupport.attValues[i].toString();
                continue;
            }
            String string2 = nls.getFormattedMessage("MIME_ATTR_ERROR_CWSIF0355", new Object[]{this.partName, ((QName)object).localPart, ((QName)object).namespaceURI}, "Unexpected attribute");
            throw new DataMediatorException(string2);
        }
        if (string.startsWith("cid:")) {
            string = string.substring(4);
        }
        MimeElementList mimeElementList = this.basicState.getMimeElements();
        object = null;
        if (mimeElementList != null) {
            object = mimeElementList.getAttachment(string);
        }
        if (object == null) {
            String string3 = nls.getFormattedMessage("MIME_REF_NOT_FOUND_CWSIF0357", new Object[]{this.partName, string}, "Reference not found");
            throw new DataMediatorException(string3);
        }
        DataObject dataObject = this.basicState.getInfoNode();
        List list = dataObject.getList("attachments");
        EClass eClass = (EClass)this.xsdMeta.getGlobalType("BoundMIMEAttachmentEntryType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", null);
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        DataObject dataObject2 = (DataObject)eFactory.create(eClass);
        dataObject2.setString("contentType", object.getContentType());
        dataObject2.setString("contentTransferEncoding", object.getEncoding());
        dataObject2.setString("contentId", object.getContentID());
        dataObject2.setString("messagePart", this.partName);
        list.add(dataObject2);
        mimeElementList.remove(object);
        DataObject dataObject3 = dataObject.getDataObject("body");
        dataObject3.set(this.partName, object.getContent());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleBoundMessagePart");
        }
    }

    public void startElementEvent(boolean bl) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent", new Boolean(bl));
        }
        DocumentScannerSupport documentScannerSupport = this.getHandlerStack().getScannerState();
        QName qName = documentScannerSupport.currentElement;
        if (this.partName == null) {
            this.partName = this.expectedPart != null ? ExtendedMetaData.INSTANCE.getName(this.expectedPart) : qName.localPart;
            try {
                this.handleBoundMessagePart();
            }
            catch (DataMediatorException dataMediatorException) {
                String string = nls.getFormattedMessage("MIME_REF_ERROR_CWSIF0356", new Object[]{this.partName, dataMediatorException}, "Exception processing attachment");
                throw new DataMediatorException(string, dataMediatorException);
            }
            catch (ResourceException resourceException) {
                String string = nls.getFormattedMessage("MIME_REF_ERROR_CWSIF0356", new Object[]{this.partName, resourceException}, "Exception processing attachment");
                throw new DataMediatorException(string, resourceException);
            }
        } else {
            String string = nls.getFormattedMessage("MIME_ELEM_ERROR_CWSIF0354", new Object[]{this.partName, qName.localPart, qName.namespaceURI}, "Unexpected element");
            throw new DataMediatorException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    public static boolean matchesPartName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "matchesPartName", new Object[]{string, string2});
        }
        Boolean bl = Boolean.FALSE;
        String string3 = MIMEPartHandler.encodePartName(string);
        if (string3.length() < string2.length()) {
            Matcher matcher;
            String string4 = string2.substring(0, string3.length());
            String string5 = string2.substring(string3.length());
            if (string4.equals(string3) && (matcher = ap10Pattern.matcher(string5)).matches()) {
                bl = Boolean.TRUE;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "matchesPartName", bl);
        }
        return bl;
    }

    public static String encodePartName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodePartName", (Object)string);
        }
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler.encodePartName", (String)"325");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodePartName", (Object)string2);
        }
        return string2;
    }

    void setExpectedPart(EProperty eProperty) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setExpectedPart", eProperty);
        }
        if (eProperty != null) {
            this.expectedPart = eProperty.getEStructuralFeature();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setExpectedPart");
        }
    }
}

