/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIMessageParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.AbstractSdoStore;
import com.ibm.ws.sib.mfp.sdo.OutputHelper;
import com.ibm.ws.sib.mfp.sdo.SdoAdapter;
import com.ibm.ws.sib.mfp.sdo.SdoCopier;
import com.ibm.ws.sib.mfp.sdo.SdoStore;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElement;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElementList;
import com.ibm.ws.sib.mfp.sdo.mime.MimeFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.soap.DocumentScanner;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediator;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.BasicXMLHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.DocumentHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.EnvelopeHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.FaultHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HeaderHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MessageIdentificationHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.ParseState;
import com.ibm.ws.sib.mfp.sdo.soap.parse.RPCHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPEncodedHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentEventHandler;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;

public class InfoNodeStore
extends AbstractSdoStore
implements Cloneable {
    private static TraceComponent tc = SibTr.register(InfoNodeStore.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String NULL_STRING = "explicit null string";
    ResourceCache cache;
    WSDLMetaData wsdlMeta;
    XSDMetaData xsdMeta;
    private boolean parsing = false;
    private DocumentScanner scanner;
    private SOAPFormatDescriptor descriptor;
    private String operationName;
    private String messageName;
    private String messageType;
    private String bufferType;
    private byte[] buffer;
    private int bufferStart;
    private int bufferLength;
    private boolean doneInitialParse;
    private boolean doneIdentifyMessage;
    private boolean doneBody;
    private boolean doneHeaders;
    private boolean doneAttachments;
    private MimeElementList mimeElements;
    private List mimeContentIds;
    private DocumentScanner.SavedState headerState;
    private DocumentScanner.SavedState bodyState;
    private Map mimeParts;
    private List headerParts;
    private EStructuralFeature operationNameFeature;
    private EStructuralFeature messageNameFeature;
    private EStructuralFeature messageTypeFeature;
    private EStructuralFeature attachmentFeature;
    private EStructuralFeature headerFeature;
    private EStructuralFeature bodyFeature;
    BasicEList attachments = new BasicEList();
    BasicEList headers = new BasicEList();
    DataObject body = null;
    private ResourceSet resources;
    private DataObject infoNode;
    private Exception lastError = null;

    InfoNodeStore(EClass eClass, String string, byte[] byArray, int n, int n2, SOAPFormatDescriptor sOAPFormatDescriptor, ResourceCache resourceCache, WSDLMetaData wSDLMetaData, XSDMetaData xSDMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "InfoNodeStore", new Object[]{eClass, string, byArray, new Integer(n), new Integer(n2), sOAPFormatDescriptor});
        }
        this.descriptor = sOAPFormatDescriptor;
        this.bufferType = string;
        this.buffer = byArray;
        this.bufferStart = n;
        this.bufferLength = n2;
        this.cache = resourceCache;
        this.wsdlMeta = wSDLMetaData;
        this.xsdMeta = xSDMetaData;
        this.operationNameFeature = eClass.getEStructuralFeature("operationName");
        this.messageNameFeature = eClass.getEStructuralFeature("messageName");
        this.messageTypeFeature = eClass.getEStructuralFeature("messageType");
        this.attachmentFeature = eClass.getEStructuralFeature("attachments");
        this.headerFeature = eClass.getEStructuralFeature("headers");
        this.bodyFeature = eClass.getEStructuralFeature("body");
        this.resources = XSDResourceHelper.createResourceSet(this.descriptor.getLocation(), this.cache);
        this.scanner = new DocumentScanner(this.buffer, n, n2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "InfoNodeStore", this);
        }
    }

    public SdoStore copy() {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "copy");
        }
        InfoNodeStore infoNodeStore = null;
        try {
            infoNodeStore = (InfoNodeStore)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.InfoNodeStore.copy", (String)"237", (Object)this);
        }
        infoNodeStore.descriptor = new SOAPFormatDescriptor(this.descriptor);
        if (null != this.mimeElements) {
            infoNodeStore.mimeElements = this.mimeElements.copy();
        }
        infoNodeStore.headers = new BasicEList();
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            infoNodeStore.headers.add((Object)SdoCopier.copy(dataObject));
        }
        infoNodeStore.attachments = new BasicEList();
        iterator = this.attachments.iterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            infoNodeStore.attachments.add((Object)SdoCopier.copy(dataObject));
        }
        if (this.body != null) {
            infoNodeStore.body = SdoCopier.copy(this.body);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "copy", infoNodeStore);
        }
        return infoNodeStore;
    }

    public String dumpState() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Format descriptor:\n");
        stringBuffer.append(this.descriptor);
        stringBuffer.append("\n");
        stringBuffer.append("\nUser visible meta data:");
        stringBuffer.append("\noperationName: ");
        stringBuffer.append(this.operationName);
        stringBuffer.append("\nmessageName  : ");
        stringBuffer.append(this.messageName);
        stringBuffer.append("\nmessageType  : ");
        stringBuffer.append(this.messageType);
        stringBuffer.append("\n");
        stringBuffer.append("\nInitial parse: ");
        stringBuffer.append(this.doneInitialParse);
        stringBuffer.append("\nIdentify msg : ");
        stringBuffer.append(this.doneIdentifyMessage);
        stringBuffer.append("\nParse body   : ");
        stringBuffer.append(this.doneBody);
        stringBuffer.append("\nParse headers: ");
        stringBuffer.append(this.doneHeaders);
        stringBuffer.append("\nParse attach : ");
        stringBuffer.append(this.doneAttachments);
        if (this.lastError != null) {
            stringBuffer.append("\nLast Error   : ");
            stringBuffer.append(this.lastError.getMessage());
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print("\nStack trace:\n");
            this.lastError.printStackTrace(printWriter);
            printWriter.flush();
            stringBuffer.append(stringWriter.toString());
        }
        stringBuffer.append("\nMessage Buffer:\n");
        stringBuffer.append(OutputHelper.print(this.buffer, this.bufferStart, this.bufferLength));
        stringBuffer.append("\n");
        stringBuffer.append("\nHeader Buffer:\n");
        if (this.headerState != null) {
            stringBuffer.append(this.headerState.dumpState());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("\nBody buffer:\n");
        if (this.bodyState != null) {
            stringBuffer.append(this.bodyState.dumpState());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("\nCurrent body data object:\n");
        stringBuffer.append(OutputHelper.trace(this.body));
        stringBuffer.append("\n");
        stringBuffer.append("\nCurrent header data object list:\n");
        stringBuffer.append(OutputHelper.trace(this.headers));
        stringBuffer.append("\n");
        stringBuffer.append("\nCurrent attachment data object list:\n");
        stringBuffer.append(OutputHelper.trace(this.attachments));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void setProxyNode(DataObject dataObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setProxyNode", dataObject);
        }
        this.infoNode = dataObject;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setProxyNode");
        }
    }

    private void initialParse() throws DataMediatorException, IOException, ResourceException {
        Object object;
        Object object2;
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialParse");
        }
        boolean bl2 = bl = this.bufferType != null && this.bufferType.length() > 0;
        if (!bl) {
            bl = true;
            object2 = "Content-Type".getBytes("US-ASCII");
            for (int i = 0; bl && i < ((byte[])object2).length; ++i) {
                if (this.bufferLength >= i && object2[i] == this.buffer[this.bufferStart + i]) continue;
                bl = false;
            }
        }
        object2 = null;
        MimeElement mimeElement = null;
        if (bl) {
            this.mimeElements = MimeFactory.createMimeMessageParser(this.bufferType, this.buffer, this.bufferStart, this.bufferLength);
            mimeElement = this.mimeElements.getStartPart();
            object2 = mimeElement.getInputStream();
            this.mimeContentIds = new ArrayList();
            object = this.mimeElements.iterator();
            while (object.hasNext()) {
                MimeElement mimeElement2 = (MimeElement)object.next();
                if (mimeElement2.isStart()) continue;
                this.mimeContentIds.add(mimeElement2.getContentID());
            }
        } else {
            this.mimeElements = null;
            object2 = new ByteArrayInputStream(this.buffer, this.bufferStart, this.bufferLength);
        }
        object = new EnvelopeHandler(this, this.scanner);
        try {
            this.scanner.scanDocument((DocumentEventHandler)object, (InputStream)object2);
        }
        catch (EnvelopeHandler.TunneledIOException tunneledIOException) {
            IOException iOException = tunneledIOException.getException();
            throw iOException;
        }
        this.bufferType = null;
        this.buffer = null;
        this.bufferStart = -1;
        this.bufferLength = -1;
        this.doneInitialParse = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialParse");
        }
    }

    private void identifyMessage() throws ResourceException, DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "identifyMessage");
        }
        if (this.descriptor.usingWSDL()) {
            MessageIdentificationHandler messageIdentificationHandler = new MessageIdentificationHandler(this.descriptor, this.wsdlMeta, this.mimeContentIds, this.cache);
            HandlerStack handlerStack = new HandlerStack(this.scanner, this.bodyState, true, this.wsdlMeta);
            handlerStack.pushDocumentHandler(messageIdentificationHandler);
            try {
                this.scanner.resumeScan(handlerStack, this.bodyState);
                messageIdentificationHandler.completeIdentification(true);
            }
            catch (MessageIdentificationHandler.ParseComplete parseComplete) {
                // empty catch block
            }
            this.mimeParts = this.wsdlMeta.getMIMEParts(this.descriptor);
            this.headerParts = this.wsdlMeta.getBoundHeaderParts(this.descriptor);
            this.operationName = this.descriptor.getOperationName();
            this.messageName = this.descriptor.getMessageName();
            this.messageType = this.descriptor.getMessageType();
        }
        this.doneIdentifyMessage = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "identifyMessage");
        }
    }

    private void parseBody() throws ResourceException, DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseBody");
        }
        if (this.bodyState != null) {
            object = this.getInfoNode();
            Property property = object.getType().getProperty("body");
            SOAPParser.BasicState basicState = new SOAPParser.BasicState();
            basicState.setWsdlMetaData(this.wsdlMeta);
            basicState.setXsdMetaData(this.xsdMeta);
            basicState.setDescriptor(this.descriptor);
            basicState.setInfoNode(this.getInfoNode());
            basicState.setMimeElements(this.mimeElements);
            basicState.setOnDemandResources(this.getResources());
            HandlerStack.HandlerBase handlerBase = null;
            HandlerStack handlerStack = null;
            if (this.descriptor.usingWSDL()) {
                String string = this.descriptor.getMessageType();
                handlerStack = new HandlerStack(this.scanner, this.bodyState, true, this.wsdlMeta);
                if (!"fault".equals(string)) {
                    DataObject dataObject = InfoNodeStore.createMessageNode(basicState, object, property);
                    handlerBase = this.wsdlMeta.isRPC(this.descriptor) ? new RPCHandler(basicState, dataObject, this.mimeContentIds) : new DocumentHandler(basicState, dataObject, this.mimeContentIds);
                } else {
                    handlerBase = new FaultHandler(basicState, this.mimeContentIds);
                }
            } else {
                handlerStack = new HandlerStack(this.scanner, this.bodyState, false, this.wsdlMeta);
                EClassifier eClassifier = this.xsdMeta.getGlobalType("UnknownBodyType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel");
                EType eType = SDOUtil.adaptType((EClassifier)eClassifier);
                DataObject dataObject = object.createDataObject(property, (Type)eType);
                String string = ParseState.getEncoding(this.bodyState);
                if (string != null) {
                    dataObject.setString("encodingStyle", string);
                }
                BasicXMLHandler basicXMLHandler = new BasicXMLHandler(basicState);
                basicXMLHandler.setCurrentNode(dataObject);
                handlerBase = basicXMLHandler;
            }
            handlerStack.pushDocumentHandler(handlerBase);
            this.scanner.resumeScan(handlerStack, this.bodyState);
            if (handlerBase instanceof SOAPEncodedHandler) {
                ((SOAPEncodedHandler)handlerBase).handleEndOfBody();
            }
            this.bodyState = null;
        }
        this.doneBody = true;
        if (this.body != null) {
            object = new AbstractSdoStore.DataObjectAdapter(this.body);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseBody");
        }
    }

    private void parseHeaders() throws ResourceException, DataMediatorException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseHeaders");
        }
        if (this.headerState != null) {
            object3 = new SOAPParser.BasicState();
            ((SOAPParser.BasicState)object3).setWsdlMetaData(this.wsdlMeta);
            ((SOAPParser.BasicState)object3).setXsdMetaData(this.xsdMeta);
            ((SOAPParser.BasicState)object3).setDescriptor(this.descriptor);
            ((SOAPParser.BasicState)object3).setInfoNode(this.getInfoNode());
            ((SOAPParser.BasicState)object3).setMimeElements(this.mimeElements);
            ((SOAPParser.BasicState)object3).setOnDemandResources(this.getResources());
            object2 = new HandlerStack(this.scanner, this.headerState, true, this.wsdlMeta);
            object = new HeaderHandler((SOAPParser.BasicState)object3, this.cache);
            ((HandlerStack)object2).pushDocumentHandler((HandlerStack.HandlerBase)object);
            this.scanner.resumeScan((DocumentEventHandler)object2, this.headerState);
            this.headerState = null;
        }
        this.doneHeaders = true;
        object3 = this.headers.iterator();
        while (object3.hasNext()) {
            object2 = (DataObject)object3.next();
            object = new AbstractSdoStore.DataObjectAdapter((DataObject)object2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseHeaders");
        }
    }

    private void parseAttachments() throws ResourceException, DataMediatorException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseAttachments");
        }
        if (this.mimeElements != null) {
            object2 = new SOAPParser.BasicState();
            ((SOAPParser.BasicState)object2).setWsdlMetaData(this.wsdlMeta);
            ((SOAPParser.BasicState)object2).setXsdMetaData(this.xsdMeta);
            ((SOAPParser.BasicState)object2).setDescriptor(this.descriptor);
            ((SOAPParser.BasicState)object2).setInfoNode(this.getInfoNode());
            ((SOAPParser.BasicState)object2).setMimeElements(this.mimeElements);
            ((SOAPParser.BasicState)object2).setOnDemandResources(this.getResources());
            object = new MIMEPartHandler((SOAPParser.BasicState)object2);
            ((MIMEPartHandler)object).handleUnreferencedParts();
        }
        this.doneAttachments = true;
        object2 = this.attachments.iterator();
        while (object2.hasNext()) {
            object = (DataObject)object2.next();
            AbstractSdoStore.DataObjectAdapter dataObjectAdapter = new AbstractSdoStore.DataObjectAdapter((DataObject)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseAttachments");
        }
    }

    public DocumentScanner.SavedState getHeaderState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getHeaderState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getHeaderState", this.headerState);
        }
        return this.headerState;
    }

    public void setHeaderState(DocumentScanner.SavedState savedState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setHeaderState", savedState);
        }
        this.headerState = savedState;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setHeaderState");
        }
    }

    public DocumentScanner.SavedState getBodyState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyState", this.bodyState);
        }
        return this.bodyState;
    }

    public void setBodyState(DocumentScanner.SavedState savedState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBodyState", savedState);
        }
        this.bodyState = savedState;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBodyState");
        }
    }

    public SOAPDataMediator.Message getInitialMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInitialMessage");
        }
        SOAPDataMediator.Message message = null;
        if (!this.doneInitialParse) {
            final byte[] byArray = this.buffer;
            final String string = this.bufferType;
            final int n = this.bufferStart;
            final int n2 = this.bufferLength;
            message = new SOAPDataMediator.Message(){

                public String getContentType() {
                    return string;
                }

                public byte[] getData() {
                    return byArray;
                }

                public int getStartOffset() {
                    return n;
                }

                public int getLength() {
                    return n2;
                }
            };
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInitialMessage", message);
        }
        return message;
    }

    ResourceSet getResources() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getResources");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getResources", this.resources);
        }
        return this.resources;
    }

    DataObject getInfoNode() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInfoNode");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInfoNode", this.infoNode);
        }
        return this.infoNode;
    }

    WSDLMetaData getWSDLMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getWSDLMetaData");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getWSDLMetaData", this.wsdlMeta);
        }
        return this.wsdlMeta;
    }

    public SOAPFormatDescriptor getDescriptor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDescriptor");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDescriptor", this.descriptor);
        }
        return this.descriptor;
    }

    MimeElementList getMimeElements() {
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMimeElements", this.mimeElements);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMimeElements");
        }
        return this.mimeElements;
    }

    static DataObject createMessageNode(SOAPParser.BasicState basicState, DataObject dataObject, Property property) throws ResourceException, DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createMessageNode", new Object[]{basicState, dataObject, property});
        }
        DataObject dataObject2 = null;
        SOAPFormatDescriptor sOAPFormatDescriptor = basicState.getDescriptor();
        WSDLMetaData wSDLMetaData = basicState.getWsdlMetaData();
        String string = sOAPFormatDescriptor.getMessageName();
        if (string != null) {
            EStructuralFeature eStructuralFeature = wSDLMetaData.getBodyFeature(sOAPFormatDescriptor);
            if (eStructuralFeature == null) {
                String string2 = nls.getFormattedMessage("MESSAGE_FEATURE_CWSIF0353", new Object[]{sOAPFormatDescriptor.getServiceNamespace(), sOAPFormatDescriptor.getServiceName(), sOAPFormatDescriptor.getOperationName(), sOAPFormatDescriptor.getMessageName()}, "Failed to locate body feature for message");
                throw new DataMediatorException(string2);
            }
            if (property == null) {
                property = SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature);
            }
            EType eType = SDOUtil.adaptType((EClassifier)eStructuralFeature.getEType());
            dataObject2 = dataObject.createDataObject(property, (Type)eType);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createMessageNode", dataObject2);
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseToLimit(EStructuralFeature eStructuralFeature, int n) {
        block23: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "parseToLimit", new Object[]{eStructuralFeature, new Integer(n)});
            }
            if (this.lastError != null) {
                String string = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{this.lastError}, "SOAP parse failure");
                throw new SIMessageParseException(string, this.lastError);
            }
            if (!this.parsing) {
                Exception exception = null;
                try {
                    block22: {
                        try {
                            this.parsing = true;
                            if (!this.doneInitialParse) {
                                this.initialParse();
                            }
                            if (eStructuralFeature == this.operationNameFeature || eStructuralFeature == this.messageNameFeature || eStructuralFeature == this.messageTypeFeature) {
                                if (!this.doneIdentifyMessage) {
                                    this.identifyMessage();
                                }
                                break block22;
                            }
                            if (eStructuralFeature == this.attachmentFeature) {
                                if (this.mimeElements == null) break block22;
                                if (!this.doneIdentifyMessage) {
                                    this.identifyMessage();
                                }
                                if (this.hasWSDLAttachments() && !this.doneBody) {
                                    this.parseBody();
                                }
                                if (this.doneAttachments) break block22;
                                this.parseAttachments();
                                break block22;
                            }
                            if (eStructuralFeature == this.headerFeature) {
                                if (this.headerState == null) break block22;
                                if (!this.doneIdentifyMessage) {
                                    this.identifyMessage();
                                }
                                if (this.hasWSDLHeaders() && !this.doneBody) {
                                    this.parseBody();
                                }
                                if (this.doneHeaders) break block22;
                                this.parseHeaders();
                                break block22;
                            }
                            if (!this.doneIdentifyMessage) {
                                this.identifyMessage();
                            }
                            if (!this.doneBody) {
                                this.parseBody();
                            }
                            if (this.hasWSDLHeaders() && !this.doneHeaders) {
                                this.parseHeaders();
                            }
                            if (!this.hasWSDLAttachments() || this.doneAttachments) break block22;
                            this.parseAttachments();
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.InfoNodeStore.parseToLimit", (String)"848", (Object)this);
                            exception = exception2;
                            Object var6_6 = null;
                            this.parsing = false;
                            if (exception != null) {
                                this.lastError = exception;
                                String string2 = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{exception}, "SOAP parse failure");
                                throw new SIMessageParseException(string2, exception);
                            }
                            break block23;
                        }
                    }
                    Object var6_5 = null;
                    this.parsing = false;
                    if (exception == null) break block23;
                    this.lastError = exception;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.parsing = false;
                    if (exception != null) {
                        this.lastError = exception;
                        String string = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{exception}, "SOAP parse failure");
                        throw new SIMessageParseException(string, exception);
                    }
                    throw throwable;
                }
                String string = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{exception}, "SOAP parse failure");
                throw new SIMessageParseException(string, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseToLimit");
        }
    }

    private boolean hasWSDLHeaders() {
        return this.headerParts != null && !this.headerParts.isEmpty();
    }

    private boolean hasWSDLAttachments() {
        return this.mimeParts != null && !this.mimeParts.isEmpty();
    }

    private void parseCompletely() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseCompletely");
        }
        this.parseToLimit(this.bodyFeature, -1);
        this.parseToLimit(this.headerFeature, -1);
        this.parseToLimit(this.attachmentFeature, -1);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseCompletely");
        }
    }

    private BasicEList getList(EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getList", eStructuralFeature);
        }
        BasicEList basicEList = null;
        if (eStructuralFeature == this.headerFeature) {
            basicEList = this.headers;
        } else if (eStructuralFeature == this.attachmentFeature) {
            basicEList = this.attachments;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getList", basicEList);
        }
        return basicEList;
    }

    public Object get(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "get", new Object[]{internalEObject, eStructuralFeature, new Integer(n)});
        }
        this.parseToLimit(eStructuralFeature, n);
        String string = null;
        if (eStructuralFeature == this.operationNameFeature) {
            string = this.operationName;
        } else if (eStructuralFeature == this.messageNameFeature) {
            string = this.messageName;
        } else if (eStructuralFeature == this.messageTypeFeature) {
            string = this.messageType;
        } else {
            if (eStructuralFeature == this.bodyFeature) {
                return this.body;
            }
            BasicEList basicEList = this.getList(eStructuralFeature);
            string = basicEList.get(n);
        }
        if (string == NULL_STRING) {
            string = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "get", (Object)string);
        }
        return string;
    }

    public Object set(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, int n, Object object) {
        NotificationImpl notificationImpl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "set", new Object[]{internalEObject, eStructuralFeature, new Integer(n), object});
        }
        this.parseToLimit(eStructuralFeature, n);
        Object object2 = this.get(internalEObject, eStructuralFeature, n);
        if (eStructuralFeature == this.operationNameFeature) {
            if (object == null) {
                object = NULL_STRING;
            }
            this.operationName = (String)object;
        } else if (eStructuralFeature == this.messageNameFeature) {
            if (object == null) {
                object = NULL_STRING;
            }
            this.messageName = (String)object;
        } else if (eStructuralFeature == this.messageTypeFeature) {
            if (object == null) {
                object = NULL_STRING;
            }
            this.messageType = (String)object;
        } else if (eStructuralFeature == this.bodyFeature) {
            this.body = (DataObject)object;
        } else {
            notificationImpl = this.getList(eStructuralFeature);
            notificationImpl.set(n, object);
        }
        notificationImpl = new NotificationImpl(1, object2, object);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "set", object2);
        }
        return object2;
    }

    public boolean isSet(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isSet", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        Object object = null;
        object = eStructuralFeature == this.operationNameFeature ? this.operationName : (eStructuralFeature == this.messageNameFeature ? this.messageName : (eStructuralFeature == this.messageTypeFeature ? this.messageType : (eStructuralFeature == this.bodyFeature ? this.body : this.getList(eStructuralFeature))));
        boolean bl2 = bl = object != null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isSet");
        }
        return bl;
    }

    public void unset(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unset", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        Object object = this.get(internalEObject, eStructuralFeature, -1);
        if (eStructuralFeature == this.operationNameFeature) {
            this.operationName = null;
        } else if (eStructuralFeature == this.messageNameFeature) {
            this.messageName = null;
        } else if (eStructuralFeature == this.messageTypeFeature) {
            this.messageType = null;
        }
        NotificationImpl notificationImpl = new NotificationImpl(2, object, null);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unset");
        }
    }

    public boolean isEmpty(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isEmpty", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        boolean bl = basicEList.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isEmpty", new Boolean(bl));
        }
        return bl;
    }

    public int size(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "size", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        int n = basicEList.size();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "size", new Integer(n));
        }
        return n;
    }

    public boolean contains(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "contains", new Object[]{internalEObject, eStructuralFeature, object});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        boolean bl = basicEList.contains(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "contains", new Boolean(bl));
        }
        return bl;
    }

    public int indexOf(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "indexOf", new Object[]{internalEObject, eStructuralFeature, object});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        int n = basicEList.indexOf(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "indexOf", new Integer(n));
        }
        return n;
    }

    public int lastIndexOf(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "lastIndexOf", new Object[]{internalEObject, eStructuralFeature, object});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        int n = basicEList.lastIndexOf(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "lastIndexOf", new Integer(n));
        }
        return n;
    }

    public void add(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, int n, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "add", new Object[]{internalEObject, eStructuralFeature, new Integer(n), object});
        }
        this.parseToLimit(eStructuralFeature, n);
        BasicEList basicEList = this.getList(eStructuralFeature);
        basicEList.add(n, object);
        NotificationImpl notificationImpl = new NotificationImpl(3, null, object);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "add");
        }
    }

    public Object remove(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove", new Object[]{internalEObject, eStructuralFeature, new Integer(n)});
        }
        this.parseToLimit(eStructuralFeature, n);
        BasicEList basicEList = this.getList(eStructuralFeature);
        Object e = basicEList.remove(n);
        NotificationImpl notificationImpl = new NotificationImpl(4, e, null);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove", e);
        }
        return e;
    }

    public Object move(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "move", new Object[]{internalEObject, eStructuralFeature, new Integer(n), new Integer(n2)});
        }
        this.parseToLimit(eStructuralFeature, n > n2 ? n : n2);
        BasicEList basicEList = this.getList(eStructuralFeature);
        Object object = basicEList.move(n, n2);
        NotificationImpl notificationImpl = new NotificationImpl(7, null, null);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "move", object);
        }
        return object;
    }

    public void clear(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clear", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        basicEList.clear();
        NotificationImpl notificationImpl = new NotificationImpl(6, null, null);
        this.eNotify((Notification)notificationImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clear");
        }
    }

    public Object[] toArray(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "toArray", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        Object[] objectArray = basicEList.toArray();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "toArray", objectArray);
        }
        return objectArray;
    }

    public Object[] toArray(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "toArray", new Object[]{internalEObject, eStructuralFeature, objectArray});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        Object[] objectArray2 = basicEList.toArray(objectArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "toArray", objectArray2);
        }
        return objectArray2;
    }

    public int hashCode(InternalEObject internalEObject, EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "hashCode", new Object[]{internalEObject, eStructuralFeature});
        }
        this.parseToLimit(eStructuralFeature, -1);
        BasicEList basicEList = this.getList(eStructuralFeature);
        int n = basicEList.hashCode();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "hashCode", new Integer(n));
        }
        return n;
    }

    public InternalEObject getContainer(InternalEObject internalEObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getContainer", internalEObject);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getContainer", null);
        }
        return null;
    }

    public EStructuralFeature getContainingFeature(InternalEObject internalEObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getContainingFeature", internalEObject);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getContainingFeature", null);
        }
        return null;
    }

    public EObject create(EClass eClass) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "create", eClass);
        }
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        EObject eObject = eFactory.create(eClass);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "create", eObject);
        }
        return eObject;
    }

    protected boolean isParsing() {
        return this.parsing;
    }

    protected void startMonitor() {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startMonitor");
        }
        if (this.body != null && this.getAdapter(this.body) == null) {
            object3 = new AbstractSdoStore.DataObjectAdapter(this.body);
        }
        object3 = this.headers.iterator();
        while (object3.hasNext()) {
            object2 = (DataObject)object3.next();
            if (this.getAdapter((DataObject)object2) != null) continue;
            object = new AbstractSdoStore.DataObjectAdapter((DataObject)object2);
        }
        object2 = this.attachments.iterator();
        while (object2.hasNext()) {
            object = (DataObject)object2.next();
            if (this.getAdapter((DataObject)object) != null) continue;
            AbstractSdoStore.DataObjectAdapter dataObjectAdapter = new AbstractSdoStore.DataObjectAdapter((DataObject)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startMonitor");
        }
    }

    protected void stopMonitor() {
        AbstractSdoStore.DataObjectAdapter dataObjectAdapter;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stopMonitor");
        }
        if (this.body != null && (object2 = this.getAdapter(this.body)) != null) {
            ((SdoAdapter)object2).remove();
        }
        object2 = this.headers.iterator();
        while (object2.hasNext()) {
            object = (DataObject)object2.next();
            dataObjectAdapter = this.getAdapter((DataObject)object);
            if (dataObjectAdapter == null) continue;
            dataObjectAdapter.remove();
        }
        object = this.attachments.iterator();
        while (object.hasNext()) {
            dataObjectAdapter = (DataObject)object.next();
            AbstractSdoStore.DataObjectAdapter dataObjectAdapter2 = this.getAdapter((DataObject)dataObjectAdapter);
            if (dataObjectAdapter2 == null) continue;
            dataObjectAdapter2.remove();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stopMonitor");
        }
    }
}

