/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MessageIdentificationHandler;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;

public class FaultIdentificationHandler
extends HandlerStack.HandlerBase {
    private static TraceComponent tc = SibTr.register(FaultIdentificationHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private MessageIdentificationHandler msgHandler;
    private boolean inFaultElement = false;
    private boolean inDetailElement = false;
    private boolean inMessagePart = false;
    private WSDLMetaData meta;

    public FaultIdentificationHandler(MessageIdentificationHandler messageIdentificationHandler, boolean bl, WSDLMetaData wSDLMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "FaultIdentificationHandler", messageIdentificationHandler);
        }
        this.inFaultElement = bl;
        this.msgHandler = messageIdentificationHandler;
        this.meta = wSDLMetaData;
        this.msgHandler.clearCandidates();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "FaultIdentificationHandler", this);
        }
    }

    private void addCandidates() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "addCandidates");
        }
        Binding binding = this.msgHandler.getBinding();
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            Operation operation = bindingOperation.getOperation();
            Map map = bindingOperation.getBindingFaults();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Fault fault = operation.getFault(string);
                if (this.meta.isRPC(binding, bindingOperation)) {
                    BindingFault bindingFault = bindingOperation.getBindingFault(string);
                    String string2 = this.meta.locateSOAPBodyNamespace(bindingFault.getExtensibilityElements());
                    this.msgHandler.addRpcCandidate(operation, fault, string2);
                    continue;
                }
                this.msgHandler.addDocCandidate(operation, fault);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "addCandidates");
        }
    }

    private void handleTopElement(String string, String string2) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleTopElement");
        }
        this.msgHandler.identifyDocPart();
        this.msgHandler.identifyRPCPart();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleTopElement");
        }
    }

    public void handleEndElement() throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndElement");
        }
        if (this.inMessagePart) {
            this.inMessagePart = false;
        } else if (this.inDetailElement) {
            this.msgHandler.completeIdentification(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndElement");
        }
    }

    public void endElementEvent() throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        this.handleEndElement();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    public void startElementEvent(boolean bl) throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        DocumentScannerSupport documentScannerSupport = this.getHandlerStack().getScannerState();
        String string = documentScannerSupport.currentElement.namespaceURI;
        String string2 = documentScannerSupport.currentElement.localPart;
        if (!this.inFaultElement) {
            this.inFaultElement = true;
        } else if (!this.inDetailElement) {
            if ("detail".equals(string2) && "".equals(string)) {
                this.inDetailElement = true;
                this.addCandidates();
            } else {
                this.getHandlerStack().skipSubtree();
            }
        } else if (this.inDetailElement) {
            this.inMessagePart = true;
            this.handleTopElement(string, string2);
            if (!bl) {
                this.getHandlerStack().skipSubtree();
            }
        }
        if (bl) {
            this.handleEndElement();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    public boolean allowText() {
        return true;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/FaultIdentificationHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.10");
        }
    }
}

